/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.codec.prefixtree.encode;

import java.io.OutputStream;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.codec.prefixtree.encode.EncoderPool;
import org.apache.hadoop.hbase.codec.prefixtree.encode.PrefixTreeEncoder;
import org.apache.hadoop.hbase.codec.prefixtree.encode.ThreadLocalEncoderPool;

@InterfaceAudience.Private
public class EncoderFactory {
    private static final EncoderPool POOL = new ThreadLocalEncoderPool();

    public static PrefixTreeEncoder checkOut(OutputStream outputStream, boolean includeMvccVersion) {
        return POOL.checkOut(outputStream, includeMvccVersion);
    }

    public static void checkIn(PrefixTreeEncoder encoder) {
        POOL.checkIn(encoder);
    }

    protected static PrefixTreeEncoder prepareEncoder(PrefixTreeEncoder encoder, OutputStream outputStream, boolean includeMvccVersion) {
        PrefixTreeEncoder ret = encoder;
        if (encoder == null) {
            ret = new PrefixTreeEncoder(outputStream, includeMvccVersion);
        }
        ret.reset(outputStream, includeMvccVersion);
        return ret;
    }
}

