/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.http.conf;

import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.http.conf.ConfServlet;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hbase.thirdparty.org.eclipse.jetty.util.ajax.JSON;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

@Category(value={MiscTests.class, SmallTests.class})
public class TestConfServlet {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestConfServlet.class);
    private static final String TEST_KEY = "testconfservlet.key";
    private static final String TEST_VAL = "testval";

    private Configuration getTestConf() {
        Configuration testConf = new Configuration();
        testConf.set(TEST_KEY, TEST_VAL);
        return testConf;
    }

    @Test
    public void testWriteJson() throws Exception {
        Object[] properties;
        StringWriter sw = new StringWriter();
        ConfServlet.writeResponse((Configuration)this.getTestConf(), (Writer)sw, (String)"json");
        String json = sw.toString();
        boolean foundSetting = false;
        HashSet<String> programSet = new HashSet<String>();
        programSet.add("programatically");
        programSet.add("programmatically");
        Object parsed = JSON.parse((String)json);
        for (Object o : properties = (Object[])((Map)parsed).get("properties")) {
            Map propertyInfo = (Map)o;
            String key = (String)propertyInfo.get("key");
            String val = (String)propertyInfo.get("value");
            String resource = (String)propertyInfo.get("resource");
            System.err.println("k: " + key + " v: " + val + " r: " + resource);
            if (!TEST_KEY.equals(key) || !TEST_VAL.equals(val) || !programSet.contains(resource)) continue;
            foundSetting = true;
        }
        Assert.assertTrue((boolean)foundSetting);
    }

    @Test
    public void testWriteXml() throws Exception {
        StringWriter sw = new StringWriter();
        ConfServlet.writeResponse((Configuration)this.getTestConf(), (Writer)sw, (String)"xml");
        String xml = sw.toString();
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = docBuilderFactory.newDocumentBuilder();
        Document doc = builder.parse(new InputSource(new StringReader(xml)));
        NodeList nameNodes = doc.getElementsByTagName("name");
        boolean foundSetting = false;
        for (int i = 0; i < nameNodes.getLength(); ++i) {
            Node nameNode = nameNodes.item(i);
            String key = nameNode.getTextContent();
            System.err.println("xml key: " + key);
            if (!TEST_KEY.equals(key)) continue;
            foundSetting = true;
            Element propertyElem = (Element)nameNode.getParentNode();
            String val = propertyElem.getElementsByTagName("value").item(0).getTextContent();
            Assert.assertEquals((Object)TEST_VAL, (Object)val);
        }
        Assert.assertTrue((boolean)foundSetting);
    }

    @Test
    public void testMask() {
        String passwordKey = "hbase.rpc.tls.keystore.password";
        Configuration conf = this.getTestConf();
        conf.set("hbase.rpc.tls.keystore.password", "MyPassword");
        Configuration maskedConf = ConfServlet.mask((Configuration)conf);
        Assert.assertEquals((Object)"<masked>", (Object)maskedConf.get("hbase.rpc.tls.keystore.password"));
    }

    @Test
    public void testBadFormat() throws Exception {
        StringWriter sw = new StringWriter();
        try {
            ConfServlet.writeResponse((Configuration)this.getTestConf(), (Writer)sw, (String)"not a format");
            Assert.fail((String)"writeResponse with bad format didn't throw!");
        }
        catch (ConfServlet.BadFormatException badFormatException) {
            // empty catch block
        }
        Assert.assertEquals((Object)"", (Object)sw.toString());
    }
}

