/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.metrics.BaseSourceImpl;
import org.apache.hadoop.hbase.rest.MetricsRESTSource;
import org.apache.hadoop.metrics2.MetricHistogram;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;

@InterfaceAudience.Private
public class MetricsRESTSourceImpl
extends BaseSourceImpl
implements MetricsRESTSource {
    private MutableCounterLong request;
    private MutableCounterLong sucGet;
    private MutableCounterLong sucPut;
    private MutableCounterLong sucDel;
    private MutableCounterLong sucScan;
    private MutableCounterLong fGet;
    private MutableCounterLong fPut;
    private MutableCounterLong fDel;
    private MutableCounterLong fScan;
    private final MutableCounterLong infoPauseThresholdExceeded = this.getMetricsRegistry().newCounter("pauseInfoThresholdExceeded", "Count of INFO level pause threshold alerts", 0L);
    private final MutableCounterLong warnPauseThresholdExceeded = this.getMetricsRegistry().newCounter("pauseWarnThresholdExceeded", "Count of WARN level pause threshold alerts", 0L);
    private final MetricHistogram pausesWithGc = this.getMetricsRegistry().newTimeHistogram("pauseTimeWithGc");
    private final MetricHistogram pausesWithoutGc = this.getMetricsRegistry().newTimeHistogram("pauseTimeWithoutGc");

    public MetricsRESTSourceImpl() {
        this("REST", "Metrics about the HBase REST server", "rest", "REST");
    }

    public MetricsRESTSourceImpl(String metricsName, String metricsDescription, String metricsContext, String metricsJmxContext) {
        super(metricsName, metricsDescription, metricsContext, metricsJmxContext);
    }

    @Override
    public void init() {
        super.init();
        this.request = this.getMetricsRegistry().getLongCounter("requests", 0L);
        this.sucGet = this.getMetricsRegistry().getLongCounter("successfulGet", 0L);
        this.sucPut = this.getMetricsRegistry().getLongCounter("successfulPut", 0L);
        this.sucDel = this.getMetricsRegistry().getLongCounter("successfulDelete", 0L);
        this.sucScan = this.getMetricsRegistry().getLongCounter("successfulScanCount", 0L);
        this.fGet = this.getMetricsRegistry().getLongCounter("failedGet", 0L);
        this.fPut = this.getMetricsRegistry().getLongCounter("failedPut", 0L);
        this.fDel = this.getMetricsRegistry().getLongCounter("failedDelete", 0L);
        this.fScan = this.getMetricsRegistry().getLongCounter("failedScanCount", 0L);
    }

    public void incrementRequests(int inc) {
        this.request.incr((long)inc);
    }

    public void incrementSucessfulGetRequests(int inc) {
        this.sucGet.incr((long)inc);
    }

    public void incrementSucessfulPutRequests(int inc) {
        this.sucPut.incr((long)inc);
    }

    public void incrementSucessfulDeleteRequests(int inc) {
        this.sucDel.incr((long)inc);
    }

    public void incrementFailedGetRequests(int inc) {
        this.fGet.incr((long)inc);
    }

    public void incrementFailedPutRequests(int inc) {
        this.fPut.incr((long)inc);
    }

    public void incrementFailedDeleteRequests(int inc) {
        this.fDel.incr((long)inc);
    }

    public void incrementSucessfulScanRequests(int inc) {
        this.sucScan.incr((long)inc);
    }

    public void incrementFailedScanRequests(int inc) {
        this.fScan.incr((long)inc);
    }

    public void incInfoThresholdExceeded(int count) {
        this.infoPauseThresholdExceeded.incr((long)count);
    }

    public void incWarnThresholdExceeded(int count) {
        this.warnPauseThresholdExceeded.incr((long)count);
    }

    public void updatePauseTimeWithGc(long t) {
        this.pausesWithGc.add(t);
    }

    public void updatePauseTimeWithoutGc(long t) {
        this.pausesWithoutGc.add(t);
    }
}

