/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.metrics.BaseSourceImpl;
import org.apache.hadoop.hbase.metrics.Interns;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerSource;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerWrapper;
import org.apache.hadoop.metrics2.MetricHistogram;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;

@InterfaceAudience.Private
public class MetricsRegionServerSourceImpl
extends BaseSourceImpl
implements MetricsRegionServerSource {
    final MetricsRegionServerWrapper rsWrap;
    private final MetricHistogram putHisto;
    private final MetricHistogram deleteHisto;
    private final MetricHistogram getHisto;
    private final MetricHistogram incrementHisto;
    private final MetricHistogram appendHisto;
    private final MetricHistogram replayHisto;
    private final MetricHistogram scanNextHisto;
    private final MutableCounterLong slowPut;
    private final MutableCounterLong slowDelete;
    private final MutableCounterLong slowGet;
    private final MutableCounterLong slowIncrement;
    private final MutableCounterLong slowAppend;
    private final MutableCounterLong splitRequest;
    private final MutableCounterLong splitSuccess;
    private final MetricHistogram splitTimeHisto;
    private final MetricHistogram flushTimeHisto;
    private final MutableCounterLong infoPauseThresholdExceeded;
    private final MutableCounterLong warnPauseThresholdExceeded;
    private final MetricHistogram pausesWithGc;
    private final MetricHistogram pausesWithoutGc;

    public MetricsRegionServerSourceImpl(MetricsRegionServerWrapper rsWrap) {
        this("Server", "Metrics about HBase RegionServer", "regionserver", "RegionServer,sub=Server", rsWrap);
    }

    public MetricsRegionServerSourceImpl(String metricsName, String metricsDescription, String metricsContext, String metricsJmxContext, MetricsRegionServerWrapper rsWrap) {
        super(metricsName, metricsDescription, metricsContext, metricsJmxContext);
        this.rsWrap = rsWrap;
        this.putHisto = this.getMetricsRegistry().newTimeHistogram("mutate");
        this.slowPut = this.getMetricsRegistry().newCounter("slowPutCount", "The number of Multis that took over 1000ms to complete", 0L);
        this.deleteHisto = this.getMetricsRegistry().newTimeHistogram("delete");
        this.slowDelete = this.getMetricsRegistry().newCounter("slowDeleteCount", "The number of Deletes that took over 1000ms to complete", 0L);
        this.getHisto = this.getMetricsRegistry().newTimeHistogram("get");
        this.slowGet = this.getMetricsRegistry().newCounter("slowGetCount", "The number of Gets that took over 1000ms to complete", 0L);
        this.incrementHisto = this.getMetricsRegistry().newTimeHistogram("increment");
        this.slowIncrement = this.getMetricsRegistry().newCounter("slowIncrementCount", "The number of Increments that took over 1000ms to complete", 0L);
        this.appendHisto = this.getMetricsRegistry().newTimeHistogram("append");
        this.slowAppend = this.getMetricsRegistry().newCounter("slowAppendCount", "The number of Appends that took over 1000ms to complete", 0L);
        this.replayHisto = this.getMetricsRegistry().newTimeHistogram("replay");
        this.scanNextHisto = this.getMetricsRegistry().newTimeHistogram("scanNext");
        this.splitTimeHisto = this.getMetricsRegistry().newTimeHistogram("splitTime");
        this.flushTimeHisto = this.getMetricsRegistry().newTimeHistogram("flushTime");
        this.splitRequest = this.getMetricsRegistry().newCounter("splitRequestCount", "Number of splits requested", 0L);
        this.splitSuccess = this.getMetricsRegistry().newCounter("splitSuccessCount", "Number of successfully executed splits", 0L);
        this.infoPauseThresholdExceeded = this.getMetricsRegistry().newCounter("pauseInfoThresholdExceeded", "Count of INFO level pause threshold alerts", 0L);
        this.warnPauseThresholdExceeded = this.getMetricsRegistry().newCounter("pauseWarnThresholdExceeded", "Count of WARN level pause threshold alerts", 0L);
        this.pausesWithGc = this.getMetricsRegistry().newTimeHistogram("pauseTimeWithGc");
        this.pausesWithoutGc = this.getMetricsRegistry().newTimeHistogram("pauseTimeWithoutGc");
    }

    public void updatePut(long t) {
        this.putHisto.add(t);
    }

    public void updateDelete(long t) {
        this.deleteHisto.add(t);
    }

    public void updateGet(long t) {
        this.getHisto.add(t);
    }

    public void updateIncrement(long t) {
        this.incrementHisto.add(t);
    }

    public void updateAppend(long t) {
        this.appendHisto.add(t);
    }

    public void updateReplay(long t) {
        this.replayHisto.add(t);
    }

    public void updateScannerNext(long scanSize) {
        this.scanNextHisto.add(scanSize);
    }

    public void incrSlowPut() {
        this.slowPut.incr();
    }

    public void incrSlowDelete() {
        this.slowDelete.incr();
    }

    public void incrSlowGet() {
        this.slowGet.incr();
    }

    public void incrSlowIncrement() {
        this.slowIncrement.incr();
    }

    public void incrSlowAppend() {
        this.slowAppend.incr();
    }

    public void incrSplitRequest() {
        this.splitRequest.incr();
    }

    public void incrSplitSuccess() {
        this.splitSuccess.incr();
    }

    public void updateSplitTime(long t) {
        this.splitTimeHisto.add(t);
    }

    public void updateFlushTime(long t) {
        this.flushTimeHisto.add(t);
    }

    @Override
    public void getMetrics(MetricsCollector metricsCollector, boolean all) {
        MetricsRecordBuilder mrb = metricsCollector.addRecord(this.metricsName);
        if (this.rsWrap != null) {
            mrb.addGauge(Interns.info("regionCount", "Number of regions"), this.rsWrap.getNumOnlineRegions()).addGauge(Interns.info("storeCount", "Number of Stores"), this.rsWrap.getNumStores()).addGauge(Interns.info("hlogFileCount", "Number of HLog Files"), this.rsWrap.getNumHLogFiles()).addGauge(Interns.info("hlogFileSize", "Size of all HLog Files"), this.rsWrap.getHLogFileSize()).addGauge(Interns.info("storeFileCount", "Number of Store Files"), this.rsWrap.getNumStoreFiles()).addGauge(Interns.info("memStoreSize", "Size of the memstore"), this.rsWrap.getMemstoreSize()).addGauge(Interns.info("storeFileSize", "Size of storefiles being served."), this.rsWrap.getStoreFileSize()).addGauge(Interns.info("maxStoreFileAge", "Max age of store files hosted on this region server"), this.rsWrap.getMaxStoreFileAge()).addGauge(Interns.info("minStoreFileAge", "Min age of store files hosted on this region server"), this.rsWrap.getMinStoreFileAge()).addGauge(Interns.info("avgStoreFileAge", "Average age of store files hosted on this region server"), this.rsWrap.getAvgStoreFileAge()).addGauge(Interns.info("numReferenceFiles", "Number of reference file on this region server"), this.rsWrap.getNumReferenceFiles()).addGauge(Interns.info("regionServerStartTime", "RegionServer Start Time"), this.rsWrap.getStartCode()).addGauge(Interns.info("averageRegionSize", "Average region size over the region server including memstore and storefile sizes."), this.rsWrap.getAverageRegionSize()).addCounter(Interns.info("totalRequestCount", "Total number of requests this RegionServer has answered."), this.rsWrap.getTotalRequestCount()).addCounter(Interns.info("readRequestCount", "Number of read requests this region server has answered."), this.rsWrap.getReadRequestsCount()).addCounter(Interns.info("writeRequestCount", "Number of mutation requests this region server has answered."), this.rsWrap.getWriteRequestsCount()).addCounter(Interns.info("checkMutateFailedCount", "Number of Check and Mutate calls that failed the checks."), this.rsWrap.getCheckAndMutateChecksFailed()).addCounter(Interns.info("checkMutatePassedCount", "Number of Check and Mutate calls that passed the checks."), this.rsWrap.getCheckAndMutateChecksPassed()).addGauge(Interns.info("storeFileIndexSize", "Size of indexes in storefiles on disk."), this.rsWrap.getStoreFileIndexSize()).addGauge(Interns.info("staticIndexSize", "Uncompressed size of the static indexes."), this.rsWrap.getTotalStaticIndexSize()).addGauge(Interns.info("staticBloomSize", "Uncompressed size of the static bloom filters."), this.rsWrap.getTotalStaticBloomSize()).addGauge(Interns.info("mutationsWithoutWALCount", "Number of mutations that have been sent by clients with the write ahead logging turned off."), this.rsWrap.getNumMutationsWithoutWAL()).addGauge(Interns.info("mutationsWithoutWALSize", "Size of data that has been sent by clients with the write ahead logging turned off."), this.rsWrap.getDataInMemoryWithoutWAL()).addGauge(Interns.info("percentFilesLocal", "The percent of HFiles that are stored on the local hdfs data node."), this.rsWrap.getPercentFileLocal()).addGauge(Interns.info("splitQueueLength", "Length of the queue for splits."), this.rsWrap.getSplitQueueSize()).addGauge(Interns.info("compactionQueueLength", "Length of the queue for compactions."), this.rsWrap.getCompactionQueueSize()).addGauge(Interns.info("flushQueueLength", "Length of the queue for region flushes"), this.rsWrap.getFlushQueueSize()).addGauge(Interns.info("blockCacheFreeSize", "Size of the block cache that is not occupied."), this.rsWrap.getBlockCacheFreeSize()).addGauge(Interns.info("blockCacheCount", "Number of block in the block cache."), this.rsWrap.getBlockCacheCount()).addGauge(Interns.info("blockCacheSize", "Size of the block cache."), this.rsWrap.getBlockCacheSize()).addCounter(Interns.info("blockCacheHitCount", "Count of the hit on the block cache."), this.rsWrap.getBlockCacheHitCount()).addCounter(Interns.info("blockCacheMissCount", "Number of requests for a block that missed the block cache."), this.rsWrap.getBlockCacheMissCount()).addCounter(Interns.info("blockCacheEvictionCount", "Count of the number of blocks evicted from the block cache."), this.rsWrap.getBlockCacheEvictedCount()).addGauge(Interns.info("blockCountHitPercent", "Percent of block cache requests that are hits"), this.rsWrap.getBlockCacheHitPercent()).addGauge(Interns.info("blockCacheExpressHitPercent", "The percent of the time that requests with the cache turned on hit the cache."), this.rsWrap.getBlockCacheHitCachingPercent()).addCounter(Interns.info("blockCacheFailedInsertionCount", "Number of times that a block cache insertion failed. Usually due to size restrictions."), this.rsWrap.getBlockCacheFailedInsertions()).addCounter(Interns.info("blockCacheDataMissCount", ""), this.rsWrap.getDataMissCount()).addCounter(Interns.info("blockCacheLeafIndexMissCount", ""), this.rsWrap.getLeafIndexMissCount()).addCounter(Interns.info("blockCacheBloomChunkMissCount", ""), this.rsWrap.getBloomChunkMissCount()).addCounter(Interns.info("blockCacheMetaMissCount", ""), this.rsWrap.getMetaMissCount()).addCounter(Interns.info("blockCacheRootIndexMissCount", ""), this.rsWrap.getRootIndexMissCount()).addCounter(Interns.info("blockCacheIntermediateIndexMissCount", ""), this.rsWrap.getIntermediateIndexMissCount()).addCounter(Interns.info("blockCacheFileInfoMissCount", ""), this.rsWrap.getFileInfoMissCount()).addCounter(Interns.info("blockCacheGeneralBloomMetaMissCount", ""), this.rsWrap.getGeneralBloomMetaMissCount()).addCounter(Interns.info("blockCacheDeleteFamilyBloomMissCount", ""), this.rsWrap.getDeleteFamilyBloomMissCount()).addCounter(Interns.info("blockCacheTrailerMissCount", ""), this.rsWrap.getTrailerMissCount()).addCounter(Interns.info("blockCacheDataHitCount", ""), this.rsWrap.getDataHitCount()).addCounter(Interns.info("blockCacheLeafIndexHitCount", ""), this.rsWrap.getLeafIndexHitCount()).addCounter(Interns.info("blockCacheBloomChunkHitCount", ""), this.rsWrap.getBloomChunkHitCount()).addCounter(Interns.info("blockCacheMetaHitCount", ""), this.rsWrap.getMetaHitCount()).addCounter(Interns.info("blockCacheRootIndexHitCount", ""), this.rsWrap.getRootIndexHitCount()).addCounter(Interns.info("blockCacheIntermediateIndexHitCount", ""), this.rsWrap.getIntermediateIndexHitCount()).addCounter(Interns.info("blockCacheFileInfoHitCount", ""), this.rsWrap.getFileInfoHitCount()).addCounter(Interns.info("blockCacheGeneralBloomMetaHitCount", ""), this.rsWrap.getGeneralBloomMetaHitCount()).addCounter(Interns.info("blockCacheDeleteFamilyBloomHitCount", ""), this.rsWrap.getDeleteFamilyBloomHitCount()).addCounter(Interns.info("blockCacheTrailerHitCount", ""), this.rsWrap.getTrailerHitCount()).addCounter(Interns.info("updatesBlockedTime", "Number of MS updates have been blocked so that the memstore can be flushed."), this.rsWrap.getUpdatesBlockedTime()).addCounter(Interns.info("flushedCellsCount", "The number of cells flushed to disk"), this.rsWrap.getFlushedCellsCount()).addCounter(Interns.info("compactedCellsCount", "The number of cells processed during minor compactions"), this.rsWrap.getCompactedCellsCount()).addCounter(Interns.info("majorCompactedCellsCount", "The number of cells processed during major compactions"), this.rsWrap.getMajorCompactedCellsCount()).addCounter(Interns.info("flushedCellsSize", "The total amount of data flushed to disk, in bytes"), this.rsWrap.getFlushedCellsSize()).addCounter(Interns.info("compactedCellsSize", "The total amount of data processed during minor compactions, in bytes"), this.rsWrap.getCompactedCellsSize()).addCounter(Interns.info("majorCompactedCellsSize", "The total amount of data processed during major compactions, in bytes"), this.rsWrap.getMajorCompactedCellsSize()).addCounter(Interns.info("blockedRequestCount", "The number of blocked requests because of memstore size is larger than blockingMemStoreSize"), this.rsWrap.getBlockedRequestsCount()).tag(Interns.info("zookeeperQuorum", "Zookeeper Quorum"), this.rsWrap.getZookeeperQuorum()).tag(Interns.info("serverName", "Server Name"), this.rsWrap.getServerName()).tag(Interns.info("clusterId", "Cluster Id"), this.rsWrap.getClusterId());
        }
        this.metricsRegistry.snapshot(mrb, all);
    }

    public void incInfoThresholdExceeded(int count) {
        this.infoPauseThresholdExceeded.incr((long)count);
    }

    public void incWarnThresholdExceeded(int count) {
        this.warnPauseThresholdExceeded.incr((long)count);
    }

    public void updatePauseTimeWithGc(long t) {
        this.pausesWithGc.add(t);
    }

    public void updatePauseTimeWithoutGc(long t) {
        this.pausesWithoutGc.add(t);
    }
}

