/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.master.MetricsAssignmentManagerSource;
import org.apache.hadoop.hbase.metrics.BaseSourceImpl;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;
import org.apache.hadoop.metrics2.lib.MutableHistogram;

@InterfaceAudience.Private
public class MetricsAssignmentManagerSourceImpl
extends BaseSourceImpl
implements MetricsAssignmentManagerSource {
    private MutableGaugeLong ritGauge;
    private MutableGaugeLong ritCountOverThresholdGauge;
    private MutableGaugeLong ritOldestAgeGauge;
    private MutableHistogram assignTimeHisto;
    private MutableHistogram bulkAssignTimeHisto;

    public MetricsAssignmentManagerSourceImpl() {
        this("AssignmentManger", "Metrics about HBase master assingment manager.", "master", "Master,sub=AssignmentManger");
    }

    public MetricsAssignmentManagerSourceImpl(String metricsName, String metricsDescription, String metricsContext, String metricsJmxContext) {
        super(metricsName, metricsDescription, metricsContext, metricsJmxContext);
    }

    @Override
    public void init() {
        this.ritGauge = this.metricsRegistry.newGauge("ritCount", "", 0L);
        this.ritCountOverThresholdGauge = this.metricsRegistry.newGauge("ritCountOverThreshold", "", 0L);
        this.ritOldestAgeGauge = this.metricsRegistry.newGauge("ritOldestAge", "", 0L);
        this.assignTimeHisto = this.metricsRegistry.newHistogram("assign");
        this.bulkAssignTimeHisto = this.metricsRegistry.newHistogram("bulkAssign");
    }

    public void updateAssignmentTime(long time) {
        this.assignTimeHisto.add(time);
    }

    public void updateBulkAssignTime(long time) {
        this.bulkAssignTimeHisto.add(time);
    }

    public void setRIT(int ritCount) {
        this.ritGauge.set((long)ritCount);
    }

    public void setRITCountOverThreshold(int ritCount) {
        this.ritCountOverThresholdGauge.set((long)ritCount);
    }

    public void setRITOldestAge(long ritCount) {
        this.ritOldestAgeGauge.set(ritCount);
    }
}

