/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Scope;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import net.spy.memcached.CachedData;
import net.spy.memcached.ConnectionFactoryBuilder;
import net.spy.memcached.FailureMode;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.OperationTimeoutException;
import net.spy.memcached.transcoders.Transcoder;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.io.ByteBuffAllocator;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.BlockCacheKey;
import org.apache.hadoop.hbase.io.hfile.CacheStats;
import org.apache.hadoop.hbase.io.hfile.Cacheable;
import org.apache.hadoop.hbase.io.hfile.CachedBlock;
import org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.hadoop.hbase.nio.SingleByteBuff;
import org.apache.hadoop.hbase.trace.TraceUtil;
import org.apache.hadoop.hbase.util.Addressing;
import org.apache.hadoop.util.StringUtils;
import org.apache.hbase.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class MemcachedBlockCache
implements BlockCache {
    private static final Logger LOG = LoggerFactory.getLogger((String)MemcachedBlockCache.class.getName());
    public static final int MAX_SIZE = 1044480;
    public static final int MAX_TIME = 2592000;
    public static final String MEMCACHED_CONFIG_KEY = "hbase.cache.memcached.servers";
    public static final String MEMCACHED_TIMEOUT_KEY = "hbase.cache.memcached.timeout";
    public static final String MEMCACHED_OPTIMEOUT_KEY = "hbase.cache.memcached.optimeout";
    public static final String MEMCACHED_OPTIMIZE_KEY = "hbase.cache.memcached.spy.optimze";
    public static final long MEMCACHED_DEFAULT_TIMEOUT = 500L;
    public static final boolean MEMCACHED_OPTIMIZE_DEFAULT = false;
    public static final int STAT_THREAD_PERIOD = 300;
    private final MemcachedClient client;
    private final HFileBlockTranscoder tc = new HFileBlockTranscoder();
    private final CacheStats cacheStats = new CacheStats("MemcachedBlockCache");
    private final AtomicLong cachedCount = new AtomicLong();
    private final AtomicLong notCachedCount = new AtomicLong();
    private final AtomicLong cacheErrorCount = new AtomicLong();
    private final AtomicLong timeoutCount = new AtomicLong();
    private final transient ScheduledExecutorService scheduleThreadPool = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("MemcachedBlockCacheStatsExecutor").setDaemon(true).build());

    public MemcachedBlockCache(Configuration c) throws IOException {
        LOG.info("Creating MemcachedBlockCache");
        long opTimeout = c.getLong(MEMCACHED_OPTIMEOUT_KEY, 500L);
        long queueTimeout = c.getLong(MEMCACHED_TIMEOUT_KEY, opTimeout + 500L);
        boolean optimize = c.getBoolean(MEMCACHED_OPTIMIZE_KEY, false);
        ConnectionFactoryBuilder builder = new ConnectionFactoryBuilder().setOpTimeout(opTimeout).setOpQueueMaxBlockTime(queueTimeout).setFailureMode(FailureMode.Redistribute).setShouldOptimize(optimize).setDaemon(true).setUseNagleAlgorithm(false).setReadBufferSize(1044480);
        String serverListString = c.get(MEMCACHED_CONFIG_KEY, "localhost:11211");
        String[] servers = serverListString.split(",");
        ArrayList<InetSocketAddress> serverAddresses = new ArrayList<InetSocketAddress>(servers.length);
        for (String s : servers) {
            serverAddresses.add(Addressing.createInetSocketAddressFromHostAndPortStr((String)s));
        }
        this.client = new MemcachedClient(builder.build(), serverAddresses);
        this.scheduleThreadPool.scheduleAtFixedRate(new StatisticsThread(this), 300L, 300L, TimeUnit.SECONDS);
    }

    public void cacheBlock(BlockCacheKey cacheKey, Cacheable buf, boolean inMemory) {
        this.cacheBlock(cacheKey, buf);
    }

    public void cacheBlock(BlockCacheKey cacheKey, Cacheable buf) {
        if (buf instanceof HFileBlock) {
            if (buf.getSerializedLength() > 1044480) {
                LOG.debug("Block of type {} with key {} is too large, size={}, max={}, will not cache", new Object[]{buf.getClass(), cacheKey, buf.getSerializedLength(), 1044480});
                this.notCachedCount.incrementAndGet();
                return;
            }
            this.client.set(cacheKey.toString(), 2592000, (Object)((HFileBlock)buf), (Transcoder)this.tc).addListener(f -> {
                try {
                    f.get();
                    this.cachedCount.incrementAndGet();
                }
                catch (Exception e) {
                    LOG.warn("Failed to cache block with key " + cacheKey, (Throwable)e);
                    this.cacheErrorCount.incrementAndGet();
                }
            });
        } else {
            LOG.debug("Can not cache Cacheables of type {} with key {}", buf.getClass(), (Object)cacheKey);
            this.notCachedCount.incrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cacheable getBlock(BlockCacheKey cacheKey, boolean caching, boolean repeat, boolean updateCacheMetrics) {
        HFileBlock result = null;
        Span span = TraceUtil.getGlobalTracer().spanBuilder("MemcachedBlockCache.getBlock").startSpan();
        try (Scope traceScope = span.makeCurrent();){
            result = (HFileBlock)this.client.get(cacheKey.toString(), (Transcoder)this.tc);
        }
        catch (Exception e) {
            if (e instanceof OperationTimeoutException || e instanceof RuntimeException && e.getCause() instanceof OperationTimeoutException) {
                this.timeoutCount.incrementAndGet();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Timeout getting key " + cacheKey.toString(), (Throwable)e);
                }
            } else {
                this.cacheErrorCount.incrementAndGet();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Exception getting key " + cacheKey.toString(), (Throwable)e);
                }
            }
            result = null;
        }
        finally {
            span.end();
            if (updateCacheMetrics) {
                if (result == null) {
                    this.cacheStats.miss(caching, cacheKey.isPrimary(), cacheKey.getBlockType());
                } else {
                    this.cacheStats.hit(caching, cacheKey.isPrimary(), cacheKey.getBlockType());
                }
            }
        }
        return result;
    }

    public boolean evictBlock(BlockCacheKey cacheKey) {
        block3: {
            try {
                this.cacheStats.evict();
                return (Boolean)this.client.delete(cacheKey.toString()).get();
            }
            catch (InterruptedException e) {
                LOG.warn("Error deleting " + cacheKey.toString(), (Throwable)e);
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug("Error deleting " + cacheKey.toString(), (Throwable)e);
            }
        }
        return false;
    }

    public int evictBlocksByHfileName(String hfileName) {
        return 0;
    }

    public CacheStats getStats() {
        return this.cacheStats;
    }

    public void shutdown() {
        this.client.shutdown();
        this.scheduleThreadPool.shutdown();
        for (int i = 0; i < 10; ++i) {
            if (this.scheduleThreadPool.isShutdown()) continue;
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException e) {
                LOG.warn("Interrupted while sleeping");
                Thread.currentThread().interrupt();
                break;
            }
        }
        if (!this.scheduleThreadPool.isShutdown()) {
            List<Runnable> runnables = this.scheduleThreadPool.shutdownNow();
            LOG.debug("Still running " + runnables);
        }
    }

    public long size() {
        return 0L;
    }

    public long getMaxSize() {
        return 0L;
    }

    public long getFreeSize() {
        return 0L;
    }

    public long getCurrentSize() {
        return 0L;
    }

    public long getCurrentDataSize() {
        return 0L;
    }

    public long getBlockCount() {
        return 0L;
    }

    public long getDataBlockCount() {
        return 0L;
    }

    public Iterator<CachedBlock> iterator() {
        return new Iterator<CachedBlock>(){

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public CachedBlock next() {
                throw new NoSuchElementException("MemcachedBlockCache can't iterate over blocks.");
            }

            @Override
            public void remove() {
            }
        };
    }

    public BlockCache[] getBlockCaches() {
        return null;
    }

    public void logStats() {
        LOG.info("cached=" + this.cachedCount.get() + ", notCached=" + this.notCachedCount.get() + ", cacheErrors=" + this.cacheErrorCount.get() + ", timeouts=" + this.timeoutCount.get() + ", reads=" + this.cacheStats.getRequestCount() + ", hits=" + this.cacheStats.getHitCount() + ", hitRatio=" + (this.cacheStats.getHitCount() == 0L ? "0" : StringUtils.formatPercent((double)this.cacheStats.getHitRatio(), (int)2) + ", ") + "cachingAccesses=" + this.cacheStats.getRequestCachingCount() + ", cachingHits=" + this.cacheStats.getHitCachingCount() + ", cachingHitsRatio=" + (this.cacheStats.getHitCachingCount() == 0L ? "0," : StringUtils.formatPercent((double)this.cacheStats.getHitCachingRatio(), (int)2) + ", ") + "evictions=" + this.cacheStats.getEvictionCount() + ", evicted=" + this.cacheStats.getEvictedCount() + ", evictedPerRun=" + this.cacheStats.evictedPerEviction());
    }

    private static class StatisticsThread
    extends Thread {
        private final MemcachedBlockCache c;

        public StatisticsThread(MemcachedBlockCache c) {
            super("MemcachedBlockCacheStats");
            this.setDaemon(true);
            this.c = c;
        }

        @Override
        public void run() {
            this.c.logStats();
        }
    }

    private static class HFileBlockTranscoder
    implements Transcoder<HFileBlock> {
        private HFileBlockTranscoder() {
        }

        public boolean asyncDecode(CachedData d) {
            return false;
        }

        public CachedData encode(HFileBlock block) {
            ByteBuffer bb = ByteBuffer.allocate(block.getSerializedLength());
            block.serialize(bb, true);
            return new CachedData(0, bb.array(), 0x1400000);
        }

        public HFileBlock decode(CachedData d) {
            try {
                SingleByteBuff buf = new SingleByteBuff(ByteBuffer.wrap(d.getData()));
                return (HFileBlock)HFileBlock.BLOCK_DESERIALIZER.deserialize((ByteBuff)buf, ByteBuffAllocator.HEAP);
            }
            catch (IOException e) {
                LOG.warn("Failed to deserialize data from memcached", (Throwable)e);
                return null;
            }
        }

        public int getMaxSize() {
            return 1044480;
        }
    }
}

