/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.compress.lz4;

import java.io.IOException;
import java.nio.ByteBuffer;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4SafeDecompressor;
import org.apache.hadoop.hbase.io.compress.CompressionUtil;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class Lz4Decompressor
implements Decompressor {
    protected static final Logger LOG = LoggerFactory.getLogger(Lz4Decompressor.class);
    protected LZ4SafeDecompressor decompressor = LZ4Factory.fastestInstance().safeDecompressor();
    protected ByteBuffer inBuf;
    protected ByteBuffer outBuf;
    protected int bufferSize;
    protected int inLen;
    protected boolean finished;

    Lz4Decompressor(int bufferSize) {
        this.bufferSize = bufferSize;
        this.inBuf = ByteBuffer.allocate(bufferSize);
        this.outBuf = ByteBuffer.allocate(bufferSize);
        this.outBuf.position(bufferSize);
    }

    public int decompress(byte[] b, int off, int len) throws IOException {
        if (this.outBuf.hasRemaining()) {
            int remaining = this.outBuf.remaining();
            int n = Math.min(remaining, len);
            this.outBuf.get(b, off, n);
            LOG.trace("decompress: {} bytes from outBuf", (Object)n);
            return n;
        }
        if (this.inBuf.position() > 0) {
            this.inBuf.flip();
            int remaining = this.inBuf.remaining();
            this.inLen -= remaining;
            this.outBuf.clear();
            this.decompressor.decompress(this.inBuf, this.outBuf);
            this.inBuf.clear();
            int written = this.outBuf.position();
            LOG.trace("decompress: decompressed {} -> {}", (Object)remaining, (Object)written);
            this.outBuf.flip();
            int n = Math.min(written, len);
            this.outBuf.get(b, off, n);
            LOG.trace("decompress: {} bytes", (Object)n);
            return n;
        }
        LOG.trace("decompress: No output, finished");
        this.finished = true;
        return 0;
    }

    public void end() {
        LOG.trace("end");
    }

    public boolean finished() {
        LOG.trace("finished");
        return this.finished;
    }

    public int getRemaining() {
        LOG.trace("getRemaining: {}", (Object)this.inLen);
        return this.inLen;
    }

    public boolean needsDictionary() {
        LOG.trace("needsDictionary");
        return false;
    }

    public void reset() {
        LOG.trace("reset");
        this.decompressor = LZ4Factory.fastestInstance().safeDecompressor();
        this.inBuf.clear();
        this.inLen = 0;
        this.outBuf.clear();
        this.outBuf.position(this.outBuf.capacity());
        this.finished = false;
    }

    public boolean needsInput() {
        boolean b = this.inBuf.position() == 0;
        LOG.trace("needsInput: {}", (Object)b);
        return b;
    }

    public void setDictionary(byte[] b, int off, int len) {
        throw new UnsupportedOperationException("setDictionary is not supported");
    }

    public void setInput(byte[] b, int off, int len) {
        LOG.trace("setInput: off={} len={}", (Object)off, (Object)len);
        if (this.inBuf.remaining() < len) {
            int needed = CompressionUtil.roundInt2((int)(this.inBuf.capacity() + len));
            LOG.trace("setInput: resize inBuf {}", (Object)needed);
            ByteBuffer newBuf = ByteBuffer.allocate(needed);
            this.inBuf.flip();
            newBuf.put(this.inBuf);
            this.inBuf = newBuf;
        }
        this.inBuf.put(b, off, len);
        this.inLen += len;
        this.finished = false;
    }
}

