/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.compress.lz4;

import java.io.IOException;
import java.nio.ByteBuffer;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.io.compress.CanReinit;
import org.apache.hadoop.hbase.io.compress.CompressionUtil;
import org.apache.hadoop.hbase.io.compress.lz4.Lz4Codec;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class Lz4Compressor
implements CanReinit,
Compressor {
    protected static final Logger LOG = LoggerFactory.getLogger(Lz4Compressor.class);
    protected LZ4Compressor compressor = LZ4Factory.fastestInstance().fastCompressor();
    protected ByteBuffer inBuf;
    protected ByteBuffer outBuf;
    protected int bufferSize;
    protected boolean finish;
    protected boolean finished;
    protected long bytesRead;
    protected long bytesWritten;

    Lz4Compressor(int bufferSize) {
        this.bufferSize = bufferSize;
        this.inBuf = ByteBuffer.allocate(bufferSize);
        this.outBuf = ByteBuffer.allocate(bufferSize);
        this.outBuf.position(bufferSize);
    }

    public int compress(byte[] b, int off, int len) throws IOException {
        if (this.outBuf.hasRemaining()) {
            int remaining = this.outBuf.remaining();
            int n = Math.min(remaining, len);
            this.outBuf.get(b, off, n);
            LOG.trace("compress: {} bytes from outBuf", (Object)n);
            return n;
        }
        if (this.finish) {
            if (this.inBuf.position() > 0) {
                ByteBuffer writeBuffer;
                this.inBuf.flip();
                int uncompressed = this.inBuf.remaining();
                int needed = this.maxCompressedLength(uncompressed);
                boolean direct = false;
                if (len <= needed) {
                    writeBuffer = ByteBuffer.wrap(b, off, len);
                    direct = true;
                } else {
                    if (this.outBuf.capacity() < needed) {
                        needed = CompressionUtil.roundInt2((int)needed);
                        LOG.trace("compress: resize outBuf {}", (Object)needed);
                        this.outBuf = ByteBuffer.allocate(needed);
                    } else {
                        this.outBuf.clear();
                    }
                    writeBuffer = this.outBuf;
                }
                int oldPos = writeBuffer.position();
                this.compressor.compress(this.inBuf, writeBuffer);
                int written = writeBuffer.position() - oldPos;
                this.bytesWritten += (long)written;
                this.inBuf.clear();
                LOG.trace("compress: compressed {} -> {}", (Object)uncompressed, (Object)written);
                this.finished = true;
                if (!direct) {
                    this.outBuf.flip();
                    int n = Math.min(written, len);
                    this.outBuf.get(b, off, n);
                    LOG.trace("compress: {} bytes", (Object)n);
                    return n;
                }
                LOG.trace("compress: {} bytes direct", (Object)written);
                return written;
            }
            this.finished = true;
        }
        LOG.trace("No output");
        return 0;
    }

    public void end() {
        LOG.trace("end");
    }

    public void finish() {
        LOG.trace("finish");
        this.finish = true;
    }

    public boolean finished() {
        boolean b = this.finished && !this.outBuf.hasRemaining();
        LOG.trace("finished: {}", (Object)b);
        return b;
    }

    public long getBytesRead() {
        return this.bytesRead;
    }

    public long getBytesWritten() {
        return this.bytesWritten;
    }

    public boolean needsInput() {
        boolean b = !this.finished();
        LOG.trace("needsInput: {}", (Object)b);
        return b;
    }

    public void reinit(Configuration conf) {
        int newBufferSize;
        LOG.trace("reinit");
        if (conf != null && this.bufferSize != (newBufferSize = Lz4Codec.getBufferSize(conf))) {
            this.bufferSize = newBufferSize;
            this.inBuf = ByteBuffer.allocate(this.bufferSize);
            this.outBuf = ByteBuffer.allocate(this.bufferSize);
        }
        this.reset();
    }

    public void reset() {
        LOG.trace("reset");
        this.compressor = LZ4Factory.fastestInstance().fastCompressor();
        this.inBuf.clear();
        this.outBuf.clear();
        this.outBuf.position(this.outBuf.capacity());
        this.bytesRead = 0L;
        this.bytesWritten = 0L;
        this.finish = false;
        this.finished = false;
    }

    public void setDictionary(byte[] b, int off, int len) {
        throw new UnsupportedOperationException("setDictionary is not supported");
    }

    public void setInput(byte[] b, int off, int len) {
        LOG.trace("setInput: off={} len={}", (Object)off, (Object)len);
        if (this.inBuf.remaining() < len) {
            int needed = CompressionUtil.roundInt2((int)(this.inBuf.capacity() + len));
            LOG.trace("setInput: resize inBuf {}", (Object)needed);
            ByteBuffer newBuf = ByteBuffer.allocate(needed);
            this.inBuf.flip();
            newBuf.put(this.inBuf);
            this.inBuf = newBuf;
        }
        this.inBuf.put(b, off, len);
        this.bytesRead += (long)len;
        this.finished = false;
    }

    int maxCompressedLength(int len) {
        return this.compressor.maxCompressedLength(len);
    }
}

