/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.CacheEvictionStats;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.NamespaceNotFoundException;
import org.apache.hadoop.hbase.RegionMetrics;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.BalanceRequest;
import org.apache.hadoop.hbase.client.BalanceResponse;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.CompactType;
import org.apache.hadoop.hbase.client.CompactionState;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.LogEntry;
import org.apache.hadoop.hbase.client.LogQueryFilter;
import org.apache.hadoop.hbase.client.NormalizeTableFilterParams;
import org.apache.hadoop.hbase.client.OnlineLogRecord;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.ServerType;
import org.apache.hadoop.hbase.client.SnapshotDescription;
import org.apache.hadoop.hbase.client.SnapshotType;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.replication.ReplicationPeerConfigUtil;
import org.apache.hadoop.hbase.client.replication.TableCFs;
import org.apache.hadoop.hbase.client.security.SecurityCapability;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.net.Address;
import org.apache.hadoop.hbase.quotas.QuotaFilter;
import org.apache.hadoop.hbase.quotas.QuotaSettings;
import org.apache.hadoop.hbase.quotas.SpaceQuotaSnapshotView;
import org.apache.hadoop.hbase.regionserver.wal.FailedLogCloseException;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationPeerDescription;
import org.apache.hadoop.hbase.replication.SyncReplicationState;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfo;
import org.apache.hadoop.hbase.security.access.GetUserPermissionsRequest;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.UserPermission;
import org.apache.hadoop.hbase.snapshot.HBaseSnapshotException;
import org.apache.hadoop.hbase.snapshot.RestoreSnapshotException;
import org.apache.hadoop.hbase.snapshot.SnapshotCreationException;
import org.apache.hadoop.hbase.snapshot.UnknownSnapshotException;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FutureUtils;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public interface Admin
extends Abortable,
Closeable {
    public int getOperationTimeout();

    public int getSyncWaitTimeout();

    @Override
    public void abort(String var1, Throwable var2);

    @Override
    public boolean isAborted();

    public Connection getConnection();

    public boolean tableExists(TableName var1) throws IOException;

    public List<TableDescriptor> listTableDescriptors() throws IOException;

    public List<TableDescriptor> listTableDescriptors(boolean var1) throws IOException;

    default public List<TableDescriptor> listTableDescriptors(Pattern pattern) throws IOException {
        return this.listTableDescriptors(pattern, false);
    }

    public List<TableDescriptor> listTableDescriptors(Pattern var1, boolean var2) throws IOException;

    public List<TableDescriptor> listTableDescriptorsByState(boolean var1) throws IOException;

    public TableName[] listTableNames() throws IOException;

    default public TableName[] listTableNames(Pattern pattern) throws IOException {
        return this.listTableNames(pattern, false);
    }

    public TableName[] listTableNames(Pattern var1, boolean var2) throws IOException;

    public List<TableName> listTableNamesByState(boolean var1) throws IOException;

    public TableDescriptor getDescriptor(TableName var1) throws TableNotFoundException, IOException;

    default public void createTable(TableDescriptor desc) throws IOException {
        FutureUtils.get(this.createTableAsync(desc), (long)this.getSyncWaitTimeout(), (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public void createTable(TableDescriptor var1, byte[] var2, byte[] var3, int var4) throws IOException;

    default public void createTable(TableDescriptor desc, byte[][] splitKeys) throws IOException {
        FutureUtils.get(this.createTableAsync(desc, splitKeys), (long)this.getSyncWaitTimeout(), (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public Future<Void> createTableAsync(TableDescriptor var1) throws IOException;

    public Future<Void> createTableAsync(TableDescriptor var1, byte[][] var2) throws IOException;

    default public void deleteTable(TableName tableName) throws IOException {
        FutureUtils.get(this.deleteTableAsync(tableName), (long)this.getSyncWaitTimeout(), (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public Future<Void> deleteTableAsync(TableName var1) throws IOException;

    default public void truncateTable(TableName tableName, boolean preserveSplits) throws IOException {
        FutureUtils.get(this.truncateTableAsync(tableName, preserveSplits), (long)this.getSyncWaitTimeout(), (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public Future<Void> truncateTableAsync(TableName var1, boolean var2) throws IOException;

    default public void enableTable(TableName tableName) throws IOException {
        FutureUtils.get(this.enableTableAsync(tableName), (long)this.getSyncWaitTimeout(), (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public Future<Void> enableTableAsync(TableName var1) throws IOException;

    public Future<Void> disableTableAsync(TableName var1) throws IOException;

    default public void disableTable(TableName tableName) throws IOException {
        FutureUtils.get(this.disableTableAsync(tableName), (long)this.getSyncWaitTimeout(), (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public boolean isTableEnabled(TableName var1) throws IOException;

    public boolean isTableDisabled(TableName var1) throws IOException;

    public boolean isTableAvailable(TableName var1) throws IOException;

    default public void addColumnFamily(TableName tableName, ColumnFamilyDescriptor columnFamily) throws IOException {
        FutureUtils.get(this.addColumnFamilyAsync(tableName, columnFamily), (long)this.getSyncWaitTimeout(), (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public Future<Void> addColumnFamilyAsync(TableName var1, ColumnFamilyDescriptor var2) throws IOException;

    default public void deleteColumnFamily(TableName tableName, byte[] columnFamily) throws IOException {
        FutureUtils.get(this.deleteColumnFamilyAsync(tableName, columnFamily), (long)this.getSyncWaitTimeout(), (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public Future<Void> deleteColumnFamilyAsync(TableName var1, byte[] var2) throws IOException;

    default public void modifyColumnFamily(TableName tableName, ColumnFamilyDescriptor columnFamily) throws IOException {
        FutureUtils.get(this.modifyColumnFamilyAsync(tableName, columnFamily), (long)this.getSyncWaitTimeout(), (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public Future<Void> modifyColumnFamilyAsync(TableName var1, ColumnFamilyDescriptor var2) throws IOException;

    default public void modifyColumnFamilyStoreFileTracker(TableName tableName, byte[] family, String dstSFT) throws IOException {
        FutureUtils.get(this.modifyColumnFamilyStoreFileTrackerAsync(tableName, family, dstSFT), (long)this.getSyncWaitTimeout(), (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public Future<Void> modifyColumnFamilyStoreFileTrackerAsync(TableName var1, byte[] var2, String var3) throws IOException;

    public List<RegionInfo> getRegions(ServerName var1) throws IOException;

    public void flush(TableName var1) throws IOException;

    public void flush(TableName var1, byte[] var2) throws IOException;

    public void flush(TableName var1, List<byte[]> var2) throws IOException;

    public void flushRegion(byte[] var1) throws IOException;

    public void flushRegion(byte[] var1, byte[] var2) throws IOException;

    public void flushRegionServer(ServerName var1) throws IOException;

    public void compact(TableName var1) throws IOException;

    public void compactRegion(byte[] var1) throws IOException;

    public void compact(TableName var1, byte[] var2) throws IOException;

    public void compactRegion(byte[] var1, byte[] var2) throws IOException;

    public void compact(TableName var1, CompactType var2) throws IOException, InterruptedException;

    public void compact(TableName var1, byte[] var2, CompactType var3) throws IOException, InterruptedException;

    public void majorCompact(TableName var1) throws IOException;

    public void majorCompactRegion(byte[] var1) throws IOException;

    public void majorCompact(TableName var1, byte[] var2) throws IOException;

    public void majorCompactRegion(byte[] var1, byte[] var2) throws IOException;

    public void majorCompact(TableName var1, CompactType var2) throws IOException, InterruptedException;

    public void majorCompact(TableName var1, byte[] var2, CompactType var3) throws IOException, InterruptedException;

    public Map<ServerName, Boolean> compactionSwitch(boolean var1, List<String> var2) throws IOException;

    public void compactRegionServer(ServerName var1) throws IOException;

    public void majorCompactRegionServer(ServerName var1) throws IOException;

    public void move(byte[] var1) throws IOException;

    @Deprecated
    default public void move(byte[] encodedRegionName, byte[] destServerName) throws IOException {
        if (destServerName == null || destServerName.length == 0) {
            this.move(encodedRegionName);
        } else {
            this.move(encodedRegionName, ServerName.valueOf((String)Bytes.toString((byte[])destServerName)));
        }
    }

    public void move(byte[] var1, ServerName var2) throws IOException;

    public void assign(byte[] var1) throws IOException;

    public void unassign(byte[] var1) throws IOException;

    @Deprecated
    default public void unassign(byte[] regionName, boolean force) throws IOException {
        this.unassign(regionName);
    }

    public void offline(byte[] var1) throws IOException;

    public boolean balancerSwitch(boolean var1, boolean var2) throws IOException;

    default public boolean balance() throws IOException {
        return this.balance(BalanceRequest.defaultInstance()).isBalancerRan();
    }

    public BalanceResponse balance(BalanceRequest var1) throws IOException;

    @Deprecated
    default public boolean balance(boolean force) throws IOException {
        return this.balance(BalanceRequest.newBuilder().setIgnoreRegionsInTransition(force).build()).isBalancerRan();
    }

    public boolean isBalancerEnabled() throws IOException;

    public CacheEvictionStats clearBlockCache(TableName var1) throws IOException;

    default public boolean normalize() throws IOException {
        return this.normalize(new NormalizeTableFilterParams.Builder().build());
    }

    public boolean normalize(NormalizeTableFilterParams var1) throws IOException;

    public boolean isNormalizerEnabled() throws IOException;

    public boolean normalizerSwitch(boolean var1) throws IOException;

    public boolean catalogJanitorSwitch(boolean var1) throws IOException;

    public int runCatalogJanitor() throws IOException;

    public boolean isCatalogJanitorEnabled() throws IOException;

    public boolean cleanerChoreSwitch(boolean var1) throws IOException;

    public boolean runCleanerChore() throws IOException;

    public boolean isCleanerChoreEnabled() throws IOException;

    @Deprecated
    default public Future<Void> mergeRegionsAsync(byte[] nameOfRegionA, byte[] nameOfRegionB, boolean forcible) throws IOException {
        byte[][] nameofRegionsToMerge = new byte[][]{nameOfRegionA, nameOfRegionB};
        return this.mergeRegionsAsync(nameofRegionsToMerge, forcible);
    }

    public Future<Void> mergeRegionsAsync(byte[][] var1, boolean var2) throws IOException;

    public void split(TableName var1) throws IOException;

    public void split(TableName var1, byte[] var2) throws IOException;

    public Future<Void> splitRegionAsync(byte[] var1) throws IOException;

    public Future<Void> splitRegionAsync(byte[] var1, byte[] var2) throws IOException;

    default public void modifyTable(TableDescriptor td) throws IOException {
        FutureUtils.get(this.modifyTableAsync(td), (long)this.getSyncWaitTimeout(), (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public void truncateRegion(byte[] var1) throws IOException;

    public Future<Void> truncateRegionAsync(byte[] var1) throws IOException;

    default public Future<Void> modifyTableAsync(TableDescriptor td) throws IOException {
        return this.modifyTableAsync(td, true);
    }

    public Future<Void> modifyTableAsync(TableDescriptor var1, boolean var2) throws IOException;

    default public void modifyTableStoreFileTracker(TableName tableName, String dstSFT) throws IOException {
        FutureUtils.get(this.modifyTableStoreFileTrackerAsync(tableName, dstSFT), (long)this.getSyncWaitTimeout(), (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public Future<Void> modifyTableStoreFileTrackerAsync(TableName var1, String var2) throws IOException;

    public void shutdown() throws IOException;

    public void stopMaster() throws IOException;

    public boolean isMasterInMaintenanceMode() throws IOException;

    public void stopRegionServer(String var1) throws IOException;

    default public ClusterMetrics getClusterMetrics() throws IOException {
        return this.getClusterMetrics(EnumSet.allOf(ClusterMetrics.Option.class));
    }

    public ClusterMetrics getClusterMetrics(EnumSet<ClusterMetrics.Option> var1) throws IOException;

    default public ServerName getMaster() throws IOException {
        return this.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.MASTER)).getMasterName();
    }

    default public Collection<ServerName> getBackupMasters() throws IOException {
        return this.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.BACKUP_MASTERS)).getBackupMasterNames();
    }

    default public Collection<ServerName> getRegionServers() throws IOException {
        return this.getRegionServers(false);
    }

    default public Collection<ServerName> getRegionServers(boolean excludeDecommissionedRS) throws IOException {
        List<ServerName> allServers = this.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.SERVERS_NAME)).getServersName();
        if (!excludeDecommissionedRS) {
            return allServers;
        }
        List<ServerName> decommissionedRegionServers = this.listDecommissionedRegionServers();
        return (Collection)allServers.stream().filter(s -> !decommissionedRegionServers.contains(s)).collect(ImmutableList.toImmutableList());
    }

    public List<RegionMetrics> getRegionMetrics(ServerName var1) throws IOException;

    public List<RegionMetrics> getRegionMetrics(ServerName var1, TableName var2) throws IOException;

    public Configuration getConfiguration();

    default public void createNamespace(NamespaceDescriptor descriptor) throws IOException {
        FutureUtils.get(this.createNamespaceAsync(descriptor), (long)this.getSyncWaitTimeout(), (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public Future<Void> createNamespaceAsync(NamespaceDescriptor var1) throws IOException;

    default public void modifyNamespace(NamespaceDescriptor descriptor) throws IOException {
        FutureUtils.get(this.modifyNamespaceAsync(descriptor), (long)this.getSyncWaitTimeout(), (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public Future<Void> modifyNamespaceAsync(NamespaceDescriptor var1) throws IOException;

    default public void deleteNamespace(String name) throws IOException {
        FutureUtils.get(this.deleteNamespaceAsync(name), (long)this.getSyncWaitTimeout(), (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public Future<Void> deleteNamespaceAsync(String var1) throws IOException;

    public NamespaceDescriptor getNamespaceDescriptor(String var1) throws NamespaceNotFoundException, IOException;

    public String[] listNamespaces() throws IOException;

    public NamespaceDescriptor[] listNamespaceDescriptors() throws IOException;

    public List<TableDescriptor> listTableDescriptorsByNamespace(byte[] var1) throws IOException;

    public TableName[] listTableNamesByNamespace(String var1) throws IOException;

    public List<RegionInfo> getRegions(TableName var1) throws IOException;

    @Override
    public void close();

    public List<TableDescriptor> listTableDescriptors(List<TableName> var1) throws IOException;

    @Deprecated
    default public boolean abortProcedure(long procId, boolean mayInterruptIfRunning) throws IOException {
        return (Boolean)FutureUtils.get(this.abortProcedureAsync(procId, mayInterruptIfRunning), (long)this.getSyncWaitTimeout(), (TimeUnit)TimeUnit.MILLISECONDS);
    }

    @Deprecated
    public Future<Boolean> abortProcedureAsync(long var1, boolean var3) throws IOException;

    public String getProcedures() throws IOException;

    public String getLocks() throws IOException;

    public void rollWALWriter(ServerName var1) throws IOException, FailedLogCloseException;

    default public List<String> getMasterCoprocessorNames() throws IOException {
        return this.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.MASTER_COPROCESSORS)).getMasterCoprocessorNames();
    }

    public CompactionState getCompactionState(TableName var1) throws IOException;

    public CompactionState getCompactionState(TableName var1, CompactType var2) throws IOException;

    public CompactionState getCompactionStateForRegion(byte[] var1) throws IOException;

    public long getLastMajorCompactionTimestamp(TableName var1) throws IOException;

    public long getLastMajorCompactionTimestampForRegion(byte[] var1) throws IOException;

    default public void snapshot(String snapshotName, TableName tableName) throws IOException, SnapshotCreationException, IllegalArgumentException {
        this.snapshot(snapshotName, tableName, SnapshotType.FLUSH);
    }

    default public void snapshot(String snapshotName, TableName tableName, SnapshotType type) throws IOException, SnapshotCreationException, IllegalArgumentException {
        this.snapshot(new SnapshotDescription(snapshotName, tableName, type));
    }

    default public void snapshot(String snapshotName, TableName tableName, SnapshotType type, Map<String, Object> snapshotProps) throws IOException, SnapshotCreationException, IllegalArgumentException {
        this.snapshot(new SnapshotDescription(snapshotName, tableName, type, snapshotProps));
    }

    default public void snapshot(String snapshotName, TableName tableName, Map<String, Object> snapshotProps) throws IOException, SnapshotCreationException, IllegalArgumentException {
        this.snapshot(new SnapshotDescription(snapshotName, tableName, SnapshotType.FLUSH, snapshotProps));
    }

    public void snapshot(SnapshotDescription var1) throws IOException, SnapshotCreationException, IllegalArgumentException;

    public Future<Void> snapshotAsync(SnapshotDescription var1) throws IOException, SnapshotCreationException;

    public boolean isSnapshotFinished(SnapshotDescription var1) throws IOException, HBaseSnapshotException, UnknownSnapshotException;

    public void restoreSnapshot(String var1) throws IOException, RestoreSnapshotException;

    default public void restoreSnapshot(String snapshotName, boolean takeFailSafeSnapshot) throws IOException, RestoreSnapshotException {
        this.restoreSnapshot(snapshotName, takeFailSafeSnapshot, false);
    }

    public void restoreSnapshot(String var1, boolean var2, boolean var3) throws IOException, RestoreSnapshotException;

    default public void cloneSnapshot(String snapshotName, TableName tableName) throws IOException, TableExistsException, RestoreSnapshotException {
        this.cloneSnapshot(snapshotName, tableName, false, null);
    }

    default public void cloneSnapshot(String snapshotName, TableName tableName, boolean restoreAcl, String customSFT) throws IOException, TableExistsException, RestoreSnapshotException {
        FutureUtils.get(this.cloneSnapshotAsync(snapshotName, tableName, restoreAcl, customSFT), (long)this.getSyncWaitTimeout(), (TimeUnit)TimeUnit.MILLISECONDS);
    }

    default public void cloneSnapshot(String snapshotName, TableName tableName, boolean restoreAcl) throws IOException, TableExistsException, RestoreSnapshotException {
        FutureUtils.get(this.cloneSnapshotAsync(snapshotName, tableName, restoreAcl), (long)this.getSyncWaitTimeout(), (TimeUnit)TimeUnit.MILLISECONDS);
    }

    default public Future<Void> cloneSnapshotAsync(String snapshotName, TableName tableName) throws IOException, TableExistsException {
        return this.cloneSnapshotAsync(snapshotName, tableName, false);
    }

    default public Future<Void> cloneSnapshotAsync(String snapshotName, TableName tableName, boolean restoreAcl) throws IOException, TableExistsException, RestoreSnapshotException {
        return this.cloneSnapshotAsync(snapshotName, tableName, restoreAcl, null);
    }

    public Future<Void> cloneSnapshotAsync(String var1, TableName var2, boolean var3, String var4) throws IOException, TableExistsException, RestoreSnapshotException;

    public void execProcedure(String var1, String var2, Map<String, String> var3) throws IOException;

    public byte[] execProcedureWithReturn(String var1, String var2, Map<String, String> var3) throws IOException;

    public boolean isProcedureFinished(String var1, String var2, Map<String, String> var3) throws IOException;

    public List<SnapshotDescription> listSnapshots() throws IOException;

    public List<SnapshotDescription> listSnapshots(Pattern var1) throws IOException;

    public List<SnapshotDescription> listTableSnapshots(Pattern var1, Pattern var2) throws IOException;

    public void deleteSnapshot(String var1) throws IOException;

    public void deleteSnapshots(Pattern var1) throws IOException;

    public void deleteTableSnapshots(Pattern var1, Pattern var2) throws IOException;

    public void setQuota(QuotaSettings var1) throws IOException;

    public List<QuotaSettings> getQuota(QuotaFilter var1) throws IOException;

    @Deprecated
    public CoprocessorRpcChannel coprocessorService();

    @Deprecated
    public CoprocessorRpcChannel coprocessorService(ServerName var1);

    public void updateConfiguration(ServerName var1) throws IOException;

    public void updateConfiguration() throws IOException;

    public void updateConfiguration(String var1) throws IOException;

    default public int getMasterInfoPort() throws IOException {
        return this.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.MASTER_INFO_PORT)).getMasterInfoPort();
    }

    public List<SecurityCapability> getSecurityCapabilities() throws IOException;

    public boolean splitSwitch(boolean var1, boolean var2) throws IOException;

    public boolean mergeSwitch(boolean var1, boolean var2) throws IOException;

    public boolean isSplitEnabled() throws IOException;

    public boolean isMergeEnabled() throws IOException;

    default public void addReplicationPeer(String peerId, ReplicationPeerConfig peerConfig) throws IOException {
        this.addReplicationPeer(peerId, peerConfig, true);
    }

    default public void addReplicationPeer(String peerId, ReplicationPeerConfig peerConfig, boolean enabled) throws IOException {
        FutureUtils.get(this.addReplicationPeerAsync(peerId, peerConfig, enabled), (long)this.getSyncWaitTimeout(), (TimeUnit)TimeUnit.MILLISECONDS);
    }

    default public Future<Void> addReplicationPeerAsync(String peerId, ReplicationPeerConfig peerConfig) throws IOException {
        return this.addReplicationPeerAsync(peerId, peerConfig, true);
    }

    public Future<Void> addReplicationPeerAsync(String var1, ReplicationPeerConfig var2, boolean var3) throws IOException;

    default public void removeReplicationPeer(String peerId) throws IOException {
        FutureUtils.get(this.removeReplicationPeerAsync(peerId), (long)this.getSyncWaitTimeout(), (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public Future<Void> removeReplicationPeerAsync(String var1) throws IOException;

    default public void enableReplicationPeer(String peerId) throws IOException {
        FutureUtils.get(this.enableReplicationPeerAsync(peerId), (long)this.getSyncWaitTimeout(), (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public Future<Void> enableReplicationPeerAsync(String var1) throws IOException;

    default public void disableReplicationPeer(String peerId) throws IOException {
        FutureUtils.get(this.disableReplicationPeerAsync(peerId), (long)this.getSyncWaitTimeout(), (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public Future<Void> disableReplicationPeerAsync(String var1) throws IOException;

    public ReplicationPeerConfig getReplicationPeerConfig(String var1) throws IOException;

    default public void updateReplicationPeerConfig(String peerId, ReplicationPeerConfig peerConfig) throws IOException {
        FutureUtils.get(this.updateReplicationPeerConfigAsync(peerId, peerConfig), (long)this.getSyncWaitTimeout(), (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public Future<Void> updateReplicationPeerConfigAsync(String var1, ReplicationPeerConfig var2) throws IOException;

    default public void appendReplicationPeerTableCFs(String id, Map<TableName, List<String>> tableCfs) throws ReplicationException, IOException {
        if (tableCfs == null) {
            throw new ReplicationException("tableCfs is null");
        }
        ReplicationPeerConfig peerConfig = this.getReplicationPeerConfig(id);
        ReplicationPeerConfig newPeerConfig = ReplicationPeerConfigUtil.appendTableCFsToReplicationPeerConfig(tableCfs, peerConfig);
        this.updateReplicationPeerConfig(id, newPeerConfig);
    }

    default public void removeReplicationPeerTableCFs(String id, Map<TableName, List<String>> tableCfs) throws ReplicationException, IOException {
        if (tableCfs == null) {
            throw new ReplicationException("tableCfs is null");
        }
        ReplicationPeerConfig peerConfig = this.getReplicationPeerConfig(id);
        ReplicationPeerConfig newPeerConfig = ReplicationPeerConfigUtil.removeTableCFsFromReplicationPeerConfig(tableCfs, peerConfig, id);
        this.updateReplicationPeerConfig(id, newPeerConfig);
    }

    public List<ReplicationPeerDescription> listReplicationPeers() throws IOException;

    public List<ReplicationPeerDescription> listReplicationPeers(Pattern var1) throws IOException;

    default public void transitReplicationPeerSyncReplicationState(String peerId, SyncReplicationState state) throws IOException {
        FutureUtils.get(this.transitReplicationPeerSyncReplicationStateAsync(peerId, state), (long)this.getSyncWaitTimeout(), (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public Future<Void> transitReplicationPeerSyncReplicationStateAsync(String var1, SyncReplicationState var2) throws IOException;

    default public SyncReplicationState getReplicationPeerSyncReplicationState(String peerId) throws IOException {
        List<ReplicationPeerDescription> peers = this.listReplicationPeers(Pattern.compile(peerId));
        if (peers.isEmpty() || !peers.get(0).getPeerId().equals(peerId)) {
            throw new IOException("Replication peer " + peerId + " does not exist");
        }
        return peers.get(0).getSyncReplicationState();
    }

    public boolean isReplicationPeerEnabled(String var1) throws IOException;

    default public boolean replicationPeerModificationSwitch(boolean on) throws IOException {
        return this.replicationPeerModificationSwitch(on, false);
    }

    public boolean replicationPeerModificationSwitch(boolean var1, boolean var2) throws IOException;

    public boolean isReplicationPeerModificationEnabled() throws IOException;

    public void decommissionRegionServers(List<ServerName> var1, boolean var2) throws IOException;

    public List<ServerName> listDecommissionedRegionServers() throws IOException;

    public void recommissionRegionServer(ServerName var1, List<byte[]> var2) throws IOException;

    public List<TableCFs> listReplicatedTableCFs() throws IOException;

    public void enableTableReplication(TableName var1) throws IOException;

    public void disableTableReplication(TableName var1) throws IOException;

    public void clearCompactionQueues(ServerName var1, Set<String> var2) throws IOException, InterruptedException;

    default public List<ServerName> listDeadServers() throws IOException {
        return this.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.DEAD_SERVERS)).getDeadServerNames();
    }

    default public List<ServerName> listUnknownServers() throws IOException {
        return this.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.UNKNOWN_SERVERS)).getUnknownServerNames();
    }

    public List<ServerName> clearDeadServers(List<ServerName> var1) throws IOException;

    public void cloneTableSchema(TableName var1, TableName var2, boolean var3) throws IOException;

    public boolean switchRpcThrottle(boolean var1) throws IOException;

    public boolean isRpcThrottleEnabled() throws IOException;

    public boolean exceedThrottleQuotaSwitch(boolean var1) throws IOException;

    public Map<TableName, Long> getSpaceQuotaTableSizes() throws IOException;

    public Map<TableName, ? extends SpaceQuotaSnapshotView> getRegionServerSpaceQuotaSnapshots(ServerName var1) throws IOException;

    public SpaceQuotaSnapshotView getCurrentSpaceQuotaSnapshot(String var1) throws IOException;

    public SpaceQuotaSnapshotView getCurrentSpaceQuotaSnapshot(TableName var1) throws IOException;

    public void grant(UserPermission var1, boolean var2) throws IOException;

    public void revoke(UserPermission var1) throws IOException;

    public List<UserPermission> getUserPermissions(GetUserPermissionsRequest var1) throws IOException;

    public List<Boolean> hasUserPermissions(String var1, List<Permission> var2) throws IOException;

    default public List<Boolean> hasUserPermissions(List<Permission> permissions) throws IOException {
        return this.hasUserPermissions(null, permissions);
    }

    public boolean snapshotCleanupSwitch(boolean var1, boolean var2) throws IOException;

    public boolean isSnapshotCleanupEnabled() throws IOException;

    @Deprecated
    default public List<OnlineLogRecord> getSlowLogResponses(Set<ServerName> serverNames, LogQueryFilter logQueryFilter) throws IOException {
        String logType = LogQueryFilter.Type.LARGE_LOG.equals((Object)logQueryFilter.getType()) ? "LARGE_LOG" : "SLOW_LOG";
        HashMap<String, Object> filterParams = new HashMap<String, Object>();
        filterParams.put("regionName", logQueryFilter.getRegionName());
        filterParams.put("clientAddress", logQueryFilter.getClientAddress());
        filterParams.put("tableName", logQueryFilter.getTableName());
        filterParams.put("userName", logQueryFilter.getUserName());
        filterParams.put("filterByOperator", logQueryFilter.getFilterByOperator().toString());
        List<LogEntry> logEntries = this.getLogEntries(serverNames, logType, ServerType.REGION_SERVER, logQueryFilter.getLimit(), filterParams);
        return logEntries.stream().map(logEntry -> (OnlineLogRecord)logEntry).collect(Collectors.toList());
    }

    public List<Boolean> clearSlowLogResponses(Set<ServerName> var1) throws IOException;

    public void addRSGroup(String var1) throws IOException;

    public RSGroupInfo getRSGroup(String var1) throws IOException;

    public RSGroupInfo getRSGroup(Address var1) throws IOException;

    public RSGroupInfo getRSGroup(TableName var1) throws IOException;

    public List<RSGroupInfo> listRSGroups() throws IOException;

    public List<TableName> listTablesInRSGroup(String var1) throws IOException;

    public Pair<List<String>, List<TableName>> getConfiguredNamespacesAndTablesInRSGroup(String var1) throws IOException;

    public void removeRSGroup(String var1) throws IOException;

    public void removeServersFromRSGroup(Set<Address> var1) throws IOException;

    public void moveServersToRSGroup(Set<Address> var1, String var2) throws IOException;

    public void setRSGroup(Set<TableName> var1, String var2) throws IOException;

    default public BalanceResponse balanceRSGroup(String groupName) throws IOException {
        return this.balanceRSGroup(groupName, BalanceRequest.defaultInstance());
    }

    public BalanceResponse balanceRSGroup(String var1, BalanceRequest var2) throws IOException;

    public void renameRSGroup(String var1, String var2) throws IOException;

    public void updateRSGroupConfig(String var1, Map<String, String> var2) throws IOException;

    public List<LogEntry> getLogEntries(Set<ServerName> var1, String var2, ServerType var3, int var4, Map<String, Object> var5) throws IOException;

    public void flushMasterStore() throws IOException;

    public List<String> getCachedFilesList(ServerName var1) throws IOException;
}

