/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.slowlog;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.shaded.protobuf.generated.TooSlowLog;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class SlowLogTableAccessor {
    private static final Logger LOG = LoggerFactory.getLogger(SlowLogTableAccessor.class);
    private static final Random RANDOM = new Random();
    private static Connection connection;
    public static final TableName SLOW_LOG_TABLE_NAME;

    private static void doPut(Connection connection, List<Put> puts) throws IOException {
        try (Table table = connection.getTable(SLOW_LOG_TABLE_NAME);){
            table.put(puts);
        }
    }

    public static void addSlowLogRecords(List<TooSlowLog.SlowLogPayload> slowLogPayloads, Configuration configuration) {
        ArrayList<Put> puts = new ArrayList<Put>(slowLogPayloads.size());
        for (TooSlowLog.SlowLogPayload slowLogPayload : slowLogPayloads) {
            byte[] rowKey = SlowLogTableAccessor.getRowKey(slowLogPayload);
            Put put = new Put(rowKey).setDurability(Durability.SKIP_WAL).setPriority(0).addColumn(HConstants.SLOWLOG_INFO_FAMILY, Bytes.toBytes((String)"call_details"), Bytes.toBytes((String)slowLogPayload.getCallDetails())).addColumn(HConstants.SLOWLOG_INFO_FAMILY, Bytes.toBytes((String)"client_address"), Bytes.toBytes((String)slowLogPayload.getClientAddress())).addColumn(HConstants.SLOWLOG_INFO_FAMILY, Bytes.toBytes((String)"method_name"), Bytes.toBytes((String)slowLogPayload.getMethodName())).addColumn(HConstants.SLOWLOG_INFO_FAMILY, Bytes.toBytes((String)"param"), Bytes.toBytes((String)slowLogPayload.getParam())).addColumn(HConstants.SLOWLOG_INFO_FAMILY, Bytes.toBytes((String)"processing_time"), Bytes.toBytes((String)Integer.toString(slowLogPayload.getProcessingTime()))).addColumn(HConstants.SLOWLOG_INFO_FAMILY, Bytes.toBytes((String)"queue_time"), Bytes.toBytes((String)Integer.toString(slowLogPayload.getQueueTime()))).addColumn(HConstants.SLOWLOG_INFO_FAMILY, Bytes.toBytes((String)"region_name"), Bytes.toBytes((String)slowLogPayload.getRegionName())).addColumn(HConstants.SLOWLOG_INFO_FAMILY, Bytes.toBytes((String)"response_size"), Bytes.toBytes((String)Long.toString(slowLogPayload.getResponseSize()))).addColumn(HConstants.SLOWLOG_INFO_FAMILY, Bytes.toBytes((String)"server_class"), Bytes.toBytes((String)slowLogPayload.getServerClass())).addColumn(HConstants.SLOWLOG_INFO_FAMILY, Bytes.toBytes((String)"start_time"), Bytes.toBytes((String)Long.toString(slowLogPayload.getStartTime()))).addColumn(HConstants.SLOWLOG_INFO_FAMILY, Bytes.toBytes((String)"type"), Bytes.toBytes((String)slowLogPayload.getType().name())).addColumn(HConstants.SLOWLOG_INFO_FAMILY, Bytes.toBytes((String)"username"), Bytes.toBytes((String)slowLogPayload.getUserName()));
            puts.add(put);
        }
        try {
            if (connection == null) {
                SlowLogTableAccessor.createConnection(configuration);
            }
            SlowLogTableAccessor.doPut(connection, puts);
        }
        catch (Exception e) {
            LOG.warn("Failed to add slow/large log records to hbase:slowlog table.", (Throwable)e);
        }
    }

    private static synchronized void createConnection(Configuration configuration) throws IOException {
        Configuration conf = new Configuration(configuration);
        conf.setInt("hbase.rpc.timeout", 20000);
        conf.setInt("hbase.client.retries.number", 5);
        conf.setInt("hbase.client.serverside.retries.multiplier", 1);
        connection = ConnectionFactory.createConnection(conf);
    }

    private static byte[] getRowKey(TooSlowLog.SlowLogPayload slowLogPayload) {
        String hashcode;
        String lastFiveDig = hashcode.substring((hashcode = String.valueOf(slowLogPayload.hashCode())).length() > 5 ? hashcode.length() - 5 : 0);
        if (lastFiveDig.startsWith("-")) {
            lastFiveDig = String.valueOf(RANDOM.nextInt(99999));
        }
        long currentTime = EnvironmentEdgeManager.currentTime();
        String timeAndHashcode = currentTime + lastFiveDig;
        long rowKeyLong = Long.parseLong(timeAndHashcode);
        return Bytes.toBytes((long)rowKeyLong);
    }

    static {
        SLOW_LOG_TABLE_NAME = TableName.valueOf((String)NamespaceDescriptor.SYSTEM_NAMESPACE_NAME_STR, (String)"slowlog");
    }
}

