/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.AsyncConnectionImpl;
import org.apache.hadoop.hbase.client.AsyncTable;
import org.apache.hadoop.hbase.client.AsyncTableRegionLocator;
import org.apache.hadoop.hbase.client.CheckAndMutate;
import org.apache.hadoop.hbase.client.CheckAndMutateResult;
import org.apache.hadoop.hbase.client.ClientCoprocessorRpcController;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.CoprocessorBlockingRpcCallback;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionCoprocessorRpcChannelImpl;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ConcurrentMapUtils;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FutureUtils;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hbase.thirdparty.com.google.common.primitives.Booleans;
import org.apache.hbase.thirdparty.com.google.protobuf.Descriptors;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcCallback;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.apache.hbase.thirdparty.com.google.protobuf.Service;
import org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
class TableOverAsyncTable
implements Table {
    private static final Logger LOG = LoggerFactory.getLogger(TableOverAsyncTable.class);
    private final AsyncConnectionImpl conn;
    private final AsyncTable<?> table;
    private final ConcurrentMapUtils.IOExceptionSupplier<ExecutorService> poolSupplier;

    TableOverAsyncTable(AsyncConnectionImpl conn, AsyncTable<?> table, ConcurrentMapUtils.IOExceptionSupplier<ExecutorService> poolSupplier) {
        this.conn = conn;
        this.table = table;
        this.poolSupplier = poolSupplier;
    }

    @Override
    public TableName getName() {
        return this.table.getName();
    }

    @Override
    public Configuration getConfiguration() {
        return this.table.getConfiguration();
    }

    @Override
    public TableDescriptor getDescriptor() throws IOException {
        return (TableDescriptor)FutureUtils.get(this.conn.getAdmin().getDescriptor(this.getName()));
    }

    @Override
    public boolean exists(Get get) throws IOException {
        return (Boolean)FutureUtils.get(this.table.exists(get));
    }

    @Override
    public boolean[] exists(List<Get> gets) throws IOException {
        return Booleans.toArray((Collection)((Collection)FutureUtils.get(this.table.existsAll(gets))));
    }

    @Override
    public void batch(List<? extends Row> actions, Object[] results) throws IOException {
        if (ArrayUtils.isEmpty((Object[])results)) {
            FutureUtils.get(this.table.batchAll(actions));
            return;
        }
        ArrayList<RetriesExhaustedException.ThrowableWithExtraContext> errors = new ArrayList<RetriesExhaustedException.ThrowableWithExtraContext>();
        List futures = this.table.batch(actions);
        int n = results.length;
        for (int i = 0; i < n; ++i) {
            try {
                results[i] = FutureUtils.get((Future)futures.get(i));
                continue;
            }
            catch (IOException e) {
                results[i] = e;
                errors.add(new RetriesExhaustedException.ThrowableWithExtraContext(e, EnvironmentEdgeManager.currentTime(), "Error when processing " + actions.get(i)));
            }
        }
        if (!errors.isEmpty()) {
            throw new RetriesExhaustedException(errors.size(), errors);
        }
    }

    @Override
    public <R> void batchCallback(List<? extends Row> actions, Object[] results, Batch.Callback<R> callback) throws IOException, InterruptedException {
        ConcurrentLinkedQueue errors = new ConcurrentLinkedQueue();
        CountDownLatch latch = new CountDownLatch(actions.size());
        AsyncTableRegionLocator locator = this.conn.getRegionLocator(this.getName());
        List futures = this.table.batch(actions);
        int n = futures.size();
        for (int i = 0; i < n; ++i) {
            int index = i;
            FutureUtils.addListener(futures.get(i), (r, e) -> {
                if (e != null) {
                    errors.add(new RetriesExhaustedException.ThrowableWithExtraContext((Throwable)e, EnvironmentEdgeManager.currentTime(), "Error when processing " + actions.get(index)));
                    if (!ArrayUtils.isEmpty((Object[])results)) {
                        results[index] = e;
                    }
                    latch.countDown();
                } else {
                    if (!ArrayUtils.isEmpty((Object[])results)) {
                        results[index] = r;
                    }
                    FutureUtils.addListener(locator.getRegionLocation(((Row)actions.get(index)).getRow()), (l, le) -> {
                        if (le != null) {
                            errors.add(new RetriesExhaustedException.ThrowableWithExtraContext((Throwable)le, EnvironmentEdgeManager.currentTime(), "Error when finding the region for row " + Bytes.toStringBinary((byte[])((Row)actions.get(index)).getRow())));
                        } else {
                            callback.update(l.getRegion().getRegionName(), ((Row)actions.get(index)).getRow(), r);
                        }
                        latch.countDown();
                    });
                }
            });
        }
        latch.await();
        if (!errors.isEmpty()) {
            throw new RetriesExhaustedException(errors.size(), errors.stream().collect(Collectors.toList()));
        }
    }

    @Override
    public Result get(Get get) throws IOException {
        return (Result)FutureUtils.get(this.table.get(get));
    }

    @Override
    public Result[] get(List<Get> gets) throws IOException {
        return ((List)FutureUtils.get(this.table.getAll(gets))).toArray(new Result[0]);
    }

    @Override
    public ResultScanner getScanner(Scan scan) throws IOException {
        return this.table.getScanner(scan);
    }

    @Override
    public ResultScanner getScanner(byte[] family) throws IOException {
        return this.table.getScanner(family);
    }

    @Override
    public ResultScanner getScanner(byte[] family, byte[] qualifier) throws IOException {
        return this.table.getScanner(family, qualifier);
    }

    @Override
    public void put(Put put) throws IOException {
        FutureUtils.get(this.table.put(put));
    }

    @Override
    public void put(List<Put> puts) throws IOException {
        FutureUtils.get(this.table.putAll(puts));
    }

    @Override
    public void delete(Delete delete) throws IOException {
        FutureUtils.get(this.table.delete(delete));
    }

    @Override
    public void delete(List<Delete> deletes) throws IOException {
        FutureUtils.get(this.table.deleteAll(deletes));
    }

    @Override
    public Table.CheckAndMutateBuilder checkAndMutate(final byte[] row, final byte[] family) {
        return new Table.CheckAndMutateBuilder(){
            private final AsyncTable.CheckAndMutateBuilder builder;
            {
                this.builder = TableOverAsyncTable.this.table.checkAndMutate(row, family);
            }

            @Override
            public Table.CheckAndMutateBuilder qualifier(byte[] qualifier) {
                this.builder.qualifier(qualifier);
                return this;
            }

            @Override
            public Table.CheckAndMutateBuilder timeRange(TimeRange timeRange) {
                this.builder.timeRange(timeRange);
                return this;
            }

            @Override
            public Table.CheckAndMutateBuilder ifNotExists() {
                this.builder.ifNotExists();
                return this;
            }

            @Override
            public Table.CheckAndMutateBuilder ifMatches(CompareOperator compareOp, byte[] value) {
                this.builder.ifMatches(compareOp, value);
                return this;
            }

            @Override
            public boolean thenPut(Put put) throws IOException {
                return (Boolean)FutureUtils.get(this.builder.thenPut(put));
            }

            @Override
            public boolean thenDelete(Delete delete) throws IOException {
                return (Boolean)FutureUtils.get(this.builder.thenDelete(delete));
            }

            @Override
            public boolean thenMutate(RowMutations mutation) throws IOException {
                return (Boolean)FutureUtils.get(this.builder.thenMutate(mutation));
            }
        };
    }

    @Override
    public Table.CheckAndMutateWithFilterBuilder checkAndMutate(final byte[] row, final Filter filter) {
        return new Table.CheckAndMutateWithFilterBuilder(){
            private final AsyncTable.CheckAndMutateWithFilterBuilder builder;
            {
                this.builder = TableOverAsyncTable.this.table.checkAndMutate(row, filter);
            }

            @Override
            public Table.CheckAndMutateWithFilterBuilder timeRange(TimeRange timeRange) {
                this.builder.timeRange(timeRange);
                return this;
            }

            @Override
            public boolean thenPut(Put put) throws IOException {
                return (Boolean)FutureUtils.get(this.builder.thenPut(put));
            }

            @Override
            public boolean thenDelete(Delete delete) throws IOException {
                return (Boolean)FutureUtils.get(this.builder.thenDelete(delete));
            }

            @Override
            public boolean thenMutate(RowMutations mutation) throws IOException {
                return (Boolean)FutureUtils.get(this.builder.thenMutate(mutation));
            }
        };
    }

    @Override
    public CheckAndMutateResult checkAndMutate(CheckAndMutate checkAndMutate) throws IOException {
        return (CheckAndMutateResult)FutureUtils.get(this.table.checkAndMutate(checkAndMutate));
    }

    @Override
    public List<CheckAndMutateResult> checkAndMutate(List<CheckAndMutate> checkAndMutates) throws IOException {
        return (List)FutureUtils.get(this.table.checkAndMutateAll(checkAndMutates));
    }

    @Override
    public Result mutateRow(RowMutations rm) throws IOException {
        return (Result)FutureUtils.get(this.table.mutateRow(rm));
    }

    @Override
    public Result append(Append append) throws IOException {
        return (Result)FutureUtils.get(this.table.append(append));
    }

    @Override
    public Result increment(Increment increment) throws IOException {
        return (Result)FutureUtils.get(this.table.increment(increment));
    }

    @Override
    public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount) throws IOException {
        return (Long)FutureUtils.get(this.table.incrementColumnValue(row, family, qualifier, amount));
    }

    @Override
    public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount, Durability durability) throws IOException {
        return (Long)FutureUtils.get(this.table.incrementColumnValue(row, family, qualifier, amount, durability));
    }

    @Override
    public void close() {
    }

    @Override
    public RegionCoprocessorRpcChannel coprocessorService(byte[] row) {
        return new RegionCoprocessorRpcChannel(this.conn, this.getName(), null, row, this.getRpcTimeout(TimeUnit.NANOSECONDS), this.getOperationTimeout(TimeUnit.NANOSECONDS));
    }

    private Pair<List<byte[]>, List<HRegionLocation>> getKeysAndRegionsInRange(byte[] startKey, byte[] endKey, boolean includeEndKey) throws IOException {
        return this.getKeysAndRegionsInRange(startKey, endKey, includeEndKey, false);
    }

    private Pair<List<byte[]>, List<HRegionLocation>> getKeysAndRegionsInRange(byte[] startKey, byte[] endKey, boolean includeEndKey, boolean reload) throws IOException {
        HRegionLocation regionLocation;
        boolean endKeyIsEndOfTable = Bytes.equals((byte[])endKey, (byte[])HConstants.EMPTY_END_ROW);
        if (Bytes.compareTo((byte[])startKey, (byte[])endKey) > 0 && !endKeyIsEndOfTable) {
            throw new IllegalArgumentException("Invalid range: " + Bytes.toStringBinary((byte[])startKey) + " > " + Bytes.toStringBinary((byte[])endKey));
        }
        ArrayList<byte[]> keysInRange = new ArrayList<byte[]>();
        ArrayList<HRegionLocation> regionsInRange = new ArrayList<HRegionLocation>();
        byte[] currentKey = startKey;
        do {
            regionLocation = (HRegionLocation)FutureUtils.get(this.conn.getRegionLocator(this.getName()).getRegionLocation(currentKey, reload));
            keysInRange.add(currentKey);
            regionsInRange.add(regionLocation);
        } while (!Bytes.equals((byte[])(currentKey = regionLocation.getRegion().getEndKey()), (byte[])HConstants.EMPTY_END_ROW) && (endKeyIsEndOfTable || Bytes.compareTo((byte[])currentKey, (byte[])endKey) < 0 || includeEndKey && Bytes.compareTo((byte[])currentKey, (byte[])endKey) == 0));
        return new Pair(keysInRange, regionsInRange);
    }

    private List<byte[]> getStartKeysInRange(byte[] start, byte[] end) throws IOException {
        if (start == null) {
            start = HConstants.EMPTY_START_ROW;
        }
        if (end == null) {
            end = HConstants.EMPTY_END_ROW;
        }
        return (List)this.getKeysAndRegionsInRange(start, end, true).getFirst();
    }

    private <R> void coprocssorService(String serviceName, byte[] startKey, byte[] endKey, final Batch.Callback<R> callback, final StubCall<R> call) throws Throwable {
        ExecutorService pool = (ExecutorService)this.poolSupplier.get();
        List<byte[]> keys = this.getStartKeysInRange(startKey, endKey);
        TreeMap futures = new TreeMap(Bytes.BYTES_COMPARATOR);
        try {
            for (final byte[] byArray : keys) {
                final RegionCoprocessorRpcChannel channel = this.coprocessorService(byArray);
                Future future = pool.submit(new Callable<R>(){

                    @Override
                    public R call() throws Exception {
                        Object result = call.call(channel);
                        byte[] region = channel.getLastRegion();
                        if (callback != null) {
                            callback.update(region, byArray, result);
                        }
                        return result;
                    }
                });
                futures.put(byArray, future);
            }
        }
        catch (RejectedExecutionException e) {
            if (this.conn.isClosed()) {
                throw new DoNotRetryIOException("Connection is closed", e);
            }
            throw new HBaseIOException("Coprocessor operation is rejected", (Throwable)e);
        }
        for (Map.Entry entry : futures.entrySet()) {
            try {
                ((Future)entry.getValue()).get();
            }
            catch (ExecutionException ee) {
                LOG.warn("Error calling coprocessor service " + serviceName + " for row " + Bytes.toStringBinary((byte[])((byte[])entry.getKey())), (Throwable)ee);
                throw ee.getCause();
            }
            catch (InterruptedException ie) {
                throw new InterruptedIOException("Interrupted calling coprocessor service " + serviceName + " for row " + Bytes.toStringBinary((byte[])((byte[])entry.getKey()))).initCause(ie);
            }
        }
    }

    @Override
    public <T extends Service, R> void coprocessorService(Class<T> service, byte[] startKey, byte[] endKey, Batch.Call<T, R> callable, Batch.Callback<R> callback) throws ServiceException, Throwable {
        this.coprocssorService(service.getName(), startKey, endKey, callback, channel -> {
            Object instance = ProtobufUtil.newServiceStub(service, channel);
            return callable.call(instance);
        });
    }

    @Override
    public <R extends Message> void batchCoprocessorService(Descriptors.MethodDescriptor methodDescriptor, Message request, byte[] startKey, byte[] endKey, R responsePrototype, Batch.Callback<R> callback) throws ServiceException, Throwable {
        this.coprocssorService(methodDescriptor.getFullName(), startKey, endKey, callback, channel -> channel.callBlockingMethod(methodDescriptor, null, request, responsePrototype));
    }

    @Override
    public long getRpcTimeout(TimeUnit unit) {
        return this.table.getRpcTimeout(unit);
    }

    @Override
    public long getReadRpcTimeout(TimeUnit unit) {
        return this.table.getReadRpcTimeout(unit);
    }

    @Override
    public long getWriteRpcTimeout(TimeUnit unit) {
        return this.table.getWriteRpcTimeout(unit);
    }

    @Override
    public long getOperationTimeout(TimeUnit unit) {
        return this.table.getOperationTimeout(unit);
    }

    @Override
    public RegionLocator getRegionLocator() throws IOException {
        return this.conn.toConnection().getRegionLocator(this.getName());
    }

    @FunctionalInterface
    private static interface StubCall<R> {
        public R call(RegionCoprocessorRpcChannel var1) throws Exception;
    }

    private static final class RegionCoprocessorRpcChannel
    extends RegionCoprocessorRpcChannelImpl
    implements CoprocessorRpcChannel {
        RegionCoprocessorRpcChannel(AsyncConnectionImpl conn, TableName tableName, RegionInfo region, byte[] row, long rpcTimeoutNs, long operationTimeoutNs) {
            super(conn, tableName, region, row, rpcTimeoutNs, operationTimeoutNs);
        }

        @Override
        public void callMethod(Descriptors.MethodDescriptor method, RpcController controller, Message request, Message responsePrototype, RpcCallback<Message> done) {
            Message ret;
            ClientCoprocessorRpcController c = new ClientCoprocessorRpcController();
            CoprocessorBlockingRpcCallback<Message> callback = new CoprocessorBlockingRpcCallback<Message>();
            super.callMethod(method, c, request, responsePrototype, callback);
            try {
                ret = callback.get();
            }
            catch (IOException e) {
                ConnectionUtils.setCoprocessorError(controller, e);
                return;
            }
            if (c.failed()) {
                ConnectionUtils.setCoprocessorError(controller, c.getFailed());
            }
            done.run((Object)ret);
        }

        public Message callBlockingMethod(Descriptors.MethodDescriptor method, RpcController controller, Message request, Message responsePrototype) throws ServiceException {
            Message ret;
            ClientCoprocessorRpcController c = new ClientCoprocessorRpcController();
            CoprocessorBlockingRpcCallback<Message> done = new CoprocessorBlockingRpcCallback<Message>();
            this.callMethod(method, c, request, responsePrototype, done);
            try {
                ret = done.get();
            }
            catch (IOException e) {
                throw new ServiceException((Throwable)e);
            }
            if (c.failed()) {
                ConnectionUtils.setCoprocessorError(controller, c.getFailed());
                throw new ServiceException(c.getFailed());
            }
            return ret;
        }
    }
}

