/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hbase.KeepDeletedCells;
import org.apache.hadoop.hbase.MemoryCompactionPolicy;
import org.apache.hadoop.hbase.client.MobCompactPartitionPolicy;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public interface ColumnFamilyDescriptor {
    @InterfaceAudience.Private
    public static final Comparator<ColumnFamilyDescriptor> COMPARATOR = (lhs, rhs) -> {
        int result = Bytes.compareTo((byte[])lhs.getName(), (byte[])rhs.getName());
        if (result != 0) {
            return result;
        }
        result = lhs.getValues().hashCode() - rhs.getValues().hashCode();
        if (result != 0) {
            return result;
        }
        return lhs.getConfiguration().hashCode() - rhs.getConfiguration().hashCode();
    };
    public static final Bytes REPLICATION_SCOPE_BYTES = new Bytes(Bytes.toBytes((String)"REPLICATION_SCOPE"));
    @InterfaceAudience.Private
    public static final Comparator<ColumnFamilyDescriptor> COMPARATOR_IGNORE_REPLICATION = (lcf, rcf) -> {
        int result = Bytes.compareTo((byte[])lcf.getName(), (byte[])rcf.getName());
        if (result != 0) {
            return result;
        }
        HashMap<Bytes, Bytes> lValues = new HashMap<Bytes, Bytes>();
        lValues.putAll(lcf.getValues());
        lValues.remove(REPLICATION_SCOPE_BYTES);
        HashMap<Bytes, Bytes> rValues = new HashMap<Bytes, Bytes>();
        rValues.putAll(rcf.getValues());
        rValues.remove(REPLICATION_SCOPE_BYTES);
        result = lValues.hashCode() - rValues.hashCode();
        if (result != 0) {
            return result;
        }
        return lcf.getConfiguration().hashCode() - rcf.getConfiguration().hashCode();
    };

    public int getBlocksize();

    public BloomType getBloomFilterType();

    public Compression.Algorithm getCompactionCompressionType();

    public Compression.Algorithm getMajorCompactionCompressionType();

    public Compression.Algorithm getMinorCompactionCompressionType();

    public Compression.Algorithm getCompressionType();

    public Map<String, String> getConfiguration();

    public String getConfigurationValue(String var1);

    public short getDFSReplication();

    public DataBlockEncoding getDataBlockEncoding();

    public byte[] getEncryptionKey();

    public String getEncryptionType();

    public MemoryCompactionPolicy getInMemoryCompaction();

    public KeepDeletedCells getKeepDeletedCells();

    public int getMaxVersions();

    public int getMinVersions();

    public MobCompactPartitionPolicy getMobCompactPartitionPolicy();

    public long getMobThreshold();

    public byte[] getName();

    public String getNameAsString();

    public int getScope();

    public String getStoragePolicy();

    public int getTimeToLive();

    public Bytes getValue(Bytes var1);

    public byte[] getValue(byte[] var1);

    public Map<Bytes, Bytes> getValues();

    public boolean isBlockCacheEnabled();

    public boolean isCacheBloomsOnWrite();

    public boolean isCacheDataOnWrite();

    public boolean isCacheIndexesOnWrite();

    public boolean isCompressTags();

    public boolean isEvictBlocksOnClose();

    public boolean isInMemory();

    public boolean isMobEnabled();

    public boolean isPrefetchBlocksOnOpen();

    public String toStringCustomizedValues();

    public boolean isNewVersionBehavior();
}

