/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.CatalogFamilyFormat;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AdvancedScanResultConsumer;
import org.apache.hadoop.hbase.client.AsyncTable;
import org.apache.hadoop.hbase.client.Consistency;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FutureUtils;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class ClientMetaTableAccessor {
    private static final Logger LOG = LoggerFactory.getLogger(ClientMetaTableAccessor.class);

    private ClientMetaTableAccessor() {
    }

    public static CompletableFuture<Boolean> tableExists(AsyncTable<?> metaTable, TableName tableName) {
        return ClientMetaTableAccessor.getTableState(metaTable, tableName).thenApply(Optional::isPresent);
    }

    public static CompletableFuture<Optional<TableState>> getTableState(AsyncTable<?> metaTable, TableName tableName) {
        CompletableFuture<Optional<TableState>> future = new CompletableFuture<Optional<TableState>>();
        Get get = new Get(tableName.getName()).addColumn(HConstants.TABLE_FAMILY, HConstants.TABLE_STATE_QUALIFIER);
        FutureUtils.addListener(metaTable.get(get), (result, error) -> {
            if (error != null) {
                future.completeExceptionally((Throwable)error);
                return;
            }
            try {
                future.complete(ClientMetaTableAccessor.getTableState(result));
            }
            catch (IOException e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    public static CompletableFuture<Optional<HRegionLocation>> getRegionLocation(AsyncTable<?> metaTable, byte[] regionName) {
        CompletableFuture<Optional<HRegionLocation>> future = new CompletableFuture<Optional<HRegionLocation>>();
        try {
            RegionInfo parsedRegionInfo = CatalogFamilyFormat.parseRegionInfoFromRegionName(regionName);
            FutureUtils.addListener(metaTable.get(new Get(CatalogFamilyFormat.getMetaKeyForRegion(parsedRegionInfo)).addFamily(HConstants.CATALOG_FAMILY)), (r, err) -> {
                if (err != null) {
                    future.completeExceptionally((Throwable)err);
                    return;
                }
                future.complete(ClientMetaTableAccessor.getRegionLocations(r).map(locations -> locations.getRegionLocation(parsedRegionInfo.getReplicaId())));
            });
        }
        catch (IOException parseEx) {
            LOG.warn("Failed to parse the passed region name: " + Bytes.toStringBinary((byte[])regionName));
            future.completeExceptionally(parseEx);
        }
        return future;
    }

    public static CompletableFuture<Optional<HRegionLocation>> getRegionLocationWithEncodedName(AsyncTable<?> metaTable, byte[] encodedRegionName) {
        CompletableFuture<Optional<HRegionLocation>> future = new CompletableFuture<Optional<HRegionLocation>>();
        FutureUtils.addListener(metaTable.scanAll(new Scan().setReadType(Scan.ReadType.PREAD).addFamily(HConstants.CATALOG_FAMILY)), (results, err) -> {
            if (err != null) {
                future.completeExceptionally((Throwable)err);
                return;
            }
            String encodedRegionNameStr = Bytes.toString((byte[])encodedRegionName);
            results.stream().filter(result -> !result.isEmpty()).filter(result -> CatalogFamilyFormat.getRegionInfo(result) != null).forEach(result -> ClientMetaTableAccessor.getRegionLocations(result).ifPresent(locations -> {
                for (HRegionLocation location : locations.getRegionLocations()) {
                    if (location == null || !encodedRegionNameStr.equals(location.getRegion().getEncodedName())) continue;
                    future.complete(Optional.of(location));
                    return;
                }
            }));
            future.complete(Optional.empty());
        });
        return future;
    }

    private static Optional<TableState> getTableState(Result r) throws IOException {
        return Optional.ofNullable(CatalogFamilyFormat.getTableState(r));
    }

    public static CompletableFuture<List<HRegionLocation>> getTableHRegionLocations(AsyncTable<AdvancedScanResultConsumer> metaTable, TableName tableName) {
        CompletableFuture<List<HRegionLocation>> future = new CompletableFuture<List<HRegionLocation>>();
        FutureUtils.addListener(ClientMetaTableAccessor.getTableRegionsAndLocations(metaTable, tableName, true), (locations, err) -> {
            if (err != null) {
                future.completeExceptionally((Throwable)err);
            } else if (locations == null || locations.isEmpty()) {
                future.complete(Collections.emptyList());
            } else {
                List regionLocations = locations.stream().map(loc -> new HRegionLocation((RegionInfo)loc.getFirst(), (ServerName)loc.getSecond())).collect(Collectors.toList());
                future.complete(regionLocations);
            }
        });
        return future;
    }

    private static CompletableFuture<List<Pair<RegionInfo, ServerName>>> getTableRegionsAndLocations(AsyncTable<AdvancedScanResultConsumer> metaTable, TableName tableName, boolean excludeOfflinedSplitParents) {
        CompletableFuture<List<Pair<RegionInfo, ServerName>>> future = new CompletableFuture<List<Pair<RegionInfo, ServerName>>>();
        if (TableName.META_TABLE_NAME.equals((Object)tableName)) {
            future.completeExceptionally(new IOException("This method can't be used to locate meta regions; use MetaTableLocator instead"));
        }
        CollectRegionLocationsVisitor visitor = new CollectRegionLocationsVisitor(excludeOfflinedSplitParents);
        FutureUtils.addListener(ClientMetaTableAccessor.scanMeta(metaTable, tableName, QueryType.REGION, visitor), (v, error) -> {
            if (error != null) {
                future.completeExceptionally((Throwable)error);
                return;
            }
            future.complete(visitor.getResults());
        });
        return future;
    }

    private static CompletableFuture<Void> scanMeta(AsyncTable<AdvancedScanResultConsumer> metaTable, TableName tableName, QueryType type, Visitor visitor) {
        return ClientMetaTableAccessor.scanMeta(metaTable, ClientMetaTableAccessor.getTableStartRowForMeta(tableName, type), ClientMetaTableAccessor.getTableStopRowForMeta(tableName, type), type, Integer.MAX_VALUE, visitor);
    }

    private static CompletableFuture<Void> scanMeta(AsyncTable<AdvancedScanResultConsumer> metaTable, byte[] startRow, byte[] stopRow, QueryType type, int maxRows, Visitor visitor) {
        int rowUpperLimit = maxRows > 0 ? maxRows : Integer.MAX_VALUE;
        Scan scan = ClientMetaTableAccessor.getMetaScan(metaTable, rowUpperLimit);
        for (byte[] family : type.getFamilies()) {
            scan.addFamily(family);
        }
        if (startRow != null) {
            scan.withStartRow(startRow);
        }
        if (stopRow != null) {
            scan.withStopRow(stopRow);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Scanning META starting at row=" + Bytes.toStringBinary((byte[])scan.getStartRow()) + " stopping at row=" + Bytes.toStringBinary((byte[])scan.getStopRow()) + " for max=" + rowUpperLimit + " with caching=" + scan.getCaching());
        }
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        metaTable.scan(scan, new MetaTableScanResultConsumer(rowUpperLimit, visitor, future));
        return future;
    }

    private static Scan getMetaScan(AsyncTable<?> metaTable, int rowUpperLimit) {
        Scan scan = new Scan();
        int scannerCaching = metaTable.getConfiguration().getInt("hbase.meta.scanner.caching", 100);
        if (metaTable.getConfiguration().getBoolean("hbase.meta.replicas.use", false)) {
            scan.setConsistency(Consistency.TIMELINE);
        }
        if (rowUpperLimit <= scannerCaching) {
            scan.setLimit(rowUpperLimit);
        }
        int rows = Math.min(rowUpperLimit, scannerCaching);
        scan.setCaching(rows);
        return scan;
    }

    private static Optional<RegionLocations> getRegionLocations(Result r) {
        return Optional.ofNullable(CatalogFamilyFormat.getRegionLocations(r));
    }

    public static byte[] getTableStartRowForMeta(TableName tableName, QueryType type) {
        if (tableName == null) {
            return null;
        }
        switch (type) {
            case REGION: 
            case REPLICATION: {
                byte[] startRow = new byte[tableName.getName().length + 2];
                System.arraycopy(tableName.getName(), 0, startRow, 0, tableName.getName().length);
                startRow[startRow.length - 2] = 44;
                startRow[startRow.length - 1] = 44;
                return startRow;
            }
        }
        return tableName.getName();
    }

    public static byte[] getTableStopRowForMeta(TableName tableName, QueryType type) {
        byte[] stopRow;
        if (tableName == null) {
            return null;
        }
        switch (type) {
            case REGION: 
            case REPLICATION: {
                stopRow = new byte[tableName.getName().length + 3];
                System.arraycopy(tableName.getName(), 0, stopRow, 0, tableName.getName().length);
                stopRow[stopRow.length - 3] = 32;
                stopRow[stopRow.length - 2] = 44;
                stopRow[stopRow.length - 1] = 44;
                break;
            }
            default: {
                stopRow = new byte[tableName.getName().length + 1];
                System.arraycopy(tableName.getName(), 0, stopRow, 0, tableName.getName().length);
                stopRow[stopRow.length - 1] = 32;
            }
        }
        return stopRow;
    }

    static class CollectAllVisitor
    extends CollectingVisitor<Result> {
        CollectAllVisitor() {
        }

        @Override
        void add(Result r) {
            this.results.add(r);
        }
    }

    static class CollectRegionLocationsVisitor
    extends CollectingVisitor<Pair<RegionInfo, ServerName>> {
        private final boolean excludeOfflinedSplitParents;
        private RegionLocations current = null;

        CollectRegionLocationsVisitor(boolean excludeOfflinedSplitParents) {
            this.excludeOfflinedSplitParents = excludeOfflinedSplitParents;
        }

        @Override
        public boolean visit(Result r) throws IOException {
            Optional currentRegionLocations = ClientMetaTableAccessor.getRegionLocations(r);
            this.current = currentRegionLocations.orElse(null);
            if (this.current == null || this.current.getRegionLocation().getRegion() == null) {
                LOG.warn("No serialized RegionInfo in " + r);
                return true;
            }
            RegionInfo hri = this.current.getRegionLocation().getRegion();
            if (this.excludeOfflinedSplitParents && hri.isSplitParent()) {
                return true;
            }
            return super.visit(r);
        }

        @Override
        void add(Result r) {
            if (this.current == null) {
                return;
            }
            for (HRegionLocation loc : this.current.getRegionLocations()) {
                if (loc == null) continue;
                this.results.add(new Pair((Object)loc.getRegion(), (Object)loc.getServerName()));
            }
        }
    }

    private static abstract class CollectingVisitor<T>
    implements Visitor {
        final List<T> results = new ArrayList<T>();

        private CollectingVisitor() {
        }

        @Override
        public boolean visit(Result r) throws IOException {
            if (r != null && !r.isEmpty()) {
                this.add(r);
            }
            return true;
        }

        abstract void add(Result var1);

        List<T> getResults() {
            return this.results;
        }
    }

    public static interface CloseableVisitor
    extends Visitor,
    Closeable {
    }

    public static interface Visitor {
        public boolean visit(Result var1) throws IOException;
    }

    private static final class MetaTableScanResultConsumer
    implements AdvancedScanResultConsumer {
        private int currentRowCount;
        private final int rowUpperLimit;
        private final Visitor visitor;
        private final CompletableFuture<Void> future;

        MetaTableScanResultConsumer(int rowUpperLimit, Visitor visitor, CompletableFuture<Void> future) {
            this.rowUpperLimit = rowUpperLimit;
            this.visitor = visitor;
            this.future = future;
            this.currentRowCount = 0;
        }

        @Override
        public void onError(Throwable error) {
            this.future.completeExceptionally(error);
        }

        @Override
        @SuppressWarnings(value={"NP_NONNULL_PARAM_VIOLATION"}, justification="https://github.com/findbugsproject/findbugs/issues/79")
        public void onComplete() {
            this.future.complete(null);
        }

        @Override
        public void onNext(Result[] results, AdvancedScanResultConsumer.ScanController controller) {
            boolean terminateScan = false;
            for (Result result : results) {
                block5: {
                    try {
                        if (!this.visitor.visit(result)) {
                            terminateScan = true;
                        }
                        break block5;
                    }
                    catch (Exception e) {
                        this.future.completeExceptionally(e);
                        terminateScan = true;
                    }
                    break;
                }
                if (++this.currentRowCount < this.rowUpperLimit) continue;
                terminateScan = true;
                break;
            }
            if (terminateScan) {
                controller.terminate();
            }
        }
    }

    @InterfaceAudience.Private
    public static enum QueryType {
        ALL(HConstants.TABLE_FAMILY, HConstants.CATALOG_FAMILY),
        REGION(new byte[][]{HConstants.CATALOG_FAMILY}),
        TABLE(new byte[][]{HConstants.TABLE_FAMILY}),
        REPLICATION(new byte[][]{HConstants.REPLICATION_BARRIER_FAMILY});

        private final byte[][] families;

        private QueryType(byte[] ... families) {
            this.families = families;
        }

        byte[][] getFamilies() {
            return this.families;
        }
    }
}

