/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.Service;
import com.google.protobuf.ServiceException;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.AsyncProcess;
import org.apache.hadoop.hbase.client.AsyncProcessTask;
import org.apache.hadoop.hbase.client.AsyncRequestFuture;
import org.apache.hadoop.hbase.client.CancellableRegionServerCallable;
import org.apache.hadoop.hbase.client.CheckAndMutate;
import org.apache.hadoop.hbase.client.CheckAndMutateResult;
import org.apache.hadoop.hbase.client.ClientAsyncPrefetchScanner;
import org.apache.hadoop.hbase.client.ClientServiceCallable;
import org.apache.hadoop.hbase.client.ClientSimpleScanner;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionConfiguration;
import org.apache.hadoop.hbase.client.ConnectionImplementation;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.Consistency;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HRegionLocator;
import org.apache.hadoop.hbase.client.ImmutableHTableDescriptor;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.MultiResponse;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.NoncedRegionServerCallable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionCoprocessorRpcChannel;
import org.apache.hadoop.hbase.client.RegionCoprocessorServiceExec;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.hadoop.hbase.client.RetryingTimeTracker;
import org.apache.hadoop.hbase.client.ReversedClientScanner;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.hadoop.hbase.client.RpcRetryingCallerWithReadReplicas;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableBuilderBase;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.client.trace.TableOperationSpanBuilder;
import org.apache.hadoop.hbase.client.trace.TableSpanBuilder;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.RequestConverter;
import org.apache.hadoop.hbase.shaded.protobuf.ResponseConverter;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.trace.HBaseSemanticAttributes;
import org.apache.hadoop.hbase.trace.TraceUtil;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.ReflectionUtils;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.hbase.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Stable
public class HTable
implements Table {
    private static final Logger LOG = LoggerFactory.getLogger(HTable.class);
    private static final Consistency DEFAULT_CONSISTENCY = Consistency.STRONG;
    private final ClusterConnection connection;
    private final TableName tableName;
    private final Configuration configuration;
    private final ConnectionConfiguration connConfiguration;
    private boolean closed = false;
    private final int scannerCaching;
    private final long scannerMaxResultSize;
    private final ExecutorService pool;
    private int operationTimeoutMs;
    private final int rpcTimeoutMs;
    private int readRpcTimeoutMs;
    private int writeRpcTimeoutMs;
    private final int scanReadRpcTimeout;
    private final int scanTimeout;
    private final boolean cleanupPoolOnClose;
    private final HRegionLocator locator;
    AsyncProcess multiAp;
    private final RpcRetryingCallerFactory rpcCallerFactory;
    private final RpcControllerFactory rpcControllerFactory;

    @InterfaceAudience.Private
    public static ThreadPoolExecutor getDefaultExecutor(Configuration conf) {
        int maxThreads = conf.getInt("hbase.htable.threads.max", Integer.MAX_VALUE);
        if (maxThreads == 0) {
            maxThreads = 1;
        }
        int corePoolSize = conf.getInt("hbase.htable.threads.coresize", 1);
        long keepAliveTime = conf.getLong("hbase.htable.threads.keepalivetime", 60L);
        ThreadPoolExecutor pool = new ThreadPoolExecutor(corePoolSize, maxThreads, keepAliveTime, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat("htable-pool-%d").setUncaughtExceptionHandler(Threads.LOGGING_EXCEPTION_HANDLER).build());
        pool.allowCoreThreadTimeOut(true);
        return pool;
    }

    @InterfaceAudience.Private
    protected HTable(ConnectionImplementation connection, TableBuilderBase builder, RpcRetryingCallerFactory rpcCallerFactory, RpcControllerFactory rpcControllerFactory, ExecutorService pool) {
        this.connection = (ClusterConnection)Preconditions.checkNotNull((Object)connection, (Object)"connection is null");
        this.configuration = connection.getConfiguration();
        this.connConfiguration = connection.getConnectionConfiguration();
        if (pool == null) {
            this.pool = HTable.getDefaultExecutor(this.configuration);
            this.cleanupPoolOnClose = true;
        } else {
            this.pool = pool;
            this.cleanupPoolOnClose = false;
        }
        this.rpcCallerFactory = rpcCallerFactory == null ? connection.getNewRpcRetryingCallerFactory(this.configuration) : rpcCallerFactory;
        this.rpcControllerFactory = rpcControllerFactory == null ? RpcControllerFactory.instantiate(this.configuration) : rpcControllerFactory;
        this.tableName = builder.tableName;
        this.operationTimeoutMs = builder.operationTimeout;
        this.rpcTimeoutMs = builder.rpcTimeout;
        this.readRpcTimeoutMs = builder.readRpcTimeout;
        this.writeRpcTimeoutMs = builder.writeRpcTimeout;
        this.scanReadRpcTimeout = builder.scanReadRpcTimeout;
        this.scanTimeout = builder.scanTimeout;
        this.scannerCaching = this.connConfiguration.getScannerCaching();
        this.scannerMaxResultSize = this.connConfiguration.getScannerMaxResultSize();
        this.multiAp = this.connection.getAsyncProcess();
        this.locator = new HRegionLocator(this.tableName, connection);
    }

    public static int getMaxKeyValueSize(Configuration conf) {
        return conf.getInt("hbase.client.keyvalue.maxsize", -1);
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public TableName getName() {
        return this.tableName;
    }

    protected Connection getConnection() {
        return this.connection;
    }

    @Override
    @Deprecated
    public HTableDescriptor getTableDescriptor() throws IOException {
        HTableDescriptor htd = HBaseAdmin.getHTableDescriptor(this.tableName, this.connection, this.rpcCallerFactory, this.rpcControllerFactory, this.operationTimeoutMs, this.readRpcTimeoutMs);
        if (htd != null) {
            return new ImmutableHTableDescriptor(htd);
        }
        return null;
    }

    @Override
    public TableDescriptor getDescriptor() throws IOException {
        return HBaseAdmin.getTableDescriptor(this.tableName, this.connection, this.rpcCallerFactory, this.rpcControllerFactory, this.operationTimeoutMs, this.readRpcTimeoutMs);
    }

    private Pair<List<byte[]>, List<HRegionLocation>> getKeysAndRegionsInRange(byte[] startKey, byte[] endKey, boolean includeEndKey) throws IOException {
        return this.getKeysAndRegionsInRange(startKey, endKey, includeEndKey, false);
    }

    private Pair<List<byte[]>, List<HRegionLocation>> getKeysAndRegionsInRange(byte[] startKey, byte[] endKey, boolean includeEndKey, boolean reload) throws IOException {
        HRegionLocation regionLocation;
        boolean endKeyIsEndOfTable = Bytes.equals((byte[])endKey, (byte[])HConstants.EMPTY_END_ROW);
        if (Bytes.compareTo((byte[])startKey, (byte[])endKey) > 0 && !endKeyIsEndOfTable) {
            throw new IllegalArgumentException("Invalid range: " + Bytes.toStringBinary((byte[])startKey) + " > " + Bytes.toStringBinary((byte[])endKey));
        }
        ArrayList<byte[]> keysInRange = new ArrayList<byte[]>();
        ArrayList<HRegionLocation> regionsInRange = new ArrayList<HRegionLocation>();
        byte[] currentKey = startKey;
        do {
            regionLocation = this.getRegionLocator().getRegionLocation(currentKey, reload);
            keysInRange.add(currentKey);
            regionsInRange.add(regionLocation);
        } while (!Bytes.equals((byte[])(currentKey = regionLocation.getRegionInfo().getEndKey()), (byte[])HConstants.EMPTY_END_ROW) && (endKeyIsEndOfTable || Bytes.compareTo((byte[])currentKey, (byte[])endKey) < 0 || includeEndKey && Bytes.compareTo((byte[])currentKey, (byte[])endKey) == 0));
        return new Pair(keysInRange, regionsInRange);
    }

    @Override
    public ResultScanner getScanner(Scan scan) throws IOException {
        Span span = new TableOperationSpanBuilder(this.connection).setTableName(this.tableName).setOperation(scan).build();
        try (Scope ignored = span.makeCurrent();){
            if (scan.getCaching() <= 0) {
                scan.setCaching(this.scannerCaching);
            }
            if (scan.getMaxResultSize() <= 0L) {
                scan.setMaxResultSize(this.scannerMaxResultSize);
            }
            if (scan.getMvccReadPoint() > 0L) {
                scan.resetMvccReadPoint();
            }
            boolean async = scan.isAsyncPrefetch() != null ? scan.isAsyncPrefetch().booleanValue() : this.connConfiguration.isClientScannerAsyncPrefetch();
            int replicaTimeout = this.connConfiguration.getReplicaCallTimeoutMicroSecondScan();
            if (scan.isReversed()) {
                ReversedClientScanner reversedClientScanner = new ReversedClientScanner(this.getConfiguration(), scan, this.getName(), this.connection, this.rpcCallerFactory, this.rpcControllerFactory, this.pool, this.scanReadRpcTimeout, this.scanTimeout, replicaTimeout);
                return reversedClientScanner;
            }
            if (async) {
                ClientAsyncPrefetchScanner clientAsyncPrefetchScanner = new ClientAsyncPrefetchScanner(this.getConfiguration(), scan, this.getName(), this.connection, this.rpcCallerFactory, this.rpcControllerFactory, this.pool, this.scanReadRpcTimeout, this.scanTimeout, replicaTimeout);
                return clientAsyncPrefetchScanner;
            }
            ClientSimpleScanner clientSimpleScanner = new ClientSimpleScanner(this.getConfiguration(), scan, this.getName(), this.connection, this.rpcCallerFactory, this.rpcControllerFactory, this.pool, this.scanReadRpcTimeout, this.scanTimeout, replicaTimeout);
            return clientSimpleScanner;
        }
    }

    @Override
    public ResultScanner getScanner(byte[] family) throws IOException {
        Scan scan = new Scan();
        scan.addFamily(family);
        return this.getScanner(scan);
    }

    @Override
    public ResultScanner getScanner(byte[] family, byte[] qualifier) throws IOException {
        Scan scan = new Scan();
        scan.addColumn(family, qualifier);
        return this.getScanner(scan);
    }

    @Override
    public Result get(Get get) throws IOException {
        TableOperationSpanBuilder supplier = new TableOperationSpanBuilder(this.connection).setTableName(this.tableName).setOperation(get);
        return (Result)TraceUtil.trace(() -> this.get(get, get.isCheckExistenceOnly()), (Supplier)supplier);
    }

    private Result get(Get get, boolean checkExistenceOnly) throws IOException {
        if (get.isCheckExistenceOnly() != checkExistenceOnly || get.getConsistency() == null) {
            get = (Get)ReflectionUtils.newInstance(get.getClass(), (Object[])new Object[]{get});
            get.setCheckExistenceOnly(checkExistenceOnly);
            if (get.getConsistency() == null) {
                get.setConsistency(DEFAULT_CONSISTENCY);
            }
        }
        if (get.getConsistency() == Consistency.STRONG) {
            final Get configuredGet = get;
            ClientServiceCallable<Result> callable = new ClientServiceCallable<Result>((Connection)this.connection, this.getName(), get.getRow(), (RpcController)this.rpcControllerFactory.newController(), get.getPriority()){

                @Override
                protected Result rpcCall() throws Exception {
                    ClientProtos.GetRequest request = RequestConverter.buildGetRequest(this.getLocation().getRegionInfo().getRegionName(), configuredGet);
                    ClientProtos.GetResponse response = this.doGet(request);
                    return response == null ? null : org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil.toResult(response.getResult(), this.getRpcControllerCellScanner());
                }
            };
            return this.rpcCallerFactory.newCaller(this.readRpcTimeoutMs).callWithRetries(callable, this.operationTimeoutMs);
        }
        RpcRetryingCallerWithReadReplicas callable = new RpcRetryingCallerWithReadReplicas(this.rpcControllerFactory, this.tableName, this.connection, get, this.pool, this.connConfiguration.getRetriesNumber(), this.operationTimeoutMs, this.readRpcTimeoutMs, this.connConfiguration.getPrimaryCallTimeoutMicroSecond());
        return callable.call(this.operationTimeoutMs);
    }

    @Override
    public Result[] get(List<Get> gets) throws IOException {
        TableOperationSpanBuilder supplier = new TableOperationSpanBuilder(this.connection).setTableName(this.tableName).setOperation(HBaseSemanticAttributes.Operation.BATCH).setContainerOperations(gets);
        return (Result[])TraceUtil.trace(() -> {
            if (gets.size() == 1) {
                return new Result[]{this.get((Get)gets.get(0))};
            }
            try {
                Object[] r1 = new Object[gets.size()];
                this.batch(gets, r1, this.readRpcTimeoutMs);
                Result[] results = new Result[r1.length];
                int i = 0;
                for (Object obj : r1) {
                    results[i++] = (Result)obj;
                }
                return results;
            }
            catch (InterruptedException e) {
                throw (InterruptedIOException)new InterruptedIOException().initCause(e);
            }
        }, (Supplier)supplier);
    }

    @Override
    public void batch(List<? extends Row> actions, Object[] results) throws InterruptedException, IOException {
        int rpcTimeout = this.writeRpcTimeoutMs;
        boolean hasRead = false;
        boolean hasWrite = false;
        for (Row row : actions) {
            if (row instanceof Mutation) {
                hasWrite = true;
            } else {
                hasRead = true;
            }
            if (!hasRead || !hasWrite) continue;
            break;
        }
        if (hasRead && !hasWrite) {
            rpcTimeout = this.readRpcTimeoutMs;
        }
        try {
            this.batch(actions, results, rpcTimeout);
        }
        catch (InterruptedException e) {
            throw (InterruptedIOException)new InterruptedIOException().initCause(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void batch(List<? extends Row> actions, Object[] results, int rpcTimeout) throws InterruptedException, IOException {
        AsyncProcessTask task = AsyncProcessTask.newBuilder().setPool(this.pool).setTableName(this.tableName).setRowAccess(actions).setResults(results).setRpcTimeout(rpcTimeout).setOperationTimeout(this.operationTimeoutMs).setSubmittedRows(AsyncProcessTask.SubmittedRows.ALL).build();
        Span span = new TableOperationSpanBuilder(this.connection).setTableName(this.tableName).setOperation(HBaseSemanticAttributes.Operation.BATCH).setContainerOperations(actions).build();
        try (Scope ignored = span.makeCurrent();){
            AsyncRequestFuture ars = this.multiAp.submit(task);
            ars.waitUntilDone();
            if (ars.hasError()) {
                TraceUtil.setError((Span)span, (Throwable)ars.getErrors());
                throw ars.getErrors();
            }
            span.setStatus(StatusCode.OK);
        }
        finally {
            span.end();
        }
    }

    @Override
    public <R> void batchCallback(List<? extends Row> actions, Object[] results, Batch.Callback<R> callback) throws IOException, InterruptedException {
        HTable.doBatchWithCallback(actions, results, callback, this.connection, this.pool, this.tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R> void doBatchWithCallback(List<? extends Row> actions, Object[] results, Batch.Callback<R> callback, ClusterConnection connection, ExecutorService pool, TableName tableName) throws InterruptedIOException, RetriesExhaustedWithDetailsException {
        int operationTimeout = connection.getConnectionConfiguration().getOperationTimeout();
        int writeTimeout = connection.getConfiguration().getInt("hbase.rpc.write.timeout", connection.getConfiguration().getInt("hbase.rpc.timeout", 60000));
        AsyncProcessTask<R> task = AsyncProcessTask.newBuilder(callback).setPool(pool).setTableName(tableName).setRowAccess(actions).setResults(results).setOperationTimeout(operationTimeout).setRpcTimeout(writeTimeout).setSubmittedRows(AsyncProcessTask.SubmittedRows.ALL).build();
        Span span = new TableOperationSpanBuilder(connection).setTableName(tableName).setOperation(HBaseSemanticAttributes.Operation.BATCH).setContainerOperations(actions).build();
        try (Scope ignored = span.makeCurrent();){
            AsyncRequestFuture ars = connection.getAsyncProcess().submit(task);
            ars.waitUntilDone();
            if (ars.hasError()) {
                TraceUtil.setError((Span)span, (Throwable)ars.getErrors());
                throw ars.getErrors();
            }
        }
        finally {
            span.end();
        }
    }

    @Override
    public void delete(final Delete delete) throws IOException {
        TableOperationSpanBuilder supplier = new TableOperationSpanBuilder(this.connection).setTableName(this.tableName).setOperation(delete);
        TraceUtil.trace(() -> {
            ClientServiceCallable<Void> callable = new ClientServiceCallable<Void>((Connection)this.connection, this.getName(), delete.getRow(), (RpcController)this.rpcControllerFactory.newController(), delete.getPriority()){

                @Override
                protected Void rpcCall() throws Exception {
                    ClientProtos.MutateRequest request = RequestConverter.buildMutateRequest(this.getLocation().getRegionInfo().getRegionName(), delete);
                    this.doMutate(request);
                    return null;
                }
            };
            this.rpcCallerFactory.newCaller(this.writeRpcTimeoutMs).callWithRetries(callable, this.operationTimeoutMs);
        }, (Supplier)supplier);
    }

    @Override
    public void delete(List<Delete> deletes) throws IOException {
        Object[] results = new Object[deletes.size()];
        try {
            this.batch(deletes, results, this.writeRpcTimeoutMs);
        }
        catch (InterruptedException e) {
            throw (InterruptedIOException)new InterruptedIOException().initCause(e);
        }
        finally {
            for (int i = results.length - 1; i >= 0; --i) {
                if (!(results[i] instanceof Result)) continue;
                deletes.remove(i);
            }
        }
    }

    @Override
    public void put(final Put put) throws IOException {
        TableOperationSpanBuilder supplier = new TableOperationSpanBuilder(this.connection).setTableName(this.tableName).setOperation(put);
        TraceUtil.trace(() -> {
            this.validatePut(put);
            ClientServiceCallable<Void> callable = new ClientServiceCallable<Void>((Connection)this.connection, this.getName(), put.getRow(), (RpcController)this.rpcControllerFactory.newController(), put.getPriority()){

                @Override
                protected Void rpcCall() throws Exception {
                    ClientProtos.MutateRequest request = RequestConverter.buildMutateRequest(this.getLocation().getRegionInfo().getRegionName(), put);
                    this.doMutate(request);
                    return null;
                }
            };
            this.rpcCallerFactory.newCaller(this.writeRpcTimeoutMs).callWithRetries(callable, this.operationTimeoutMs);
        }, (Supplier)supplier);
    }

    @Override
    public void put(List<Put> puts) throws IOException {
        for (Put put : puts) {
            this.validatePut(put);
        }
        Object[] results = new Object[puts.size()];
        try {
            this.batch(puts, results, this.writeRpcTimeoutMs);
        }
        catch (InterruptedException e) {
            throw (InterruptedIOException)new InterruptedIOException().initCause(e);
        }
    }

    @Override
    public Result mutateRow(final RowMutations rm) throws IOException {
        TableOperationSpanBuilder supplier = new TableOperationSpanBuilder(this.connection).setTableName(this.tableName).setOperation(HBaseSemanticAttributes.Operation.BATCH).setContainerOperations(rm);
        return (Result)TraceUtil.trace(() -> {
            final long nonceGroup = this.getNonceGroup();
            final long nonce = this.getNonce();
            CancellableRegionServerCallable<MultiResponse> callable = new CancellableRegionServerCallable<MultiResponse>((Connection)this.connection, this.getName(), rm.getRow(), (RpcController)this.rpcControllerFactory.newController(), this.writeRpcTimeoutMs, new RetryingTimeTracker().start(), rm.getMaxPriority()){

                @Override
                protected MultiResponse rpcCall() throws Exception {
                    ClientProtos.MultiRequest request = RequestConverter.buildMultiRequest(this.getLocation().getRegionInfo().getRegionName(), rm, nonceGroup, nonce);
                    ClientProtos.MultiResponse response = this.doMulti(request);
                    ClientProtos.RegionActionResult res = (ClientProtos.RegionActionResult)response.getRegionActionResultList().get(0);
                    if (res.hasException()) {
                        Throwable ex = org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil.toException(res.getException());
                        if (ex instanceof IOException) {
                            throw (IOException)ex;
                        }
                        throw new IOException("Failed to mutate row: " + Bytes.toStringBinary((byte[])rm.getRow()), ex);
                    }
                    return ResponseConverter.getResults(request, response, this.getRpcControllerCellScanner());
                }
            };
            Object[] results = new Object[rm.getMutations().size()];
            AsyncProcessTask task = AsyncProcessTask.newBuilder().setPool(this.pool).setTableName(this.tableName).setRowAccess(rm.getMutations()).setCallable(callable).setRpcTimeout(this.writeRpcTimeoutMs).setOperationTimeout(this.operationTimeoutMs).setSubmittedRows(AsyncProcessTask.SubmittedRows.ALL).setResults(results).build();
            AsyncRequestFuture ars = this.multiAp.submit(task);
            ars.waitUntilDone();
            if (ars.hasError()) {
                throw ars.getErrors();
            }
            return (Result)results[0];
        }, (Supplier)supplier);
    }

    private long getNonceGroup() {
        return ((ClusterConnection)this.getConnection()).getNonceGenerator().getNonceGroup();
    }

    private long getNonce() {
        return ((ClusterConnection)this.getConnection()).getNonceGenerator().newNonce();
    }

    @Override
    public Result append(final Append append) throws IOException {
        TableOperationSpanBuilder supplier = new TableOperationSpanBuilder(this.connection).setTableName(this.tableName).setOperation(append);
        return (Result)TraceUtil.trace(() -> {
            ConnectionUtils.checkHasFamilies(append);
            NoncedRegionServerCallable<Result> callable = new NoncedRegionServerCallable<Result>((Connection)this.connection, this.getName(), append.getRow(), this.rpcControllerFactory.newController(), append.getPriority()){

                @Override
                protected Result rpcCall() throws Exception {
                    ClientProtos.MutateRequest request = RequestConverter.buildMutateRequest(this.getLocation().getRegionInfo().getRegionName(), append, super.getNonceGroup(), super.getNonce());
                    ClientProtos.MutateResponse response = this.doMutate(request);
                    if (!response.hasResult()) {
                        return null;
                    }
                    return org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil.toResult(response.getResult(), this.getRpcControllerCellScanner());
                }
            };
            return this.rpcCallerFactory.newCaller(this.writeRpcTimeoutMs).callWithRetries(callable, this.operationTimeoutMs);
        }, (Supplier)supplier);
    }

    @Override
    public Result increment(final Increment increment) throws IOException {
        TableOperationSpanBuilder supplier = new TableOperationSpanBuilder(this.connection).setTableName(this.tableName).setOperation(increment);
        return (Result)TraceUtil.trace(() -> {
            ConnectionUtils.checkHasFamilies(increment);
            NoncedRegionServerCallable<Result> callable = new NoncedRegionServerCallable<Result>((Connection)this.connection, this.getName(), increment.getRow(), this.rpcControllerFactory.newController(), increment.getPriority()){

                @Override
                protected Result rpcCall() throws Exception {
                    ClientProtos.MutateRequest request = RequestConverter.buildMutateRequest(this.getLocation().getRegionInfo().getRegionName(), increment, super.getNonceGroup(), super.getNonce());
                    ClientProtos.MutateResponse response = this.doMutate(request);
                    return org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil.toResult(response.getResult(), this.getRpcControllerCellScanner());
                }
            };
            return this.rpcCallerFactory.newCaller(this.writeRpcTimeoutMs).callWithRetries(callable, this.operationTimeoutMs);
        }, (Supplier)supplier);
    }

    @Override
    public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount) throws IOException {
        return this.incrementColumnValue(row, family, qualifier, amount, Durability.SYNC_WAL);
    }

    @Override
    public long incrementColumnValue(final byte[] row, final byte[] family, final byte[] qualifier, final long amount, final Durability durability) throws IOException {
        TableOperationSpanBuilder supplier = new TableOperationSpanBuilder(this.connection).setTableName(this.tableName).setOperation(HBaseSemanticAttributes.Operation.INCREMENT);
        return (Long)TraceUtil.trace(() -> {
            NullPointerException npe = null;
            if (row == null) {
                npe = new NullPointerException("row is null");
            } else if (family == null) {
                npe = new NullPointerException("family is null");
            }
            if (npe != null) {
                throw new IOException("Invalid arguments to incrementColumnValue", npe);
            }
            NoncedRegionServerCallable<Long> callable = new NoncedRegionServerCallable<Long>((Connection)this.connection, this.getName(), row, this.rpcControllerFactory.newController(), -1){

                @Override
                protected Long rpcCall() throws Exception {
                    ClientProtos.MutateRequest request = RequestConverter.buildIncrementRequest(this.getLocation().getRegionInfo().getRegionName(), row, family, qualifier, amount, durability, super.getNonceGroup(), super.getNonce());
                    ClientProtos.MutateResponse response = this.doMutate(request);
                    Result result = org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil.toResult(response.getResult(), this.getRpcControllerCellScanner());
                    return Bytes.toLong((byte[])result.getValue(family, qualifier));
                }
            };
            return this.rpcCallerFactory.newCaller(this.writeRpcTimeoutMs).callWithRetries(callable, this.operationTimeoutMs);
        }, (Supplier)supplier);
    }

    @Override
    @Deprecated
    public boolean checkAndPut(byte[] row, byte[] family, byte[] qualifier, byte[] value, Put put) throws IOException {
        TableOperationSpanBuilder supplier = new TableOperationSpanBuilder(this.connection).setTableName(this.tableName).setOperation(HBaseSemanticAttributes.Operation.CHECK_AND_MUTATE).setContainerOperations(HBaseSemanticAttributes.Operation.CHECK_AND_MUTATE, HBaseSemanticAttributes.Operation.PUT);
        return (Boolean)TraceUtil.trace(() -> this.doCheckAndMutate(row, family, qualifier, CompareOperator.EQUAL, value, null, null, put).isSuccess(), (Supplier)supplier);
    }

    @Override
    @Deprecated
    public boolean checkAndPut(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, byte[] value, Put put) throws IOException {
        TableOperationSpanBuilder supplier = new TableOperationSpanBuilder(this.connection).setTableName(this.tableName).setOperation(HBaseSemanticAttributes.Operation.CHECK_AND_MUTATE).setContainerOperations(HBaseSemanticAttributes.Operation.CHECK_AND_MUTATE, HBaseSemanticAttributes.Operation.PUT);
        return (Boolean)TraceUtil.trace(() -> this.doCheckAndMutate(row, family, qualifier, this.toCompareOperator(compareOp), value, null, null, put).isSuccess(), (Supplier)supplier);
    }

    @Override
    @Deprecated
    public boolean checkAndPut(byte[] row, byte[] family, byte[] qualifier, CompareOperator op, byte[] value, Put put) throws IOException {
        TableOperationSpanBuilder supplier = new TableOperationSpanBuilder(this.connection).setTableName(this.tableName).setOperation(HBaseSemanticAttributes.Operation.CHECK_AND_MUTATE).setContainerOperations(HBaseSemanticAttributes.Operation.CHECK_AND_MUTATE, HBaseSemanticAttributes.Operation.PUT);
        return (Boolean)TraceUtil.trace(() -> this.doCheckAndMutate(row, family, qualifier, op, value, null, null, put).isSuccess(), (Supplier)supplier);
    }

    @Override
    @Deprecated
    public boolean checkAndDelete(byte[] row, byte[] family, byte[] qualifier, byte[] value, Delete delete) throws IOException {
        TableOperationSpanBuilder supplier = new TableOperationSpanBuilder(this.connection).setTableName(this.tableName).setOperation(HBaseSemanticAttributes.Operation.CHECK_AND_MUTATE).setContainerOperations(HBaseSemanticAttributes.Operation.CHECK_AND_MUTATE, HBaseSemanticAttributes.Operation.DELETE);
        return (Boolean)TraceUtil.trace(() -> this.doCheckAndMutate(row, family, qualifier, CompareOperator.EQUAL, value, null, null, delete).isSuccess(), (Supplier)supplier);
    }

    @Override
    @Deprecated
    public boolean checkAndDelete(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, byte[] value, Delete delete) throws IOException {
        TableOperationSpanBuilder supplier = new TableOperationSpanBuilder(this.connection).setTableName(this.tableName).setOperation(HBaseSemanticAttributes.Operation.CHECK_AND_MUTATE).setContainerOperations(HBaseSemanticAttributes.Operation.CHECK_AND_MUTATE, HBaseSemanticAttributes.Operation.DELETE);
        return (Boolean)TraceUtil.trace(() -> this.doCheckAndMutate(row, family, qualifier, this.toCompareOperator(compareOp), value, null, null, delete).isSuccess(), (Supplier)supplier);
    }

    @Override
    @Deprecated
    public boolean checkAndDelete(byte[] row, byte[] family, byte[] qualifier, CompareOperator op, byte[] value, Delete delete) throws IOException {
        TableOperationSpanBuilder supplier = new TableOperationSpanBuilder(this.connection).setTableName(this.tableName).setOperation(HBaseSemanticAttributes.Operation.CHECK_AND_MUTATE).setContainerOperations(HBaseSemanticAttributes.Operation.CHECK_AND_MUTATE, HBaseSemanticAttributes.Operation.DELETE);
        return (Boolean)TraceUtil.trace(() -> this.doCheckAndMutate(row, family, qualifier, op, value, null, null, delete).isSuccess(), (Supplier)supplier);
    }

    @Override
    @Deprecated
    public Table.CheckAndMutateBuilder checkAndMutate(byte[] row, byte[] family) {
        return new CheckAndMutateBuilderImpl(row, family);
    }

    @Override
    @Deprecated
    public Table.CheckAndMutateWithFilterBuilder checkAndMutate(byte[] row, Filter filter) {
        return new CheckAndMutateWithFilterBuilderImpl(row, filter);
    }

    private CheckAndMutateResult doCheckAndMutate(final byte[] row, final byte[] family, final byte[] qualifier, final CompareOperator op, final byte[] value, final Filter filter, final TimeRange timeRange, final RowMutations rm) throws IOException {
        final long nonceGroup = this.getNonceGroup();
        final long nonce = this.getNonce();
        CancellableRegionServerCallable<MultiResponse> callable = new CancellableRegionServerCallable<MultiResponse>((Connection)this.connection, this.getName(), rm.getRow(), (RpcController)this.rpcControllerFactory.newController(), this.writeRpcTimeoutMs, new RetryingTimeTracker().start(), rm.getMaxPriority()){

            @Override
            protected MultiResponse rpcCall() throws Exception {
                ClientProtos.MultiRequest request = RequestConverter.buildMultiRequest(this.getLocation().getRegionInfo().getRegionName(), row, family, qualifier, op, value, filter, timeRange, rm, nonceGroup, nonce);
                ClientProtos.MultiResponse response = this.doMulti(request);
                ClientProtos.RegionActionResult res = (ClientProtos.RegionActionResult)response.getRegionActionResultList().get(0);
                if (res.hasException()) {
                    Throwable ex = org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil.toException(res.getException());
                    if (ex instanceof IOException) {
                        throw (IOException)ex;
                    }
                    throw new IOException("Failed to checkAndMutate row: " + Bytes.toStringBinary((byte[])rm.getRow()), ex);
                }
                return ResponseConverter.getResults(request, response, this.getRpcControllerCellScanner());
            }
        };
        Object[] results = new Object[rm.getMutations().size()];
        AsyncProcessTask task = AsyncProcessTask.newBuilder().setPool(this.pool).setTableName(this.tableName).setRowAccess(rm.getMutations()).setResults(results).setCallable(callable).setRpcTimeout(Math.max(this.readRpcTimeoutMs, this.writeRpcTimeoutMs)).setOperationTimeout(this.operationTimeoutMs).setSubmittedRows(AsyncProcessTask.SubmittedRows.ALL).build();
        AsyncRequestFuture ars = this.multiAp.submit(task);
        ars.waitUntilDone();
        if (ars.hasError()) {
            throw ars.getErrors();
        }
        return (CheckAndMutateResult)results[0];
    }

    @Override
    @Deprecated
    public boolean checkAndMutate(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, byte[] value, RowMutations rm) throws IOException {
        TableOperationSpanBuilder supplier = new TableOperationSpanBuilder(this.connection).setTableName(this.tableName).setOperation(HBaseSemanticAttributes.Operation.CHECK_AND_MUTATE).setContainerOperations(rm);
        return (Boolean)TraceUtil.trace(() -> this.doCheckAndMutate(row, family, qualifier, this.toCompareOperator(compareOp), value, null, null, rm).isSuccess(), (Supplier)supplier);
    }

    @Override
    @Deprecated
    public boolean checkAndMutate(byte[] row, byte[] family, byte[] qualifier, CompareOperator op, byte[] value, RowMutations rm) throws IOException {
        TableOperationSpanBuilder supplier = new TableOperationSpanBuilder(this.connection).setTableName(this.tableName).setOperation(HBaseSemanticAttributes.Operation.CHECK_AND_MUTATE).setContainerOperations(rm);
        return (Boolean)TraceUtil.trace(() -> this.doCheckAndMutate(row, family, qualifier, op, value, null, null, rm).isSuccess(), (Supplier)supplier);
    }

    @Override
    public CheckAndMutateResult checkAndMutate(CheckAndMutate checkAndMutate) throws IOException {
        TableOperationSpanBuilder supplier = new TableOperationSpanBuilder(this.connection).setTableName(this.tableName).setOperation(checkAndMutate).setContainerOperations(checkAndMutate);
        return (CheckAndMutateResult)TraceUtil.trace(() -> {
            Row action = checkAndMutate.getAction();
            if (action instanceof Put || action instanceof Delete || action instanceof Increment || action instanceof Append) {
                if (action instanceof Put) {
                    this.validatePut((Put)action);
                }
                return this.doCheckAndMutate(checkAndMutate.getRow(), checkAndMutate.getFamily(), checkAndMutate.getQualifier(), checkAndMutate.getCompareOp(), checkAndMutate.getValue(), checkAndMutate.getFilter(), checkAndMutate.getTimeRange(), (Mutation)action);
            }
            return this.doCheckAndMutate(checkAndMutate.getRow(), checkAndMutate.getFamily(), checkAndMutate.getQualifier(), checkAndMutate.getCompareOp(), checkAndMutate.getValue(), checkAndMutate.getFilter(), checkAndMutate.getTimeRange(), (RowMutations)action);
        }, (Supplier)supplier);
    }

    private CheckAndMutateResult doCheckAndMutate(final byte[] row, final byte[] family, final byte[] qualifier, final CompareOperator op, final byte[] value, final Filter filter, final TimeRange timeRange, final Mutation mutation) throws IOException {
        final long nonceGroup = this.getNonceGroup();
        final long nonce = this.getNonce();
        ClientServiceCallable<CheckAndMutateResult> callable = new ClientServiceCallable<CheckAndMutateResult>((Connection)this.connection, this.getName(), row, (RpcController)this.rpcControllerFactory.newController(), mutation.getPriority()){

            @Override
            protected CheckAndMutateResult rpcCall() throws Exception {
                ClientProtos.MutateRequest request = RequestConverter.buildMutateRequest(this.getLocation().getRegionInfo().getRegionName(), row, family, qualifier, op, value, filter, timeRange, mutation, nonceGroup, nonce);
                ClientProtos.MutateResponse response = this.doMutate(request);
                if (response.hasResult()) {
                    return new CheckAndMutateResult(response.getProcessed(), org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil.toResult(response.getResult(), this.getRpcControllerCellScanner()));
                }
                return new CheckAndMutateResult(response.getProcessed(), null);
            }
        };
        return this.rpcCallerFactory.newCaller(this.writeRpcTimeoutMs).callWithRetries(callable, this.operationTimeoutMs);
    }

    @Override
    public List<CheckAndMutateResult> checkAndMutate(List<CheckAndMutate> checkAndMutates) throws IOException {
        TableOperationSpanBuilder supplier = new TableOperationSpanBuilder(this.connection).setTableName(this.tableName).setOperation(HBaseSemanticAttributes.Operation.BATCH).setContainerOperations(checkAndMutates);
        return (List)TraceUtil.trace(() -> {
            if (checkAndMutates.isEmpty()) {
                return Collections.emptyList();
            }
            if (checkAndMutates.size() == 1) {
                return Collections.singletonList(this.checkAndMutate((CheckAndMutate)checkAndMutates.get(0)));
            }
            Object[] results = new Object[checkAndMutates.size()];
            try {
                this.batch(checkAndMutates, results, this.writeRpcTimeoutMs);
            }
            catch (InterruptedException e) {
                throw (InterruptedIOException)new InterruptedIOException().initCause(e);
            }
            ArrayList<CheckAndMutateResult> ret = new ArrayList<CheckAndMutateResult>(results.length);
            for (Object r : results) {
                ret.add((CheckAndMutateResult)r);
            }
            return ret;
        }, (Supplier)supplier);
    }

    private CompareOperator toCompareOperator(CompareFilter.CompareOp compareOp) {
        switch (compareOp) {
            case LESS: {
                return CompareOperator.LESS;
            }
            case LESS_OR_EQUAL: {
                return CompareOperator.LESS_OR_EQUAL;
            }
            case EQUAL: {
                return CompareOperator.EQUAL;
            }
            case NOT_EQUAL: {
                return CompareOperator.NOT_EQUAL;
            }
            case GREATER_OR_EQUAL: {
                return CompareOperator.GREATER_OR_EQUAL;
            }
            case GREATER: {
                return CompareOperator.GREATER;
            }
            case NO_OP: {
                return CompareOperator.NO_OP;
            }
        }
        throw new AssertionError();
    }

    @Override
    public boolean exists(Get get) throws IOException {
        TableOperationSpanBuilder supplier = new TableOperationSpanBuilder(this.connection).setTableName(this.tableName).setOperation(get);
        return (Boolean)TraceUtil.trace(() -> {
            Result r = this.get(get, true);
            assert (r.getExists() != null);
            return r.getExists();
        }, (Supplier)supplier);
    }

    @Override
    public boolean[] exists(List<Get> gets) throws IOException {
        TableOperationSpanBuilder supplier = new TableOperationSpanBuilder(this.connection).setTableName(this.tableName).setOperation(HBaseSemanticAttributes.Operation.BATCH).setContainerOperations(gets);
        return (boolean[])TraceUtil.trace(() -> {
            if (gets.isEmpty()) {
                return new boolean[0];
            }
            if (gets.size() == 1) {
                return new boolean[]{this.exists((Get)gets.get(0))};
            }
            ArrayList<Get> exists = new ArrayList<Get>(gets.size());
            for (Get g : gets) {
                Get ge = new Get(g);
                ge.setCheckExistenceOnly(true);
                exists.add(ge);
            }
            Object[] r1 = new Object[exists.size()];
            try {
                this.batch(exists, r1, this.readRpcTimeoutMs);
            }
            catch (InterruptedException e) {
                throw (InterruptedIOException)new InterruptedIOException().initCause(e);
            }
            boolean[] results = new boolean[r1.length];
            int i = 0;
            for (Object o : r1) {
                results[i++] = ((Result)o).getExists();
            }
            return results;
        }, (Supplier)supplier);
    }

    public <R> void processBatchCallback(List<? extends Row> list, Object[] results, Batch.Callback<R> callback) throws IOException, InterruptedException {
        this.batchCallback(list, results, callback);
    }

    @Override
    public void close() throws IOException {
        TableSpanBuilder supplier = new TableSpanBuilder(this.connection).setName("HTable.close").setTableName(this.tableName);
        TraceUtil.trace(() -> {
            if (this.closed) {
                return;
            }
            if (this.cleanupPoolOnClose) {
                this.pool.shutdown();
                try {
                    boolean terminated = false;
                    while (!(terminated = this.pool.awaitTermination(60L, TimeUnit.SECONDS))) {
                    }
                }
                catch (InterruptedException e) {
                    this.pool.shutdownNow();
                    LOG.warn("waitForTermination interrupted");
                }
            }
            this.closed = true;
        }, (Supplier)supplier);
    }

    private void validatePut(Put put) throws IllegalArgumentException {
        ConnectionUtils.validatePut(put, this.connConfiguration.getMaxKeyValueSize());
    }

    ExecutorService getPool() {
        return this.pool;
    }

    public void clearRegionCache() {
        this.connection.clearRegionLocationCache();
    }

    @Override
    public CoprocessorRpcChannel coprocessorService(byte[] row) {
        return new RegionCoprocessorRpcChannel(this.connection, this.tableName, row);
    }

    @Override
    public <T extends Service, R> Map<byte[], R> coprocessorService(Class<T> service, byte[] startKey, byte[] endKey, Batch.Call<T, R> callable) throws ServiceException, Throwable {
        Map results = Collections.synchronizedMap(new TreeMap(Bytes.BYTES_COMPARATOR));
        this.coprocessorService(service, startKey, endKey, callable, (region, row, value) -> {
            if (region != null) {
                results.put(region, value);
            }
        });
        return results;
    }

    @Override
    public <T extends Service, R> void coprocessorService(Class<T> service, byte[] startKey, byte[] endKey, Batch.Call<T, R> callable, Batch.Callback<R> callback) throws ServiceException, Throwable {
        TableOperationSpanBuilder supplier = new TableOperationSpanBuilder(this.connection).setTableName(this.tableName).setOperation(HBaseSemanticAttributes.Operation.COPROC_EXEC);
        TraceUtil.trace(() -> {
            Context context = Context.current();
            ExecutorService wrappedPool = context.wrap(this.pool);
            List<byte[]> keys = this.getStartKeysInRange(startKey, endKey);
            TreeMap<byte[], Future<Object>> futures = new TreeMap<byte[], Future<Object>>(Bytes.BYTES_COMPARATOR);
            for (byte[] byArray : keys) {
                RegionCoprocessorRpcChannel channel = new RegionCoprocessorRpcChannel(this.connection, this.tableName, byArray);
                Future<Object> future = wrappedPool.submit(() -> {
                    Object instance = ProtobufUtil.newServiceStub(service, channel);
                    Object result = callable.call(instance);
                    byte[] region = channel.getLastRegion();
                    if (callback != null) {
                        callback.update(region, r, result);
                    }
                    return result;
                });
                futures.put(byArray, future);
            }
            for (Map.Entry entry : futures.entrySet()) {
                try {
                    ((Future)entry.getValue()).get();
                }
                catch (ExecutionException ee) {
                    LOG.warn("Error calling coprocessor service {} for row {}", new Object[]{service.getName(), Bytes.toStringBinary((byte[])((byte[])entry.getKey())), ee});
                    throw ee.getCause();
                }
                catch (InterruptedException ie) {
                    throw new InterruptedIOException("Interrupted calling coprocessor service " + service.getName() + " for row " + Bytes.toStringBinary((byte[])((byte[])entry.getKey()))).initCause(ie);
                }
            }
        }, (Supplier)supplier);
    }

    private List<byte[]> getStartKeysInRange(byte[] start, byte[] end) throws IOException {
        if (start == null) {
            start = HConstants.EMPTY_START_ROW;
        }
        if (end == null) {
            end = HConstants.EMPTY_END_ROW;
        }
        return (List)this.getKeysAndRegionsInRange(start, end, true).getFirst();
    }

    @Override
    public long getRpcTimeout(TimeUnit unit) {
        return unit.convert(this.rpcTimeoutMs, TimeUnit.MILLISECONDS);
    }

    @Override
    @Deprecated
    public int getRpcTimeout() {
        return this.rpcTimeoutMs;
    }

    @Override
    @Deprecated
    public void setRpcTimeout(int rpcTimeout) {
        this.setReadRpcTimeout(rpcTimeout);
        this.setWriteRpcTimeout(rpcTimeout);
    }

    @Override
    public long getReadRpcTimeout(TimeUnit unit) {
        return unit.convert(this.readRpcTimeoutMs, TimeUnit.MILLISECONDS);
    }

    @Override
    @Deprecated
    public int getReadRpcTimeout() {
        return this.readRpcTimeoutMs;
    }

    @Override
    @Deprecated
    public void setReadRpcTimeout(int readRpcTimeout) {
        this.readRpcTimeoutMs = readRpcTimeout;
    }

    @Override
    public long getWriteRpcTimeout(TimeUnit unit) {
        return unit.convert(this.writeRpcTimeoutMs, TimeUnit.MILLISECONDS);
    }

    @Override
    @Deprecated
    public int getWriteRpcTimeout() {
        return this.writeRpcTimeoutMs;
    }

    @Override
    @Deprecated
    public void setWriteRpcTimeout(int writeRpcTimeout) {
        this.writeRpcTimeoutMs = writeRpcTimeout;
    }

    @Override
    public long getOperationTimeout(TimeUnit unit) {
        return unit.convert(this.operationTimeoutMs, TimeUnit.MILLISECONDS);
    }

    @Override
    @Deprecated
    public int getOperationTimeout() {
        return this.operationTimeoutMs;
    }

    @Override
    @Deprecated
    public void setOperationTimeout(int operationTimeout) {
        this.operationTimeoutMs = operationTimeout;
    }

    public String toString() {
        return this.tableName + ";" + this.connection;
    }

    @Override
    public <R extends Message> Map<byte[], R> batchCoprocessorService(Descriptors.MethodDescriptor methodDescriptor, Message request, byte[] startKey, byte[] endKey, R responsePrototype) throws ServiceException, Throwable {
        Map results = Collections.synchronizedMap(new TreeMap(Bytes.BYTES_COMPARATOR));
        this.batchCoprocessorService(methodDescriptor, request, startKey, endKey, responsePrototype, (region, row, result) -> {
            if (region != null) {
                results.put(region, result);
            }
        });
        return results;
    }

    @Override
    public <R extends Message> void batchCoprocessorService(Descriptors.MethodDescriptor methodDescriptor, Message request, byte[] startKey, byte[] endKey, R responsePrototype, Batch.Callback<R> callback) throws ServiceException, Throwable {
        TableOperationSpanBuilder supplier = new TableOperationSpanBuilder(this.connection).setTableName(this.tableName).setOperation(HBaseSemanticAttributes.Operation.COPROC_EXEC);
        TraceUtil.trace(() -> {
            Context context = Context.current();
            byte[] sanitizedStartKey = Optional.ofNullable(startKey).orElse(HConstants.EMPTY_START_ROW);
            byte[] sanitizedEndKey = Optional.ofNullable(endKey).orElse(HConstants.EMPTY_END_ROW);
            Pair<List<byte[]>, List<HRegionLocation>> keysAndRegions = this.getKeysAndRegionsInRange(sanitizedStartKey, sanitizedEndKey, true);
            List keys = (List)keysAndRegions.getFirst();
            List regions = (List)keysAndRegions.getSecond();
            if (keys.isEmpty()) {
                LOG.info("No regions were selected by key range start={}, end={}", (Object)Bytes.toStringBinary((byte[])sanitizedStartKey), (Object)Bytes.toStringBinary((byte[])sanitizedEndKey));
                return;
            }
            ArrayList<RegionCoprocessorServiceExec> execs = new ArrayList<RegionCoprocessorServiceExec>(keys.size());
            TreeMap<byte[], RegionCoprocessorServiceExec> execsByRow = new TreeMap<byte[], RegionCoprocessorServiceExec>(Bytes.BYTES_COMPARATOR);
            for (int i = 0; i < keys.size(); ++i) {
                byte[] rowKey = (byte[])keys.get(i);
                byte[] region2 = ((HRegionLocation)regions.get(i)).getRegionInfo().getRegionName();
                RegionCoprocessorServiceExec exec = new RegionCoprocessorServiceExec(region2, rowKey, methodDescriptor, request);
                execs.add(exec);
                execsByRow.put(rowKey, exec);
            }
            ArrayList<Throwable> callbackErrorExceptions = new ArrayList<Throwable>();
            ArrayList<Row> callbackErrorActions = new ArrayList<Row>();
            ArrayList<String> callbackErrorServers = new ArrayList<String>();
            Object[] results = new Object[execs.size()];
            AsyncProcess asyncProcess = new AsyncProcess(this.connection, this.configuration, RpcRetryingCallerFactory.instantiate(this.configuration, this.connection.getStatisticsTracker(), this.connection.getConnectionMetrics()), RpcControllerFactory.instantiate(this.configuration));
            Batch.Callback<ClientProtos.CoprocessorServiceResult> resultsCallback = (region, row, serviceResult) -> {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Received result for endpoint {}: region={}, row={}, value={}", new Object[]{methodDescriptor.getFullName(), Bytes.toStringBinary((byte[])region), Bytes.toStringBinary((byte[])row), serviceResult.getValue().getValue()});
                }
                try {
                    Message.Builder builder = responsePrototype.newBuilderForType();
                    ProtobufUtil.mergeFrom(builder, serviceResult.getValue().getValue().toByteArray());
                    callback.update(region, row, builder.build());
                }
                catch (IOException e) {
                    LOG.error("Unexpected response type from endpoint {}", (Object)methodDescriptor.getFullName(), (Object)e);
                    callbackErrorExceptions.add(e);
                    callbackErrorActions.add((Row)execsByRow.get(row));
                    callbackErrorServers.add("null");
                }
            };
            AsyncProcessTask<ClientProtos.CoprocessorServiceResult> task = AsyncProcessTask.newBuilder(resultsCallback).setPool(context.wrap(this.pool)).setTableName(this.tableName).setRowAccess(execs).setResults(results).setRpcTimeout(this.readRpcTimeoutMs).setOperationTimeout(this.operationTimeoutMs).setSubmittedRows(AsyncProcessTask.SubmittedRows.ALL).build();
            AsyncRequestFuture future = asyncProcess.submit(task);
            future.waitUntilDone();
            if (future.hasError()) {
                throw future.getErrors();
            }
            if (!callbackErrorExceptions.isEmpty()) {
                throw new RetriesExhaustedWithDetailsException(callbackErrorExceptions, callbackErrorActions, callbackErrorServers);
            }
        }, (Supplier)supplier);
    }

    @Override
    public RegionLocator getRegionLocator() {
        return this.locator;
    }

    private class CheckAndMutateWithFilterBuilderImpl
    implements Table.CheckAndMutateWithFilterBuilder {
        private final byte[] row;
        private final Filter filter;
        private TimeRange timeRange;

        CheckAndMutateWithFilterBuilderImpl(byte[] row, Filter filter) {
            this.row = (byte[])Preconditions.checkNotNull((Object)row, (Object)"row is null");
            this.filter = (Filter)Preconditions.checkNotNull((Object)filter, (Object)"filter is null");
        }

        @Override
        public Table.CheckAndMutateWithFilterBuilder timeRange(TimeRange timeRange) {
            this.timeRange = timeRange;
            return this;
        }

        @Override
        public boolean thenPut(Put put) throws IOException {
            TableOperationSpanBuilder supplier = new TableOperationSpanBuilder(HTable.this.connection).setTableName(HTable.this.tableName).setOperation(HBaseSemanticAttributes.Operation.CHECK_AND_MUTATE);
            return (Boolean)TraceUtil.trace(() -> {
                HTable.this.validatePut(put);
                return HTable.this.doCheckAndMutate(this.row, null, null, null, null, this.filter, this.timeRange, put).isSuccess();
            }, (Supplier)supplier);
        }

        @Override
        public boolean thenDelete(Delete delete) throws IOException {
            TableOperationSpanBuilder supplier = new TableOperationSpanBuilder(HTable.this.connection).setTableName(HTable.this.tableName).setOperation(HBaseSemanticAttributes.Operation.CHECK_AND_MUTATE);
            return (Boolean)TraceUtil.trace(() -> HTable.this.doCheckAndMutate(this.row, null, null, null, null, this.filter, this.timeRange, delete).isSuccess(), (Supplier)supplier);
        }

        @Override
        public boolean thenMutate(RowMutations mutation) throws IOException {
            TableOperationSpanBuilder supplier = new TableOperationSpanBuilder(HTable.this.connection).setTableName(HTable.this.tableName).setOperation(HBaseSemanticAttributes.Operation.CHECK_AND_MUTATE);
            return (Boolean)TraceUtil.trace(() -> HTable.this.doCheckAndMutate(this.row, null, null, null, null, this.filter, this.timeRange, mutation).isSuccess(), (Supplier)supplier);
        }
    }

    private class CheckAndMutateBuilderImpl
    implements Table.CheckAndMutateBuilder {
        private final byte[] row;
        private final byte[] family;
        private byte[] qualifier;
        private TimeRange timeRange;
        private CompareOperator op;
        private byte[] value;

        CheckAndMutateBuilderImpl(byte[] row, byte[] family) {
            this.row = (byte[])Preconditions.checkNotNull((Object)row, (Object)"row is null");
            this.family = (byte[])Preconditions.checkNotNull((Object)family, (Object)"family is null");
        }

        @Override
        public Table.CheckAndMutateBuilder qualifier(byte[] qualifier) {
            this.qualifier = (byte[])Preconditions.checkNotNull((Object)qualifier, (Object)"qualifier is null. Consider using an empty byte array, or just do not call this method if you want a null qualifier");
            return this;
        }

        @Override
        public Table.CheckAndMutateBuilder timeRange(TimeRange timeRange) {
            this.timeRange = timeRange;
            return this;
        }

        @Override
        public Table.CheckAndMutateBuilder ifNotExists() {
            this.op = CompareOperator.EQUAL;
            this.value = null;
            return this;
        }

        @Override
        public Table.CheckAndMutateBuilder ifMatches(CompareOperator compareOp, byte[] value) {
            this.op = (CompareOperator)((Object)Preconditions.checkNotNull((Object)((Object)compareOp), (Object)"compareOp is null"));
            this.value = (byte[])Preconditions.checkNotNull((Object)value, (Object)"value is null");
            return this;
        }

        private void preCheck() {
            Preconditions.checkNotNull((Object)((Object)this.op), (Object)"condition is null. You need to specify the condition by calling ifNotExists/ifEquals/ifMatches before executing the request");
        }

        @Override
        public boolean thenPut(Put put) throws IOException {
            TableOperationSpanBuilder supplier = new TableOperationSpanBuilder(HTable.this.connection).setTableName(HTable.this.tableName).setOperation(HBaseSemanticAttributes.Operation.CHECK_AND_MUTATE);
            return (Boolean)TraceUtil.trace(() -> {
                HTable.this.validatePut(put);
                this.preCheck();
                return HTable.this.doCheckAndMutate(this.row, this.family, this.qualifier, this.op, this.value, null, this.timeRange, put).isSuccess();
            }, (Supplier)supplier);
        }

        @Override
        public boolean thenDelete(Delete delete) throws IOException {
            TableOperationSpanBuilder supplier = new TableOperationSpanBuilder(HTable.this.connection).setTableName(HTable.this.tableName).setOperation(HBaseSemanticAttributes.Operation.CHECK_AND_MUTATE);
            return (Boolean)TraceUtil.trace(() -> {
                this.preCheck();
                return HTable.this.doCheckAndMutate(this.row, this.family, this.qualifier, this.op, this.value, null, this.timeRange, delete).isSuccess();
            }, (Supplier)supplier);
        }

        @Override
        public boolean thenMutate(RowMutations mutation) throws IOException {
            TableOperationSpanBuilder supplier = new TableOperationSpanBuilder(HTable.this.connection).setTableName(HTable.this.tableName).setOperation(HBaseSemanticAttributes.Operation.CHECK_AND_MUTATE);
            return (Boolean)TraceUtil.trace(() -> {
                this.preCheck();
                return HTable.this.doCheckAndMutate(this.row, this.family, this.qualifier, this.op, this.value, null, this.timeRange, mutation).isSuccess();
            }, (Supplier)supplier);
        }
    }
}

