/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.Map;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.SnapshotType;
import org.apache.hbase.thirdparty.org.apache.commons.collections4.MapUtils;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class SnapshotDescription {
    private final String name;
    private final TableName table;
    private final SnapshotType snapShotType;
    private final String owner;
    private final long creationTime;
    private final int version;
    private final long maxFileSize;

    public SnapshotDescription(String name) {
        this(name, (TableName)null);
    }

    @Deprecated
    public SnapshotDescription(String name, String table) {
        this(name, TableName.valueOf((String)table));
    }

    public SnapshotDescription(String name, TableName table) {
        this(name, table, SnapshotType.DISABLED, null, -1L, -1, null);
    }

    @Deprecated
    public SnapshotDescription(String name, String table, SnapshotType type) {
        this(name, TableName.valueOf((String)table), type);
    }

    public SnapshotDescription(String name, TableName table, SnapshotType type) {
        this(name, table, type, null, -1L, -1, null);
    }

    @Deprecated
    public SnapshotDescription(String name, String table, SnapshotType type, String owner) {
        this(name, TableName.valueOf((String)table), type, owner);
    }

    public SnapshotDescription(String name, TableName table, SnapshotType type, String owner) {
        this(name, table, type, owner, -1L, -1, null);
    }

    @Deprecated
    public SnapshotDescription(String name, String table, SnapshotType type, String owner, long creationTime, int version) {
        this(name, TableName.valueOf((String)table), type, owner, creationTime, version, null);
    }

    public SnapshotDescription(String name, TableName table, SnapshotType type, String owner, long creationTime, int version, Map<String, Object> snapshotProps) {
        this.name = name;
        this.table = table;
        this.snapShotType = type;
        this.owner = owner;
        this.creationTime = creationTime;
        this.version = version;
        this.maxFileSize = this.getLongFromSnapshotProps(snapshotProps, "MAX_FILESIZE");
    }

    private long getLongFromSnapshotProps(Map<String, Object> snapshotProps, String property) {
        return MapUtils.getLongValue(snapshotProps, (Object)property, (long)-1L);
    }

    public SnapshotDescription(String snapshotName, TableName tableName, SnapshotType type, Map<String, Object> snapshotProps) {
        this(snapshotName, tableName, type, null, -1L, -1, snapshotProps);
    }

    public String getName() {
        return this.name;
    }

    @Deprecated
    public String getTable() {
        return this.getTableNameAsString();
    }

    public String getTableNameAsString() {
        return this.table.getNameAsString();
    }

    public TableName getTableName() {
        return this.table;
    }

    public SnapshotType getType() {
        return this.snapShotType;
    }

    public String getOwner() {
        return this.owner;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public int getVersion() {
        return this.version;
    }

    public long getMaxFileSize() {
        return this.maxFileSize;
    }

    public String toString() {
        return "SnapshotDescription: name = " + (this.name != null ? this.name : null) + "/table = " + (this.table != null ? this.table : null) + " /owner = " + (this.owner != null ? this.owner : null) + (this.creationTime != -1L ? "/creationtime = " + this.creationTime : "") + (this.version != -1 ? "/version = " + this.version : "") + (this.maxFileSize != -1L ? "/maxFileSize = " + this.maxFileSize : "");
    }
}

