/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AsyncProcess;
import org.apache.hadoop.hbase.client.AsyncProcessTask;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.BufferedMutatorParams;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.ConnectionConfiguration;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowAccess;
import org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class BufferedMutatorImpl
implements BufferedMutator {
    private static final Logger LOG = LoggerFactory.getLogger(BufferedMutatorImpl.class);
    private final BufferedMutator.ExceptionListener listener;
    private final TableName tableName;
    private final Configuration conf;
    private final ConcurrentLinkedQueue<Mutation> writeAsyncBuffer = new ConcurrentLinkedQueue();
    private final AtomicLong currentWriteBufferSize = new AtomicLong(0L);
    private final AtomicInteger undealtMutationCount = new AtomicInteger(0);
    private final long writeBufferSize;
    private final AtomicLong writeBufferPeriodicFlushTimeoutMs = new AtomicLong(0L);
    private final AtomicLong writeBufferPeriodicFlushTimerTickMs = new AtomicLong(100L);
    private Timer writeBufferPeriodicFlushTimer = null;
    private final int maxKeyValueSize;
    private final ExecutorService pool;
    private final AtomicInteger rpcTimeout;
    private final AtomicInteger operationTimeout;
    private final boolean cleanupPoolOnClose;
    private volatile boolean closed = false;
    private final AsyncProcess ap;
    private final AtomicLong firstRecordInBufferTimestamp = new AtomicLong(0L);
    private final AtomicLong executedWriteBufferPeriodicFlushes = new AtomicLong(0L);

    @VisibleForTesting
    BufferedMutatorImpl(ClusterConnection conn, BufferedMutatorParams params, AsyncProcess ap) {
        if (conn == null || conn.isClosed()) {
            throw new IllegalArgumentException("Connection is null or closed.");
        }
        this.tableName = params.getTableName();
        this.conf = conn.getConfiguration();
        this.listener = params.getListener();
        if (params.getPool() == null) {
            this.pool = HTable.getDefaultExecutor(this.conf);
            this.cleanupPoolOnClose = true;
        } else {
            this.pool = params.getPool();
            this.cleanupPoolOnClose = false;
        }
        ConnectionConfiguration tableConf = new ConnectionConfiguration(this.conf);
        this.writeBufferSize = params.getWriteBufferSize() != -1L ? params.getWriteBufferSize() : tableConf.getWriteBufferSize();
        long newWriteBufferPeriodicFlushTimeoutMs = params.getWriteBufferPeriodicFlushTimeoutMs() != -1L ? params.getWriteBufferPeriodicFlushTimeoutMs() : tableConf.getWriteBufferPeriodicFlushTimeoutMs();
        long newWriteBufferPeriodicFlushTimerTickMs = params.getWriteBufferPeriodicFlushTimerTickMs() != -1L ? params.getWriteBufferPeriodicFlushTimerTickMs() : tableConf.getWriteBufferPeriodicFlushTimerTickMs();
        this.setWriteBufferPeriodicFlush(newWriteBufferPeriodicFlushTimeoutMs, newWriteBufferPeriodicFlushTimerTickMs);
        this.maxKeyValueSize = params.getMaxKeyValueSize() != -1 ? params.getMaxKeyValueSize() : tableConf.getMaxKeyValueSize();
        this.rpcTimeout = new AtomicInteger(params.getRpcTimeout() != -1 ? params.getRpcTimeout() : conn.getConnectionConfiguration().getWriteRpcTimeout());
        this.operationTimeout = new AtomicInteger(params.getOperationTimeout() != -1 ? params.getOperationTimeout() : conn.getConnectionConfiguration().getOperationTimeout());
        this.ap = ap;
    }

    BufferedMutatorImpl(ClusterConnection conn, RpcRetryingCallerFactory rpcCallerFactory, RpcControllerFactory rpcFactory, BufferedMutatorParams params) {
        this(conn, params, new AsyncProcess(conn, conn.getConfiguration(), rpcCallerFactory, true, rpcFactory));
    }

    @VisibleForTesting
    ExecutorService getPool() {
        return this.pool;
    }

    @VisibleForTesting
    AsyncProcess getAsyncProcess() {
        return this.ap;
    }

    @Override
    public TableName getName() {
        return this.tableName;
    }

    @Override
    public Configuration getConfiguration() {
        return this.conf;
    }

    @Override
    public void mutate(Mutation m) throws InterruptedIOException, RetriesExhaustedWithDetailsException {
        this.mutate(Collections.singletonList(m));
    }

    @Override
    public void mutate(List<? extends Mutation> ms) throws InterruptedIOException, RetriesExhaustedWithDetailsException {
        if (this.closed) {
            throw new IllegalStateException("Cannot put when the BufferedMutator is closed.");
        }
        long toAddSize = 0L;
        int toAddCount = 0;
        for (Mutation mutation : ms) {
            if (mutation instanceof Put) {
                this.validatePut((Put)mutation);
            }
            toAddSize += mutation.heapSize();
            ++toAddCount;
        }
        if (this.currentWriteBufferSize.get() == 0L) {
            this.firstRecordInBufferTimestamp.set(System.currentTimeMillis());
        }
        if (this.ap.hasError()) {
            this.currentWriteBufferSize.addAndGet(toAddSize);
            this.writeAsyncBuffer.addAll(ms);
            this.undealtMutationCount.addAndGet(toAddCount);
            this.backgroundFlushCommits(true);
        } else {
            this.currentWriteBufferSize.addAndGet(toAddSize);
            this.writeAsyncBuffer.addAll(ms);
            this.undealtMutationCount.addAndGet(toAddCount);
        }
        while (this.undealtMutationCount.get() != 0 && this.currentWriteBufferSize.get() > this.writeBufferSize) {
            this.backgroundFlushCommits(false);
        }
    }

    @VisibleForTesting
    protected long getExecutedWriteBufferPeriodicFlushes() {
        return this.executedWriteBufferPeriodicFlushes.get();
    }

    private void timerCallbackForWriteBufferPeriodicFlush() {
        if (this.currentWriteBufferSize.get() == 0L) {
            return;
        }
        long now = System.currentTimeMillis();
        if (this.firstRecordInBufferTimestamp.get() + this.writeBufferPeriodicFlushTimeoutMs.get() > now) {
            return;
        }
        try {
            this.executedWriteBufferPeriodicFlushes.incrementAndGet();
            this.flush();
        }
        catch (InterruptedIOException | RetriesExhaustedWithDetailsException e) {
            LOG.error("Exception during timerCallbackForWriteBufferPeriodicFlush --> " + e.getMessage());
        }
    }

    public void validatePut(Put put) throws IllegalArgumentException {
        HTable.validatePut(put, this.maxKeyValueSize);
    }

    @Override
    public synchronized void close() throws IOException {
        block8: {
            try {
                boolean terminated;
                if (this.closed) {
                    return;
                }
                this.disableWriteBufferPeriodicFlush();
                this.backgroundFlushCommits(true);
                if (!this.cleanupPoolOnClose) break block8;
                this.pool.shutdown();
                int loopCnt = 0;
                do {
                    terminated = this.pool.awaitTermination(60L, TimeUnit.SECONDS);
                    if (++loopCnt < 10) continue;
                    LOG.warn("close() failed to terminate pool after 10 minutes. Abandoning pool.");
                    break;
                } while (!terminated);
            }
            catch (InterruptedException e) {
                LOG.warn("waitForTermination interrupted");
            }
            finally {
                this.closed = true;
            }
        }
    }

    @Override
    public synchronized void flush() throws InterruptedIOException, RetriesExhaustedWithDetailsException {
        this.backgroundFlushCommits(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void backgroundFlushCommits(boolean synchronous) throws InterruptedIOException, RetriesExhaustedWithDetailsException {
        AsyncProcessTask task;
        QueueRowAccess taker;
        if (!synchronous && this.writeAsyncBuffer.isEmpty()) {
            return;
        }
        if (!synchronous) {
            taker = new QueueRowAccess();
            task = this.wrapAsyncProcessTask(taker);
            try {
                this.ap.submit(task);
                if (this.ap.hasError()) {
                    LOG.debug(this.tableName + ": One or more of the operations have failed - waiting for all operation in progress to finish (successfully or not)");
                }
            }
            finally {
                taker.restoreRemainder();
            }
        }
        if (synchronous || this.ap.hasError()) {
            taker = new QueueRowAccess();
            task = this.wrapAsyncProcessTask(taker);
            try {
                while (!taker.isEmpty()) {
                    this.ap.submit(task);
                    taker.reset();
                }
            }
            finally {
                taker.restoreRemainder();
            }
            RetriesExhaustedWithDetailsException error = this.ap.waitForAllPreviousOpsAndReset(null, this.tableName);
            if (error != null) {
                if (this.listener == null) {
                    throw error;
                }
                this.listener.onException(error, this);
            }
        }
    }

    private AsyncProcessTask wrapAsyncProcessTask(QueueRowAccess taker) {
        AsyncProcessTask task = AsyncProcessTask.newBuilder().setPool(this.pool).setTableName(this.tableName).setRowAccess(taker).setSubmittedRows(AsyncProcessTask.SubmittedRows.AT_LEAST_ONE).build();
        return new AsyncProcessTask(task){

            @Override
            public int getRpcTimeout() {
                return BufferedMutatorImpl.this.rpcTimeout.get();
            }

            @Override
            public int getOperationTimeout() {
                return BufferedMutatorImpl.this.operationTimeout.get();
            }
        };
    }

    @Override
    public long getWriteBufferSize() {
        return this.writeBufferSize;
    }

    @Override
    public synchronized void setWriteBufferPeriodicFlush(long timeoutMs, long timerTickMs) {
        long originalTimeoutMs = this.writeBufferPeriodicFlushTimeoutMs.get();
        long originalTimerTickMs = this.writeBufferPeriodicFlushTimerTickMs.get();
        this.writeBufferPeriodicFlushTimeoutMs.set(Math.max(0L, timeoutMs));
        this.writeBufferPeriodicFlushTimerTickMs.set(Math.max(100L, timerTickMs));
        if ((this.writeBufferPeriodicFlushTimeoutMs.get() != originalTimeoutMs || this.writeBufferPeriodicFlushTimerTickMs.get() != originalTimerTickMs) && this.writeBufferPeriodicFlushTimer != null) {
            this.writeBufferPeriodicFlushTimer.cancel();
            this.writeBufferPeriodicFlushTimer = null;
        }
        if (this.writeBufferPeriodicFlushTimer == null && this.writeBufferPeriodicFlushTimeoutMs.get() > 0L) {
            this.writeBufferPeriodicFlushTimer = new Timer(true);
            this.writeBufferPeriodicFlushTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    BufferedMutatorImpl.this.timerCallbackForWriteBufferPeriodicFlush();
                }
            }, this.writeBufferPeriodicFlushTimerTickMs.get(), this.writeBufferPeriodicFlushTimerTickMs.get());
        }
    }

    @Override
    public long getWriteBufferPeriodicFlushTimeoutMs() {
        return this.writeBufferPeriodicFlushTimeoutMs.get();
    }

    @Override
    public long getWriteBufferPeriodicFlushTimerTickMs() {
        return this.writeBufferPeriodicFlushTimerTickMs.get();
    }

    @Override
    public void setRpcTimeout(int rpcTimeout) {
        this.rpcTimeout.set(rpcTimeout);
    }

    @Override
    public void setOperationTimeout(int operationTimeout) {
        this.operationTimeout.set(operationTimeout);
    }

    @VisibleForTesting
    long getCurrentWriteBufferSize() {
        return this.currentWriteBufferSize.get();
    }

    @VisibleForTesting
    int size() {
        return this.undealtMutationCount.get();
    }

    private class QueueRowAccess
    implements RowAccess<Row> {
        private int remainder;

        private QueueRowAccess() {
            this.remainder = BufferedMutatorImpl.this.undealtMutationCount.getAndSet(0);
        }

        void reset() {
            this.restoreRemainder();
            this.remainder = BufferedMutatorImpl.this.undealtMutationCount.getAndSet(0);
        }

        @Override
        public Iterator<Row> iterator() {
            return new Iterator<Row>(){
                private final Iterator<Mutation> iter;
                private int countDown;
                private Mutation last;
                {
                    this.iter = BufferedMutatorImpl.this.writeAsyncBuffer.iterator();
                    this.countDown = QueueRowAccess.this.remainder;
                    this.last = null;
                }

                @Override
                public boolean hasNext() {
                    if (this.countDown <= 0) {
                        return false;
                    }
                    return this.iter.hasNext();
                }

                @Override
                public Row next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    this.last = this.iter.next();
                    if (this.last == null) {
                        throw new NoSuchElementException();
                    }
                    --this.countDown;
                    return this.last;
                }

                @Override
                public void remove() {
                    if (this.last == null) {
                        throw new IllegalStateException();
                    }
                    this.iter.remove();
                    BufferedMutatorImpl.this.currentWriteBufferSize.addAndGet(-this.last.heapSize());
                    --QueueRowAccess.this.remainder;
                }
            };
        }

        @Override
        public int size() {
            return this.remainder;
        }

        void restoreRemainder() {
            if (this.remainder > 0) {
                BufferedMutatorImpl.this.undealtMutationCount.addAndGet(this.remainder);
                this.remainder = 0;
            }
        }

        @Override
        public boolean isEmpty() {
            return this.remainder <= 0;
        }
    }
}

