/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
public class TablePermission
extends Permission {
    private TableName table;
    private byte[] family;
    private byte[] qualifier;
    private String namespace;

    public TablePermission() {
    }

    public TablePermission(TableName table, byte[] family, Permission.Action ... assigned) {
        this(table, family, (byte[])null, assigned);
    }

    public TablePermission(TableName table, byte[] family, byte[] qualifier, Permission.Action ... assigned) {
        super(assigned);
        this.table = table;
        this.family = family;
        this.qualifier = qualifier;
    }

    public TablePermission(TableName table, byte[] family, byte[] qualifier, byte[] actionCodes) {
        super(actionCodes);
        this.table = table;
        this.family = family;
        this.qualifier = qualifier;
    }

    public TablePermission(String namespace, TableName table, byte[] family, byte[] qualifier, Permission.Action ... assigned) {
        super(assigned);
        this.namespace = namespace;
        this.table = table;
        this.family = family;
        this.qualifier = qualifier;
    }

    public TablePermission(String namespace, TableName table, byte[] family, byte[] qualifier, byte[] actionCodes) {
        super(actionCodes);
        this.namespace = namespace;
        this.table = table;
        this.family = family;
        this.qualifier = qualifier;
    }

    public TablePermission(String namespace, byte[] actionCodes) {
        super(actionCodes);
        this.namespace = namespace;
    }

    public TablePermission(String namespace, Permission.Action ... assigned) {
        super(assigned);
        this.namespace = namespace;
    }

    public boolean hasTable() {
        return this.table != null;
    }

    public TableName getTableName() {
        return this.table;
    }

    public void setTableName(TableName table) {
        this.table = table;
    }

    public boolean hasFamily() {
        return this.family != null;
    }

    public byte[] getFamily() {
        return this.family;
    }

    public boolean hasQualifier() {
        return this.qualifier != null;
    }

    public byte[] getQualifier() {
        return this.qualifier;
    }

    public boolean hasNamespace() {
        return this.namespace != null;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public boolean implies(String namespace, Permission.Action action) {
        if (this.namespace == null || !this.namespace.equals(namespace)) {
            return false;
        }
        return super.implies(action);
    }

    public boolean implies(TableName table, byte[] family, byte[] qualifier, Permission.Action action) {
        if (this.table == null || !this.table.equals((Object)table)) {
            return false;
        }
        if (!(this.family == null || family != null && Bytes.equals((byte[])this.family, (byte[])family))) {
            return false;
        }
        if (!(this.qualifier == null || qualifier != null && Bytes.equals((byte[])this.qualifier, (byte[])qualifier))) {
            return false;
        }
        return super.implies(action);
    }

    public boolean implies(TableName table, KeyValue kv, Permission.Action action) {
        if (this.table == null || !this.table.equals((Object)table)) {
            return false;
        }
        if (this.family != null && !CellUtil.matchingFamily((Cell)kv, (byte[])this.family)) {
            return false;
        }
        if (this.qualifier != null && !CellUtil.matchingQualifier((Cell)kv, (byte[])this.qualifier)) {
            return false;
        }
        return super.implies(action);
    }

    public boolean matchesFamily(TableName table, byte[] family, Permission.Action action) {
        if (this.table == null || !this.table.equals((Object)table)) {
            return false;
        }
        if (!(this.family == null || family != null && Bytes.equals((byte[])this.family, (byte[])family))) {
            return false;
        }
        return super.implies(action);
    }

    public boolean matchesFamilyQualifier(TableName table, byte[] family, byte[] qualifier, Permission.Action action) {
        if (!this.matchesFamily(table, family, action)) {
            return false;
        }
        if (!(this.qualifier == null || qualifier != null && Bytes.equals((byte[])this.qualifier, (byte[])qualifier))) {
            return false;
        }
        return super.implies(action);
    }

    public boolean tableFieldsEqual(TablePermission other) {
        return (this.table == null && other.getTableName() == null || this.table != null && this.table.equals((Object)other.getTableName())) && (this.family == null && other.getFamily() == null || Bytes.equals((byte[])this.family, (byte[])other.getFamily())) && (this.qualifier == null && other.getQualifier() == null || Bytes.equals((byte[])this.qualifier, (byte[])other.getQualifier())) && (this.namespace == null && other.getNamespace() == null || this.namespace != null && this.namespace.equals(other.getNamespace()));
    }

    @Override
    @SuppressWarnings(value={"NP_NULL_ON_SOME_PATH"}, justification="Passed on construction except on constructor not to be used")
    public boolean equals(Object obj) {
        if (!(obj instanceof TablePermission)) {
            return false;
        }
        TablePermission other = (TablePermission)((Object)obj);
        if (!this.tableFieldsEqual(other)) {
            return false;
        }
        return super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int prime = 37;
        int result = super.hashCode();
        if (this.table != null) {
            result = 37 * result + this.table.hashCode();
        }
        if (this.family != null) {
            result = 37 * result + Bytes.hashCode((byte[])this.family);
        }
        if (this.qualifier != null) {
            result = 37 * result + Bytes.hashCode((byte[])this.qualifier);
        }
        if (this.namespace != null) {
            result = 37 * result + this.namespace.hashCode();
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder("[TablePermission: ");
        if (this.namespace != null) {
            str.append("namespace=").append(this.namespace).append(", ");
        }
        if (this.table != null) {
            str.append("table=").append(this.table).append(", family=").append(this.family == null ? null : Bytes.toString((byte[])this.family)).append(", qualifier=").append(this.qualifier == null ? null : Bytes.toString((byte[])this.qualifier)).append(", ");
        }
        if (this.actions != null) {
            str.append("actions=");
            for (int i = 0; i < this.actions.length; ++i) {
                if (i > 0) {
                    str.append(",");
                }
                if (this.actions[i] != null) {
                    str.append(this.actions[i].toString());
                    continue;
                }
                str.append("NULL");
            }
        }
        str.append("]");
        return str.toString();
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        byte[] tableBytes = Bytes.readByteArray((DataInput)in);
        if (tableBytes.length > 0) {
            this.table = TableName.valueOf((byte[])tableBytes);
        }
        if (in.readBoolean()) {
            this.family = Bytes.readByteArray((DataInput)in);
        }
        if (in.readBoolean()) {
            this.qualifier = Bytes.readByteArray((DataInput)in);
        }
        if (in.readBoolean()) {
            this.namespace = Bytes.toString((byte[])Bytes.readByteArray((DataInput)in));
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        Bytes.writeByteArray((DataOutput)out, this.table == null ? null : this.table.getName());
        out.writeBoolean(this.family != null);
        if (this.family != null) {
            Bytes.writeByteArray((DataOutput)out, (byte[])this.family);
        }
        out.writeBoolean(this.qualifier != null);
        if (this.qualifier != null) {
            Bytes.writeByteArray((DataOutput)out, (byte[])this.qualifier);
        }
        out.writeBoolean(this.namespace != null);
        if (this.namespace != null) {
            Bytes.writeByteArray((DataOutput)out, (byte[])Bytes.toBytes((String)this.namespace));
        }
    }
}

