/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security;

import java.util.Map;
import java.util.TreeMap;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.classification.InterfaceAudience;

@InterfaceAudience.Private
public class SaslUtil {
    private static final Log LOG = LogFactory.getLog(SaslUtil.class);
    public static final String SASL_DEFAULT_REALM = "default";
    public static final int SWITCH_TO_SIMPLE_AUTH = -88;

    public static String[] splitKerberosName(String fullName) {
        return fullName.split("[/@]");
    }

    static String encodeIdentifier(byte[] identifier) {
        return new String(Base64.encodeBase64((byte[])identifier));
    }

    static byte[] decodeIdentifier(String identifier) {
        return Base64.decodeBase64((byte[])identifier.getBytes());
    }

    static char[] encodePassword(byte[] password) {
        return new String(Base64.encodeBase64((byte[])password)).toCharArray();
    }

    public static QualityOfProtection getQop(String stringQop) {
        for (QualityOfProtection qop : QualityOfProtection.values()) {
            if (!qop.matches(stringQop)) continue;
            return qop;
        }
        throw new IllegalArgumentException("Invalid qop: " + stringQop + ". It must be one of 'authentication', 'integrity', 'privacy'.");
    }

    public static Map<String, String> initSaslProperties(String rpcProtection) {
        String saslQop;
        if (rpcProtection.isEmpty()) {
            saslQop = QualityOfProtection.AUTHENTICATION.getSaslQop();
        } else {
            String[] qops = rpcProtection.split(",");
            StringBuilder saslQopBuilder = new StringBuilder();
            for (int i = 0; i < qops.length; ++i) {
                QualityOfProtection qop = SaslUtil.getQop(qops[i]);
                saslQopBuilder.append(",").append(qop.getSaslQop());
            }
            saslQop = saslQopBuilder.substring(1);
        }
        TreeMap<String, String> saslProps = new TreeMap<String, String>();
        saslProps.put("javax.security.sasl.qop", saslQop);
        saslProps.put("javax.security.sasl.server.authentication", "true");
        return saslProps;
    }

    static void safeDispose(SaslClient saslClient) {
        try {
            saslClient.dispose();
        }
        catch (SaslException e) {
            LOG.error((Object)"Error disposing of SASL client", (Throwable)e);
        }
    }

    static void safeDispose(SaslServer saslServer) {
        try {
            saslServer.dispose();
        }
        catch (SaslException e) {
            LOG.error((Object)"Error disposing of SASL server", (Throwable)e);
        }
    }

    public static enum QualityOfProtection {
        AUTHENTICATION("auth"),
        INTEGRITY("auth-int"),
        PRIVACY("auth-conf");

        private final String saslQop;

        private QualityOfProtection(String saslQop) {
            this.saslQop = saslQop;
        }

        public String getSaslQop() {
            return this.saslQop;
        }

        public boolean matches(String stringQop) {
            if (this.saslQop.equals(stringQop)) {
                LOG.warn((Object)"Use authentication/integrity/privacy as value for rpc protection configurations instead of auth/auth-int/auth-conf.");
                return true;
            }
            return this.name().equalsIgnoreCase(stringQop);
        }
    }
}

