/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.FilterProtos;

@InterfaceAudience.Public
public class ValueFilter
extends CompareFilter {
    public ValueFilter(CompareFilter.CompareOp valueCompareOp, ByteArrayComparable valueComparator) {
        super(valueCompareOp, valueComparator);
    }

    @Override
    public Filter.ReturnCode filterKeyValue(Cell v) {
        if (this.compareValue(this.compareOp, this.comparator, v)) {
            return Filter.ReturnCode.SKIP;
        }
        return Filter.ReturnCode.INCLUDE;
    }

    public static Filter createFilterFromArguments(ArrayList<byte[]> filterArguments) {
        ArrayList<Object> arguments = CompareFilter.extractArguments(filterArguments);
        CompareFilter.CompareOp compareOp = (CompareFilter.CompareOp)((Object)arguments.get(0));
        ByteArrayComparable comparator = (ByteArrayComparable)arguments.get(1);
        return new ValueFilter(compareOp, comparator);
    }

    @Override
    public byte[] toByteArray() {
        FilterProtos.ValueFilter.Builder builder = FilterProtos.ValueFilter.newBuilder();
        builder.setCompareFilter(super.convert());
        return builder.build().toByteArray();
    }

    public static ValueFilter parseFrom(byte[] pbBytes) throws DeserializationException {
        FilterProtos.ValueFilter proto;
        try {
            proto = FilterProtos.ValueFilter.parseFrom((byte[])pbBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException((Throwable)e);
        }
        CompareFilter.CompareOp valueCompareOp = CompareFilter.CompareOp.valueOf(proto.getCompareFilter().getCompareOp().name());
        ByteArrayComparable valueComparator = null;
        try {
            if (proto.getCompareFilter().hasComparator()) {
                valueComparator = ProtobufUtil.toComparator(proto.getCompareFilter().getComparator());
            }
        }
        catch (IOException ioe) {
            throw new DeserializationException((Throwable)ioe);
        }
        return new ValueFilter(valueCompareOp, valueComparator);
    }

    @Override
    boolean areSerializedFieldsEqual(Filter o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ValueFilter)) {
            return false;
        }
        return super.areSerializedFieldsEqual(o);
    }
}

