/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.filter.ParseFilter;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.hadoop.hbase.shaded.protobuf.generated.FilterProtos;

@InterfaceAudience.Public
public class ColumnCountGetFilter
extends FilterBase {
    private int limit = 0;
    private int count = 0;

    public ColumnCountGetFilter(int n) {
        Preconditions.checkArgument((n >= 0 ? 1 : 0) != 0, (String)"limit be positive %s", (Object[])new Object[]{n});
        this.limit = n;
    }

    public int getLimit() {
        return this.limit;
    }

    @Override
    public boolean filterRowKey(Cell cell) throws IOException {
        return this.filterAllRemaining();
    }

    @Override
    public boolean filterAllRemaining() {
        return this.count > this.limit;
    }

    @Override
    public Filter.ReturnCode filterKeyValue(Cell v) {
        ++this.count;
        return this.filterAllRemaining() ? Filter.ReturnCode.NEXT_COL : Filter.ReturnCode.INCLUDE_AND_NEXT_COL;
    }

    @Override
    public void reset() {
        this.count = 0;
    }

    public static Filter createFilterFromArguments(ArrayList<byte[]> filterArguments) {
        Preconditions.checkArgument((filterArguments.size() == 1 ? 1 : 0) != 0, (String)"Expected 1 but got: %s", (Object[])new Object[]{filterArguments.size()});
        int limit = ParseFilter.convertByteArrayToInt(filterArguments.get(0));
        return new ColumnCountGetFilter(limit);
    }

    @Override
    public byte[] toByteArray() {
        FilterProtos.ColumnCountGetFilter.Builder builder = FilterProtos.ColumnCountGetFilter.newBuilder();
        builder.setLimit(this.limit);
        return builder.build().toByteArray();
    }

    public static ColumnCountGetFilter parseFrom(byte[] pbBytes) throws DeserializationException {
        FilterProtos.ColumnCountGetFilter proto;
        try {
            proto = FilterProtos.ColumnCountGetFilter.parseFrom((byte[])pbBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException((Throwable)e);
        }
        return new ColumnCountGetFilter(proto.getLimit());
    }

    @Override
    boolean areSerializedFieldsEqual(Filter o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ColumnCountGetFilter)) {
            return false;
        }
        ColumnCountGetFilter other = (ColumnCountGetFilter)o;
        return this.getLimit() == other.getLimit();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " " + this.limit;
    }
}

