/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.exceptions;

import java.net.ConnectException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;

@InterfaceAudience.Public
public class PreemptiveFastFailException
extends ConnectException {
    private static final long serialVersionUID = 7129103682617007177L;
    private long failureCount;
    private long timeOfFirstFailureMilliSec;
    private long timeOfLatestAttemptMilliSec;
    private boolean guaranteedClientSideOnly;

    public PreemptiveFastFailException(long count, long timeOfFirstFailureMilliSec, long timeOfLatestAttemptMilliSec, ServerName serverName) {
        super("Exception happened " + count + " times. to" + serverName);
        this.failureCount = count;
        this.timeOfFirstFailureMilliSec = timeOfFirstFailureMilliSec;
        this.timeOfLatestAttemptMilliSec = timeOfLatestAttemptMilliSec;
    }

    public PreemptiveFastFailException(long count, long timeOfFirstFailureMilliSec, long timeOfLatestAttemptMilliSec, ServerName serverName, boolean guaranteedClientSideOnly) {
        super("Exception happened " + count + " times. to" + serverName);
        this.failureCount = count;
        this.timeOfFirstFailureMilliSec = timeOfFirstFailureMilliSec;
        this.timeOfLatestAttemptMilliSec = timeOfLatestAttemptMilliSec;
        this.guaranteedClientSideOnly = guaranteedClientSideOnly;
    }

    public long getFirstFailureAt() {
        return this.timeOfFirstFailureMilliSec;
    }

    public long getLastAttemptAt() {
        return this.timeOfLatestAttemptMilliSec;
    }

    public long getFailureCount() {
        return this.failureCount;
    }

    public boolean wasOperationAttemptedByServer() {
        return false;
    }

    public boolean isGuaranteedClientSideOnly() {
        return this.guaranteedClientSideOnly;
    }
}

