/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client.backoff;

import com.google.common.base.Preconditions;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.backoff.ClientBackoffPolicy;
import org.apache.hadoop.hbase.client.backoff.ServerStatistics;

@InterfaceAudience.Public
public class ExponentialClientBackoffPolicy
implements ClientBackoffPolicy {
    private static final Log LOG = LogFactory.getLog(ExponentialClientBackoffPolicy.class);
    private static final long ONE_MINUTE = 60000L;
    public static final long DEFAULT_MAX_BACKOFF = 300000L;
    public static final String MAX_BACKOFF_KEY = "hbase.client.exponential-backoff.max";
    private long maxBackoff;
    private float heapOccupancyLowWatermark;
    private float heapOccupancyHighWatermark;

    public ExponentialClientBackoffPolicy(Configuration conf) {
        this.maxBackoff = conf.getLong(MAX_BACKOFF_KEY, 300000L);
        this.heapOccupancyLowWatermark = conf.getFloat("hbase.heap.occupancy.low_water_mark", 0.95f);
        this.heapOccupancyHighWatermark = conf.getFloat("hbase.heap.occupancy.high_water_mark", 0.98f);
    }

    @Override
    public long getBackoffTime(ServerName serverName, byte[] region, ServerStatistics stats) {
        double multiplier;
        if (stats == null) {
            return 0L;
        }
        ServerStatistics.RegionStatistics regionStats = stats.getStatsForRegion(region);
        if (regionStats == null) {
            return 0L;
        }
        double percent = (double)regionStats.getMemstoreLoadPercent() / 100.0;
        float heapOccupancy = (float)regionStats.getHeapOccupancyPercent() / 100.0f;
        float compactionPressure = (float)regionStats.getCompactionPressure() / 100.0f;
        if (heapOccupancy >= this.heapOccupancyLowWatermark) {
            if (heapOccupancy > this.heapOccupancyHighWatermark) {
                heapOccupancy = this.heapOccupancyHighWatermark;
            }
            percent = Math.max(percent, ExponentialClientBackoffPolicy.scale(heapOccupancy, this.heapOccupancyLowWatermark, this.heapOccupancyHighWatermark, 0.1, 1.0));
        }
        if ((multiplier = Math.pow(percent = Math.max(percent, (double)compactionPressure), 4.0)) > 1.0) {
            multiplier = 1.0;
        }
        return (long)(multiplier * (double)this.maxBackoff);
    }

    private static double scale(double valueIn, double baseMin, double baseMax, double limitMin, double limitMax) {
        Preconditions.checkArgument((baseMin <= baseMax ? 1 : 0) != 0, (String)"Illegal source range [%s,%s]", (Object[])new Object[]{baseMin, baseMax});
        Preconditions.checkArgument((limitMin <= limitMax ? 1 : 0) != 0, (String)"Illegal target range [%s,%s]", (Object[])new Object[]{limitMin, limitMax});
        Preconditions.checkArgument((valueIn >= baseMin && valueIn <= baseMax ? 1 : 0) != 0, (String)"Value %s must be within the range [%s,%s]", (Object[])new Object[]{valueIn, baseMin, baseMax});
        return (limitMax - limitMin) * (valueIn - baseMin) / (baseMax - baseMin) + limitMin;
    }
}

