/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang.mutable.MutableInt;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.curator.framework.api.CuratorEvent;
import org.apache.curator.framework.api.ErrorListenerPathable;
import org.apache.curator.retry.RetryNTimes;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterId;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.AsyncRegistry;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.zookeeper.RecoverableZooKeeper;
import org.apache.hadoop.hbase.zookeeper.ZKConfig;
import org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import org.apache.zookeeper.data.Stat;

@InterfaceAudience.Private
class ZKAsyncRegistry
implements AsyncRegistry {
    private static final Log LOG = LogFactory.getLog(ZKAsyncRegistry.class);
    private final CuratorFramework zk;
    private final ZNodePaths znodePaths;

    ZKAsyncRegistry(Configuration conf) {
        this.znodePaths = new ZNodePaths(conf);
        int zkSessionTimeout = conf.getInt("zookeeper.session.timeout", 180000);
        int zkRetry = conf.getInt("zookeeper.recovery.retry", 3);
        int zkRetryIntervalMs = conf.getInt("zookeeper.recovery.retry.intervalmill", 1000);
        this.zk = CuratorFrameworkFactory.builder().connectString(ZKConfig.getZKQuorumServersString((Configuration)conf)).sessionTimeoutMs(zkSessionTimeout).retryPolicy((RetryPolicy)new RetryNTimes(zkRetry, zkRetryIntervalMs)).threadFactory(Threads.newDaemonThreadFactory((String)String.format("ZKClusterRegistry-0x%08x", this.hashCode()))).build();
        this.zk.start();
    }

    private static <T> CompletableFuture<T> exec(BackgroundPathable<?> opBuilder, String path, CuratorEventProcessor<T> processor) {
        CompletableFuture future = new CompletableFuture();
        try {
            ((ErrorListenerPathable)opBuilder.inBackground((client, event) -> {
                try {
                    future.complete(processor.process(event));
                }
                catch (Exception e) {
                    future.completeExceptionally(e);
                }
            })).withUnhandledErrorListener((msg, e) -> future.completeExceptionally(e)).forPath(path);
        }
        catch (Exception e2) {
            future.completeExceptionally(e2);
        }
        return future;
    }

    private static String getClusterId(CuratorEvent event) throws DeserializationException {
        byte[] data = event.getData();
        if (data == null || data.length == 0) {
            return null;
        }
        data = RecoverableZooKeeper.removeMetaData(data);
        return ClusterId.parseFrom(data).toString();
    }

    @Override
    public CompletableFuture<String> getClusterId() {
        return ZKAsyncRegistry.exec(this.zk.getData(), this.znodePaths.clusterIdZNode, ZKAsyncRegistry::getClusterId);
    }

    private static ZooKeeperProtos.MetaRegionServer getMetaProto(CuratorEvent event) throws IOException {
        byte[] data = event.getData();
        if (data == null || data.length == 0) {
            return null;
        }
        data = RecoverableZooKeeper.removeMetaData(data);
        int prefixLen = ProtobufUtil.lengthOfPBMagic();
        return (ZooKeeperProtos.MetaRegionServer)ZooKeeperProtos.MetaRegionServer.parser().parseFrom(data, prefixLen, data.length - prefixLen);
    }

    private static void tryComplete(MutableInt remaining, HRegionLocation[] locs, CompletableFuture<RegionLocations> future) {
        remaining.decrement();
        if (remaining.intValue() > 0) {
            return;
        }
        future.complete(new RegionLocations(locs));
    }

    private Pair<RegionState.State, ServerName> getStateAndServerName(ZooKeeperProtos.MetaRegionServer proto) {
        RegionState.State state = proto.hasState() ? RegionState.State.convert(proto.getState()) : RegionState.State.OPEN;
        HBaseProtos.ServerName snProto = proto.getServer();
        return Pair.newPair((Object)((Object)state), (Object)ServerName.valueOf((String)snProto.getHostName(), (int)snProto.getPort(), (long)snProto.getStartCode()));
    }

    @Override
    public CompletableFuture<RegionLocations> getMetaRegionLocation() {
        CompletableFuture<RegionLocations> future = new CompletableFuture<RegionLocations>();
        HRegionLocation[] locs = new HRegionLocation[this.znodePaths.metaReplicaZNodes.size()];
        MutableInt remaining = new MutableInt(locs.length);
        this.znodePaths.metaReplicaZNodes.forEach((replicaId, path) -> {
            if (replicaId == 0) {
                ZKAsyncRegistry.exec(this.zk.getData(), path, ZKAsyncRegistry::getMetaProto).whenComplete((proto, error) -> {
                    if (error != null) {
                        future.completeExceptionally((Throwable)error);
                        return;
                    }
                    if (proto == null) {
                        future.completeExceptionally(new IOException("Meta znode is null"));
                        return;
                    }
                    Pair<RegionState.State, ServerName> stateAndServerName = this.getStateAndServerName((ZooKeeperProtos.MetaRegionServer)proto);
                    if (stateAndServerName.getFirst() != RegionState.State.OPEN) {
                        future.completeExceptionally(new IOException("Meta region is in state " + stateAndServerName.getFirst()));
                        return;
                    }
                    locs[0] = new HRegionLocation(RegionReplicaUtil.getRegionInfoForDefaultReplica(HRegionInfo.FIRST_META_REGIONINFO), (ServerName)stateAndServerName.getSecond());
                    ZKAsyncRegistry.tryComplete(remaining, locs, future);
                });
            } else {
                ZKAsyncRegistry.exec(this.zk.getData(), path, ZKAsyncRegistry::getMetaProto).whenComplete((proto, error) -> {
                    if (future.isDone()) {
                        return;
                    }
                    if (error != null) {
                        LOG.warn((Object)("Failed to fetch " + path), error);
                        locs[replicaId.intValue()] = null;
                    } else if (proto == null) {
                        LOG.warn((Object)("Meta znode for replica " + replicaId + " is null"));
                        locs[replicaId.intValue()] = null;
                    } else {
                        Pair<RegionState.State, ServerName> stateAndServerName = this.getStateAndServerName((ZooKeeperProtos.MetaRegionServer)proto);
                        if (stateAndServerName.getFirst() != RegionState.State.OPEN) {
                            LOG.warn((Object)("Meta region for replica " + replicaId + " is in state " + stateAndServerName.getFirst()));
                            locs[replicaId.intValue()] = null;
                        } else {
                            locs[replicaId.intValue()] = new HRegionLocation(RegionReplicaUtil.getRegionInfoForReplica(HRegionInfo.FIRST_META_REGIONINFO, replicaId), (ServerName)stateAndServerName.getSecond());
                        }
                    }
                    ZKAsyncRegistry.tryComplete(remaining, locs, future);
                });
            }
        });
        return future;
    }

    private static int getCurrentNrHRS(CuratorEvent event) {
        Stat stat = event.getStat();
        return stat != null ? stat.getNumChildren() : 0;
    }

    @Override
    public CompletableFuture<Integer> getCurrentNrHRS() {
        return ZKAsyncRegistry.exec(this.zk.checkExists(), this.znodePaths.rsZNode, ZKAsyncRegistry::getCurrentNrHRS);
    }

    private static ZooKeeperProtos.Master getMasterProto(CuratorEvent event) throws IOException {
        byte[] data = event.getData();
        if (data == null || data.length == 0) {
            return null;
        }
        data = RecoverableZooKeeper.removeMetaData(data);
        int prefixLen = ProtobufUtil.lengthOfPBMagic();
        return (ZooKeeperProtos.Master)ZooKeeperProtos.Master.parser().parseFrom(data, prefixLen, data.length - prefixLen);
    }

    @Override
    public CompletableFuture<ServerName> getMasterAddress() {
        return ZKAsyncRegistry.exec(this.zk.getData(), this.znodePaths.masterAddressZNode, ZKAsyncRegistry::getMasterProto).thenApply(proto -> {
            if (proto == null) {
                return null;
            }
            HBaseProtos.ServerName snProto = proto.getMaster();
            return ServerName.valueOf((String)snProto.getHostName(), (int)snProto.getPort(), (long)snProto.getStartCode());
        });
    }

    @Override
    public CompletableFuture<Integer> getMasterInfoPort() {
        return ZKAsyncRegistry.exec(this.zk.getData(), this.znodePaths.masterAddressZNode, ZKAsyncRegistry::getMasterProto).thenApply(proto -> proto != null ? proto.getInfoPort() : 0);
    }

    @Override
    public void close() {
        this.zk.close();
    }

    private static interface CuratorEventProcessor<T> {
        public T process(CuratorEvent var1) throws Exception;
    }
}

