/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.metrics.ScanMetrics;

@InterfaceAudience.Public
public interface ResultScanner
extends Closeable,
Iterable<Result> {
    @Override
    default public Iterator<Result> iterator() {
        return new Iterator<Result>(){
            Result next = null;

            @Override
            public boolean hasNext() {
                if (this.next != null) {
                    return true;
                }
                try {
                    this.next = ResultScanner.this.next();
                    return this.next != null;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }

            @Override
            public Result next() {
                if (!this.hasNext()) {
                    return null;
                }
                Result temp = this.next;
                this.next = null;
                return temp;
            }
        };
    }

    public Result next() throws IOException;

    default public Result[] next(int nbRows) throws IOException {
        Result next;
        ArrayList<Result> resultSets = new ArrayList<Result>(nbRows);
        for (int i = 0; i < nbRows && (next = this.next()) != null; ++i) {
            resultSets.add(next);
        }
        return resultSets.toArray(new Result[0]);
    }

    @Override
    public void close();

    public boolean renewLease();

    public ScanMetrics getScanMetrics();
}

