/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.AsyncConnectionImpl;
import org.apache.hadoop.hbase.client.AsyncRegionLocator;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.NoServerForRegionException;
import org.apache.hadoop.hbase.client.RegionLocateType;
import org.apache.hadoop.hbase.client.RegionOfflineException;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CollectionUtils;

@InterfaceAudience.Private
class AsyncNonMetaRegionLocator {
    private static final Log LOG = LogFactory.getLog(AsyncNonMetaRegionLocator.class);
    static final String MAX_CONCURRENT_LOCATE_REQUEST_PER_TABLE = "hbase.client.meta.max.concurrent.locate.per.table";
    private static final int DEFAULT_MAX_CONCURRENT_LOCATE_REQUEST_PER_TABLE = 8;
    private final AsyncConnectionImpl conn;
    private final int maxConcurrentLocateRequestPerTable;
    private final ConcurrentMap<TableName, TableCache> cache = new ConcurrentHashMap<TableName, TableCache>();

    AsyncNonMetaRegionLocator(AsyncConnectionImpl conn) {
        this.conn = conn;
        this.maxConcurrentLocateRequestPerTable = conn.getConfiguration().getInt(MAX_CONCURRENT_LOCATE_REQUEST_PER_TABLE, 8);
    }

    private TableCache getTableCache(TableName tableName) {
        return (TableCache)CollectionUtils.computeIfAbsent(this.cache, (Object)tableName, () -> new TableCache());
    }

    private void removeFromCache(HRegionLocation loc) {
        TableCache tableCache = (TableCache)this.cache.get(loc.getRegionInfo().getTable());
        if (tableCache == null) {
            return;
        }
        tableCache.cache.computeIfPresent(loc.getRegionInfo().getStartKey(), (k, oldLoc) -> {
            if (oldLoc.getSeqNum() > loc.getSeqNum() || !oldLoc.getServerName().equals((Object)loc.getServerName())) {
                return oldLoc;
            }
            return null;
        });
    }

    private boolean addToCache(TableCache tableCache, HRegionLocation loc) {
        byte[] startKey;
        HRegionLocation oldLoc;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Try adding " + loc + " to cache"));
        }
        if ((oldLoc = tableCache.cache.putIfAbsent(startKey = loc.getRegionInfo().getStartKey(), loc)) == null) {
            return true;
        }
        if (oldLoc.getSeqNum() > loc.getSeqNum() || oldLoc.getServerName().equals((Object)loc.getServerName())) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Will not add " + loc + " to cache because the old value " + oldLoc + " is newer than us or has the same server name"));
            }
            return false;
        }
        return loc == tableCache.cache.compute(startKey, (k, oldValue) -> {
            if (oldValue == null || oldValue.getSeqNum() <= loc.getSeqNum()) {
                return loc;
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Will not add " + loc + " to cache because the old value " + oldValue + " is newer than us or has the same server name. Maybe it is updated before we replace it"));
            }
            return oldValue;
        });
    }

    @SuppressWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Called by lambda expression")
    private void addToCache(HRegionLocation loc) {
        this.addToCache(this.getTableCache(loc.getRegionInfo().getTable()), loc);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Try adding " + loc + " to cache"));
        }
    }

    private boolean tryComplete(LocateRequest req, CompletableFuture<HRegionLocation> future, HRegionLocation loc) {
        int c;
        if (future.isDone()) {
            return true;
        }
        boolean completed = req.locateType.equals((Object)RegionLocateType.BEFORE) ? (c = Bytes.compareTo((byte[])loc.getRegionInfo().getEndKey(), (byte[])req.row)) == 0 || c > 0 && Bytes.compareTo((byte[])loc.getRegionInfo().getStartKey(), (byte[])req.row) < 0 : loc.getRegionInfo().containsRow(req.row);
        if (completed) {
            future.complete(loc);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void complete(TableName tableName, LocateRequest req, HRegionLocation loc, Throwable error) {
        if (error != null && LOG.isDebugEnabled()) {
            LOG.debug((Object)("Failed to locate region in '" + tableName + "', row='" + Bytes.toStringBinary((byte[])req.row) + "', locateType=" + (Object)((Object)req.locateType)), error);
        }
        LocateRequest toSend = null;
        TableCache tableCache = this.getTableCache(tableName);
        if (loc != null && !this.addToCache(tableCache, loc)) {
            TableCache tableCache2 = tableCache;
            synchronized (tableCache2) {
                tableCache.pendingRequests.remove(req);
            }
            return;
        }
        TableCache tableCache3 = tableCache;
        synchronized (tableCache3) {
            LocateRequest[] candidates;
            CompletableFuture<HRegionLocation> future;
            tableCache.pendingRequests.remove(req);
            if (error instanceof DoNotRetryIOException && (future = tableCache.allRequests.remove(req)) != null) {
                future.completeExceptionally(error);
            }
            if (loc != null) {
                Iterator<Map.Entry<LocateRequest, CompletableFuture<HRegionLocation>>> iter = tableCache.allRequests.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry<LocateRequest, CompletableFuture<HRegionLocation>> entry = iter.next();
                    if (!this.tryComplete(entry.getKey(), entry.getValue(), loc)) continue;
                    iter.remove();
                }
            }
            if (!tableCache.allRequests.isEmpty() && tableCache.hasQuota(this.maxConcurrentLocateRequestPerTable) && (candidates = (LocateRequest[])tableCache.allRequests.keySet().stream().filter(r -> !tableCache.isPending((LocateRequest)r)).toArray(LocateRequest[]::new)).length > 0) {
                toSend = candidates[ThreadLocalRandom.current().nextInt(candidates.length)];
                tableCache.send(toSend);
            }
        }
        if (toSend != null) {
            this.locateInMeta(tableName, toSend);
        }
    }

    private void onScanComplete(TableName tableName, LocateRequest req, List<Result> results, Throwable error) {
        if (error != null) {
            this.complete(tableName, req, null, error);
            return;
        }
        if (results.isEmpty()) {
            this.complete(tableName, req, null, (Throwable)((Object)new TableNotFoundException(tableName)));
            return;
        }
        RegionLocations locs = MetaTableAccessor.getRegionLocations(results.get(0));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("The fetched location of '" + tableName + "', row='" + Bytes.toStringBinary((byte[])req.row) + "', locateType=" + (Object)((Object)req.locateType) + " is " + locs));
        }
        if (locs == null || locs.getDefaultRegionLocation() == null) {
            this.complete(tableName, req, null, new IOException(String.format("No location found for '%s', row='%s', locateType=%s", new Object[]{tableName, Bytes.toStringBinary((byte[])req.row), req.locateType})));
            return;
        }
        HRegionLocation loc = locs.getDefaultRegionLocation();
        HRegionInfo info = loc.getRegionInfo();
        if (info == null) {
            this.complete(tableName, req, null, new IOException(String.format("HRegionInfo is null for '%s', row='%s', locateType=%s", new Object[]{tableName, Bytes.toStringBinary((byte[])req.row), req.locateType})));
            return;
        }
        if (!info.getTable().equals((Object)tableName)) {
            this.complete(tableName, req, null, (Throwable)((Object)new TableNotFoundException("Table '" + tableName + "' was not found, got: '" + info.getTable() + "'")));
            return;
        }
        if (info.isSplit()) {
            this.complete(tableName, req, null, (Throwable)((Object)new RegionOfflineException("the only available region for the required row is a split parent, the daughters should be online soon: '" + info.getRegionNameAsString() + "'")));
            return;
        }
        if (info.isOffline()) {
            this.complete(tableName, req, null, (Throwable)((Object)new RegionOfflineException("the region is offline, could be caused by a disable table call: '" + info.getRegionNameAsString() + "'")));
            return;
        }
        if (loc.getServerName() == null) {
            this.complete(tableName, req, null, (Throwable)((Object)new NoServerForRegionException(String.format("No server address listed for region '%s', row='%s', locateType=%s", new Object[]{info.getRegionNameAsString(), Bytes.toStringBinary((byte[])req.row), req.locateType}))));
            return;
        }
        this.complete(tableName, req, loc, null);
    }

    private HRegionLocation locateRowInCache(TableCache tableCache, TableName tableName, byte[] row) {
        Map.Entry entry = tableCache.cache.floorEntry(row);
        if (entry == null) {
            return null;
        }
        HRegionLocation loc = (HRegionLocation)entry.getValue();
        byte[] endKey = loc.getRegionInfo().getEndKey();
        if (ConnectionUtils.isEmptyStopRow(endKey) || Bytes.compareTo((byte[])row, (byte[])endKey) < 0) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Found " + loc + " in cache for '" + tableName + "', row='" + Bytes.toStringBinary((byte[])row) + "', locateType=" + (Object)((Object)RegionLocateType.CURRENT)));
            }
            return loc;
        }
        return null;
    }

    private HRegionLocation locateRowBeforeInCache(TableCache tableCache, TableName tableName, byte[] row) {
        Map.Entry entry;
        Map.Entry entry2 = entry = ConnectionUtils.isEmptyStopRow(row) ? tableCache.cache.lastEntry() : tableCache.cache.lowerEntry(row);
        if (entry == null) {
            return null;
        }
        HRegionLocation loc = (HRegionLocation)entry.getValue();
        if (ConnectionUtils.isEmptyStopRow(loc.getRegionInfo().getEndKey()) || Bytes.compareTo((byte[])loc.getRegionInfo().getEndKey(), (byte[])row) >= 0) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Found " + loc + " in cache for '" + tableName + "', row='" + Bytes.toStringBinary((byte[])row) + "', locateType=" + (Object)((Object)RegionLocateType.BEFORE)));
            }
            return loc;
        }
        return null;
    }

    private void locateInMeta(TableName tableName, LocateRequest req) {
        byte[] metaKey;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Try locate '" + tableName + "', row='" + Bytes.toStringBinary((byte[])req.row) + "', locateType=" + (Object)((Object)req.locateType) + " in meta"));
        }
        if (req.locateType.equals((Object)RegionLocateType.BEFORE)) {
            if (ConnectionUtils.isEmptyStopRow(req.row)) {
                byte[] binaryTableName = tableName.getName();
                metaKey = Arrays.copyOf(binaryTableName, binaryTableName.length + 1);
            } else {
                metaKey = HRegionInfo.createRegionName(tableName, req.row, "00000000000000", false);
            }
        } else {
            metaKey = HRegionInfo.createRegionName(tableName, req.row, "99999999999999", false);
        }
        this.conn.getRawTable(TableName.META_TABLE_NAME).scanAll(new Scan().withStartRow(metaKey).setReversed(true).addFamily(HConstants.CATALOG_FAMILY).setOneRowLimit()).whenComplete((results, error) -> this.onScanComplete(tableName, req, (List<Result>)results, (Throwable)error));
    }

    private HRegionLocation locateInCache(TableCache tableCache, TableName tableName, byte[] row, RegionLocateType locateType) {
        return locateType.equals((Object)RegionLocateType.BEFORE) ? this.locateRowBeforeInCache(tableCache, tableName, row) : this.locateRowInCache(tableCache, tableName, row);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<HRegionLocation> getRegionLocationInternal(TableName tableName, byte[] row, RegionLocateType locateType) {
        CompletableFuture<HRegionLocation> future;
        LocateRequest req;
        assert (!locateType.equals((Object)RegionLocateType.AFTER));
        TableCache tableCache = this.getTableCache(tableName);
        HRegionLocation loc = this.locateInCache(tableCache, tableName, row, locateType);
        if (loc != null) {
            return CompletableFuture.completedFuture(loc);
        }
        boolean sendRequest = false;
        TableCache tableCache2 = tableCache;
        synchronized (tableCache2) {
            loc = this.locateInCache(tableCache, tableName, row, locateType);
            if (loc != null) {
                return CompletableFuture.completedFuture(loc);
            }
            req = new LocateRequest(row, locateType);
            future = tableCache.allRequests.get(req);
            if (future == null) {
                future = new CompletableFuture();
                tableCache.allRequests.put(req, future);
                if (tableCache.hasQuota(this.maxConcurrentLocateRequestPerTable) && !tableCache.isPending(req)) {
                    tableCache.send(req);
                    sendRequest = true;
                }
            }
        }
        if (sendRequest) {
            this.locateInMeta(tableName, req);
        }
        return future;
    }

    CompletableFuture<HRegionLocation> getRegionLocation(TableName tableName, byte[] row, RegionLocateType locateType) {
        if (locateType.equals((Object)RegionLocateType.BEFORE)) {
            return this.getRegionLocationInternal(tableName, row, locateType);
        }
        if (locateType.equals((Object)RegionLocateType.AFTER)) {
            row = ConnectionUtils.createClosestRowAfter(row);
        }
        return this.getRegionLocationInternal(tableName, row, RegionLocateType.CURRENT);
    }

    void updateCachedLocation(HRegionLocation loc, Throwable exception) {
        AsyncRegionLocator.updateCachedLocation(loc, exception, l -> {
            TableCache tableCache = (TableCache)this.cache.get(l.getRegionInfo().getTable());
            if (tableCache == null) {
                return null;
            }
            return (HRegionLocation)tableCache.cache.get(l.getRegionInfo().getStartKey());
        }, this::addToCache, this::removeFromCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearCache(TableName tableName) {
        TableCache tableCache = (TableCache)this.cache.remove(tableName);
        if (tableCache == null) {
            return;
        }
        TableCache tableCache2 = tableCache;
        synchronized (tableCache2) {
            if (!tableCache.allRequests.isEmpty()) {
                IOException error = new IOException("Cache cleared");
                tableCache.allRequests.values().forEach(f -> f.completeExceptionally(error));
            }
        }
    }

    private static final class TableCache {
        public final ConcurrentNavigableMap<byte[], HRegionLocation> cache = new ConcurrentSkipListMap<byte[], HRegionLocation>(Bytes.BYTES_COMPARATOR);
        public final Set<LocateRequest> pendingRequests = new HashSet<LocateRequest>();
        public final Map<LocateRequest, CompletableFuture<HRegionLocation>> allRequests = new HashMap<LocateRequest, CompletableFuture<HRegionLocation>>();

        private TableCache() {
        }

        public boolean hasQuota(int max) {
            return this.pendingRequests.size() < max;
        }

        public boolean isPending(LocateRequest req) {
            return this.pendingRequests.contains(req);
        }

        public void send(LocateRequest req) {
            this.pendingRequests.add(req);
        }
    }

    private static final class LocateRequest {
        public final byte[] row;
        public final RegionLocateType locateType;

        public LocateRequest(byte[] row, RegionLocateType locateType) {
            this.row = row;
            this.locateType = locateType;
        }

        public int hashCode() {
            return Bytes.hashCode((byte[])this.row) ^ this.locateType.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != LocateRequest.class) {
                return false;
            }
            LocateRequest that = (LocateRequest)obj;
            return this.locateType.equals((Object)that.locateType) && Bytes.equals((byte[])this.row, (byte[])that.row);
        }
    }
}

