/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Pattern;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.ProcedureInfo;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.AsyncConnectionImpl;
import org.apache.hadoop.hbase.client.SnapshotDescription;
import org.apache.hadoop.hbase.client.SnapshotType;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.replication.TableCFs;
import org.apache.hadoop.hbase.quotas.QuotaFilter;
import org.apache.hadoop.hbase.quotas.QuotaSettings;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationPeerDescription;
import org.apache.hadoop.hbase.util.Pair;

@InterfaceAudience.Private
public interface AsyncAdmin {
    public AsyncConnectionImpl getConnection();

    public CompletableFuture<Boolean> tableExists(TableName var1);

    public CompletableFuture<TableDescriptor[]> listTables();

    public CompletableFuture<TableDescriptor[]> listTables(String var1, boolean var2);

    public CompletableFuture<TableDescriptor[]> listTables(Pattern var1, boolean var2);

    public CompletableFuture<TableName[]> listTableNames();

    public CompletableFuture<TableName[]> listTableNames(String var1, boolean var2);

    public CompletableFuture<TableName[]> listTableNames(Pattern var1, boolean var2);

    public CompletableFuture<TableDescriptor> getTableDescriptor(TableName var1);

    public CompletableFuture<Void> createTable(TableDescriptor var1);

    public CompletableFuture<Void> createTable(TableDescriptor var1, byte[] var2, byte[] var3, int var4);

    public CompletableFuture<Void> createTable(TableDescriptor var1, byte[][] var2);

    public CompletableFuture<Void> deleteTable(TableName var1);

    public CompletableFuture<TableDescriptor[]> deleteTables(String var1);

    public CompletableFuture<TableDescriptor[]> deleteTables(Pattern var1);

    public CompletableFuture<Void> truncateTable(TableName var1, boolean var2);

    public CompletableFuture<Void> enableTable(TableName var1);

    public CompletableFuture<TableDescriptor[]> enableTables(String var1);

    public CompletableFuture<TableDescriptor[]> enableTables(Pattern var1);

    public CompletableFuture<Void> disableTable(TableName var1);

    public CompletableFuture<TableDescriptor[]> disableTables(String var1);

    public CompletableFuture<TableDescriptor[]> disableTables(Pattern var1);

    public CompletableFuture<Boolean> isTableDisabled(TableName var1);

    public CompletableFuture<Boolean> isTableAvailable(TableName var1);

    public CompletableFuture<Boolean> isTableAvailable(TableName var1, byte[][] var2);

    public CompletableFuture<Pair<Integer, Integer>> getAlterStatus(TableName var1);

    public CompletableFuture<Void> addColumnFamily(TableName var1, HColumnDescriptor var2);

    public CompletableFuture<Void> deleteColumnFamily(TableName var1, byte[] var2);

    public CompletableFuture<Void> modifyColumnFamily(TableName var1, HColumnDescriptor var2);

    public CompletableFuture<Void> createNamespace(NamespaceDescriptor var1);

    public CompletableFuture<Void> modifyNamespace(NamespaceDescriptor var1);

    public CompletableFuture<Void> deleteNamespace(String var1);

    public CompletableFuture<NamespaceDescriptor> getNamespaceDescriptor(String var1);

    public CompletableFuture<NamespaceDescriptor[]> listNamespaceDescriptors();

    public CompletableFuture<Boolean> isTableEnabled(TableName var1);

    public CompletableFuture<Boolean> setBalancerRunning(boolean var1);

    public CompletableFuture<Boolean> balancer();

    public CompletableFuture<Boolean> balancer(boolean var1);

    public CompletableFuture<Boolean> isBalancerEnabled();

    public CompletableFuture<Void> closeRegion(String var1, String var2);

    public CompletableFuture<Void> closeRegion(byte[] var1, String var2);

    public CompletableFuture<Boolean> closeRegionWithEncodedRegionName(String var1, String var2);

    public CompletableFuture<Void> closeRegion(ServerName var1, HRegionInfo var2);

    public CompletableFuture<List<HRegionInfo>> getOnlineRegions(ServerName var1);

    public CompletableFuture<Void> flush(TableName var1);

    public CompletableFuture<Void> flushRegion(byte[] var1);

    public CompletableFuture<Void> compact(TableName var1);

    public CompletableFuture<Void> compact(TableName var1, byte[] var2);

    public CompletableFuture<Void> compactRegion(byte[] var1);

    public CompletableFuture<Void> compactRegion(byte[] var1, byte[] var2);

    public CompletableFuture<Void> majorCompact(TableName var1);

    public CompletableFuture<Void> majorCompact(TableName var1, byte[] var2);

    public CompletableFuture<Void> majorCompactRegion(byte[] var1);

    public CompletableFuture<Void> majorCompactRegion(byte[] var1, byte[] var2);

    public CompletableFuture<Void> compactRegionServer(ServerName var1);

    public CompletableFuture<Void> majorCompactRegionServer(ServerName var1);

    public CompletableFuture<Void> mergeRegions(byte[] var1, byte[] var2, boolean var3);

    public CompletableFuture<Void> split(TableName var1);

    public CompletableFuture<Void> splitRegion(byte[] var1);

    public CompletableFuture<Void> split(TableName var1, byte[] var2);

    public CompletableFuture<Void> splitRegion(byte[] var1, byte[] var2);

    public CompletableFuture<Void> assign(byte[] var1);

    public CompletableFuture<Void> unassign(byte[] var1, boolean var2);

    public CompletableFuture<Void> offline(byte[] var1);

    public CompletableFuture<Void> move(byte[] var1, byte[] var2);

    public CompletableFuture<Void> setQuota(QuotaSettings var1);

    public CompletableFuture<List<QuotaSettings>> getQuota(QuotaFilter var1);

    public CompletableFuture<Void> addReplicationPeer(String var1, ReplicationPeerConfig var2);

    public CompletableFuture<Void> removeReplicationPeer(String var1);

    public CompletableFuture<Void> enableReplicationPeer(String var1);

    public CompletableFuture<Void> disableReplicationPeer(String var1);

    public CompletableFuture<ReplicationPeerConfig> getReplicationPeerConfig(String var1);

    public CompletableFuture<Void> updateReplicationPeerConfig(String var1, ReplicationPeerConfig var2);

    public CompletableFuture<Void> appendReplicationPeerTableCFs(String var1, Map<TableName, ? extends Collection<String>> var2);

    public CompletableFuture<Void> removeReplicationPeerTableCFs(String var1, Map<TableName, ? extends Collection<String>> var2);

    public CompletableFuture<List<ReplicationPeerDescription>> listReplicationPeers();

    public CompletableFuture<List<ReplicationPeerDescription>> listReplicationPeers(String var1);

    public CompletableFuture<List<ReplicationPeerDescription>> listReplicationPeers(Pattern var1);

    public CompletableFuture<List<TableCFs>> listReplicatedTableCFs();

    public CompletableFuture<Void> snapshot(String var1, TableName var2);

    public CompletableFuture<Void> snapshot(String var1, TableName var2, SnapshotType var3);

    public CompletableFuture<Void> snapshot(SnapshotDescription var1);

    public CompletableFuture<Boolean> isSnapshotFinished(SnapshotDescription var1);

    public CompletableFuture<Void> restoreSnapshot(String var1);

    public CompletableFuture<Void> restoreSnapshot(String var1, boolean var2);

    public CompletableFuture<Void> cloneSnapshot(String var1, TableName var2);

    public CompletableFuture<List<SnapshotDescription>> listSnapshots();

    public CompletableFuture<List<SnapshotDescription>> listSnapshots(String var1);

    public CompletableFuture<List<SnapshotDescription>> listSnapshots(Pattern var1);

    public CompletableFuture<List<SnapshotDescription>> listTableSnapshots(String var1, String var2);

    public CompletableFuture<List<SnapshotDescription>> listTableSnapshots(Pattern var1, Pattern var2);

    public CompletableFuture<Void> deleteSnapshot(String var1);

    public CompletableFuture<Void> deleteSnapshots(String var1);

    public CompletableFuture<Void> deleteSnapshots(Pattern var1);

    public CompletableFuture<Void> deleteTableSnapshots(String var1, String var2);

    public CompletableFuture<Void> deleteTableSnapshots(Pattern var1, Pattern var2);

    public CompletableFuture<Void> execProcedure(String var1, String var2, Map<String, String> var3);

    public CompletableFuture<byte[]> execProcedureWithRet(String var1, String var2, Map<String, String> var3);

    public CompletableFuture<Boolean> isProcedureFinished(String var1, String var2, Map<String, String> var3);

    public CompletableFuture<Boolean> abortProcedure(long var1, boolean var3);

    public CompletableFuture<ProcedureInfo[]> listProcedures();
}

