/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Consistency;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.RawAsyncTable;
import org.apache.hadoop.hbase.client.RawScanResultConsumer;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Pair;

@InterfaceAudience.Private
public class AsyncMetaTableAccessor {
    private static final Log LOG = LogFactory.getLog(AsyncMetaTableAccessor.class);
    private static final char META_REPLICA_ID_DELIMITER = '_';
    private static final Pattern SERVER_COLUMN_PATTERN = Pattern.compile("^server(_[0-9a-fA-F]{4})?$");

    public static CompletableFuture<Boolean> tableExists(RawAsyncTable metaTable, TableName tableName) {
        if (tableName.equals((Object)TableName.META_TABLE_NAME)) {
            return CompletableFuture.completedFuture(true);
        }
        return AsyncMetaTableAccessor.getTableState(metaTable, tableName).thenApply(Optional::isPresent);
    }

    public static CompletableFuture<Optional<TableState>> getTableState(RawAsyncTable metaTable, TableName tableName) {
        CompletableFuture<Optional<TableState>> future = new CompletableFuture<Optional<TableState>>();
        Get get = new Get(tableName.getName()).addColumn(AsyncMetaTableAccessor.getTableFamily(), AsyncMetaTableAccessor.getStateColumn());
        long time = EnvironmentEdgeManager.currentTime();
        try {
            get.setTimeRange(0L, time);
            metaTable.get(get).whenComplete((result, error) -> {
                if (error != null) {
                    future.completeExceptionally((Throwable)error);
                    return;
                }
                try {
                    future.complete(AsyncMetaTableAccessor.getTableState(result));
                }
                catch (IOException e) {
                    future.completeExceptionally(e);
                }
            });
        }
        catch (IOException ioe) {
            future.completeExceptionally(ioe);
        }
        return future;
    }

    public static CompletableFuture<Pair<HRegionInfo, ServerName>> getRegion(RawAsyncTable metaTable, byte[] regionName) {
        CompletableFuture<Pair<HRegionInfo, ServerName>> future = new CompletableFuture<Pair<HRegionInfo, ServerName>>();
        byte[] row = regionName;
        HRegionInfo parsedInfo = null;
        try {
            parsedInfo = MetaTableAccessor.parseRegionInfoFromRegionName(regionName);
            row = MetaTableAccessor.getMetaKeyForRegion(parsedInfo);
        }
        catch (Exception exception) {
            // empty catch block
        }
        HRegionInfo finalHRI = parsedInfo;
        metaTable.get(new Get(row).addFamily(HConstants.CATALOG_FAMILY)).whenComplete((r, err) -> {
            HRegionLocation hrl;
            if (err != null) {
                future.completeExceptionally((Throwable)err);
                return;
            }
            RegionLocations locations = MetaTableAccessor.getRegionLocations(r);
            HRegionLocation hRegionLocation = locations == null ? null : (hrl = locations.getRegionLocation(finalHRI == null ? 0 : finalHRI.getReplicaId()));
            if (hrl == null) {
                future.complete(null);
            } else {
                future.complete(new Pair((Object)hrl.getRegionInfo(), (Object)hrl.getServerName()));
            }
        });
        return future;
    }

    private static Optional<TableState> getTableState(Result r) throws IOException {
        Cell cell = r.getColumnLatestCell(AsyncMetaTableAccessor.getTableFamily(), AsyncMetaTableAccessor.getStateColumn());
        if (cell == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(TableState.parseFrom(TableName.valueOf((byte[])r.getRow()), Arrays.copyOfRange(cell.getValueArray(), cell.getValueOffset(), cell.getValueOffset() + cell.getValueLength())));
        }
        catch (DeserializationException e) {
            throw new IOException("Failed to parse table state from result: " + r, e);
        }
    }

    public static CompletableFuture<List<Pair<HRegionInfo, ServerName>>> getTableRegionsAndLocations(RawAsyncTable metaTable, Optional<TableName> tableName) {
        return AsyncMetaTableAccessor.getTableRegionsAndLocations(metaTable, tableName, true);
    }

    public static CompletableFuture<List<Pair<HRegionInfo, ServerName>>> getTableRegionsAndLocations(RawAsyncTable metaTable, Optional<TableName> tableName, final boolean excludeOfflinedSplitParents) {
        CompletableFuture<List<Pair<HRegionInfo, ServerName>>> future = new CompletableFuture<List<Pair<HRegionInfo, ServerName>>>();
        if (tableName.filter(t -> t.equals((Object)TableName.META_TABLE_NAME)).isPresent()) {
            future.completeExceptionally(new IOException("This method can't be used to locate meta regions; use MetaTableLocator instead"));
        }
        MetaTableAccessor.CollectingVisitor<Pair<HRegionInfo, ServerName>> visitor = new MetaTableAccessor.CollectingVisitor<Pair<HRegionInfo, ServerName>>(){
            private Optional<RegionLocations> current = null;

            @Override
            public boolean visit(Result r) throws IOException {
                this.current = AsyncMetaTableAccessor.getRegionLocations(r);
                if (!this.current.isPresent() || this.current.get().getRegionLocation().getRegionInfo() == null) {
                    LOG.warn((Object)("No serialized HRegionInfo in " + r));
                    return true;
                }
                HRegionInfo hri = this.current.get().getRegionLocation().getRegionInfo();
                if (excludeOfflinedSplitParents && hri.isSplitParent()) {
                    return true;
                }
                return super.visit(r);
            }

            @Override
            void add(Result r) {
                if (!this.current.isPresent()) {
                    return;
                }
                for (HRegionLocation loc : this.current.get().getRegionLocations()) {
                    if (loc == null) continue;
                    this.results.add(new Pair((Object)loc.getRegionInfo(), (Object)loc.getServerName()));
                }
            }
        };
        AsyncMetaTableAccessor.scanMeta(metaTable, tableName, MetaTableAccessor.QueryType.REGION, visitor).whenComplete((v, error) -> {
            if (error != null) {
                future.completeExceptionally((Throwable)error);
                return;
            }
            future.complete(visitor.getResults());
        });
        return future;
    }

    private static CompletableFuture<Void> scanMeta(RawAsyncTable metaTable, Optional<TableName> tableName, MetaTableAccessor.QueryType type, MetaTableAccessor.Visitor visitor) {
        return AsyncMetaTableAccessor.scanMeta(metaTable, AsyncMetaTableAccessor.getTableStartRowForMeta(tableName, type), AsyncMetaTableAccessor.getTableStopRowForMeta(tableName, type), type, Integer.MAX_VALUE, visitor);
    }

    private static CompletableFuture<Void> scanMeta(RawAsyncTable metaTable, Optional<byte[]> startRow, Optional<byte[]> stopRow, MetaTableAccessor.QueryType type, int maxRows, MetaTableAccessor.Visitor visitor) {
        int rowUpperLimit = maxRows > 0 ? maxRows : Integer.MAX_VALUE;
        Scan scan = AsyncMetaTableAccessor.getMetaScan(metaTable, rowUpperLimit);
        for (byte[] family : type.getFamilies()) {
            scan.addFamily(family);
        }
        startRow.ifPresent(scan::withStartRow);
        stopRow.ifPresent(scan::withStopRow);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Scanning META starting at row=" + Bytes.toStringBinary((byte[])scan.getStartRow()) + " stopping at row=" + Bytes.toStringBinary((byte[])scan.getStopRow()) + " for max=" + rowUpperLimit + " with caching=" + scan.getCaching()));
        }
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        metaTable.scan(scan, new MetaTableRawScanResultConsumer(rowUpperLimit, visitor, future));
        return future;
    }

    private static Scan getMetaScan(RawAsyncTable metaTable, int rowUpperLimit) {
        Scan scan = new Scan();
        int scannerCaching = metaTable.getConfiguration().getInt("hbase.meta.scanner.caching", 100);
        if (metaTable.getConfiguration().getBoolean("hbase.meta.replicas.use", false)) {
            scan.setConsistency(Consistency.TIMELINE);
        }
        if (rowUpperLimit <= scannerCaching) {
            scan.setLimit(rowUpperLimit);
        }
        int rows = Math.min(rowUpperLimit, scannerCaching);
        scan.setCaching(rows);
        return scan;
    }

    private static Optional<RegionLocations> getRegionLocations(Result r) {
        Map.Entry entry;
        if (r == null) {
            return Optional.empty();
        }
        Optional<HRegionInfo> regionInfo = AsyncMetaTableAccessor.getHRegionInfo(r, AsyncMetaTableAccessor.getRegionInfoColumn());
        if (!regionInfo.isPresent()) {
            return Optional.empty();
        }
        ArrayList<HRegionLocation> locations = new ArrayList<HRegionLocation>(1);
        NavigableMap<byte[], NavigableMap<byte[], byte[]>> familyMap = r.getNoVersionMap();
        locations.add(AsyncMetaTableAccessor.getRegionLocation(r, regionInfo.get(), 0));
        NavigableMap infoMap = (NavigableMap)familyMap.get(AsyncMetaTableAccessor.getCatalogFamily());
        if (infoMap == null) {
            return Optional.of(new RegionLocations(locations));
        }
        int replicaId = 0;
        byte[] serverColumn = AsyncMetaTableAccessor.getServerColumn(replicaId);
        NavigableMap serverMap = null;
        serverMap = infoMap.tailMap(serverColumn, false);
        if (serverMap.isEmpty()) {
            return Optional.of(new RegionLocations(locations));
        }
        Iterator iterator = serverMap.entrySet().iterator();
        while (iterator.hasNext() && (replicaId = AsyncMetaTableAccessor.parseReplicaIdFromServerColumn((byte[])(entry = iterator.next()).getKey())) >= 0) {
            HRegionLocation location = AsyncMetaTableAccessor.getRegionLocation(r, regionInfo.get(), replicaId);
            if (location == null || location.getServerName() == null) {
                locations.add(null);
                continue;
            }
            locations.add(location);
        }
        return Optional.of(new RegionLocations(locations));
    }

    private static HRegionLocation getRegionLocation(Result r, HRegionInfo regionInfo, int replicaId) {
        Optional<ServerName> serverName = AsyncMetaTableAccessor.getServerName(r, replicaId);
        long seqNum = AsyncMetaTableAccessor.getSeqNumDuringOpen(r, replicaId);
        HRegionInfo replicaInfo = RegionReplicaUtil.getRegionInfoForReplica(regionInfo, replicaId);
        return new HRegionLocation(replicaInfo, serverName.orElse(null), seqNum);
    }

    private static Optional<ServerName> getServerName(Result r, int replicaId) {
        byte[] serverColumn = AsyncMetaTableAccessor.getServerColumn(replicaId);
        Cell cell = r.getColumnLatestCell(AsyncMetaTableAccessor.getCatalogFamily(), serverColumn);
        if (cell == null || cell.getValueLength() == 0) {
            return Optional.empty();
        }
        String hostAndPort = Bytes.toString((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength());
        byte[] startcodeColumn = AsyncMetaTableAccessor.getStartCodeColumn(replicaId);
        cell = r.getColumnLatestCell(AsyncMetaTableAccessor.getCatalogFamily(), startcodeColumn);
        if (cell == null || cell.getValueLength() == 0) {
            return Optional.empty();
        }
        try {
            return Optional.of(ServerName.valueOf((String)hostAndPort, (long)Bytes.toLong((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength())));
        }
        catch (IllegalArgumentException e) {
            LOG.error((Object)("Ignoring invalid region for server " + hostAndPort + "; cell=" + cell), (Throwable)e);
            return Optional.empty();
        }
    }

    private static long getSeqNumDuringOpen(Result r, int replicaId) {
        Cell cell = r.getColumnLatestCell(AsyncMetaTableAccessor.getCatalogFamily(), AsyncMetaTableAccessor.getSeqNumColumn(replicaId));
        if (cell == null || cell.getValueLength() == 0) {
            return -1L;
        }
        return Bytes.toLong((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength());
    }

    private static Optional<byte[]> getTableStartRowForMeta(Optional<TableName> tableName, MetaTableAccessor.QueryType type) {
        return tableName.map(table -> {
            switch (type) {
                case REGION: {
                    byte[] startRow = new byte[table.getName().length + 2];
                    System.arraycopy(table.getName(), 0, startRow, 0, table.getName().length);
                    startRow[startRow.length - 2] = 44;
                    startRow[startRow.length - 1] = 44;
                    return startRow;
                }
            }
            return table.getName();
        });
    }

    private static Optional<byte[]> getTableStopRowForMeta(Optional<TableName> tableName, MetaTableAccessor.QueryType type) {
        return tableName.map(table -> {
            byte[] stopRow;
            switch (type) {
                case REGION: {
                    stopRow = new byte[table.getName().length + 3];
                    System.arraycopy(table.getName(), 0, stopRow, 0, table.getName().length);
                    stopRow[stopRow.length - 3] = 32;
                    stopRow[stopRow.length - 2] = 44;
                    stopRow[stopRow.length - 1] = 44;
                    break;
                }
                default: {
                    stopRow = new byte[table.getName().length + 1];
                    System.arraycopy(table.getName(), 0, stopRow, 0, table.getName().length);
                    stopRow[stopRow.length - 1] = 32;
                }
            }
            return stopRow;
        });
    }

    private static Optional<HRegionInfo> getHRegionInfo(Result r, byte[] qualifier) {
        Cell cell = r.getColumnLatestCell(AsyncMetaTableAccessor.getCatalogFamily(), qualifier);
        if (cell == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(HRegionInfo.parseFromOrNull(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength()));
    }

    private static byte[] getCatalogFamily() {
        return HConstants.CATALOG_FAMILY;
    }

    private static byte[] getTableFamily() {
        return HConstants.TABLE_FAMILY;
    }

    private static byte[] getRegionInfoColumn() {
        return HConstants.REGIONINFO_QUALIFIER;
    }

    private static byte[] getStateColumn() {
        return HConstants.TABLE_STATE_QUALIFIER;
    }

    private static byte[] getServerColumn(int replicaId) {
        return replicaId == 0 ? HConstants.SERVER_QUALIFIER : Bytes.toBytes((String)("server_" + String.format("%04X", replicaId)));
    }

    private static byte[] getStartCodeColumn(int replicaId) {
        return replicaId == 0 ? HConstants.STARTCODE_QUALIFIER : Bytes.toBytes((String)("serverstartcode_" + String.format("%04X", replicaId)));
    }

    private static byte[] getSeqNumColumn(int replicaId) {
        return replicaId == 0 ? HConstants.SEQNUM_QUALIFIER : Bytes.toBytes((String)("seqnumDuringOpen_" + String.format("%04X", replicaId)));
    }

    private static int parseReplicaIdFromServerColumn(byte[] serverColumn) {
        String serverStr = Bytes.toString((byte[])serverColumn);
        Matcher matcher = SERVER_COLUMN_PATTERN.matcher(serverStr);
        if (matcher.matches() && matcher.groupCount() > 0) {
            String group = matcher.group(1);
            if (group != null && group.length() > 0) {
                return Integer.parseInt(group.substring(1), 16);
            }
            return 0;
        }
        return -1;
    }

    private static final class MetaTableRawScanResultConsumer
    implements RawScanResultConsumer {
        private int currentRowCount;
        private final int rowUpperLimit;
        private final MetaTableAccessor.Visitor visitor;
        private final CompletableFuture<Void> future;

        MetaTableRawScanResultConsumer(int rowUpperLimit, MetaTableAccessor.Visitor visitor, CompletableFuture<Void> future) {
            this.rowUpperLimit = rowUpperLimit;
            this.visitor = visitor;
            this.future = future;
            this.currentRowCount = 0;
        }

        @Override
        public void onError(Throwable error) {
            this.future.completeExceptionally(error);
        }

        @Override
        @SuppressWarnings(value={"NP_NONNULL_PARAM_VIOLATION"}, justification="https://github.com/findbugsproject/findbugs/issues/79")
        public void onComplete() {
            this.future.complete(null);
        }

        @Override
        public void onNext(Result[] results, RawScanResultConsumer.ScanController controller) {
            for (Result result : results) {
                try {
                    if (!this.visitor.visit(result)) {
                        controller.terminate();
                    }
                }
                catch (IOException e) {
                    this.future.completeExceptionally(e);
                    controller.terminate();
                }
                if (++this.currentRowCount < this.rowUpperLimit) continue;
                controller.terminate();
            }
        }
    }
}

