/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import com.google.protobuf.TextFormat;
import java.io.IOException;
import java.net.UnknownHostException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.RemoteExceptionHandler;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.UnknownScannerException;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.RegionServerCallable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.metrics.ScanMetrics;
import org.apache.hadoop.hbase.ipc.PayloadCarryingRpcController;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.RequestConverter;
import org.apache.hadoop.hbase.protobuf.ResponseConverter;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.regionserver.RegionServerStoppedException;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.net.DNS;

@InterfaceAudience.Private
public class ScannerCallable
extends RegionServerCallable<Result[]> {
    public static final String LOG_SCANNER_LATENCY_CUTOFF = "hbase.client.log.scanner.latency.cutoff";
    public static final String LOG_SCANNER_ACTIVITY = "hbase.client.log.scanner.activity";
    public static final Log LOG = LogFactory.getLog(ScannerCallable.class);
    private long scannerId = -1L;
    private boolean instantiated = false;
    private boolean closed = false;
    private Scan scan;
    private int caching = 1;
    private ScanMetrics scanMetrics;
    private boolean logScannerActivity = false;
    private int logCutOffLatency = 1000;
    private static String myAddress;
    private boolean isRegionServerRemote = true;
    private long nextCallSeq = 0L;

    public ScannerCallable(HConnection connection, TableName tableName, Scan scan, ScanMetrics scanMetrics) {
        super(connection, tableName, scan.getStartRow());
        this.scan = scan;
        this.scanMetrics = scanMetrics;
        Configuration conf = connection.getConfiguration();
        this.logScannerActivity = conf.getBoolean(LOG_SCANNER_ACTIVITY, false);
        this.logCutOffLatency = conf.getInt(LOG_SCANNER_LATENCY_CUTOFF, 1000);
    }

    @Deprecated
    public ScannerCallable(HConnection connection, byte[] tableName, Scan scan, ScanMetrics scanMetrics) {
        this(connection, TableName.valueOf((byte[])tableName), scan, scanMetrics);
    }

    @Override
    public void prepare(boolean reload) throws IOException {
        if (!this.instantiated || reload) {
            super.prepare(reload);
            this.checkIfRegionServerIsRemote();
            this.instantiated = true;
        }
        if (reload && this.scanMetrics != null) {
            this.scanMetrics.countOfRPCRetries.incrementAndGet();
            if (this.isRegionServerRemote) {
                this.scanMetrics.countOfRemoteRPCRetries.incrementAndGet();
            }
        }
    }

    private void checkIfRegionServerIsRemote() {
        this.isRegionServerRemote = !this.getLocation().getHostname().equalsIgnoreCase(myAddress);
    }

    @Override
    public Result[] call() throws IOException {
        if (this.closed) {
            if (this.scannerId != -1L) {
                this.close();
            }
        } else if (this.scannerId == -1L) {
            this.scannerId = this.openScanner();
        } else {
            Result[] rrs = null;
            ClientProtos.ScanRequest request = null;
            try {
                this.incRPCcallsMetrics();
                request = RequestConverter.buildScanRequest(this.scannerId, this.caching, false, this.nextCallSeq);
                ClientProtos.ScanResponse response = null;
                PayloadCarryingRpcController controller = new PayloadCarryingRpcController();
                try {
                    long now;
                    controller.setPriority(this.getTableName());
                    response = this.getStub().scan((RpcController)controller, request);
                    ++this.nextCallSeq;
                    long timestamp = System.currentTimeMillis();
                    CellScanner cellScanner = controller.cellScanner();
                    rrs = ResponseConverter.getResults(cellScanner, response);
                    if (this.logScannerActivity && (now = System.currentTimeMillis()) - timestamp > (long)this.logCutOffLatency) {
                        int rows = rrs == null ? 0 : rrs.length;
                        LOG.info((Object)("Took " + (now - timestamp) + "ms to fetch " + rows + " rows from scanner=" + this.scannerId));
                    }
                    if (response.hasMoreResults() && !response.getMoreResults()) {
                        this.scannerId = -1L;
                        this.closed = true;
                        return null;
                    }
                }
                catch (ServiceException se) {
                    throw ProtobufUtil.getRemoteException(se);
                }
                this.updateResultsMetrics(rrs);
            }
            catch (IOException e) {
                if (this.logScannerActivity) {
                    LOG.info((Object)("Got exception making request " + TextFormat.shortDebugString((MessageOrBuilder)request) + " to " + this.getLocation()), (Throwable)e);
                }
                IOException ioe = e;
                if (e instanceof RemoteException) {
                    ioe = RemoteExceptionHandler.decodeRemoteException((RemoteException)((Object)e));
                }
                if (this.logScannerActivity && ioe instanceof UnknownScannerException) {
                    try {
                        HRegionLocation location = this.getConnection().relocateRegion(this.getTableName(), this.scan.getStartRow());
                        LOG.info((Object)("Scanner=" + this.scannerId + " expired, current region location is " + location.toString()));
                    }
                    catch (Throwable t) {
                        LOG.info((Object)"Failed to relocate region", t);
                    }
                }
                if (ioe instanceof NotServingRegionException) {
                    if (this.scanMetrics != null) {
                        this.scanMetrics.countOfNSRE.incrementAndGet();
                    }
                    throw new DoNotRetryIOException("Resetting the scanner -- see exception cause", ioe);
                }
                if (ioe instanceof RegionServerStoppedException) {
                    throw new DoNotRetryIOException("Resetting the scanner -- see exception cause", ioe);
                }
                throw ioe;
            }
            return rrs;
        }
        return null;
    }

    private void incRPCcallsMetrics() {
        if (this.scanMetrics == null) {
            return;
        }
        this.scanMetrics.countOfRPCcalls.incrementAndGet();
        if (this.isRegionServerRemote) {
            this.scanMetrics.countOfRemoteRPCcalls.incrementAndGet();
        }
    }

    private void updateResultsMetrics(Result[] rrs) {
        if (this.scanMetrics == null || rrs == null || rrs.length == 0) {
            return;
        }
        long resultSize = 0L;
        for (Result rr : rrs) {
            for (Cell kv : rr.rawCells()) {
                resultSize += (long)KeyValueUtil.ensureKeyValue((Cell)kv).getLength();
            }
        }
        this.scanMetrics.countOfBytesInResults.addAndGet(resultSize);
        if (this.isRegionServerRemote) {
            this.scanMetrics.countOfBytesInRemoteResults.addAndGet(resultSize);
        }
    }

    private void close() {
        if (this.scannerId == -1L) {
            return;
        }
        try {
            this.incRPCcallsMetrics();
            ClientProtos.ScanRequest request = RequestConverter.buildScanRequest(this.scannerId, 0, true);
            try {
                this.getStub().scan(null, request);
            }
            catch (ServiceException se) {
                throw ProtobufUtil.getRemoteException(se);
            }
        }
        catch (IOException e) {
            LOG.warn((Object)"Ignore, probably already closed", (Throwable)e);
        }
        this.scannerId = -1L;
    }

    protected long openScanner() throws IOException {
        this.incRPCcallsMetrics();
        ClientProtos.ScanRequest request = RequestConverter.buildScanRequest(this.getLocation().getRegionInfo().getRegionName(), this.scan, 0, false);
        try {
            ClientProtos.ScanResponse response = this.getStub().scan(null, request);
            long id = response.getScannerId();
            if (this.logScannerActivity) {
                LOG.info((Object)("Open scanner=" + id + " for scan=" + this.scan.toString() + " on region " + this.getLocation().toString()));
            }
            return id;
        }
        catch (ServiceException se) {
            throw ProtobufUtil.getRemoteException(se);
        }
    }

    protected Scan getScan() {
        return this.scan;
    }

    public void setClose() {
        this.closed = true;
    }

    @Override
    public HRegionInfo getHRegionInfo() {
        if (!this.instantiated) {
            return null;
        }
        return this.getLocation().getRegionInfo();
    }

    public int getCaching() {
        return this.caching;
    }

    public void setCaching(int caching) {
        this.caching = caching;
    }

    static {
        try {
            myAddress = DNS.getDefaultHost((String)"default", (String)"default");
        }
        catch (UnknownHostException uhe) {
            LOG.error((Object)"cannot determine my address", (Throwable)uhe);
        }
    }
}

