/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.protobuf.ServiceException;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.client.RetryingCallable;
import org.apache.hadoop.hbase.ipc.RpcClient;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.ipc.RemoteException;

@InterfaceAudience.Private
@SuppressWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="na")
public class RpcRetryingCaller<T> {
    static final Log LOG = LogFactory.getLog(RpcRetryingCaller.class);
    private int callTimeout;
    private long globalStartTime;
    private static final int MIN_RPC_TIMEOUT = 2000;
    private final long pause;
    private final int retries;

    public RpcRetryingCaller(Configuration conf) {
        this.pause = conf.getLong(HConstants.HBASE_CLIENT_PAUSE, HConstants.DEFAULT_HBASE_CLIENT_PAUSE);
        this.retries = conf.getInt(HConstants.HBASE_CLIENT_RETRIES_NUMBER, HConstants.DEFAULT_HBASE_CLIENT_RETRIES_NUMBER);
        this.callTimeout = conf.getInt("hbase.client.operation.timeout", Integer.MAX_VALUE);
    }

    private void beforeCall() {
        int remaining = (int)((long)this.callTimeout - (EnvironmentEdgeManager.currentTimeMillis() - this.globalStartTime));
        if (remaining < 2000) {
            remaining = 2000;
        }
        RpcClient.setRpcTimeout(remaining);
    }

    private void afterCall() {
        RpcClient.resetRpcTimeout();
    }

    public synchronized T callWithRetries(RetryingCallable<T> callable) throws IOException, RuntimeException {
        return this.callWithRetries(callable, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"SWL_SLEEP_WITH_LOCK_HELD"}, justification="na")
    public synchronized T callWithRetries(RetryingCallable<T> callable, int callTimeout) throws IOException, RuntimeException {
        this.callTimeout = callTimeout;
        ArrayList<RetriesExhaustedException.ThrowableWithExtraContext> exceptions = new ArrayList<RetriesExhaustedException.ThrowableWithExtraContext>();
        this.globalStartTime = EnvironmentEdgeManager.currentTimeMillis();
        int tries = 0;
        while (true) {
            long expectedSleep = 0L;
            try {
                this.beforeCall();
                callable.prepare(tries != 0);
                Object v = callable.call();
                return (T)v;
            }
            catch (Throwable t) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Call exception, tries=" + tries + ", retries=" + this.retries + ", retryTime=" + (EnvironmentEdgeManager.currentTimeMillis() - this.globalStartTime) + "ms"), t);
                }
                t = RpcRetryingCaller.translateException(t);
                callable.throwable(t, this.retries != 1);
                RetriesExhaustedException.ThrowableWithExtraContext qt = new RetriesExhaustedException.ThrowableWithExtraContext(t, EnvironmentEdgeManager.currentTimeMillis(), this.toString());
                exceptions.add(qt);
                if (tries >= this.retries - 1) {
                    throw new RetriesExhaustedException(tries, exceptions);
                }
                expectedSleep = callable.sleep(this.pause, tries + 1);
                long duration = this.singleCallDuration(expectedSleep);
                if (duration > (long)this.callTimeout) {
                    String msg = "callTimeout=" + this.callTimeout + ", callDuration=" + duration + ": " + callable.getExceptionMessageAdditionalDetail();
                    throw (SocketTimeoutException)new SocketTimeoutException(msg).initCause(t);
                }
            }
            finally {
                this.afterCall();
            }
            try {
                Thread.sleep(expectedSleep);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new InterruptedIOException("Interrupted after " + tries + " tries  on " + this.retries);
            }
            ++tries;
        }
    }

    private long singleCallDuration(long expectedSleep) {
        return EnvironmentEdgeManager.currentTimeMillis() - this.globalStartTime + 2000L + expectedSleep;
    }

    public T callWithoutRetries(RetryingCallable<T> callable) throws IOException, RuntimeException {
        this.globalStartTime = EnvironmentEdgeManager.currentTimeMillis();
        try {
            this.beforeCall();
            callable.prepare(false);
            Object v = callable.call();
            return (T)v;
        }
        catch (Throwable t) {
            Throwable t2 = RpcRetryingCaller.translateException(t);
            if (t2 instanceof IOException) {
                throw (IOException)t2;
            }
            throw new RuntimeException(t2);
        }
        finally {
            this.afterCall();
        }
    }

    static Throwable translateException(Throwable t) throws DoNotRetryIOException {
        if (t instanceof UndeclaredThrowableException && t.getCause() != null) {
            t = t.getCause();
        }
        if (t instanceof RemoteException) {
            t = ((RemoteException)t).unwrapRemoteException();
        }
        if (t instanceof LinkageError) {
            throw new DoNotRetryIOException(t);
        }
        if (t instanceof ServiceException) {
            ServiceException se = (ServiceException)t;
            Throwable cause = se.getCause();
            if (cause != null && cause instanceof DoNotRetryIOException) {
                throw (DoNotRetryIOException)((Object)cause);
            }
            t = cause;
            RpcRetryingCaller.translateException(t);
        } else if (t instanceof DoNotRetryIOException) {
            throw (DoNotRetryIOException)((Object)t);
        }
        return t;
    }
}

