/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ClientScanner;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.RegionServerCallable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.ipc.PayloadCarryingRpcController;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.RequestConverter;
import org.apache.hadoop.hbase.protobuf.ResponseConverter;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class ClientSmallScanner
extends ClientScanner {
    private final Log LOG = LogFactory.getLog(this.getClass());
    private RegionServerCallable<Result[]> smallScanCallable = null;
    private byte[] skipRowOfFirstResult = null;

    public ClientSmallScanner(Configuration conf, Scan scan, TableName tableName) throws IOException {
        this(conf, scan, tableName, HConnectionManager.getConnection(conf));
    }

    public ClientSmallScanner(Configuration conf, Scan scan, TableName tableName, HConnection connection) throws IOException {
        this(conf, scan, tableName, connection, new RpcRetryingCallerFactory(conf));
    }

    public ClientSmallScanner(Configuration conf, Scan scan, TableName tableName, HConnection connection, RpcRetryingCallerFactory rpcFactory) throws IOException {
        super(conf, scan, tableName, connection, rpcFactory);
    }

    @Override
    protected void initializeScannerInConstruction() throws IOException {
    }

    private boolean nextScanner(int nbRows, boolean done, boolean currentRegionDone) throws IOException {
        byte[] localStartKey;
        int cacheNum = nbRows;
        this.skipRowOfFirstResult = null;
        if (this.currentRegion != null && currentRegionDone) {
            byte[] endKey = this.currentRegion.getEndKey();
            if (endKey == null || Bytes.equals((byte[])endKey, (byte[])HConstants.EMPTY_BYTE_ARRAY) || this.checkScanStopRow(endKey) || done) {
                this.close();
                if (this.LOG.isDebugEnabled()) {
                    this.LOG.debug((Object)("Finished scan of " + this.currentRegion));
                }
                return false;
            }
            localStartKey = endKey;
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug((Object)("Finished with " + this.currentRegion));
            }
        } else if (this.lastResult != null) {
            localStartKey = this.lastResult.getRow();
            this.skipRowOfFirstResult = this.lastResult.getRow();
            ++cacheNum;
        } else {
            localStartKey = this.scan.getStartRow();
        }
        if (this.LOG.isTraceEnabled()) {
            this.LOG.trace((Object)("Advancing to startKey at '" + Bytes.toStringBinary((byte[])localStartKey) + "'"));
        }
        this.smallScanCallable = this.getSmallScanCallable(localStartKey, cacheNum);
        if (this.scanMetrics != null && this.skipRowOfFirstResult == null) {
            this.scanMetrics.countOfRegions.incrementAndGet();
        }
        return true;
    }

    private RegionServerCallable<Result[]> getSmallScanCallable(byte[] localStartKey, final int cacheNum) {
        this.scan.setStartRow(localStartKey);
        RegionServerCallable<Result[]> callable = new RegionServerCallable<Result[]>(this.getConnection(), this.getTable(), this.scan.getStartRow()){

            @Override
            public Result[] call() throws IOException {
                ClientProtos.ScanRequest request = RequestConverter.buildScanRequest(this.getLocation().getRegionInfo().getRegionName(), ClientSmallScanner.this.scan, cacheNum, true);
                ClientProtos.ScanResponse response = null;
                PayloadCarryingRpcController controller = new PayloadCarryingRpcController();
                try {
                    controller.setPriority(this.getTableName());
                    response = this.getStub().scan((RpcController)controller, request);
                    return ResponseConverter.getResults(controller.cellScanner(), response);
                }
                catch (ServiceException se) {
                    throw ProtobufUtil.getRemoteException(se);
                }
            }
        };
        return callable;
    }

    @Override
    public Result next() throws IOException {
        if (this.cache.size() == 0 && this.closed) {
            return null;
        }
        if (this.cache.size() == 0) {
            Result[] values = null;
            long remainingResultSize = this.maxScannerResultSize;
            int countdown = this.caching;
            boolean currentRegionDone = false;
            while (remainingResultSize > 0L && countdown > 0 && this.nextScanner(countdown, values == null, currentRegionDone)) {
                values = this.caller.callWithRetries(this.smallScanCallable);
                this.currentRegion = this.smallScanCallable.getHRegionInfo();
                long currentTime = System.currentTimeMillis();
                if (this.scanMetrics != null) {
                    this.scanMetrics.sumOfMillisSecBetweenNexts.addAndGet(currentTime - this.lastNext);
                }
                this.lastNext = currentTime;
                if (values != null && values.length > 0) {
                    for (int i = 0; i < values.length; ++i) {
                        Result rs = values[i];
                        if (i == 0 && this.skipRowOfFirstResult != null && Bytes.equals((byte[])this.skipRowOfFirstResult, (byte[])rs.getRow())) continue;
                        this.cache.add(rs);
                        for (Cell kv : rs.rawCells()) {
                            remainingResultSize -= KeyValueUtil.ensureKeyValue((Cell)kv).heapSize();
                        }
                        --countdown;
                        this.lastResult = rs;
                    }
                }
                currentRegionDone = countdown > 0;
            }
        }
        if (this.cache.size() > 0) {
            return (Result)this.cache.poll();
        }
        this.writeScanMetrics();
        return null;
    }

    @Override
    public void close() {
        if (!this.scanMetricsPublished) {
            this.writeScanMetrics();
        }
        this.closed = true;
    }
}

