/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.asyncfs;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseCommonTestingUtility;
import org.apache.hadoop.hbase.trace.TraceUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.metrics2.impl.MetricsSystemImpl;
import org.apache.hadoop.metrics2.util.MBeans;
import org.apache.log4j.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AsyncFSTestBase {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncFSTestBase.class);
    protected static final HBaseCommonTestingUtility UTIL = new HBaseCommonTestingUtility();
    protected static File CLUSTER_TEST_DIR;
    protected static MiniDFSCluster CLUSTER;

    private static boolean deleteOnExit() {
        String v = System.getProperty("hbase.testing.preserve.testdir");
        return v == null ? true : !Boolean.parseBoolean(v);
    }

    protected static void setupClusterTestDir() {
        Path testDir = UTIL.getDataTestDir("cluster_" + HBaseCommonTestingUtility.getRandomUUID().toString());
        CLUSTER_TEST_DIR = new File(testDir.toString()).getAbsoluteFile();
        boolean b = AsyncFSTestBase.deleteOnExit();
        if (b) {
            CLUSTER_TEST_DIR.deleteOnExit();
        }
        LOG.info("Created new mini-cluster data directory: {}, deleteOnExit={}", (Object)CLUSTER_TEST_DIR, (Object)b);
    }

    private static String createDirAndSetProperty(String property) {
        return AsyncFSTestBase.createDirAndSetProperty(property, property);
    }

    private static String createDirAndSetProperty(String relPath, String property) {
        String path = UTIL.getDataTestDir(relPath).toString();
        System.setProperty(property, path);
        UTIL.getConfiguration().set(property, path);
        new File(path).mkdirs();
        LOG.info("Setting " + property + " to " + path + " in system properties and HBase conf");
        return path;
    }

    private static void createDirsAndSetProperties() throws IOException {
        AsyncFSTestBase.setupClusterTestDir();
        System.setProperty("test.build.data", CLUSTER_TEST_DIR.getPath());
        AsyncFSTestBase.createDirAndSetProperty("test.cache.data");
        AsyncFSTestBase.createDirAndSetProperty("hadoop.tmp.dir");
        AsyncFSTestBase.createDirAndSetProperty("dfs.journalnode.edits.dir");
        AsyncFSTestBase.createDirAndSetProperty("dfs.datanode.shared.file.descriptor.paths");
        AsyncFSTestBase.createDirAndSetProperty("nfs.dump.dir");
        AsyncFSTestBase.createDirAndSetProperty("java.io.tmpdir");
        AsyncFSTestBase.createDirAndSetProperty("dfs.journalnode.edits.dir");
        AsyncFSTestBase.createDirAndSetProperty("dfs.provided.aliasmap.inmemory.leveldb.dir");
        AsyncFSTestBase.createDirAndSetProperty("fs.s3a.committer.staging.tmp.path");
    }

    protected static void startMiniDFSCluster(int servers) throws IOException {
        if (CLUSTER != null) {
            throw new IllegalStateException("Already started");
        }
        AsyncFSTestBase.createDirsAndSetProperties();
        Configuration conf = UTIL.getConfiguration();
        org.apache.log4j.Logger.getLogger(MBeans.class).setLevel(Level.ERROR);
        org.apache.log4j.Logger.getLogger(MetricsSystemImpl.class).setLevel(Level.ERROR);
        TraceUtil.initTracer((Configuration)conf);
        CLUSTER = new MiniDFSCluster.Builder(conf).numDataNodes(servers).build();
        CLUSTER.waitClusterUp();
    }

    protected static void shutdownMiniDFSCluster() {
        if (CLUSTER != null) {
            CLUSTER.shutdown(true);
            CLUSTER = null;
        }
    }
}

