/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.thirdparty.com.google.common.util.concurrent;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.thirdparty.com.google.common.annotations.GwtCompatible;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.apache.hadoop.thirdparty.com.google.common.util.concurrent.AbstractFuture;
import org.jspecify.annotations.Nullable;

@GwtCompatible(emulated=true)
final class Platform {
    static boolean isInstanceOfThrowableClass(@Nullable Throwable t2, Class<? extends Throwable> expectedClass) {
        return expectedClass.isInstance(t2);
    }

    static void restoreInterruptIfIsInterruptedException(Throwable t2) {
        Preconditions.checkNotNull(t2);
        if (t2 instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    static void interruptCurrentThread() {
        Thread.currentThread().interrupt();
    }

    static void rethrowIfErrorOtherThanStackOverflow(Throwable t2) {
        Preconditions.checkNotNull(t2);
        if (t2 instanceof Error && !(t2 instanceof StackOverflowError)) {
            throw (Error)t2;
        }
    }

    static <V> V get(AbstractFuture<V> future) throws InterruptedException, ExecutionException {
        return future.blockingGet();
    }

    static <V> V get(AbstractFuture<V> future, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return future.blockingGet(timeout, unit);
    }

    private Platform() {
    }
}

