/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.reader;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandler;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.client.urlconnection.HttpURLConnectionFactory;
import com.sun.jersey.client.urlconnection.URLConnectionClientHandler;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.Set;
import javax.ws.rs.core.MediaType;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.timeline.TimelineAbout;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntityType;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineReaderServer;
import org.apache.hadoop.yarn.server.timelineservice.storage.FileSystemTimelineReaderImpl;
import org.apache.hadoop.yarn.server.timelineservice.storage.TestFileSystemTimelineReaderImpl;
import org.apache.hadoop.yarn.server.timelineservice.storage.TimelineReader;
import org.apache.hadoop.yarn.webapp.YarnJacksonJaxbJsonProvider;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestTimelineReaderWebServices {
    private static final String ROOT_DIR = new File("target", TestTimelineReaderWebServices.class.getSimpleName()).getAbsolutePath();
    private int serverPort;
    private TimelineReaderServer server;

    @BeforeClass
    public static void setup() throws Exception {
        TestFileSystemTimelineReaderImpl.initializeDataDirectory(ROOT_DIR);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        FileUtils.deleteDirectory((File)new File(ROOT_DIR));
    }

    @Before
    public void init() throws Exception {
        try {
            YarnConfiguration config = new YarnConfiguration();
            config.setBoolean("yarn.timeline-service.enabled", true);
            config.setFloat("yarn.timeline-service.version", 2.0f);
            config.set("yarn.timeline-service.reader.webapp.address", "localhost:0");
            config.set("yarn.resourcemanager.cluster-id", "cluster1");
            config.setClass("yarn.timeline-service.reader.class", FileSystemTimelineReaderImpl.class, TimelineReader.class);
            config.set("yarn.timeline-service.fs-writer.root-dir", ROOT_DIR);
            this.server = new TimelineReaderServer();
            this.server.init((Configuration)config);
            this.server.start();
            this.serverPort = this.server.getWebServerPort();
        }
        catch (Exception e) {
            Assert.fail((String)"Web server failed to start");
        }
    }

    @After
    public void stop() throws Exception {
        if (this.server != null) {
            this.server.stop();
            this.server = null;
        }
    }

    private static TimelineEntity newEntity(String type, String id) {
        TimelineEntity entity = new TimelineEntity();
        entity.setIdentifier(new TimelineEntity.Identifier(type, id));
        return entity;
    }

    private static void verifyHttpResponse(Client client, URI uri, ClientResponse.Status expectedStatus) {
        ClientResponse resp = (ClientResponse)((WebResource.Builder)client.resource(uri).accept(new String[]{"application/json"}).type("application/json")).get(ClientResponse.class);
        Assert.assertNotNull((Object)resp);
        Assert.assertEquals((long)resp.getStatusInfo().getStatusCode(), (long)expectedStatus.getStatusCode());
    }

    private static Client createClient() {
        DefaultClientConfig cfg = new DefaultClientConfig();
        cfg.getClasses().add(YarnJacksonJaxbJsonProvider.class);
        return new Client((ClientHandler)new URLConnectionClientHandler((HttpURLConnectionFactory)new DummyURLConnectionFactory()), (ClientConfig)cfg);
    }

    private static ClientResponse getResponse(Client client, URI uri) throws Exception {
        ClientResponse resp = (ClientResponse)((WebResource.Builder)client.resource(uri).accept(new String[]{"application/json"}).type("application/json")).get(ClientResponse.class);
        if (resp == null || resp.getStatusInfo().getStatusCode() != ClientResponse.Status.OK.getStatusCode()) {
            String msg = new String();
            if (resp != null) {
                msg = String.valueOf(resp.getStatusInfo().getStatusCode());
            }
            throw new IOException("Incorrect response from timeline reader. Status=" + msg);
        }
        return resp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAbout() throws Exception {
        URI uri = URI.create("http://localhost:" + this.serverPort + "/ws/v2/timeline/");
        Client client = TestTimelineReaderWebServices.createClient();
        try {
            ClientResponse resp = TestTimelineReaderWebServices.getResponse(client, uri);
            TimelineAbout about = (TimelineAbout)resp.getEntity(TimelineAbout.class);
            Assert.assertNotNull((Object)about);
            Assert.assertEquals((Object)"Timeline Reader API", (Object)about.getAbout());
        }
        finally {
            client.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetEntityDefaultView() throws Exception {
        Client client = TestTimelineReaderWebServices.createClient();
        try {
            URI uri = URI.create("http://localhost:" + this.serverPort + "/ws/v2/timeline/clusters/cluster1/apps/app1/entities/app/id_1");
            ClientResponse resp = TestTimelineReaderWebServices.getResponse(client, uri);
            TimelineEntity entity = (TimelineEntity)resp.getEntity(TimelineEntity.class);
            Assert.assertEquals((Object)"application/json; charset=utf-8", (Object)resp.getType().toString());
            Assert.assertNotNull((Object)entity);
            Assert.assertEquals((Object)"id_1", (Object)entity.getId());
            Assert.assertEquals((Object)"app", (Object)entity.getType());
            Assert.assertEquals((Object)1425016502000L, (Object)entity.getCreatedTime());
            Assert.assertEquals((long)0L, (long)entity.getConfigs().size());
            Assert.assertEquals((long)0L, (long)entity.getMetrics().size());
        }
        finally {
            client.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetEntityWithUserAndFlowInfo() throws Exception {
        Client client = TestTimelineReaderWebServices.createClient();
        try {
            URI uri = URI.create("http://localhost:" + this.serverPort + "/ws/v2/timeline/clusters/cluster1/apps/app1/entities/app/id_1?userid=user1&flowname=flow1&flowrunid=1");
            ClientResponse resp = TestTimelineReaderWebServices.getResponse(client, uri);
            TimelineEntity entity = (TimelineEntity)resp.getEntity(TimelineEntity.class);
            Assert.assertEquals((Object)"application/json; charset=utf-8", (Object)resp.getType().toString());
            Assert.assertNotNull((Object)entity);
            Assert.assertEquals((Object)"id_1", (Object)entity.getId());
            Assert.assertEquals((Object)"app", (Object)entity.getType());
            Assert.assertEquals((Object)1425016502000L, (Object)entity.getCreatedTime());
        }
        finally {
            client.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetEntityCustomFields() throws Exception {
        Client client = TestTimelineReaderWebServices.createClient();
        try {
            URI uri = URI.create("http://localhost:" + this.serverPort + "/ws/v2/timeline/clusters/cluster1/apps/app1/entities/app/id_1?fields=CONFIGS,Metrics,info");
            ClientResponse resp = TestTimelineReaderWebServices.getResponse(client, uri);
            TimelineEntity entity = (TimelineEntity)resp.getEntity(TimelineEntity.class);
            Assert.assertEquals((Object)"application/json; charset=utf-8", (Object)resp.getType().toString());
            Assert.assertNotNull((Object)entity);
            Assert.assertEquals((Object)"id_1", (Object)entity.getId());
            Assert.assertEquals((Object)"app", (Object)entity.getType());
            Assert.assertEquals((long)3L, (long)entity.getConfigs().size());
            Assert.assertEquals((long)3L, (long)entity.getMetrics().size());
            Assert.assertTrue((String)"UID should be present", (boolean)entity.getInfo().containsKey("UID"));
            Assert.assertEquals((long)3L, (long)entity.getInfo().size());
            Assert.assertEquals((long)0L, (long)entity.getEvents().size());
        }
        finally {
            client.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetEntityAllFields() throws Exception {
        Client client = TestTimelineReaderWebServices.createClient();
        try {
            URI uri = URI.create("http://localhost:" + this.serverPort + "/ws/v2/timeline/clusters/cluster1/apps/app1/entities/app/id_1?fields=ALL");
            ClientResponse resp = TestTimelineReaderWebServices.getResponse(client, uri);
            TimelineEntity entity = (TimelineEntity)resp.getEntity(TimelineEntity.class);
            Assert.assertEquals((Object)"application/json; charset=utf-8", (Object)resp.getType().toString());
            Assert.assertNotNull((Object)entity);
            Assert.assertEquals((Object)"id_1", (Object)entity.getId());
            Assert.assertEquals((Object)"app", (Object)entity.getType());
            Assert.assertEquals((long)3L, (long)entity.getConfigs().size());
            Assert.assertEquals((long)3L, (long)entity.getMetrics().size());
            Assert.assertTrue((String)"UID should be present", (boolean)entity.getInfo().containsKey("UID"));
            Assert.assertEquals((long)3L, (long)entity.getInfo().size());
            Assert.assertEquals((long)2L, (long)entity.getEvents().size());
        }
        finally {
            client.destroy();
        }
    }

    @Test
    public void testGetEntityNotPresent() throws Exception {
        Client client = TestTimelineReaderWebServices.createClient();
        try {
            URI uri = URI.create("http://localhost:" + this.serverPort + "/ws/v2/timeline/clusters/cluster1/apps/app1/entities/app/id_10");
            TestTimelineReaderWebServices.verifyHttpResponse(client, uri, ClientResponse.Status.NOT_FOUND);
        }
        finally {
            client.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testQueryWithoutCluster() throws Exception {
        Client client = TestTimelineReaderWebServices.createClient();
        try {
            URI uri = URI.create("http://localhost:" + this.serverPort + "/ws/v2/timeline/apps/app1/entities/app/id_1");
            ClientResponse resp = TestTimelineReaderWebServices.getResponse(client, uri);
            TimelineEntity entity = (TimelineEntity)resp.getEntity(TimelineEntity.class);
            Assert.assertEquals((Object)"application/json; charset=utf-8", (Object)resp.getType().toString());
            Assert.assertNotNull((Object)entity);
            Assert.assertEquals((Object)"id_1", (Object)entity.getId());
            Assert.assertEquals((Object)"app", (Object)entity.getType());
            uri = URI.create("http://localhost:" + this.serverPort + "/ws/v2/timeline/apps/app1/entities/app");
            resp = TestTimelineReaderWebServices.getResponse(client, uri);
            Set entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertEquals((Object)"application/json; charset=utf-8", (Object)resp.getType().toString());
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)4L, (long)entities.size());
        }
        finally {
            client.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetEntities() throws Exception {
        Client client = TestTimelineReaderWebServices.createClient();
        try {
            URI uri = URI.create("http://localhost:" + this.serverPort + "/ws/v2/timeline/clusters/cluster1/apps/app1/entities/app");
            ClientResponse resp = TestTimelineReaderWebServices.getResponse(client, uri);
            Set entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertEquals((Object)"application/json; charset=utf-8", (Object)resp.getType().toString());
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)4L, (long)entities.size());
            Assert.assertTrue((String)"Entities id_1, id_2, id_3 and id_4 should have been present in response", (entities.contains(TestTimelineReaderWebServices.newEntity("app", "id_1")) && entities.contains(TestTimelineReaderWebServices.newEntity("app", "id_2")) && entities.contains(TestTimelineReaderWebServices.newEntity("app", "id_3")) && entities.contains(TestTimelineReaderWebServices.newEntity("app", "id_4")) ? 1 : 0) != 0);
        }
        finally {
            client.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetEntitiesWithLimit() throws Exception {
        Client client = TestTimelineReaderWebServices.createClient();
        try {
            URI uri = URI.create("http://localhost:" + this.serverPort + "/ws/v2/timeline/clusters/cluster1/apps/app1/entities/app?limit=2");
            ClientResponse resp = TestTimelineReaderWebServices.getResponse(client, uri);
            Set entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertEquals((Object)"application/json; charset=utf-8", (Object)resp.getType().toString());
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)2L, (long)entities.size());
            Assert.assertTrue((String)"Entities with id_1 and id_4 should have been present in response based on entity created time.", (entities.contains(TestTimelineReaderWebServices.newEntity("app", "id_1")) && entities.contains(TestTimelineReaderWebServices.newEntity("app", "id_4")) ? 1 : 0) != 0);
            uri = URI.create("http://localhost:" + this.serverPort + "/ws/v2/timeline/clusters/cluster1/apps/app1/entities/app?limit=3");
            resp = TestTimelineReaderWebServices.getResponse(client, uri);
            entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertEquals((Object)"application/json; charset=utf-8", (Object)resp.getType().toString());
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)3L, (long)entities.size());
        }
        finally {
            client.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetEntitiesBasedOnCreatedTime() throws Exception {
        Client client = TestTimelineReaderWebServices.createClient();
        try {
            URI uri = URI.create("http://localhost:" + this.serverPort + "/ws/v2/timeline/clusters/cluster1/apps/app1/entities/app?createdtimestart=1425016502030&createdtimeend=1425016502060");
            ClientResponse resp = TestTimelineReaderWebServices.getResponse(client, uri);
            Set entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertEquals((Object)"application/json; charset=utf-8", (Object)resp.getType().toString());
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)1L, (long)entities.size());
            Assert.assertTrue((String)"Entity with id_4 should have been present in response.", (boolean)entities.contains(TestTimelineReaderWebServices.newEntity("app", "id_4")));
            uri = URI.create("http://localhost:" + this.serverPort + "/ws/v2/timeline/clusters/cluster1/apps/app1/entities/app?createdtimeend=1425016502010");
            resp = TestTimelineReaderWebServices.getResponse(client, uri);
            entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertEquals((Object)"application/json; charset=utf-8", (Object)resp.getType().toString());
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)3L, (long)entities.size());
            Assert.assertFalse((String)"Entity with id_4 should not have been present in response.", (boolean)entities.contains(TestTimelineReaderWebServices.newEntity("app", "id_4")));
            uri = URI.create("http://localhost:" + this.serverPort + "/ws/v2/timeline/clusters/cluster1/apps/app1/entities/app?createdtimestart=1425016502010");
            resp = TestTimelineReaderWebServices.getResponse(client, uri);
            entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertEquals((Object)"application/json; charset=utf-8", (Object)resp.getType().toString());
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)1L, (long)entities.size());
            Assert.assertTrue((String)"Entity with id_4 should have been present in response.", (boolean)entities.contains(TestTimelineReaderWebServices.newEntity("app", "id_4")));
        }
        finally {
            client.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetEntitiesByRelations() throws Exception {
        Client client = TestTimelineReaderWebServices.createClient();
        try {
            URI uri = URI.create("http://localhost:" + this.serverPort + "/ws/v2/timeline/clusters/cluster1/apps/app1/entities/app?relatesto=flow:flow1");
            ClientResponse resp = TestTimelineReaderWebServices.getResponse(client, uri);
            Set entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertEquals((Object)"application/json; charset=utf-8", (Object)resp.getType().toString());
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)1L, (long)entities.size());
            Assert.assertTrue((String)"Entity with id_1 should have been present in response.", (boolean)entities.contains(TestTimelineReaderWebServices.newEntity("app", "id_1")));
            uri = URI.create("http://localhost:" + this.serverPort + "/ws/v2/timeline/clusters/cluster1/apps/app1/entities/app?isrelatedto=type1:tid1_2,type2:tid2_1%60");
            resp = TestTimelineReaderWebServices.getResponse(client, uri);
            entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertEquals((Object)"application/json; charset=utf-8", (Object)resp.getType().toString());
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)1L, (long)entities.size());
            Assert.assertTrue((String)"Entity with id_1 should have been present in response.", (boolean)entities.contains(TestTimelineReaderWebServices.newEntity("app", "id_1")));
            uri = URI.create("http://localhost:" + this.serverPort + "/ws/v2/timeline/clusters/cluster1/apps/app1/entities/app?isrelatedto=type1:tid1_1:tid1_2,type2:tid2_1%60");
            resp = TestTimelineReaderWebServices.getResponse(client, uri);
            entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertEquals((Object)"application/json; charset=utf-8", (Object)resp.getType().toString());
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)1L, (long)entities.size());
            Assert.assertTrue((String)"Entity with id_1 should have been present in response.", (boolean)entities.contains(TestTimelineReaderWebServices.newEntity("app", "id_1")));
        }
        finally {
            client.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetEntitiesByConfigFilters() throws Exception {
        Client client = TestTimelineReaderWebServices.createClient();
        try {
            URI uri = URI.create("http://localhost:" + this.serverPort + "/ws/v2/timeline/clusters/cluster1/apps/app1/entities/app?conffilters=config_1%20eq%20123%20AND%20config_3%20eq%20abc");
            ClientResponse resp = TestTimelineReaderWebServices.getResponse(client, uri);
            Set entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertEquals((Object)"application/json; charset=utf-8", (Object)resp.getType().toString());
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)1L, (long)entities.size());
            Assert.assertTrue((String)"Entity with id_3 should have been present in response.", (boolean)entities.contains(TestTimelineReaderWebServices.newEntity("app", "id_3")));
        }
        finally {
            client.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetEntitiesByInfoFilters() throws Exception {
        Client client = TestTimelineReaderWebServices.createClient();
        try {
            URI uri = URI.create("http://localhost:" + this.serverPort + "/ws/v2/timeline/clusters/cluster1/apps/app1/entities/app?infofilters=info2%20eq%203.5");
            ClientResponse resp = TestTimelineReaderWebServices.getResponse(client, uri);
            Set entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertEquals((Object)"application/json; charset=utf-8", (Object)resp.getType().toString());
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)1L, (long)entities.size());
            Assert.assertTrue((String)"Entity with id_3 should have been present in response.", (boolean)entities.contains(TestTimelineReaderWebServices.newEntity("app", "id_3")));
        }
        finally {
            client.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetEntitiesByMetricFilters() throws Exception {
        Client client = TestTimelineReaderWebServices.createClient();
        try {
            URI uri = URI.create("http://localhost:" + this.serverPort + "/ws/v2/timeline/clusters/cluster1/apps/app1/entities/app?metricfilters=metric3%20ge%200");
            ClientResponse resp = TestTimelineReaderWebServices.getResponse(client, uri);
            Set entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertEquals((Object)"application/json; charset=utf-8", (Object)resp.getType().toString());
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)2L, (long)entities.size());
            Assert.assertTrue((String)"Entities with id_1 and id_2 should have been present in response.", (entities.contains(TestTimelineReaderWebServices.newEntity("app", "id_1")) && entities.contains(TestTimelineReaderWebServices.newEntity("app", "id_2")) ? 1 : 0) != 0);
        }
        finally {
            client.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetEntitiesByEventFilters() throws Exception {
        Client client = TestTimelineReaderWebServices.createClient();
        try {
            URI uri = URI.create("http://localhost:" + this.serverPort + "/ws/v2/timeline/clusters/cluster1/apps/app1/entities/app?eventfilters=event_2,event_4");
            ClientResponse resp = TestTimelineReaderWebServices.getResponse(client, uri);
            Set entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertEquals((Object)"application/json; charset=utf-8", (Object)resp.getType().toString());
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)1L, (long)entities.size());
            Assert.assertTrue((String)"Entity with id_3 should have been present in response.", (boolean)entities.contains(TestTimelineReaderWebServices.newEntity("app", "id_3")));
        }
        finally {
            client.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetEntitiesNoMatch() throws Exception {
        Client client = TestTimelineReaderWebServices.createClient();
        try {
            URI uri = URI.create("http://localhost:" + this.serverPort + "/ws/v2/timeline/clusters/cluster1/apps/app1/entities/app?metricfilters=metric7%20ge%200&isrelatedto=type1:tid1_1:tid1_2,type2:tid2_1%60&relatesto=flow:flow1&eventfilters=event_2,event_4&infofilters=info2%20eq%203.5&createdtimestart=1425016502030&createdtimeend=1425016502060");
            ClientResponse resp = TestTimelineReaderWebServices.getResponse(client, uri);
            Set entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertEquals((Object)"application/json; charset=utf-8", (Object)resp.getType().toString());
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)0L, (long)entities.size());
        }
        finally {
            client.destroy();
        }
    }

    @Test
    public void testInvalidValuesHandling() throws Exception {
        Client client = TestTimelineReaderWebServices.createClient();
        try {
            URI uri = URI.create("http://localhost:" + this.serverPort + "/ws/v2/timeline/clusters/cluster1/apps/app1/entities/app?flowrunid=a23b");
            TestTimelineReaderWebServices.verifyHttpResponse(client, uri, ClientResponse.Status.BAD_REQUEST);
            uri = URI.create("http://localhost:" + this.serverPort + "/ws/v2/timeline/clusters/cluster1/apps/app1/entities/app/id_1?flowrunid=2ab15");
            TestTimelineReaderWebServices.verifyHttpResponse(client, uri, ClientResponse.Status.BAD_REQUEST);
            uri = URI.create("http://localhost:" + this.serverPort + "/ws/v2/timeline/clusters/cluster1/apps/app1/entities/app?limit=#$561av");
            TestTimelineReaderWebServices.verifyHttpResponse(client, uri, ClientResponse.Status.BAD_REQUEST);
        }
        finally {
            client.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetAppAttempts() throws Exception {
        Client client = TestTimelineReaderWebServices.createClient();
        try {
            URI uri = URI.create("http://localhost:" + this.serverPort + "/ws/v2/timeline/clusters/cluster1/apps/app1/entities/YARN_APPLICATION_ATTEMPT");
            ClientResponse resp = TestTimelineReaderWebServices.getResponse(client, uri);
            Set entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertEquals((Object)"application/json; charset=utf-8", (Object)resp.getType().toString());
            Assert.assertNotNull((Object)entities);
            int totalEntities = entities.size();
            Assert.assertEquals((long)2L, (long)totalEntities);
            Assert.assertTrue((String)"Entity with app-attempt-2 should have been present in response.", (boolean)entities.contains(TestTimelineReaderWebServices.newEntity(TimelineEntityType.YARN_APPLICATION_ATTEMPT.toString(), "app-attempt-1")));
            Assert.assertTrue((String)"Entity with app-attempt-2 should have been present in response.", (boolean)entities.contains(TestTimelineReaderWebServices.newEntity(TimelineEntityType.YARN_APPLICATION_ATTEMPT.toString(), "app-attempt-2")));
            uri = URI.create("http://localhost:" + this.serverPort + "/ws/v2/timeline/clusters/cluster1/apps/app1/appattempts");
            resp = TestTimelineReaderWebServices.getResponse(client, uri);
            entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)resp.getType());
            Assert.assertNotNull((Object)entities);
            int retrievedEntity = entities.size();
            Assert.assertEquals((long)2L, (long)retrievedEntity);
            Assert.assertTrue((String)"Entity with app-attempt-2 should have been present in response.", (boolean)entities.contains(TestTimelineReaderWebServices.newEntity(TimelineEntityType.YARN_APPLICATION_ATTEMPT.toString(), "app-attempt-1")));
            Assert.assertTrue((String)"Entity with app-attempt-2 should have been present in response.", (boolean)entities.contains(TestTimelineReaderWebServices.newEntity(TimelineEntityType.YARN_APPLICATION_ATTEMPT.toString(), "app-attempt-2")));
            Assert.assertEquals((long)totalEntities, (long)retrievedEntity);
        }
        finally {
            client.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetAppAttempt() throws Exception {
        Client client = TestTimelineReaderWebServices.createClient();
        try {
            URI uri = URI.create("http://localhost:" + this.serverPort + "/ws/v2/timeline/clusters/cluster1/apps/app1/entities/YARN_APPLICATION_ATTEMPT/app-attempt-1");
            ClientResponse resp = TestTimelineReaderWebServices.getResponse(client, uri);
            TimelineEntity entities1 = (TimelineEntity)resp.getEntity((GenericType)new GenericType<TimelineEntity>(){});
            Assert.assertEquals((Object)"application/json; charset=utf-8", (Object)resp.getType().toString());
            Assert.assertNotNull((Object)entities1);
            uri = URI.create("http://localhost:" + this.serverPort + "/ws/v2/timeline/clusters/cluster1/apps/app1/appattempts/app-attempt-1");
            resp = TestTimelineReaderWebServices.getResponse(client, uri);
            TimelineEntity entities2 = (TimelineEntity)resp.getEntity((GenericType)new GenericType<TimelineEntity>(){});
            Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)resp.getType());
            Assert.assertNotNull((Object)entities2);
            Assert.assertEquals((Object)entities1, (Object)entities2);
        }
        finally {
            client.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetContainers() throws Exception {
        Client client = TestTimelineReaderWebServices.createClient();
        try {
            URI uri = URI.create("http://localhost:" + this.serverPort + "/ws/v2/timeline/clusters/cluster1/apps/app1/entities/YARN_CONTAINER");
            ClientResponse resp = TestTimelineReaderWebServices.getResponse(client, uri);
            Set entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertEquals((Object)"application/json; charset=utf-8", (Object)resp.getType().toString());
            Assert.assertNotNull((Object)entities);
            int totalEntities = entities.size();
            Assert.assertEquals((long)3L, (long)totalEntities);
            Assert.assertTrue((String)"Entity with container_1_1 should have been present in response.", (boolean)entities.contains(TestTimelineReaderWebServices.newEntity(TimelineEntityType.YARN_CONTAINER.toString(), "container_1_1")));
            Assert.assertTrue((String)"Entity with container_2_1 should have been present in response.", (boolean)entities.contains(TestTimelineReaderWebServices.newEntity(TimelineEntityType.YARN_CONTAINER.toString(), "container_2_1")));
            Assert.assertTrue((String)"Entity with container_2_2 should have been present in response.", (boolean)entities.contains(TestTimelineReaderWebServices.newEntity(TimelineEntityType.YARN_CONTAINER.toString(), "container_2_2")));
            uri = URI.create("http://localhost:" + this.serverPort + "/ws/v2/timeline/clusters/cluster1/apps/app1/appattempts/app-attempt-1/containers");
            resp = TestTimelineReaderWebServices.getResponse(client, uri);
            entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)resp.getType());
            Assert.assertNotNull((Object)entities);
            int retrievedEntity = entities.size();
            Assert.assertEquals((long)1L, (long)retrievedEntity);
            Assert.assertTrue((String)"Entity with container_1_1 should have been present in response.", (boolean)entities.contains(TestTimelineReaderWebServices.newEntity(TimelineEntityType.YARN_CONTAINER.toString(), "container_1_1")));
            uri = URI.create("http://localhost:" + this.serverPort + "/ws/v2/timeline/clusters/cluster1/apps/app1/appattempts/app-attempt-2/containers");
            resp = TestTimelineReaderWebServices.getResponse(client, uri);
            entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)resp.getType());
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)2L, (long)entities.size());
            Assert.assertTrue((String)"Entity with container_2_1 should have been present in response.", (boolean)entities.contains(TestTimelineReaderWebServices.newEntity(TimelineEntityType.YARN_CONTAINER.toString(), "container_2_1")));
            Assert.assertTrue((String)"Entity with container_2_2 should have been present in response.", (boolean)entities.contains(TestTimelineReaderWebServices.newEntity(TimelineEntityType.YARN_CONTAINER.toString(), "container_2_2")));
            Assert.assertEquals((long)totalEntities, (long)(retrievedEntity += entities.size()));
        }
        finally {
            client.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetContainer() throws Exception {
        Client client = TestTimelineReaderWebServices.createClient();
        try {
            URI uri = URI.create("http://localhost:" + this.serverPort + "/ws/v2/timeline/clusters/cluster1/apps/app1/entities/YARN_CONTAINER/container_2_2");
            ClientResponse resp = TestTimelineReaderWebServices.getResponse(client, uri);
            TimelineEntity entities1 = (TimelineEntity)resp.getEntity((GenericType)new GenericType<TimelineEntity>(){});
            Assert.assertEquals((Object)"application/json; charset=utf-8", (Object)resp.getType().toString());
            Assert.assertNotNull((Object)entities1);
            uri = URI.create("http://localhost:" + this.serverPort + "/ws/v2/timeline/clusters/cluster1/apps/app1/containers/container_2_2");
            resp = TestTimelineReaderWebServices.getResponse(client, uri);
            TimelineEntity entities2 = (TimelineEntity)resp.getEntity((GenericType)new GenericType<TimelineEntity>(){});
            Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)resp.getType());
            Assert.assertNotNull((Object)entities2);
            Assert.assertEquals((Object)entities1, (Object)entities2);
        }
        finally {
            client.destroy();
        }
    }

    private static class DummyURLConnectionFactory
    implements HttpURLConnectionFactory {
        private DummyURLConnectionFactory() {
        }

        public HttpURLConnection getHttpURLConnection(URL url) throws IOException {
            try {
                return (HttpURLConnection)url.openConnection();
            }
            catch (UndeclaredThrowableException e) {
                throw new IOException(e.getCause());
            }
        }
    }
}

