/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.reader;

import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Singleton;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.yarn.api.records.timeline.TimelineAbout;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntityType;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineEntityFilters;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineParseException;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineReaderContext;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineReaderManager;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineReaderWebServicesUtils;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineUIDConverter;
import org.apache.hadoop.yarn.util.timeline.TimelineUtils;
import org.apache.hadoop.yarn.webapp.BadRequestException;
import org.apache.hadoop.yarn.webapp.NotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
@Singleton
@Path(value="/ws/v2/timeline")
public class TimelineReaderWebServices {
    private static final Logger LOG = LoggerFactory.getLogger(TimelineReaderWebServices.class);
    @Context
    private ServletContext ctxt;
    private static final String QUERY_STRING_SEP = "?";
    private static final String RANGE_DELIMITER = "-";
    private static final String DATE_PATTERN = "yyyyMMdd";
    @VisibleForTesting
    static final ThreadLocal<DateFormat> DATE_FORMAT = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            SimpleDateFormat format = new SimpleDateFormat(TimelineReaderWebServices.DATE_PATTERN, Locale.ENGLISH);
            format.setTimeZone(TimeZone.getTimeZone("GMT"));
            format.setLenient(false);
            return format;
        }
    };

    private void init(HttpServletResponse response) {
        response.setContentType(null);
    }

    private static long parseDate(String strDate) throws ParseException {
        Date date = DATE_FORMAT.get().parse(strDate);
        return date.getTime();
    }

    private static DateRange parseDateRange(String dateRange) throws IllegalArgumentException {
        if (dateRange == null || dateRange.isEmpty()) {
            return new DateRange(null, null);
        }
        String[] dates = dateRange.split(RANGE_DELIMITER, 2);
        Long start = null;
        Long end = null;
        try {
            String startDate = dates[0].trim();
            if (!startDate.isEmpty()) {
                if (startDate.length() != DATE_PATTERN.length()) {
                    throw new IllegalArgumentException("Invalid date range " + dateRange);
                }
                start = TimelineReaderWebServices.parseDate(startDate);
            }
            if (dates.length > 1) {
                String endDate = dates[1].trim();
                if (!endDate.isEmpty()) {
                    if (endDate.length() != DATE_PATTERN.length()) {
                        throw new IllegalArgumentException("Invalid date range " + dateRange);
                    }
                    end = TimelineReaderWebServices.parseDate(endDate);
                }
            } else {
                end = start;
            }
            if (start != null && end != null && start > end) {
                throw new IllegalArgumentException("Invalid date range " + dateRange);
            }
            return new DateRange(start, end);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Invalid date range " + dateRange);
        }
    }

    private TimelineReaderManager getTimelineReaderManager() {
        return (TimelineReaderManager)((Object)this.ctxt.getAttribute("timeline.reader.manager"));
    }

    private static void handleException(Exception e, String url, long startTime, String invalidNumMsg) throws BadRequestException, WebApplicationException {
        long endTime = Time.monotonicNow();
        LOG.info("Processed URL " + url + " but encountered exception (Took " + (endTime - startTime) + " ms.)");
        if (e instanceof NumberFormatException) {
            throw new BadRequestException(invalidNumMsg + " is not a numeric value.");
        }
        if (e instanceof IllegalArgumentException) {
            throw new BadRequestException(e.getMessage() == null ? "Requested Invalid Field." : e.getMessage());
        }
        if (e instanceof NotFoundException) {
            throw (NotFoundException)e;
        }
        if (e instanceof TimelineParseException) {
            throw new BadRequestException(e.getMessage() == null ? "Filter Parsing failed." : e.getMessage());
        }
        if (e instanceof BadRequestException) {
            throw (BadRequestException)e;
        }
        LOG.error("Error while processing REST request", (Throwable)e);
        throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
    }

    @GET
    @Produces(value={"application/json; charset=utf-8"})
    public TimelineAbout about(@Context HttpServletRequest req, @Context HttpServletResponse res) {
        this.init(res);
        return TimelineUtils.createTimelineAbout((String)"Timeline Reader API");
    }

    @GET
    @Path(value="/app-uid/{uid}/entities/{entitytype}")
    @Produces(value={"application/json; charset=utf-8"})
    public Set<TimelineEntity> getEntities(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="uid") String uId, @PathParam(value="entitytype") String entityType, @QueryParam(value="limit") String limit, @QueryParam(value="createdtimestart") String createdTimeStart, @QueryParam(value="createdtimeend") String createdTimeEnd, @QueryParam(value="relatesto") String relatesTo, @QueryParam(value="isrelatedto") String isRelatedTo, @QueryParam(value="infofilters") String infofilters, @QueryParam(value="conffilters") String conffilters, @QueryParam(value="metricfilters") String metricfilters, @QueryParam(value="eventfilters") String eventfilters, @QueryParam(value="confstoretrieve") String confsToRetrieve, @QueryParam(value="metricstoretrieve") String metricsToRetrieve, @QueryParam(value="fields") String fields, @QueryParam(value="metricslimit") String metricsLimit, @QueryParam(value="metricstimestart") String metricsTimeStart, @QueryParam(value="metricstimeend") String metricsTimeEnd, @QueryParam(value="fromid") String fromId) {
        String url = req.getRequestURI() + (req.getQueryString() == null ? "" : QUERY_STRING_SEP + req.getQueryString());
        UserGroupInformation callerUGI = TimelineReaderWebServicesUtils.getUser(req);
        LOG.info("Received URL " + url + " from user " + TimelineReaderWebServicesUtils.getUserName(callerUGI));
        long startTime = Time.monotonicNow();
        this.init(res);
        TimelineReaderManager timelineReaderManager = this.getTimelineReaderManager();
        Set<TimelineEntity> entities = null;
        try {
            TimelineReaderContext context = TimelineUIDConverter.APPLICATION_UID.decodeUID(uId);
            if (context == null) {
                throw new BadRequestException("Incorrect UID " + uId);
            }
            context.setEntityType(TimelineReaderWebServicesUtils.parseStr(entityType));
            entities = timelineReaderManager.getEntities(context, TimelineReaderWebServicesUtils.createTimelineEntityFilters(limit, createdTimeStart, createdTimeEnd, relatesTo, isRelatedTo, infofilters, conffilters, metricfilters, eventfilters, fromId), TimelineReaderWebServicesUtils.createTimelineDataToRetrieve(confsToRetrieve, metricsToRetrieve, fields, metricsLimit, metricsTimeStart, metricsTimeEnd));
        }
        catch (Exception e) {
            TimelineReaderWebServices.handleException(e, url, startTime, "createdTime start/end or limit or flowrunid");
        }
        long endTime = Time.monotonicNow();
        if (entities == null) {
            entities = Collections.emptySet();
        }
        LOG.info("Processed URL " + url + " (Took " + (endTime - startTime) + " ms.)");
        return entities;
    }

    @GET
    @Path(value="/apps/{appid}/entities/{entitytype}")
    @Produces(value={"application/json; charset=utf-8"})
    public Set<TimelineEntity> getEntities(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="appid") String appId, @PathParam(value="entitytype") String entityType, @QueryParam(value="userid") String userId, @QueryParam(value="flowname") String flowName, @QueryParam(value="flowrunid") String flowRunId, @QueryParam(value="limit") String limit, @QueryParam(value="createdtimestart") String createdTimeStart, @QueryParam(value="createdtimeend") String createdTimeEnd, @QueryParam(value="relatesto") String relatesTo, @QueryParam(value="isrelatedto") String isRelatedTo, @QueryParam(value="infofilters") String infofilters, @QueryParam(value="conffilters") String conffilters, @QueryParam(value="metricfilters") String metricfilters, @QueryParam(value="eventfilters") String eventfilters, @QueryParam(value="confstoretrieve") String confsToRetrieve, @QueryParam(value="metricstoretrieve") String metricsToRetrieve, @QueryParam(value="fields") String fields, @QueryParam(value="metricslimit") String metricsLimit, @QueryParam(value="metricstimestart") String metricsTimeStart, @QueryParam(value="metricstimeend") String metricsTimeEnd, @QueryParam(value="fromid") String fromId) {
        return this.getEntities(req, res, null, appId, entityType, userId, flowName, flowRunId, limit, createdTimeStart, createdTimeEnd, relatesTo, isRelatedTo, infofilters, conffilters, metricfilters, eventfilters, confsToRetrieve, metricsToRetrieve, fields, metricsLimit, metricsTimeStart, metricsTimeEnd, fromId);
    }

    @GET
    @Path(value="/clusters/{clusterid}/apps/{appid}/entities/{entitytype}")
    @Produces(value={"application/json; charset=utf-8"})
    public Set<TimelineEntity> getEntities(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="clusterid") String clusterId, @PathParam(value="appid") String appId, @PathParam(value="entitytype") String entityType, @QueryParam(value="userid") String userId, @QueryParam(value="flowname") String flowName, @QueryParam(value="flowrunid") String flowRunId, @QueryParam(value="limit") String limit, @QueryParam(value="createdtimestart") String createdTimeStart, @QueryParam(value="createdtimeend") String createdTimeEnd, @QueryParam(value="relatesto") String relatesTo, @QueryParam(value="isrelatedto") String isRelatedTo, @QueryParam(value="infofilters") String infofilters, @QueryParam(value="conffilters") String conffilters, @QueryParam(value="metricfilters") String metricfilters, @QueryParam(value="eventfilters") String eventfilters, @QueryParam(value="confstoretrieve") String confsToRetrieve, @QueryParam(value="metricstoretrieve") String metricsToRetrieve, @QueryParam(value="fields") String fields, @QueryParam(value="metricslimit") String metricsLimit, @QueryParam(value="metricstimestart") String metricsTimeStart, @QueryParam(value="metricstimeend") String metricsTimeEnd, @QueryParam(value="fromid") String fromId) {
        String url = req.getRequestURI() + (req.getQueryString() == null ? "" : QUERY_STRING_SEP + req.getQueryString());
        UserGroupInformation callerUGI = TimelineReaderWebServicesUtils.getUser(req);
        LOG.info("Received URL " + url + " from user " + TimelineReaderWebServicesUtils.getUserName(callerUGI));
        long startTime = Time.monotonicNow();
        this.init(res);
        TimelineReaderManager timelineReaderManager = this.getTimelineReaderManager();
        Set<TimelineEntity> entities = null;
        try {
            TimelineReaderContext context = TimelineReaderWebServicesUtils.createTimelineReaderContext(clusterId, userId, flowName, flowRunId, appId, entityType, null, null);
            entities = timelineReaderManager.getEntities(context, TimelineReaderWebServicesUtils.createTimelineEntityFilters(limit, createdTimeStart, createdTimeEnd, relatesTo, isRelatedTo, infofilters, conffilters, metricfilters, eventfilters, fromId), TimelineReaderWebServicesUtils.createTimelineDataToRetrieve(confsToRetrieve, metricsToRetrieve, fields, metricsLimit, metricsTimeStart, metricsTimeEnd));
        }
        catch (Exception e) {
            TimelineReaderWebServices.handleException(e, url, startTime, "createdTime start/end or limit or flowrunid");
        }
        long endTime = Time.monotonicNow();
        if (entities == null) {
            entities = Collections.emptySet();
        }
        LOG.info("Processed URL " + url + " (Took " + (endTime - startTime) + " ms.)");
        return entities;
    }

    @GET
    @Path(value="/entity-uid/{uid}/")
    @Produces(value={"application/json; charset=utf-8"})
    public TimelineEntity getEntity(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="uid") String uId, @QueryParam(value="confstoretrieve") String confsToRetrieve, @QueryParam(value="metricstoretrieve") String metricsToRetrieve, @QueryParam(value="fields") String fields, @QueryParam(value="metricslimit") String metricsLimit, @QueryParam(value="metricstimestart") String metricsTimeStart, @QueryParam(value="metricstimeend") String metricsTimeEnd) {
        String url = req.getRequestURI() + (req.getQueryString() == null ? "" : QUERY_STRING_SEP + req.getQueryString());
        UserGroupInformation callerUGI = TimelineReaderWebServicesUtils.getUser(req);
        LOG.info("Received URL " + url + " from user " + TimelineReaderWebServicesUtils.getUserName(callerUGI));
        long startTime = Time.monotonicNow();
        this.init(res);
        TimelineReaderManager timelineReaderManager = this.getTimelineReaderManager();
        TimelineEntity entity = null;
        try {
            TimelineReaderContext context = TimelineUIDConverter.GENERIC_ENTITY_UID.decodeUID(uId);
            if (context == null) {
                throw new BadRequestException("Incorrect UID " + uId);
            }
            entity = timelineReaderManager.getEntity(context, TimelineReaderWebServicesUtils.createTimelineDataToRetrieve(confsToRetrieve, metricsToRetrieve, fields, metricsLimit, metricsTimeStart, metricsTimeEnd));
        }
        catch (Exception e) {
            TimelineReaderWebServices.handleException(e, url, startTime, "flowrunid");
        }
        long endTime = Time.monotonicNow();
        if (entity == null) {
            LOG.info("Processed URL " + url + " but entity not found (Took " + (endTime - startTime) + " ms.)");
            throw new NotFoundException("Timeline entity with uid: " + uId + "is not found");
        }
        LOG.info("Processed URL " + url + " (Took " + (endTime - startTime) + " ms.)");
        return entity;
    }

    @GET
    @Path(value="/apps/{appid}/entities/{entitytype}/{entityid}/")
    @Produces(value={"application/json; charset=utf-8"})
    public TimelineEntity getEntity(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="appid") String appId, @PathParam(value="entitytype") String entityType, @PathParam(value="entityid") String entityId, @QueryParam(value="userid") String userId, @QueryParam(value="flowname") String flowName, @QueryParam(value="flowrunid") String flowRunId, @QueryParam(value="confstoretrieve") String confsToRetrieve, @QueryParam(value="metricstoretrieve") String metricsToRetrieve, @QueryParam(value="fields") String fields, @QueryParam(value="metricslimit") String metricsLimit, @QueryParam(value="metricstimestart") String metricsTimeStart, @QueryParam(value="metricstimeend") String metricsTimeEnd, @QueryParam(value="entityidprefix") String entityIdPrefix) {
        return this.getEntity(req, res, null, appId, entityType, entityId, userId, flowName, flowRunId, confsToRetrieve, metricsToRetrieve, fields, metricsLimit, metricsTimeStart, metricsTimeEnd, entityIdPrefix);
    }

    @GET
    @Path(value="/clusters/{clusterid}/apps/{appid}/entities/{entitytype}/{entityid}/")
    @Produces(value={"application/json; charset=utf-8"})
    public TimelineEntity getEntity(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="clusterid") String clusterId, @PathParam(value="appid") String appId, @PathParam(value="entitytype") String entityType, @PathParam(value="entityid") String entityId, @QueryParam(value="userid") String userId, @QueryParam(value="flowname") String flowName, @QueryParam(value="flowrunid") String flowRunId, @QueryParam(value="confstoretrieve") String confsToRetrieve, @QueryParam(value="metricstoretrieve") String metricsToRetrieve, @QueryParam(value="fields") String fields, @QueryParam(value="metricslimit") String metricsLimit, @QueryParam(value="metricstimestart") String metricsTimeStart, @QueryParam(value="metricstimeend") String metricsTimeEnd, @QueryParam(value="entityidprefix") String entityIdPrefix) {
        String url = req.getRequestURI() + (req.getQueryString() == null ? "" : QUERY_STRING_SEP + req.getQueryString());
        UserGroupInformation callerUGI = TimelineReaderWebServicesUtils.getUser(req);
        LOG.info("Received URL " + url + " from user " + TimelineReaderWebServicesUtils.getUserName(callerUGI));
        long startTime = Time.monotonicNow();
        this.init(res);
        TimelineReaderManager timelineReaderManager = this.getTimelineReaderManager();
        TimelineEntity entity = null;
        try {
            entity = timelineReaderManager.getEntity(TimelineReaderWebServicesUtils.createTimelineReaderContext(clusterId, userId, flowName, flowRunId, appId, entityType, entityIdPrefix, entityId), TimelineReaderWebServicesUtils.createTimelineDataToRetrieve(confsToRetrieve, metricsToRetrieve, fields, metricsLimit, metricsTimeStart, metricsTimeEnd));
        }
        catch (Exception e) {
            TimelineReaderWebServices.handleException(e, url, startTime, "flowrunid");
        }
        long endTime = Time.monotonicNow();
        if (entity == null) {
            LOG.info("Processed URL " + url + " but entity not found (Took " + (endTime - startTime) + " ms.)");
            throw new NotFoundException("Timeline entity {id: " + entityId + ", type: " + entityType + " } is not found");
        }
        LOG.info("Processed URL " + url + " (Took " + (endTime - startTime) + " ms.)");
        return entity;
    }

    @GET
    @Path(value="/run-uid/{uid}/")
    @Produces(value={"application/json; charset=utf-8"})
    public TimelineEntity getFlowRun(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="uid") String uId, @QueryParam(value="metricstoretrieve") String metricsToRetrieve) {
        String url = req.getRequestURI() + (req.getQueryString() == null ? "" : QUERY_STRING_SEP + req.getQueryString());
        UserGroupInformation callerUGI = TimelineReaderWebServicesUtils.getUser(req);
        LOG.info("Received URL " + url + " from user " + TimelineReaderWebServicesUtils.getUserName(callerUGI));
        long startTime = Time.monotonicNow();
        this.init(res);
        TimelineReaderManager timelineReaderManager = this.getTimelineReaderManager();
        TimelineEntity entity = null;
        try {
            TimelineReaderContext context = TimelineUIDConverter.FLOWRUN_UID.decodeUID(uId);
            if (context == null) {
                throw new BadRequestException("Incorrect UID " + uId);
            }
            context.setEntityType(TimelineEntityType.YARN_FLOW_RUN.toString());
            entity = timelineReaderManager.getEntity(context, TimelineReaderWebServicesUtils.createTimelineDataToRetrieve(null, metricsToRetrieve, null, null, null, null));
        }
        catch (Exception e) {
            TimelineReaderWebServices.handleException(e, url, startTime, "flowrunid");
        }
        long endTime = Time.monotonicNow();
        if (entity == null) {
            LOG.info("Processed URL " + url + " but flowrun not found (Took " + (endTime - startTime) + " ms.)");
            throw new NotFoundException("Flowrun with uid: " + uId + "is not found");
        }
        LOG.info("Processed URL " + url + " (Took " + (endTime - startTime) + " ms.)");
        return entity;
    }

    @GET
    @Path(value="/users/{userid}/flows/{flowname}/runs/{flowrunid}/")
    @Produces(value={"application/json; charset=utf-8"})
    public TimelineEntity getFlowRun(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="userid") String userId, @PathParam(value="flowname") String flowName, @PathParam(value="flowrunid") String flowRunId, @QueryParam(value="metricstoretrieve") String metricsToRetrieve) {
        return this.getFlowRun(req, res, null, userId, flowName, flowRunId, metricsToRetrieve);
    }

    @GET
    @Path(value="/clusters/{clusterid}/users/{userid}/flows/{flowname}/runs/{flowrunid}/")
    @Produces(value={"application/json; charset=utf-8"})
    public TimelineEntity getFlowRun(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="clusterid") String clusterId, @PathParam(value="userid") String userId, @PathParam(value="flowname") String flowName, @PathParam(value="flowrunid") String flowRunId, @QueryParam(value="metricstoretrieve") String metricsToRetrieve) {
        String url = req.getRequestURI() + (req.getQueryString() == null ? "" : QUERY_STRING_SEP + req.getQueryString());
        UserGroupInformation callerUGI = TimelineReaderWebServicesUtils.getUser(req);
        LOG.info("Received URL " + url + " from user " + TimelineReaderWebServicesUtils.getUserName(callerUGI));
        long startTime = Time.monotonicNow();
        this.init(res);
        TimelineReaderManager timelineReaderManager = this.getTimelineReaderManager();
        TimelineEntity entity = null;
        try {
            entity = timelineReaderManager.getEntity(TimelineReaderWebServicesUtils.createTimelineReaderContext(clusterId, userId, flowName, flowRunId, null, TimelineEntityType.YARN_FLOW_RUN.toString(), null, null), TimelineReaderWebServicesUtils.createTimelineDataToRetrieve(null, metricsToRetrieve, null, null, null, null));
        }
        catch (Exception e) {
            TimelineReaderWebServices.handleException(e, url, startTime, "flowrunid");
        }
        long endTime = Time.monotonicNow();
        if (entity == null) {
            LOG.info("Processed URL " + url + " but flowrun not found (Took " + (endTime - startTime) + " ms.)");
            throw new NotFoundException("Flow run {flow name: " + TimelineReaderWebServicesUtils.parseStr(flowName) + ", run id: " + TimelineReaderWebServicesUtils.parseLongStr(flowRunId) + " } is not found");
        }
        LOG.info("Processed URL " + url + " (Took " + (endTime - startTime) + " ms.)");
        return entity;
    }

    @GET
    @Path(value="/flow-uid/{uid}/runs/")
    @Produces(value={"application/json; charset=utf-8"})
    public Set<TimelineEntity> getFlowRuns(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="uid") String uId, @QueryParam(value="limit") String limit, @QueryParam(value="createdtimestart") String createdTimeStart, @QueryParam(value="createdtimeend") String createdTimeEnd, @QueryParam(value="metricstoretrieve") String metricsToRetrieve, @QueryParam(value="fields") String fields, @QueryParam(value="fromid") String fromId) {
        String url = req.getRequestURI() + (req.getQueryString() == null ? "" : QUERY_STRING_SEP + req.getQueryString());
        UserGroupInformation callerUGI = TimelineReaderWebServicesUtils.getUser(req);
        LOG.info("Received URL " + url + " from user " + TimelineReaderWebServicesUtils.getUserName(callerUGI));
        long startTime = Time.monotonicNow();
        this.init(res);
        TimelineReaderManager timelineReaderManager = this.getTimelineReaderManager();
        Set<TimelineEntity> entities = null;
        try {
            TimelineReaderContext context = TimelineUIDConverter.FLOW_UID.decodeUID(uId);
            if (context == null) {
                throw new BadRequestException("Incorrect UID " + uId);
            }
            context.setEntityType(TimelineEntityType.YARN_FLOW_RUN.toString());
            entities = timelineReaderManager.getEntities(context, TimelineReaderWebServicesUtils.createTimelineEntityFilters(limit, createdTimeStart, createdTimeEnd, null, null, null, null, null, null, fromId), TimelineReaderWebServicesUtils.createTimelineDataToRetrieve(null, metricsToRetrieve, fields, null, null, null));
        }
        catch (Exception e) {
            TimelineReaderWebServices.handleException(e, url, startTime, "createdTime start/end or limit or fromId");
        }
        long endTime = Time.monotonicNow();
        if (entities == null) {
            entities = Collections.emptySet();
        }
        LOG.info("Processed URL " + url + " (Took " + (endTime - startTime) + " ms.)");
        return entities;
    }

    @GET
    @Path(value="/users/{userid}/flows/{flowname}/runs/")
    @Produces(value={"application/json; charset=utf-8"})
    public Set<TimelineEntity> getFlowRuns(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="userid") String userId, @PathParam(value="flowname") String flowName, @QueryParam(value="limit") String limit, @QueryParam(value="createdtimestart") String createdTimeStart, @QueryParam(value="createdtimeend") String createdTimeEnd, @QueryParam(value="metricstoretrieve") String metricsToRetrieve, @QueryParam(value="fields") String fields, @QueryParam(value="fromid") String fromId) {
        return this.getFlowRuns(req, res, null, userId, flowName, limit, createdTimeStart, createdTimeEnd, metricsToRetrieve, fields, fromId);
    }

    @GET
    @Path(value="/clusters/{clusterid}/users/{userid}/flows/{flowname}/runs/")
    @Produces(value={"application/json; charset=utf-8"})
    public Set<TimelineEntity> getFlowRuns(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="clusterid") String clusterId, @PathParam(value="userid") String userId, @PathParam(value="flowname") String flowName, @QueryParam(value="limit") String limit, @QueryParam(value="createdtimestart") String createdTimeStart, @QueryParam(value="createdtimeend") String createdTimeEnd, @QueryParam(value="metricstoretrieve") String metricsToRetrieve, @QueryParam(value="fields") String fields, @QueryParam(value="fromid") String fromId) {
        String url = req.getRequestURI() + (req.getQueryString() == null ? "" : QUERY_STRING_SEP + req.getQueryString());
        UserGroupInformation callerUGI = TimelineReaderWebServicesUtils.getUser(req);
        LOG.info("Received URL " + url + " from user " + TimelineReaderWebServicesUtils.getUserName(callerUGI));
        long startTime = Time.monotonicNow();
        this.init(res);
        TimelineReaderManager timelineReaderManager = this.getTimelineReaderManager();
        Set<TimelineEntity> entities = null;
        try {
            entities = timelineReaderManager.getEntities(TimelineReaderWebServicesUtils.createTimelineReaderContext(clusterId, userId, flowName, null, null, TimelineEntityType.YARN_FLOW_RUN.toString(), null, null), TimelineReaderWebServicesUtils.createTimelineEntityFilters(limit, createdTimeStart, createdTimeEnd, null, null, null, null, null, null, fromId), TimelineReaderWebServicesUtils.createTimelineDataToRetrieve(null, metricsToRetrieve, fields, null, null, null));
        }
        catch (Exception e) {
            TimelineReaderWebServices.handleException(e, url, startTime, "createdTime start/end or limit or fromId");
        }
        long endTime = Time.monotonicNow();
        if (entities == null) {
            entities = Collections.emptySet();
        }
        LOG.info("Processed URL " + url + " (Took " + (endTime - startTime) + " ms.)");
        return entities;
    }

    @GET
    @Path(value="/flows/")
    @Produces(value={"application/json; charset=utf-8"})
    public Set<TimelineEntity> getFlows(@Context HttpServletRequest req, @Context HttpServletResponse res, @QueryParam(value="limit") String limit, @QueryParam(value="daterange") String dateRange, @QueryParam(value="fromid") String fromId) {
        return this.getFlows(req, res, null, limit, dateRange, fromId);
    }

    @GET
    @Path(value="/clusters/{clusterid}/flows/")
    @Produces(value={"application/json; charset=utf-8"})
    public Set<TimelineEntity> getFlows(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="clusterid") String clusterId, @QueryParam(value="limit") String limit, @QueryParam(value="daterange") String dateRange, @QueryParam(value="fromid") String fromId) {
        String url = req.getRequestURI() + (req.getQueryString() == null ? "" : QUERY_STRING_SEP + req.getQueryString());
        UserGroupInformation callerUGI = TimelineReaderWebServicesUtils.getUser(req);
        LOG.info("Received URL " + url + " from user " + TimelineReaderWebServicesUtils.getUserName(callerUGI));
        long startTime = Time.monotonicNow();
        this.init(res);
        TimelineReaderManager timelineReaderManager = this.getTimelineReaderManager();
        Set<TimelineEntity> entities = null;
        try {
            DateRange range = TimelineReaderWebServices.parseDateRange(dateRange);
            TimelineEntityFilters entityFilters = TimelineReaderWebServicesUtils.createTimelineEntityFilters(limit, range.dateStart, range.dateEnd, null, null, null, null, null, null, fromId);
            entities = timelineReaderManager.getEntities(TimelineReaderWebServicesUtils.createTimelineReaderContext(clusterId, null, null, null, null, TimelineEntityType.YARN_FLOW_ACTIVITY.toString(), null, null), entityFilters, TimelineReaderWebServicesUtils.createTimelineDataToRetrieve(null, null, null, null, null, null));
        }
        catch (Exception e) {
            TimelineReaderWebServices.handleException(e, url, startTime, "limit");
        }
        long endTime = Time.monotonicNow();
        if (entities == null) {
            entities = Collections.emptySet();
        }
        LOG.info("Processed URL " + url + " (Took " + (endTime - startTime) + " ms.)");
        return entities;
    }

    @GET
    @Path(value="/app-uid/{uid}/")
    @Produces(value={"application/json; charset=utf-8"})
    public TimelineEntity getApp(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="uid") String uId, @QueryParam(value="confstoretrieve") String confsToRetrieve, @QueryParam(value="metricstoretrieve") String metricsToRetrieve, @QueryParam(value="fields") String fields, @QueryParam(value="metricslimit") String metricsLimit, @QueryParam(value="metricstimestart") String metricsTimeStart, @QueryParam(value="metricstimeend") String metricsTimeEnd) {
        String url = req.getRequestURI() + (req.getQueryString() == null ? "" : QUERY_STRING_SEP + req.getQueryString());
        UserGroupInformation callerUGI = TimelineReaderWebServicesUtils.getUser(req);
        LOG.info("Received URL " + url + " from user " + TimelineReaderWebServicesUtils.getUserName(callerUGI));
        long startTime = Time.monotonicNow();
        this.init(res);
        TimelineReaderManager timelineReaderManager = this.getTimelineReaderManager();
        TimelineEntity entity = null;
        try {
            TimelineReaderContext context = TimelineUIDConverter.APPLICATION_UID.decodeUID(uId);
            if (context == null) {
                throw new BadRequestException("Incorrect UID " + uId);
            }
            context.setEntityType(TimelineEntityType.YARN_APPLICATION.toString());
            entity = timelineReaderManager.getEntity(context, TimelineReaderWebServicesUtils.createTimelineDataToRetrieve(confsToRetrieve, metricsToRetrieve, fields, metricsLimit, metricsTimeStart, metricsTimeEnd));
        }
        catch (Exception e) {
            TimelineReaderWebServices.handleException(e, url, startTime, "flowrunid");
        }
        long endTime = Time.monotonicNow();
        if (entity == null) {
            LOG.info("Processed URL " + url + " but app not found (Took " + (endTime - startTime) + " ms.)");
            throw new NotFoundException("App with uid " + uId + " not found");
        }
        LOG.info("Processed URL " + url + " (Took " + (endTime - startTime) + " ms.)");
        return entity;
    }

    @GET
    @Path(value="/apps/{appid}/")
    @Produces(value={"application/json; charset=utf-8"})
    public TimelineEntity getApp(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="appid") String appId, @QueryParam(value="flowname") String flowName, @QueryParam(value="flowrunid") String flowRunId, @QueryParam(value="userid") String userId, @QueryParam(value="confstoretrieve") String confsToRetrieve, @QueryParam(value="metricstoretrieve") String metricsToRetrieve, @QueryParam(value="fields") String fields, @QueryParam(value="metricslimit") String metricsLimit, @QueryParam(value="metricstimestart") String metricsTimeStart, @QueryParam(value="metricstimeend") String metricsTimeEnd) {
        return this.getApp(req, res, null, appId, flowName, flowRunId, userId, confsToRetrieve, metricsToRetrieve, fields, metricsLimit, metricsTimeStart, metricsTimeEnd);
    }

    @GET
    @Path(value="/clusters/{clusterid}/apps/{appid}/")
    @Produces(value={"application/json; charset=utf-8"})
    public TimelineEntity getApp(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="clusterid") String clusterId, @PathParam(value="appid") String appId, @QueryParam(value="flowname") String flowName, @QueryParam(value="flowrunid") String flowRunId, @QueryParam(value="userid") String userId, @QueryParam(value="confstoretrieve") String confsToRetrieve, @QueryParam(value="metricstoretrieve") String metricsToRetrieve, @QueryParam(value="fields") String fields, @QueryParam(value="metricslimit") String metricsLimit, @QueryParam(value="metricstimestart") String metricsTimeStart, @QueryParam(value="metricstimeend") String metricsTimeEnd) {
        String url = req.getRequestURI() + (req.getQueryString() == null ? "" : QUERY_STRING_SEP + req.getQueryString());
        UserGroupInformation callerUGI = TimelineReaderWebServicesUtils.getUser(req);
        LOG.info("Received URL " + url + " from user " + TimelineReaderWebServicesUtils.getUserName(callerUGI));
        long startTime = Time.monotonicNow();
        this.init(res);
        TimelineReaderManager timelineReaderManager = this.getTimelineReaderManager();
        TimelineEntity entity = null;
        try {
            entity = timelineReaderManager.getEntity(TimelineReaderWebServicesUtils.createTimelineReaderContext(clusterId, userId, flowName, flowRunId, appId, TimelineEntityType.YARN_APPLICATION.toString(), null, null), TimelineReaderWebServicesUtils.createTimelineDataToRetrieve(confsToRetrieve, metricsToRetrieve, fields, metricsLimit, metricsTimeStart, metricsTimeEnd));
        }
        catch (Exception e) {
            TimelineReaderWebServices.handleException(e, url, startTime, "flowrunid");
        }
        long endTime = Time.monotonicNow();
        if (entity == null) {
            LOG.info("Processed URL " + url + " but app not found (Took " + (endTime - startTime) + " ms.)");
            throw new NotFoundException("App " + appId + " not found");
        }
        LOG.info("Processed URL " + url + " (Took " + (endTime - startTime) + " ms.)");
        return entity;
    }

    @GET
    @Path(value="/run-uid/{uid}/apps")
    @Produces(value={"application/json; charset=utf-8"})
    public Set<TimelineEntity> getFlowRunApps(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="uid") String uId, @QueryParam(value="limit") String limit, @QueryParam(value="createdtimestart") String createdTimeStart, @QueryParam(value="createdtimeend") String createdTimeEnd, @QueryParam(value="relatesto") String relatesTo, @QueryParam(value="isrelatedto") String isRelatedTo, @QueryParam(value="infofilters") String infofilters, @QueryParam(value="conffilters") String conffilters, @QueryParam(value="metricfilters") String metricfilters, @QueryParam(value="eventfilters") String eventfilters, @QueryParam(value="confstoretrieve") String confsToRetrieve, @QueryParam(value="metricstoretrieve") String metricsToRetrieve, @QueryParam(value="fields") String fields, @QueryParam(value="metricslimit") String metricsLimit, @QueryParam(value="metricstimestart") String metricsTimeStart, @QueryParam(value="metricstimeend") String metricsTimeEnd, @QueryParam(value="fromid") String fromId) {
        String url = req.getRequestURI() + (req.getQueryString() == null ? "" : QUERY_STRING_SEP + req.getQueryString());
        UserGroupInformation callerUGI = TimelineReaderWebServicesUtils.getUser(req);
        LOG.info("Received URL " + url + " from user " + TimelineReaderWebServicesUtils.getUserName(callerUGI));
        long startTime = Time.monotonicNow();
        this.init(res);
        TimelineReaderManager timelineReaderManager = this.getTimelineReaderManager();
        Set<TimelineEntity> entities = null;
        try {
            TimelineReaderContext context = TimelineUIDConverter.FLOWRUN_UID.decodeUID(uId);
            if (context == null) {
                throw new BadRequestException("Incorrect UID " + uId);
            }
            context.setEntityType(TimelineEntityType.YARN_APPLICATION.toString());
            entities = timelineReaderManager.getEntities(context, TimelineReaderWebServicesUtils.createTimelineEntityFilters(limit, createdTimeStart, createdTimeEnd, relatesTo, isRelatedTo, infofilters, conffilters, metricfilters, eventfilters, fromId), TimelineReaderWebServicesUtils.createTimelineDataToRetrieve(confsToRetrieve, metricsToRetrieve, fields, metricsLimit, metricsTimeStart, metricsTimeEnd));
        }
        catch (Exception e) {
            TimelineReaderWebServices.handleException(e, url, startTime, "createdTime start/end or limit or flowrunid");
        }
        long endTime = Time.monotonicNow();
        if (entities == null) {
            entities = Collections.emptySet();
        }
        LOG.info("Processed URL " + url + " (Took " + (endTime - startTime) + " ms.)");
        return entities;
    }

    @GET
    @Path(value="/users/{userid}/flows/{flowname}/runs/{flowrunid}/apps/")
    @Produces(value={"application/json; charset=utf-8"})
    public Set<TimelineEntity> getFlowRunApps(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="userid") String userId, @PathParam(value="flowname") String flowName, @PathParam(value="flowrunid") String flowRunId, @QueryParam(value="limit") String limit, @QueryParam(value="createdtimestart") String createdTimeStart, @QueryParam(value="createdtimeend") String createdTimeEnd, @QueryParam(value="relatesto") String relatesTo, @QueryParam(value="isrelatedto") String isRelatedTo, @QueryParam(value="infofilters") String infofilters, @QueryParam(value="conffilters") String conffilters, @QueryParam(value="metricfilters") String metricfilters, @QueryParam(value="eventfilters") String eventfilters, @QueryParam(value="confstoretrieve") String confsToRetrieve, @QueryParam(value="metricstoretrieve") String metricsToRetrieve, @QueryParam(value="fields") String fields, @QueryParam(value="metricslimit") String metricsLimit, @QueryParam(value="metricstimestart") String metricsTimeStart, @QueryParam(value="metricstimeend") String metricsTimeEnd, @QueryParam(value="fromid") String fromId) {
        return this.getEntities(req, res, null, null, TimelineEntityType.YARN_APPLICATION.toString(), userId, flowName, flowRunId, limit, createdTimeStart, createdTimeEnd, relatesTo, isRelatedTo, infofilters, conffilters, metricfilters, eventfilters, confsToRetrieve, metricsToRetrieve, fields, metricsLimit, metricsTimeStart, metricsTimeEnd, fromId);
    }

    @GET
    @Path(value="/clusters/{clusterid}/users/{userid}/flows/{flowname}/runs/{flowrunid}/apps/")
    @Produces(value={"application/json; charset=utf-8"})
    public Set<TimelineEntity> getFlowRunApps(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="clusterid") String clusterId, @PathParam(value="userid") String userId, @PathParam(value="flowname") String flowName, @PathParam(value="flowrunid") String flowRunId, @QueryParam(value="limit") String limit, @QueryParam(value="createdtimestart") String createdTimeStart, @QueryParam(value="createdtimeend") String createdTimeEnd, @QueryParam(value="relatesto") String relatesTo, @QueryParam(value="isrelatedto") String isRelatedTo, @QueryParam(value="infofilters") String infofilters, @QueryParam(value="conffilters") String conffilters, @QueryParam(value="metricfilters") String metricfilters, @QueryParam(value="eventfilters") String eventfilters, @QueryParam(value="confstoretrieve") String confsToRetrieve, @QueryParam(value="metricstoretrieve") String metricsToRetrieve, @QueryParam(value="fields") String fields, @QueryParam(value="metricslimit") String metricsLimit, @QueryParam(value="metricstimestart") String metricsTimeStart, @QueryParam(value="metricstimeend") String metricsTimeEnd, @QueryParam(value="fromid") String fromId) {
        return this.getEntities(req, res, clusterId, null, TimelineEntityType.YARN_APPLICATION.toString(), userId, flowName, flowRunId, limit, createdTimeStart, createdTimeEnd, relatesTo, isRelatedTo, infofilters, conffilters, metricfilters, eventfilters, confsToRetrieve, metricsToRetrieve, fields, metricsLimit, metricsTimeStart, metricsTimeEnd, fromId);
    }

    @GET
    @Path(value="/users/{userid}/flows/{flowname}/apps/")
    @Produces(value={"application/json; charset=utf-8"})
    public Set<TimelineEntity> getFlowApps(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="userid") String userId, @PathParam(value="flowname") String flowName, @QueryParam(value="limit") String limit, @QueryParam(value="createdtimestart") String createdTimeStart, @QueryParam(value="createdtimeend") String createdTimeEnd, @QueryParam(value="relatesto") String relatesTo, @QueryParam(value="isrelatedto") String isRelatedTo, @QueryParam(value="infofilters") String infofilters, @QueryParam(value="conffilters") String conffilters, @QueryParam(value="metricfilters") String metricfilters, @QueryParam(value="eventfilters") String eventfilters, @QueryParam(value="confstoretrieve") String confsToRetrieve, @QueryParam(value="metricstoretrieve") String metricsToRetrieve, @QueryParam(value="fields") String fields, @QueryParam(value="metricslimit") String metricsLimit, @QueryParam(value="metricstimestart") String metricsTimeStart, @QueryParam(value="metricstimeend") String metricsTimeEnd, @QueryParam(value="fromid") String fromId) {
        return this.getEntities(req, res, null, null, TimelineEntityType.YARN_APPLICATION.toString(), userId, flowName, null, limit, createdTimeStart, createdTimeEnd, relatesTo, isRelatedTo, infofilters, conffilters, metricfilters, eventfilters, confsToRetrieve, metricsToRetrieve, fields, metricsLimit, metricsTimeStart, metricsTimeEnd, fromId);
    }

    @GET
    @Path(value="/clusters/{clusterid}/users/{userid}/flows/{flowname}/apps/")
    @Produces(value={"application/json; charset=utf-8"})
    public Set<TimelineEntity> getFlowApps(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="clusterid") String clusterId, @PathParam(value="userid") String userId, @PathParam(value="flowname") String flowName, @QueryParam(value="limit") String limit, @QueryParam(value="createdtimestart") String createdTimeStart, @QueryParam(value="createdtimeend") String createdTimeEnd, @QueryParam(value="relatesto") String relatesTo, @QueryParam(value="isrelatedto") String isRelatedTo, @QueryParam(value="infofilters") String infofilters, @QueryParam(value="conffilters") String conffilters, @QueryParam(value="metricfilters") String metricfilters, @QueryParam(value="eventfilters") String eventfilters, @QueryParam(value="confstoretrieve") String confsToRetrieve, @QueryParam(value="metricstoretrieve") String metricsToRetrieve, @QueryParam(value="fields") String fields, @QueryParam(value="metricslimit") String metricsLimit, @QueryParam(value="metricstimestart") String metricsTimeStart, @QueryParam(value="metricstimeend") String metricsTimeEnd, @QueryParam(value="fromid") String fromId) {
        return this.getEntities(req, res, clusterId, null, TimelineEntityType.YARN_APPLICATION.toString(), userId, flowName, null, limit, createdTimeStart, createdTimeEnd, relatesTo, isRelatedTo, infofilters, conffilters, metricfilters, eventfilters, confsToRetrieve, metricsToRetrieve, fields, metricsLimit, metricsTimeStart, metricsTimeEnd, fromId);
    }

    @GET
    @Path(value="/apps/{appid}/appattempts")
    @Produces(value={"application/json"})
    public Set<TimelineEntity> getAppAttempts(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="appid") String appId, @QueryParam(value="userid") String userId, @QueryParam(value="flowname") String flowName, @QueryParam(value="flowrunid") String flowRunId, @QueryParam(value="limit") String limit, @QueryParam(value="createdtimestart") String createdTimeStart, @QueryParam(value="createdtimeend") String createdTimeEnd, @QueryParam(value="relatesto") String relatesTo, @QueryParam(value="isrelatedto") String isRelatedTo, @QueryParam(value="infofilters") String infofilters, @QueryParam(value="conffilters") String conffilters, @QueryParam(value="metricfilters") String metricfilters, @QueryParam(value="eventfilters") String eventfilters, @QueryParam(value="confstoretrieve") String confsToRetrieve, @QueryParam(value="metricstoretrieve") String metricsToRetrieve, @QueryParam(value="fields") String fields, @QueryParam(value="metricslimit") String metricsLimit, @QueryParam(value="metricstimestart") String metricsTimeStart, @QueryParam(value="metricstimeend") String metricsTimeEnd, @QueryParam(value="fromid") String fromId) {
        return this.getAppAttempts(req, res, null, appId, userId, flowName, flowRunId, limit, createdTimeStart, createdTimeEnd, relatesTo, isRelatedTo, infofilters, conffilters, metricfilters, eventfilters, confsToRetrieve, metricsToRetrieve, fields, metricsLimit, metricsTimeStart, metricsTimeEnd, fromId);
    }

    @GET
    @Path(value="/clusters/{clusterid}/apps/{appid}/appattempts")
    @Produces(value={"application/json"})
    public Set<TimelineEntity> getAppAttempts(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="clusterid") String clusterId, @PathParam(value="appid") String appId, @QueryParam(value="userid") String userId, @QueryParam(value="flowname") String flowName, @QueryParam(value="flowrunid") String flowRunId, @QueryParam(value="limit") String limit, @QueryParam(value="createdtimestart") String createdTimeStart, @QueryParam(value="createdtimeend") String createdTimeEnd, @QueryParam(value="relatesto") String relatesTo, @QueryParam(value="isrelatedto") String isRelatedTo, @QueryParam(value="infofilters") String infofilters, @QueryParam(value="conffilters") String conffilters, @QueryParam(value="metricfilters") String metricfilters, @QueryParam(value="eventfilters") String eventfilters, @QueryParam(value="confstoretrieve") String confsToRetrieve, @QueryParam(value="metricstoretrieve") String metricsToRetrieve, @QueryParam(value="fields") String fields, @QueryParam(value="metricslimit") String metricsLimit, @QueryParam(value="metricstimestart") String metricsTimeStart, @QueryParam(value="metricstimeend") String metricsTimeEnd, @QueryParam(value="fromid") String fromId) {
        return this.getEntities(req, res, clusterId, appId, TimelineEntityType.YARN_APPLICATION_ATTEMPT.toString(), userId, flowName, flowRunId, limit, createdTimeStart, createdTimeEnd, relatesTo, isRelatedTo, infofilters, conffilters, metricfilters, eventfilters, confsToRetrieve, metricsToRetrieve, fields, metricsLimit, metricsTimeStart, metricsTimeEnd, fromId);
    }

    @GET
    @Path(value="/apps/{appid}/appattempts/{appattemptid}")
    @Produces(value={"application/json"})
    public TimelineEntity getAppAttempt(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="appid") String appId, @PathParam(value="appattemptid") String appAttemptId, @QueryParam(value="userid") String userId, @QueryParam(value="flowname") String flowName, @QueryParam(value="flowrunid") String flowRunId, @QueryParam(value="confstoretrieve") String confsToRetrieve, @QueryParam(value="metricstoretrieve") String metricsToRetrieve, @QueryParam(value="fields") String fields, @QueryParam(value="metricslimit") String metricsLimit, @QueryParam(value="metricstimestart") String metricsTimeStart, @QueryParam(value="metricstimeend") String metricsTimeEnd, @QueryParam(value="entityidprefix") String entityIdPrefix) {
        return this.getAppAttempt(req, res, null, appId, appAttemptId, userId, flowName, flowRunId, confsToRetrieve, metricsToRetrieve, fields, metricsLimit, metricsTimeStart, metricsTimeEnd, entityIdPrefix);
    }

    @GET
    @Path(value="/clusters/{clusterid}/apps/{appid}/appattempts/{appattemptid}")
    @Produces(value={"application/json"})
    public TimelineEntity getAppAttempt(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="clusterid") String clusterId, @PathParam(value="appid") String appId, @PathParam(value="appattemptid") String appAttemptId, @QueryParam(value="userid") String userId, @QueryParam(value="flowname") String flowName, @QueryParam(value="flowrunid") String flowRunId, @QueryParam(value="confstoretrieve") String confsToRetrieve, @QueryParam(value="metricstoretrieve") String metricsToRetrieve, @QueryParam(value="fields") String fields, @QueryParam(value="metricslimit") String metricsLimit, @QueryParam(value="metricstimestart") String metricsTimeStart, @QueryParam(value="metricstimeend") String metricsTimeEnd, @QueryParam(value="entityidprefix") String entityIdPrefix) {
        return this.getEntity(req, res, clusterId, appId, TimelineEntityType.YARN_APPLICATION_ATTEMPT.toString(), appAttemptId, userId, flowName, flowRunId, confsToRetrieve, metricsToRetrieve, fields, metricsLimit, metricsTimeStart, metricsTimeEnd, entityIdPrefix);
    }

    @GET
    @Path(value="/apps/{appid}/appattempts/{appattemptid}/containers")
    @Produces(value={"application/json"})
    public Set<TimelineEntity> getContainers(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="appid") String appId, @PathParam(value="appattemptid") String appattemptId, @QueryParam(value="userid") String userId, @QueryParam(value="flowname") String flowName, @QueryParam(value="flowrunid") String flowRunId, @QueryParam(value="limit") String limit, @QueryParam(value="createdtimestart") String createdTimeStart, @QueryParam(value="createdtimeend") String createdTimeEnd, @QueryParam(value="relatesto") String relatesTo, @QueryParam(value="isrelatedto") String isRelatedTo, @QueryParam(value="infofilters") String infofilters, @QueryParam(value="conffilters") String conffilters, @QueryParam(value="metricfilters") String metricfilters, @QueryParam(value="eventfilters") String eventfilters, @QueryParam(value="confstoretrieve") String confsToRetrieve, @QueryParam(value="metricstoretrieve") String metricsToRetrieve, @QueryParam(value="fields") String fields, @QueryParam(value="metricslimit") String metricsLimit, @QueryParam(value="metricstimestart") String metricsTimeStart, @QueryParam(value="metricstimeend") String metricsTimeEnd, @QueryParam(value="fromid") String fromId) {
        return this.getContainers(req, res, null, appId, appattemptId, userId, flowName, flowRunId, limit, createdTimeStart, createdTimeEnd, relatesTo, isRelatedTo, infofilters, conffilters, metricfilters, eventfilters, confsToRetrieve, metricsToRetrieve, fields, metricsLimit, metricsTimeStart, metricsTimeEnd, fromId);
    }

    @GET
    @Path(value="/clusters/{clusterid}/apps/{appid}/appattempts/{appattemptid}/containers")
    @Produces(value={"application/json"})
    public Set<TimelineEntity> getContainers(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="clusterid") String clusterId, @PathParam(value="appid") String appId, @PathParam(value="appattemptid") String appattemptId, @QueryParam(value="userid") String userId, @QueryParam(value="flowname") String flowName, @QueryParam(value="flowrunid") String flowRunId, @QueryParam(value="limit") String limit, @QueryParam(value="createdtimestart") String createdTimeStart, @QueryParam(value="createdtimeend") String createdTimeEnd, @QueryParam(value="relatesto") String relatesTo, @QueryParam(value="isrelatedto") String isRelatedTo, @QueryParam(value="infofilters") String infofilters, @QueryParam(value="conffilters") String conffilters, @QueryParam(value="metricfilters") String metricfilters, @QueryParam(value="eventfilters") String eventfilters, @QueryParam(value="confstoretrieve") String confsToRetrieve, @QueryParam(value="metricstoretrieve") String metricsToRetrieve, @QueryParam(value="fields") String fields, @QueryParam(value="metricslimit") String metricsLimit, @QueryParam(value="metricstimestart") String metricsTimeStart, @QueryParam(value="metricstimeend") String metricsTimeEnd, @QueryParam(value="fromid") String fromId) {
        String entityType = TimelineEntityType.YARN_CONTAINER.toString();
        String parentEntityType = TimelineEntityType.YARN_APPLICATION_ATTEMPT.toString();
        String jsonFormatString = "{\"type\":\"" + parentEntityType + "\",\"id\":\"" + appattemptId + "\"}";
        String containerFilters = "SYSTEM_INFO_PARENT_ENTITY eq " + jsonFormatString;
        String infofilter = infofilters != null ? containerFilters + " AND " + infofilters : containerFilters;
        return this.getEntities(req, res, clusterId, appId, entityType, userId, flowName, flowRunId, limit, createdTimeStart, createdTimeEnd, relatesTo, isRelatedTo, infofilter, conffilters, metricfilters, eventfilters, confsToRetrieve, metricsToRetrieve, fields, metricsLimit, metricsTimeStart, metricsTimeEnd, fromId);
    }

    @GET
    @Path(value="/apps/{appid}/containers/{containerid}")
    @Produces(value={"application/json"})
    public TimelineEntity getContainer(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="appid") String appId, @PathParam(value="containerid") String containerId, @QueryParam(value="userid") String userId, @QueryParam(value="flowname") String flowName, @QueryParam(value="flowrunid") String flowRunId, @QueryParam(value="confstoretrieve") String confsToRetrieve, @QueryParam(value="metricstoretrieve") String metricsToRetrieve, @QueryParam(value="fields") String fields, @QueryParam(value="metricslimit") String metricsLimit, @QueryParam(value="metricstimestart") String metricsTimeStart, @QueryParam(value="metricstimeend") String metricsTimeEnd, @QueryParam(value="entityidprefix") String entityIdPrefix) {
        return this.getContainer(req, res, null, appId, containerId, userId, flowName, flowRunId, confsToRetrieve, metricsToRetrieve, fields, metricsLimit, entityIdPrefix, metricsTimeStart, metricsTimeEnd);
    }

    @GET
    @Path(value="/clusters/{clusterid}/apps/{appid}/containers/{containerid}")
    @Produces(value={"application/json"})
    public TimelineEntity getContainer(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="clusterid") String clusterId, @PathParam(value="appid") String appId, @PathParam(value="containerid") String containerId, @QueryParam(value="userid") String userId, @QueryParam(value="flowname") String flowName, @QueryParam(value="flowrunid") String flowRunId, @QueryParam(value="confstoretrieve") String confsToRetrieve, @QueryParam(value="metricstoretrieve") String metricsToRetrieve, @QueryParam(value="fields") String fields, @QueryParam(value="metricslimit") String metricsLimit, @QueryParam(value="metricstimestart") String metricsTimeStart, @QueryParam(value="metricstimeend") String metricsTimeEnd, @QueryParam(value="entityidprefix") String entityIdPrefix) {
        return this.getEntity(req, res, clusterId, appId, TimelineEntityType.YARN_CONTAINER.toString(), containerId, userId, flowName, flowRunId, confsToRetrieve, metricsToRetrieve, fields, metricsLimit, metricsTimeStart, metricsTimeEnd, entityIdPrefix);
    }

    @GET
    @Path(value="/apps/{appid}/entity-types")
    @Produces(value={"application/json"})
    public Set<String> getEntityTypes(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="appid") String appId, @QueryParam(value="flowname") String flowName, @QueryParam(value="flowrunid") String flowRunId, @QueryParam(value="userid") String userId) {
        return this.getEntityTypes(req, res, null, appId, flowName, flowRunId, userId);
    }

    @GET
    @Path(value="/clusters/{clusterid}/apps/{appid}/entity-types")
    @Produces(value={"application/json"})
    public Set<String> getEntityTypes(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="clusterid") String clusterId, @PathParam(value="appid") String appId, @QueryParam(value="flowname") String flowName, @QueryParam(value="flowrunid") String flowRunId, @QueryParam(value="userid") String userId) {
        String url = req.getRequestURI() + (req.getQueryString() == null ? "" : QUERY_STRING_SEP + req.getQueryString());
        UserGroupInformation callerUGI = TimelineReaderWebServicesUtils.getUser(req);
        LOG.info("Received URL " + url + " from user " + TimelineReaderWebServicesUtils.getUserName(callerUGI));
        long startTime = Time.monotonicNow();
        this.init(res);
        TimelineReaderManager timelineReaderManager = this.getTimelineReaderManager();
        Set<String> results = null;
        try {
            results = timelineReaderManager.getEntityTypes(TimelineReaderWebServicesUtils.createTimelineReaderContext(clusterId, userId, flowName, flowRunId, appId, null, null, null));
        }
        catch (Exception e) {
            TimelineReaderWebServices.handleException(e, url, startTime, "flowrunid");
        }
        long endTime = Time.monotonicNow();
        LOG.info("Processed URL " + url + " (Took " + (endTime - startTime) + " ms.)");
        return results;
    }

    @GET
    @Path(value="/users/{userid}/entities/{entitytype}")
    @Produces(value={"application/json; charset=utf-8"})
    public Set<TimelineEntity> getSubAppEntities(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="userid") String userId, @PathParam(value="entitytype") String entityType, @QueryParam(value="limit") String limit, @QueryParam(value="createdtimestart") String createdTimeStart, @QueryParam(value="createdtimeend") String createdTimeEnd, @QueryParam(value="relatesto") String relatesTo, @QueryParam(value="isrelatedto") String isRelatedTo, @QueryParam(value="infofilters") String infofilters, @QueryParam(value="conffilters") String conffilters, @QueryParam(value="metricfilters") String metricfilters, @QueryParam(value="eventfilters") String eventfilters, @QueryParam(value="confstoretrieve") String confsToRetrieve, @QueryParam(value="metricstoretrieve") String metricsToRetrieve, @QueryParam(value="fields") String fields, @QueryParam(value="metricslimit") String metricsLimit, @QueryParam(value="metricstimestart") String metricsTimeStart, @QueryParam(value="metricstimeend") String metricsTimeEnd, @QueryParam(value="fromid") String fromId) {
        return this.getSubAppEntities(req, res, null, userId, entityType, limit, createdTimeStart, createdTimeEnd, relatesTo, isRelatedTo, infofilters, conffilters, metricfilters, eventfilters, confsToRetrieve, metricsToRetrieve, fields, metricsLimit, metricsTimeStart, metricsTimeEnd, fromId);
    }

    @GET
    @Path(value="/clusters/{clusterid}/users/{userid}/entities/{entitytype}")
    @Produces(value={"application/json; charset=utf-8"})
    public Set<TimelineEntity> getSubAppEntities(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="clusterid") String clusterId, @PathParam(value="userid") String userId, @PathParam(value="entitytype") String entityType, @QueryParam(value="limit") String limit, @QueryParam(value="createdtimestart") String createdTimeStart, @QueryParam(value="createdtimeend") String createdTimeEnd, @QueryParam(value="relatesto") String relatesTo, @QueryParam(value="isrelatedto") String isRelatedTo, @QueryParam(value="infofilters") String infofilters, @QueryParam(value="conffilters") String conffilters, @QueryParam(value="metricfilters") String metricfilters, @QueryParam(value="eventfilters") String eventfilters, @QueryParam(value="confstoretrieve") String confsToRetrieve, @QueryParam(value="metricstoretrieve") String metricsToRetrieve, @QueryParam(value="fields") String fields, @QueryParam(value="metricslimit") String metricsLimit, @QueryParam(value="metricstimestart") String metricsTimeStart, @QueryParam(value="metricstimeend") String metricsTimeEnd, @QueryParam(value="fromid") String fromId) {
        String url = req.getRequestURI() + (req.getQueryString() == null ? "" : QUERY_STRING_SEP + req.getQueryString());
        UserGroupInformation callerUGI = TimelineReaderWebServicesUtils.getUser(req);
        LOG.info("Received URL " + url + " from user " + TimelineReaderWebServicesUtils.getUserName(callerUGI));
        long startTime = Time.monotonicNow();
        this.init(res);
        TimelineReaderManager timelineReaderManager = this.getTimelineReaderManager();
        Set<TimelineEntity> entities = null;
        try {
            TimelineReaderContext context = TimelineReaderWebServicesUtils.createTimelineReaderContext(clusterId, null, null, null, null, entityType, null, null, userId);
            entities = timelineReaderManager.getEntities(context, TimelineReaderWebServicesUtils.createTimelineEntityFilters(limit, createdTimeStart, createdTimeEnd, relatesTo, isRelatedTo, infofilters, conffilters, metricfilters, eventfilters, fromId), TimelineReaderWebServicesUtils.createTimelineDataToRetrieve(confsToRetrieve, metricsToRetrieve, fields, metricsLimit, metricsTimeStart, metricsTimeEnd));
        }
        catch (Exception e) {
            TimelineReaderWebServices.handleException(e, url, startTime, "createdTime start/end or limit");
        }
        long endTime = Time.monotonicNow();
        if (entities == null) {
            entities = Collections.emptySet();
        }
        LOG.info("Processed URL " + url + " (Took " + (endTime - startTime) + " ms.)");
        return entities;
    }

    @GET
    @Path(value="/users/{userid}/entities/{entitytype}/{entityid}")
    @Produces(value={"application/json; charset=utf-8"})
    public Set<TimelineEntity> getSubAppEntities(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="userid") String userId, @PathParam(value="entitytype") String entityType, @PathParam(value="entityid") String entityId, @QueryParam(value="confstoretrieve") String confsToRetrieve, @QueryParam(value="metricstoretrieve") String metricsToRetrieve, @QueryParam(value="fields") String fields, @QueryParam(value="metricslimit") String metricsLimit, @QueryParam(value="metricstimestart") String metricsTimeStart, @QueryParam(value="metricstimeend") String metricsTimeEnd, @QueryParam(value="entityidprefix") String entityIdPrefix) {
        return this.getSubAppEntities(req, res, null, userId, entityType, entityId, confsToRetrieve, metricsToRetrieve, fields, metricsLimit, metricsTimeStart, metricsTimeEnd, entityIdPrefix);
    }

    @GET
    @Path(value="/clusters/{clusterid}/users/{userid}/entities/{entitytype}/{entityid}")
    @Produces(value={"application/json; charset=utf-8"})
    public Set<TimelineEntity> getSubAppEntities(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="clusterid") String clusterId, @PathParam(value="userid") String userId, @PathParam(value="entitytype") String entityType, @PathParam(value="entityid") String entityId, @QueryParam(value="confstoretrieve") String confsToRetrieve, @QueryParam(value="metricstoretrieve") String metricsToRetrieve, @QueryParam(value="fields") String fields, @QueryParam(value="metricslimit") String metricsLimit, @QueryParam(value="metricstimestart") String metricsTimeStart, @QueryParam(value="metricstimeend") String metricsTimeEnd, @QueryParam(value="entityidprefix") String entityIdPrefix) {
        String url = req.getRequestURI() + (req.getQueryString() == null ? "" : QUERY_STRING_SEP + req.getQueryString());
        UserGroupInformation callerUGI = TimelineReaderWebServicesUtils.getUser(req);
        LOG.info("Received URL " + url + " from user " + TimelineReaderWebServicesUtils.getUserName(callerUGI));
        long startTime = Time.monotonicNow();
        this.init(res);
        TimelineReaderManager timelineReaderManager = this.getTimelineReaderManager();
        Set<TimelineEntity> entities = null;
        try {
            TimelineReaderContext context = TimelineReaderWebServicesUtils.createTimelineReaderContext(clusterId, null, null, null, null, entityType, entityIdPrefix, entityId, userId);
            entities = timelineReaderManager.getEntities(context, new TimelineEntityFilters.Builder().build(), TimelineReaderWebServicesUtils.createTimelineDataToRetrieve(confsToRetrieve, metricsToRetrieve, fields, metricsLimit, metricsTimeStart, metricsTimeEnd));
        }
        catch (Exception e) {
            TimelineReaderWebServices.handleException(e, url, startTime, "");
        }
        long endTime = Time.monotonicNow();
        if (entities == null) {
            entities = Collections.emptySet();
        }
        LOG.info("Processed URL " + url + " (Took " + (endTime - startTime) + " ms.)");
        return entities;
    }

    private static final class DateRange {
        private Long dateStart;
        private Long dateEnd;

        private DateRange(Long start, Long end) {
            this.dateStart = start;
            this.dateEnd = end;
        }
    }
}

