/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.collector;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.api.CollectorNodemanagerProtocol;
import org.apache.hadoop.yarn.server.api.ContainerInitializationContext;
import org.apache.hadoop.yarn.server.api.ContainerTerminationContext;
import org.apache.hadoop.yarn.server.api.ContainerType;
import org.apache.hadoop.yarn.server.api.protocolrecords.GetTimelineCollectorContextRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.GetTimelineCollectorContextResponse;
import org.apache.hadoop.yarn.server.timelineservice.collector.NodeTimelineCollectorManager;
import org.apache.hadoop.yarn.server.timelineservice.collector.PerNodeTimelineCollectorsAuxService;
import org.apache.hadoop.yarn.server.timelineservice.storage.FileSystemTimelineWriterImpl;
import org.apache.hadoop.yarn.server.timelineservice.storage.TimelineWriter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class TestPerNodeTimelineCollectorsAuxService {
    private ApplicationAttemptId appAttemptId;
    private PerNodeTimelineCollectorsAuxService auxService;
    private Configuration conf;

    public TestPerNodeTimelineCollectorsAuxService() {
        ApplicationId appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        this.appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        this.conf = new YarnConfiguration();
        this.conf.setBoolean("yarn.timeline-service.enabled", true);
        this.conf.setFloat("yarn.timeline-service.version", 2.0f);
        this.conf.setClass("yarn.timeline-service.writer.class", FileSystemTimelineWriterImpl.class, TimelineWriter.class);
        this.conf.setLong("yarn.timeline-service.app-collector.linger-period.ms", 1000L);
    }

    @After
    public void tearDown() throws Shell.ExitCodeException {
        if (this.auxService != null) {
            this.auxService.stop();
        }
    }

    @Test
    public void testAddApplication() throws Exception {
        this.auxService = this.createCollectorAndAddApplication();
        Assert.assertTrue((boolean)this.auxService.hasApplication(this.appAttemptId.getApplicationId()));
        this.auxService.close();
    }

    @Test
    public void testAddApplicationNonAMContainer() throws Exception {
        this.auxService = this.createCollector();
        ContainerId containerId = this.getContainerId(2L);
        ContainerInitializationContext context = (ContainerInitializationContext)Mockito.mock(ContainerInitializationContext.class);
        Mockito.when((Object)context.getContainerId()).thenReturn((Object)containerId);
        this.auxService.initializeContainer(context);
        Assert.assertFalse((boolean)this.auxService.hasApplication(this.appAttemptId.getApplicationId()));
    }

    @Test
    public void testRemoveApplication() throws Exception {
        this.auxService = this.createCollectorAndAddApplication();
        Assert.assertTrue((boolean)this.auxService.hasApplication(this.appAttemptId.getApplicationId()));
        ContainerId containerId = this.getAMContainerId();
        ContainerTerminationContext context = (ContainerTerminationContext)Mockito.mock(ContainerTerminationContext.class);
        Mockito.when((Object)context.getContainerId()).thenReturn((Object)containerId);
        Mockito.when((Object)context.getContainerType()).thenReturn((Object)ContainerType.APPLICATION_MASTER);
        this.auxService.stopContainer(context);
        Assert.assertTrue((boolean)this.auxService.hasApplication(this.appAttemptId.getApplicationId()));
        for (int i = 0; i < 4; ++i) {
            Thread.sleep(500L);
            if (!this.auxService.hasApplication(this.appAttemptId.getApplicationId())) break;
        }
        Assert.assertFalse((boolean)this.auxService.hasApplication(this.appAttemptId.getApplicationId()));
        this.auxService.close();
    }

    @Test
    public void testRemoveApplicationNonAMContainer() throws Exception {
        this.auxService = this.createCollectorAndAddApplication();
        Assert.assertTrue((boolean)this.auxService.hasApplication(this.appAttemptId.getApplicationId()));
        ContainerId containerId = this.getContainerId(2L);
        ContainerTerminationContext context = (ContainerTerminationContext)Mockito.mock(ContainerTerminationContext.class);
        Mockito.when((Object)context.getContainerId()).thenReturn((Object)containerId);
        this.auxService.stopContainer(context);
        Assert.assertTrue((boolean)this.auxService.hasApplication(this.appAttemptId.getApplicationId()));
        this.auxService.close();
    }

    @Test(timeout=60000L)
    public void testLaunch() throws Exception {
        ExitUtil.disableSystemExit();
        try {
            this.auxService = PerNodeTimelineCollectorsAuxService.launchServer((String[])new String[0], (NodeTimelineCollectorManager)this.createCollectorManager(), (Configuration)this.conf);
        }
        catch (ExitUtil.ExitException e) {
            Assert.assertEquals((long)0L, (long)e.status);
            ExitUtil.resetFirstExitException();
            Assert.fail();
        }
    }

    private PerNodeTimelineCollectorsAuxService createCollectorAndAddApplication() {
        PerNodeTimelineCollectorsAuxService service = this.createCollector();
        ContainerId containerId = this.getAMContainerId();
        ContainerInitializationContext context = (ContainerInitializationContext)Mockito.mock(ContainerInitializationContext.class);
        Mockito.when((Object)context.getContainerId()).thenReturn((Object)containerId);
        Mockito.when((Object)context.getContainerType()).thenReturn((Object)ContainerType.APPLICATION_MASTER);
        service.initializeContainer(context);
        return service;
    }

    private PerNodeTimelineCollectorsAuxService createCollector() {
        NodeTimelineCollectorManager collectorManager = this.createCollectorManager();
        PerNodeTimelineCollectorsAuxService service = (PerNodeTimelineCollectorsAuxService)Mockito.spy((Object)new PerNodeTimelineCollectorsAuxService(collectorManager));
        service.init(this.conf);
        service.start();
        return service;
    }

    private NodeTimelineCollectorManager createCollectorManager() {
        NodeTimelineCollectorManager collectorManager = (NodeTimelineCollectorManager)Mockito.spy((Object)new NodeTimelineCollectorManager());
        ((NodeTimelineCollectorManager)Mockito.doReturn((Object)new Configuration()).when((Object)collectorManager)).getConfig();
        CollectorNodemanagerProtocol nmCollectorService = (CollectorNodemanagerProtocol)Mockito.mock(CollectorNodemanagerProtocol.class);
        GetTimelineCollectorContextResponse response = GetTimelineCollectorContextResponse.newInstance(null, null, null, (long)0L);
        try {
            Mockito.when((Object)nmCollectorService.getTimelineCollectorContext((GetTimelineCollectorContextRequest)Matchers.any(GetTimelineCollectorContextRequest.class))).thenReturn((Object)response);
        }
        catch (IOException | YarnException e) {
            Assert.fail();
        }
        ((NodeTimelineCollectorManager)Mockito.doReturn((Object)nmCollectorService).when((Object)collectorManager)).getNMCollectorService();
        return collectorManager;
    }

    private ContainerId getAMContainerId() {
        return this.getContainerId(1L);
    }

    private ContainerId getContainerId(long id) {
        return ContainerId.newContainerId((ApplicationAttemptId)this.appAttemptId, (long)id);
    }
}

