/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage.subapplication;

import java.io.IOException;
import java.util.Map;
import java.util.NavigableMap;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ColumnFamily;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ColumnHelper;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ColumnPrefix;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.GenericConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.KeyConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.LongConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.Separator;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.TypedBufferedMutator;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ValueConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.Attribute;
import org.apache.hadoop.yarn.server.timelineservice.storage.subapplication.SubApplicationColumnFamily;
import org.apache.hadoop.yarn.server.timelineservice.storage.subapplication.SubApplicationTable;

public enum SubApplicationColumnPrefix implements ColumnPrefix<SubApplicationTable>
{
    IS_RELATED_TO(SubApplicationColumnFamily.INFO, "s"),
    RELATES_TO(SubApplicationColumnFamily.INFO, "r"),
    INFO(SubApplicationColumnFamily.INFO, "i"),
    EVENT((ColumnFamily<SubApplicationTable>)SubApplicationColumnFamily.INFO, "e", true),
    CONFIG(SubApplicationColumnFamily.CONFIGS, null),
    METRIC((ColumnFamily<SubApplicationTable>)SubApplicationColumnFamily.METRICS, null, new LongConverter());

    private final ColumnHelper<SubApplicationTable> column;
    private final ColumnFamily<SubApplicationTable> columnFamily;
    private final String columnPrefix;
    private final byte[] columnPrefixBytes;

    private SubApplicationColumnPrefix(ColumnFamily<SubApplicationTable> columnFamily, String columnPrefix) {
        this(columnFamily, columnPrefix, false, GenericConverter.getInstance());
    }

    private SubApplicationColumnPrefix(ColumnFamily<SubApplicationTable> columnFamily, String columnPrefix, boolean compondColQual) {
        this(columnFamily, columnPrefix, compondColQual, GenericConverter.getInstance());
    }

    private SubApplicationColumnPrefix(ColumnFamily<SubApplicationTable> columnFamily, String columnPrefix, ValueConverter converter) {
        this(columnFamily, columnPrefix, false, converter);
    }

    private SubApplicationColumnPrefix(ColumnFamily<SubApplicationTable> columnFamily, String columnPrefix, boolean compondColQual, ValueConverter converter) {
        this.column = new ColumnHelper<SubApplicationTable>(columnFamily, converter);
        this.columnFamily = columnFamily;
        this.columnPrefix = columnPrefix;
        this.columnPrefixBytes = (byte[])(columnPrefix == null ? null : Bytes.toBytes((String)Separator.SPACE.encode(columnPrefix)));
    }

    public String getColumnPrefix() {
        return this.columnPrefix;
    }

    @Override
    public byte[] getColumnPrefixBytes(byte[] qualifierPrefix) {
        return ColumnHelper.getColumnQualifier(this.columnPrefixBytes, qualifierPrefix);
    }

    @Override
    public byte[] getColumnPrefixBytes(String qualifierPrefix) {
        return ColumnHelper.getColumnQualifier(this.columnPrefixBytes, qualifierPrefix);
    }

    @Override
    public byte[] getColumnFamilyBytes() {
        return this.columnFamily.getBytes();
    }

    @Override
    public ValueConverter getValueConverter() {
        return this.column.getValueConverter();
    }

    @Override
    public void store(byte[] rowKey, TypedBufferedMutator<SubApplicationTable> tableMutator, String qualifier, Long timestamp, Object inputValue, Attribute ... attributes) throws IOException {
        if (qualifier == null) {
            throw new IOException("Cannot store column with null qualifier in " + tableMutator.getName().getNameAsString());
        }
        byte[] columnQualifier = this.getColumnPrefixBytes(qualifier);
        this.column.store(rowKey, tableMutator, columnQualifier, timestamp, inputValue, attributes);
    }

    @Override
    public void store(byte[] rowKey, TypedBufferedMutator<SubApplicationTable> tableMutator, byte[] qualifier, Long timestamp, Object inputValue, Attribute ... attributes) throws IOException {
        if (qualifier == null) {
            throw new IOException("Cannot store column with null qualifier in " + tableMutator.getName().getNameAsString());
        }
        byte[] columnQualifier = this.getColumnPrefixBytes(qualifier);
        this.column.store(rowKey, tableMutator, columnQualifier, timestamp, inputValue, attributes);
    }

    @Override
    public Object readResult(Result result, String qualifier) throws IOException {
        byte[] columnQualifier = ColumnHelper.getColumnQualifier(this.columnPrefixBytes, qualifier);
        return this.column.readResult(result, columnQualifier);
    }

    @Override
    public <K> Map<K, Object> readResults(Result result, KeyConverter<K> keyConverter) throws IOException {
        return this.column.readResults(result, this.columnPrefixBytes, keyConverter);
    }

    @Override
    public <K, V> NavigableMap<K, NavigableMap<Long, V>> readResultsWithTimestamps(Result result, KeyConverter<K> keyConverter) throws IOException {
        return this.column.readResultsWithTimestamps(result, this.columnPrefixBytes, keyConverter);
    }
}

