/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.Range;

public enum Separator {
    QUALIFIERS("!", "%0$"),
    VALUES("=", "%1$"),
    SPACE(" ", "%2$"),
    TAB("\t", "%3$");

    private static final String PERCENT = "%";
    private static final String PERCENT_ENCODED = "%9$";
    private static final Pattern PERCENT_PATTERN;
    private static final String PERCENT_REPLACEMENT;
    private static final Pattern PERCENT_ENCODED_PATTERN;
    private static final String PERCENT_ENCODED_REPLACEMENT;
    private final String value;
    private final byte[] bytes;
    private final Pattern valuePattern;
    private final String valueReplacement;
    private final Pattern encodedValuePattern;
    private final String encodedValueReplacement;
    public static final int VARIABLE_SIZE = 0;
    public static final String EMPTY_STRING = "";
    public static final byte[] EMPTY_BYTES;

    private Separator(String value, String encodedValue) {
        this.value = value;
        if (value == null || value.length() == 0 || encodedValue == null || encodedValue.length() == 0) {
            throw new IllegalArgumentException("Cannot create separator from null or empty string.");
        }
        this.bytes = Bytes.toBytes((String)value);
        this.valuePattern = Pattern.compile(value, 16);
        this.valueReplacement = Matcher.quoteReplacement(value);
        this.encodedValuePattern = Pattern.compile(encodedValue, 16);
        this.encodedValueReplacement = Matcher.quoteReplacement(encodedValue);
    }

    public String getValue() {
        return this.value;
    }

    public String encode(String token) {
        if (token == null || token.length() == 0) {
            return token;
        }
        String escaped = Separator.encodePercent(token);
        return Separator.encodeSingle(escaped, this);
    }

    private static String replace(String token, Pattern pattern, String replacement) {
        return pattern.matcher(token).replaceAll(replacement);
    }

    private static String encodeSingle(String token, Separator separator) {
        return Separator.replace(token, separator.valuePattern, separator.encodedValueReplacement);
    }

    private static String encodePercent(String token) {
        return Separator.replace(token, PERCENT_PATTERN, PERCENT_ENCODED_REPLACEMENT);
    }

    public String decode(String token) {
        if (token == null || token.length() == 0) {
            return token;
        }
        String escaped = Separator.decodeSingle(token, this);
        return Separator.decodePercent(escaped);
    }

    private static String decodeSingle(String token, Separator separator) {
        return Separator.replace(token, separator.encodedValuePattern, separator.valueReplacement);
    }

    private static String decodePercent(String token) {
        return Separator.replace(token, PERCENT_ENCODED_PATTERN, PERCENT_REPLACEMENT);
    }

    public static byte[] encode(String token, Separator ... separators) {
        if (token == null || token.length() == 0) {
            return EMPTY_BYTES;
        }
        String result = token;
        result = Separator.encodePercent(token);
        for (Separator separator : separators) {
            if (separator == null) continue;
            result = Separator.encodeSingle(result, separator);
        }
        return Bytes.toBytes((String)result);
    }

    public static String decode(byte[] token, Separator ... separators) {
        if (token == null) {
            return null;
        }
        return Separator.decode(Bytes.toString((byte[])token), separators);
    }

    public static String decode(String token, Separator ... separators) {
        if (token == null) {
            return null;
        }
        String result = token;
        for (Separator separator : separators) {
            if (separator == null) continue;
            result = Separator.decodeSingle(result, separator);
        }
        return Separator.decodePercent(result);
    }

    public byte[] join(byte[] ... components) {
        if (components == null || components.length == 0) {
            return EMPTY_BYTES;
        }
        int finalSize = 0;
        finalSize = this.value.length() * (components.length - 1);
        for (byte[] comp : components) {
            if (comp == null) continue;
            finalSize += comp.length;
        }
        byte[] buf = new byte[finalSize];
        int offset = 0;
        for (int i = 0; i < components.length; ++i) {
            if (components[i] != null) {
                System.arraycopy(components[i], 0, buf, offset, components[i].length);
                offset += components[i].length;
            }
            if (i >= components.length - 1) continue;
            System.arraycopy(this.bytes, 0, buf, offset, this.value.length());
            offset += this.value.length();
        }
        return buf;
    }

    public String joinEncoded(String ... items) {
        if (items == null || items.length == 0) {
            return EMPTY_STRING;
        }
        StringBuilder sb = new StringBuilder(this.encode(items[0].toString()));
        for (int i = 1; i < items.length; ++i) {
            sb.append(this.value);
            sb.append(this.encode(items[i].toString()));
        }
        return sb.toString();
    }

    public String joinEncoded(Iterable<?> items) {
        if (items == null) {
            return EMPTY_STRING;
        }
        Iterator<?> i = items.iterator();
        if (!i.hasNext()) {
            return EMPTY_STRING;
        }
        StringBuilder sb = new StringBuilder(this.encode(i.next().toString()));
        while (i.hasNext()) {
            sb.append(this.value);
            sb.append(this.encode(i.next().toString()));
        }
        return sb.toString();
    }

    public Collection<String> splitEncoded(String compoundValue) {
        ArrayList<String> result = new ArrayList<String>();
        if (compoundValue != null) {
            for (String val : this.valuePattern.split(compoundValue)) {
                result.add(this.decode(val));
            }
        }
        return result;
    }

    public byte[][] split(byte[] source, int limit) {
        return Separator.split(source, this.bytes, limit);
    }

    public byte[][] split(byte[] source, int[] sizes) {
        return Separator.split(source, this.bytes, sizes);
    }

    public byte[][] split(byte[] source) {
        return Separator.split(source, this.bytes);
    }

    private static List<Range> splitRanges(byte[] source, byte[] separator, int[] sizes) {
        ArrayList<Range> segments = new ArrayList<Range>();
        if (source == null || separator == null) {
            return segments;
        }
        int limit = 0;
        if (sizes != null && sizes.length > 0) {
            limit = sizes.length;
        }
        int start = 0;
        int currentSegment = 0;
        block0: for (int i = 0; i < source.length; ++i) {
            for (int j = 0; j < separator.length; ++j) {
                if (source[i + j] != separator[j]) continue block0;
            }
            if (limit > 0) {
                int currentSegExpectedSize;
                if (segments.size() >= limit - 1) break;
                if (sizes != null && (currentSegExpectedSize = sizes[currentSegment]) > 0) {
                    int currentSegSize = i - start;
                    if (currentSegSize < currentSegExpectedSize) continue;
                    if (currentSegSize > currentSegExpectedSize) {
                        throw new IllegalArgumentException("Segments not separated as per expected sizes");
                    }
                }
            }
            segments.add(new Range(start, i));
            start = i + separator.length;
            i += separator.length - 1;
            ++currentSegment;
        }
        if (start <= source.length) {
            if (sizes != null && sizes[currentSegment] > 0 && source.length - start > sizes[currentSegment]) {
                throw new IllegalArgumentException("Segments not separated as per expected sizes");
            }
            segments.add(new Range(start, source.length));
        }
        return segments;
    }

    private static byte[][] split(byte[] source, List<Range> segments) {
        byte[][] splits = new byte[segments.size()][];
        for (int i = 0; i < segments.size(); ++i) {
            Range r = segments.get(i);
            byte[] tmp = new byte[r.length()];
            if (tmp.length > 0) {
                System.arraycopy(source, r.start(), tmp, 0, r.length());
            }
            splits[i] = tmp;
        }
        return splits;
    }

    private static byte[][] split(byte[] source, byte[] separator, int[] sizes) {
        List<Range> segments = Separator.splitRanges(source, separator, sizes);
        return Separator.split(source, segments);
    }

    private static byte[][] split(byte[] source, byte[] separator) {
        return Separator.split(source, separator, null);
    }

    private static byte[][] split(byte[] source, byte[] separator, int limit) {
        int[] sizes = null;
        if (limit > 0) {
            sizes = new int[limit];
        }
        List<Range> segments = Separator.splitRanges(source, separator, sizes);
        return Separator.split(source, segments);
    }

    static {
        PERCENT_PATTERN = Pattern.compile(PERCENT, 16);
        PERCENT_REPLACEMENT = Matcher.quoteReplacement(PERCENT);
        PERCENT_ENCODED_PATTERN = Pattern.compile(PERCENT_ENCODED, 16);
        PERCENT_ENCODED_REPLACEMENT = Matcher.quoteReplacement(PERCENT_ENCODED);
        EMPTY_BYTES = new byte[0];
    }
}

