/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage.subapplication;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.BaseTable;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.TimelineHBaseSchemaConstants;
import org.apache.hadoop.yarn.server.timelineservice.storage.subapplication.SubApplicationColumnFamily;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubApplicationTable
extends BaseTable<SubApplicationTable> {
    private static final String PREFIX = "yarn.timeline-service.subapplication";
    public static final String TABLE_NAME_CONF_NAME = "yarn.timeline-service.subapplication.table.name";
    private static final String METRICS_TTL_CONF_NAME = "yarn.timeline-service.subapplication.table.metrics.ttl";
    private static final String METRICS_MAX_VERSIONS = "yarn.timeline-service.subapplication.table.metrics.max-versions";
    public static final String DEFAULT_TABLE_NAME = "timelineservice.subapplication";
    private static final int DEFAULT_METRICS_TTL = 2592000;
    private static final int DEFAULT_METRICS_MAX_VERSIONS = 10000;
    private static final Logger LOG = LoggerFactory.getLogger(SubApplicationTable.class);

    public SubApplicationTable() {
        super(TABLE_NAME_CONF_NAME, DEFAULT_TABLE_NAME);
    }

    public void createTable(Admin admin, Configuration hbaseConf) throws IOException {
        TableName table = this.getTableName(hbaseConf);
        if (admin.tableExists(table)) {
            throw new IOException("Table " + table.getNameAsString() + " already exists.");
        }
        HTableDescriptor subAppTableDescp = new HTableDescriptor(table);
        HColumnDescriptor infoCF = new HColumnDescriptor(SubApplicationColumnFamily.INFO.getBytes());
        infoCF.setBloomFilterType(BloomType.ROWCOL);
        subAppTableDescp.addFamily(infoCF);
        HColumnDescriptor configCF = new HColumnDescriptor(SubApplicationColumnFamily.CONFIGS.getBytes());
        configCF.setBloomFilterType(BloomType.ROWCOL);
        configCF.setBlockCacheEnabled(true);
        subAppTableDescp.addFamily(configCF);
        HColumnDescriptor metricsCF = new HColumnDescriptor(SubApplicationColumnFamily.METRICS.getBytes());
        subAppTableDescp.addFamily(metricsCF);
        metricsCF.setBlockCacheEnabled(true);
        metricsCF.setMinVersions(1);
        metricsCF.setMaxVersions(hbaseConf.getInt(METRICS_MAX_VERSIONS, 10000));
        metricsCF.setTimeToLive(hbaseConf.getInt(METRICS_TTL_CONF_NAME, 2592000));
        subAppTableDescp.setRegionSplitPolicyClassName("org.apache.hadoop.hbase.regionserver.KeyPrefixRegionSplitPolicy");
        subAppTableDescp.setValue("KeyPrefixRegionSplitPolicy.prefix_length", "4");
        admin.createTable(subAppTableDescp, TimelineHBaseSchemaConstants.getUsernameSplits());
        LOG.info("Status of table creation for " + table.getNameAsString() + "=" + admin.tableExists(table));
    }

    public void setMetricsTTL(int metricsTTL, Configuration hbaseConf) {
        hbaseConf.setInt(METRICS_TTL_CONF_NAME, metricsTTL);
    }
}

