/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage.reader;

import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.filter.BinaryPrefixComparator;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.QualifierFilter;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEvent;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineMetric;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineDataToRetrieve;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineEntityFilters;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineReaderContext;
import org.apache.hadoop.yarn.server.timelineservice.storage.TimelineReader;
import org.apache.hadoop.yarn.server.timelineservice.storage.application.ApplicationColumnPrefix;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.BaseTable;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ColumnPrefix;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.EventColumnName;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.EventColumnNameConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.KeyConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.Separator;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.StringKeyConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.entity.EntityColumnPrefix;
import org.apache.hadoop.yarn.server.timelineservice.storage.reader.AbstractTimelineStorageReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TimelineEntityReader
extends AbstractTimelineStorageReader {
    private static final Logger LOG = LoggerFactory.getLogger(TimelineEntityReader.class);
    private final boolean singleEntityRead;
    private TimelineDataToRetrieve dataToRetrieve;
    private TimelineEntityFilters filters;
    private BaseTable<?> table;
    private final KeyConverter<String> stringKeyConverter = new StringKeyConverter();

    protected TimelineEntityReader(TimelineReaderContext ctxt, TimelineEntityFilters entityFilters, TimelineDataToRetrieve toRetrieve) {
        super(ctxt);
        this.singleEntityRead = false;
        this.dataToRetrieve = toRetrieve;
        this.filters = entityFilters;
        this.setTable(this.getTable());
    }

    protected TimelineEntityReader(TimelineReaderContext ctxt, TimelineDataToRetrieve toRetrieve) {
        super(ctxt);
        this.singleEntityRead = true;
        this.dataToRetrieve = toRetrieve;
        this.setTable(this.getTable());
    }

    protected abstract FilterList constructFilterListBasedOnFields() throws IOException;

    protected abstract FilterList constructFilterListBasedOnFilters() throws IOException;

    private FilterList createFilterList() throws IOException {
        boolean hasListBasedOnFields;
        FilterList listBasedOnFilters = this.constructFilterListBasedOnFilters();
        boolean hasListBasedOnFilters = listBasedOnFilters != null && !listBasedOnFilters.getFilters().isEmpty();
        FilterList listBasedOnFields = this.constructFilterListBasedOnFields();
        boolean bl = hasListBasedOnFields = listBasedOnFields != null && !listBasedOnFields.getFilters().isEmpty();
        if (hasListBasedOnFilters && hasListBasedOnFields) {
            FilterList list = new FilterList(new Filter[0]);
            list.addFilter((Filter)listBasedOnFilters);
            list.addFilter((Filter)listBasedOnFields);
            return list;
        }
        if (hasListBasedOnFilters) {
            return listBasedOnFilters;
        }
        if (hasListBasedOnFields) {
            return listBasedOnFields;
        }
        return null;
    }

    protected TimelineDataToRetrieve getDataToRetrieve() {
        return this.dataToRetrieve;
    }

    protected TimelineEntityFilters getFilters() {
        return this.filters;
    }

    protected void createFiltersIfNull() {
        if (this.filters == null) {
            this.filters = new TimelineEntityFilters.Builder().build();
        }
    }

    public TimelineEntity readEntity(Configuration hbaseConf, Connection conn) throws IOException {
        Result result;
        this.validateParams();
        this.augmentParams(hbaseConf, conn);
        FilterList filterList = this.constructFilterListBasedOnFields();
        if (LOG.isDebugEnabled() && filterList != null) {
            LOG.debug("FilterList created for get is - " + filterList);
        }
        if ((result = this.getResult(hbaseConf, conn, filterList)) == null || result.isEmpty()) {
            LOG.info("Cannot find matching entity of type " + this.getContext().getEntityType());
            return null;
        }
        return this.parseEntity(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<TimelineEntity> readEntities(Configuration hbaseConf, Connection conn) throws IOException {
        this.validateParams();
        this.augmentParams(hbaseConf, conn);
        LinkedHashSet<TimelineEntity> entities = new LinkedHashSet<TimelineEntity>();
        FilterList filterList = this.createFilterList();
        if (LOG.isDebugEnabled() && filterList != null) {
            LOG.debug("FilterList created for scan is - " + filterList);
        }
        try (ResultScanner results = this.getResults(hbaseConf, conn, filterList);){
            for (Result result : results) {
                TimelineEntity entity = this.parseEntity(result);
                if (entity == null) continue;
                entities.add(entity);
                if ((long)entities.size() != this.filters.getLimit()) continue;
                break;
            }
            LinkedHashSet<TimelineEntity> linkedHashSet = entities;
            return linkedHashSet;
        }
    }

    protected BaseTable<?> getTable() {
        return this.table;
    }

    protected abstract Result getResult(Configuration var1, Connection var2, FilterList var3) throws IOException;

    protected abstract ResultScanner getResults(Configuration var1, Connection var2, FilterList var3) throws IOException;

    protected abstract TimelineEntity parseEntity(Result var1) throws IOException;

    protected void readMetrics(TimelineEntity entity, Result result, ColumnPrefix<?> columnPrefix) throws IOException {
        NavigableMap metricsResult = columnPrefix.readResultsWithTimestamps(result, this.stringKeyConverter);
        for (Map.Entry metricResult : metricsResult.entrySet()) {
            TimelineMetric metric = new TimelineMetric();
            metric.setId((String)metricResult.getKey());
            TimelineMetric.Type metricType = ((NavigableMap)metricResult.getValue()).size() > 1 ? TimelineMetric.Type.TIME_SERIES : TimelineMetric.Type.SINGLE_VALUE;
            metric.setType(metricType);
            metric.addValues((Map)metricResult.getValue());
            entity.addMetric(metric);
        }
    }

    public boolean isSingleEntityRead() {
        return this.singleEntityRead;
    }

    protected void setTable(BaseTable<?> baseTable) {
        this.table = baseTable;
    }

    protected boolean hasField(EnumSet<TimelineReader.Field> fieldsToRetrieve, TimelineReader.Field requiredField) {
        return fieldsToRetrieve.contains(TimelineReader.Field.ALL) || fieldsToRetrieve.contains(requiredField);
    }

    protected <T> FilterList createFiltersFromColumnQualifiers(ColumnPrefix<T> colPrefix, Set<String> columns) {
        FilterList list = new FilterList(FilterList.Operator.MUST_PASS_ONE);
        for (String column : columns) {
            byte[] compoundColQual = this.createColQualifierPrefix(colPrefix, column);
            list.addFilter((Filter)new QualifierFilter(CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)new BinaryPrefixComparator(colPrefix.getColumnPrefixBytes(compoundColQual))));
        }
        return list;
    }

    protected <T> byte[] createColQualifierPrefix(ColumnPrefix<T> colPrefix, String column) {
        if (colPrefix == ApplicationColumnPrefix.EVENT || colPrefix == EntityColumnPrefix.EVENT) {
            return new EventColumnName(column, null, null).getColumnQualifier();
        }
        return this.stringKeyConverter.encode((Object)column);
    }

    protected <T> void readRelationship(TimelineEntity entity, Result result, ColumnPrefix<T> prefix, boolean isRelatedTo) throws IOException {
        Map columns = prefix.readResults(result, this.stringKeyConverter);
        for (Map.Entry column : columns.entrySet()) {
            for (String id : Separator.VALUES.splitEncoded(column.getValue().toString())) {
                if (isRelatedTo) {
                    entity.addIsRelatedToEntity((String)column.getKey(), id);
                    continue;
                }
                entity.addRelatesToEntity((String)column.getKey(), id);
            }
        }
    }

    protected static <T> void readEvents(TimelineEntity entity, Result result, ColumnPrefix<T> prefix) throws IOException {
        HashMap<String, TimelineEvent> eventsMap = new HashMap<String, TimelineEvent>();
        Map eventsResult = prefix.readResults(result, (KeyConverter)new EventColumnNameConverter());
        for (Map.Entry eventResult : eventsResult.entrySet()) {
            EventColumnName eventColumnName = (EventColumnName)eventResult.getKey();
            String key = eventColumnName.getId() + Long.toString(eventColumnName.getTimestamp());
            TimelineEvent event = (TimelineEvent)eventsMap.get(key);
            if (event == null) {
                event = new TimelineEvent();
                event.setId(eventColumnName.getId());
                event.setTimestamp(eventColumnName.getTimestamp().longValue());
                eventsMap.put(key, event);
            }
            if (eventColumnName.getInfoKey() == null) continue;
            event.addInfo(eventColumnName.getInfoKey(), eventResult.getValue());
        }
        HashSet eventsSet = new HashSet(eventsMap.values());
        entity.addEvents(eventsSet);
    }
}

