/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage.reader;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.EnumSet;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Query;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.FamilyFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.PageFilter;
import org.apache.hadoop.hbase.filter.QualifierFilter;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineDataToRetrieve;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineEntityFilters;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineReaderContext;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineFilterList;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineFilterUtils;
import org.apache.hadoop.yarn.server.timelineservice.storage.TimelineReader;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.BaseTable;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.Column;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ColumnFamily;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ColumnPrefix;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.HBaseTimelineStorageUtils;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.TimelineStorageUtils;
import org.apache.hadoop.yarn.server.timelineservice.storage.reader.GenericEntityReader;
import org.apache.hadoop.yarn.server.timelineservice.storage.subapplication.SubApplicationColumn;
import org.apache.hadoop.yarn.server.timelineservice.storage.subapplication.SubApplicationColumnFamily;
import org.apache.hadoop.yarn.server.timelineservice.storage.subapplication.SubApplicationColumnPrefix;
import org.apache.hadoop.yarn.server.timelineservice.storage.subapplication.SubApplicationRowKey;
import org.apache.hadoop.yarn.server.timelineservice.storage.subapplication.SubApplicationRowKeyPrefix;
import org.apache.hadoop.yarn.server.timelineservice.storage.subapplication.SubApplicationTable;
import org.apache.hadoop.yarn.webapp.BadRequestException;

/*
 * Exception performing whole class analysis ignored.
 */
class SubApplicationEntityReader
extends GenericEntityReader {
    private static final SubApplicationTable SUB_APPLICATION_TABLE = new SubApplicationTable();

    SubApplicationEntityReader(TimelineReaderContext ctxt, TimelineEntityFilters entityFilters, TimelineDataToRetrieve toRetrieve) {
        super(ctxt, entityFilters, toRetrieve);
    }

    SubApplicationEntityReader(TimelineReaderContext ctxt, TimelineDataToRetrieve toRetrieve) {
        super(ctxt, toRetrieve);
    }

    protected BaseTable<?> getTable() {
        return SUB_APPLICATION_TABLE;
    }

    protected FilterList constructFilterListBasedOnFilters() throws IOException {
        TimelineFilterList infoFilters;
        TimelineFilterList configFilters;
        TimelineFilterList metricFilters;
        FilterList listBasedOnFilters = new FilterList(new Filter[0]);
        TimelineEntityFilters filters = this.getFilters();
        long createdTimeBegin = filters.getCreatedTimeBegin();
        long createdTimeEnd = filters.getCreatedTimeEnd();
        if (createdTimeBegin != 0L || createdTimeEnd != Long.MAX_VALUE) {
            listBasedOnFilters.addFilter((Filter)TimelineFilterUtils.createSingleColValueFiltersByRange((Column)SubApplicationColumn.CREATED_TIME, (Object)createdTimeBegin, (Object)createdTimeEnd));
        }
        if ((metricFilters = filters.getMetricFilters()) != null && !metricFilters.getFilterList().isEmpty()) {
            listBasedOnFilters.addFilter((Filter)TimelineFilterUtils.createHBaseFilterList((ColumnPrefix)SubApplicationColumnPrefix.METRIC, (TimelineFilterList)metricFilters));
        }
        if ((configFilters = filters.getConfigFilters()) != null && !configFilters.getFilterList().isEmpty()) {
            listBasedOnFilters.addFilter((Filter)TimelineFilterUtils.createHBaseFilterList((ColumnPrefix)SubApplicationColumnPrefix.CONFIG, (TimelineFilterList)configFilters));
        }
        if ((infoFilters = filters.getInfoFilters()) != null && !infoFilters.getFilterList().isEmpty()) {
            listBasedOnFilters.addFilter((Filter)TimelineFilterUtils.createHBaseFilterList((ColumnPrefix)SubApplicationColumnPrefix.INFO, (TimelineFilterList)infoFilters));
        }
        return listBasedOnFilters;
    }

    protected void updateFixedColumns(FilterList list) {
        for (SubApplicationColumn column : SubApplicationColumn.values()) {
            list.addFilter((Filter)new QualifierFilter(CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)new BinaryComparator(column.getColumnQualifierBytes())));
        }
    }

    private FilterList createFilterListForColsOfInfoFamily() throws IOException {
        FilterList infoFamilyColsFilter = new FilterList(FilterList.Operator.MUST_PASS_ONE);
        this.updateFixedColumns(infoFamilyColsFilter);
        EnumSet fieldsToRetrieve = this.getDataToRetrieve().getFieldsToRetrieve();
        if (this.hasField(fieldsToRetrieve, TimelineReader.Field.INFO)) {
            infoFamilyColsFilter.addFilter(TimelineFilterUtils.createHBaseQualifierFilter((CompareFilter.CompareOp)CompareFilter.CompareOp.EQUAL, (ColumnPrefix)SubApplicationColumnPrefix.INFO));
        }
        TimelineFilterList relatesTo = this.getFilters().getRelatesTo();
        if (this.hasField(fieldsToRetrieve, TimelineReader.Field.RELATES_TO)) {
            infoFamilyColsFilter.addFilter(TimelineFilterUtils.createHBaseQualifierFilter((CompareFilter.CompareOp)CompareFilter.CompareOp.EQUAL, (ColumnPrefix)SubApplicationColumnPrefix.RELATES_TO));
        } else if (relatesTo != null && !relatesTo.getFilterList().isEmpty()) {
            Set relatesToCols = TimelineFilterUtils.fetchColumnsFromFilterList((TimelineFilterList)relatesTo);
            infoFamilyColsFilter.addFilter((Filter)this.createFiltersFromColumnQualifiers((ColumnPrefix)SubApplicationColumnPrefix.RELATES_TO, relatesToCols));
        }
        TimelineFilterList isRelatedTo = this.getFilters().getIsRelatedTo();
        if (this.hasField(fieldsToRetrieve, TimelineReader.Field.IS_RELATED_TO)) {
            infoFamilyColsFilter.addFilter(TimelineFilterUtils.createHBaseQualifierFilter((CompareFilter.CompareOp)CompareFilter.CompareOp.EQUAL, (ColumnPrefix)SubApplicationColumnPrefix.IS_RELATED_TO));
        } else if (isRelatedTo != null && !isRelatedTo.getFilterList().isEmpty()) {
            Set isRelatedToCols = TimelineFilterUtils.fetchColumnsFromFilterList((TimelineFilterList)isRelatedTo);
            infoFamilyColsFilter.addFilter((Filter)this.createFiltersFromColumnQualifiers((ColumnPrefix)SubApplicationColumnPrefix.IS_RELATED_TO, isRelatedToCols));
        }
        TimelineFilterList eventFilters = this.getFilters().getEventFilters();
        if (this.hasField(fieldsToRetrieve, TimelineReader.Field.EVENTS)) {
            infoFamilyColsFilter.addFilter(TimelineFilterUtils.createHBaseQualifierFilter((CompareFilter.CompareOp)CompareFilter.CompareOp.EQUAL, (ColumnPrefix)SubApplicationColumnPrefix.EVENT));
        } else if (eventFilters != null && !eventFilters.getFilterList().isEmpty()) {
            Set eventCols = TimelineFilterUtils.fetchColumnsFromFilterList((TimelineFilterList)eventFilters);
            infoFamilyColsFilter.addFilter((Filter)this.createFiltersFromColumnQualifiers((ColumnPrefix)SubApplicationColumnPrefix.EVENT, eventCols));
        }
        return infoFamilyColsFilter;
    }

    private void excludeFieldsFromInfoColFamily(FilterList infoColFamilyList) {
        EnumSet fieldsToRetrieve = this.getDataToRetrieve().getFieldsToRetrieve();
        if (!this.hasField(fieldsToRetrieve, TimelineReader.Field.EVENTS)) {
            infoColFamilyList.addFilter(TimelineFilterUtils.createHBaseQualifierFilter((CompareFilter.CompareOp)CompareFilter.CompareOp.NOT_EQUAL, (ColumnPrefix)SubApplicationColumnPrefix.EVENT));
        }
        if (!this.hasField(fieldsToRetrieve, TimelineReader.Field.INFO)) {
            infoColFamilyList.addFilter(TimelineFilterUtils.createHBaseQualifierFilter((CompareFilter.CompareOp)CompareFilter.CompareOp.NOT_EQUAL, (ColumnPrefix)SubApplicationColumnPrefix.INFO));
        }
        if (!this.hasField(fieldsToRetrieve, TimelineReader.Field.IS_RELATED_TO)) {
            infoColFamilyList.addFilter(TimelineFilterUtils.createHBaseQualifierFilter((CompareFilter.CompareOp)CompareFilter.CompareOp.NOT_EQUAL, (ColumnPrefix)SubApplicationColumnPrefix.IS_RELATED_TO));
        }
        if (!this.hasField(fieldsToRetrieve, TimelineReader.Field.RELATES_TO)) {
            infoColFamilyList.addFilter(TimelineFilterUtils.createHBaseQualifierFilter((CompareFilter.CompareOp)CompareFilter.CompareOp.NOT_EQUAL, (ColumnPrefix)SubApplicationColumnPrefix.RELATES_TO));
        }
    }

    private void updateFilterForConfsAndMetricsToRetrieve(FilterList listBasedOnFields) throws IOException {
        TimelineDataToRetrieve dataToRetrieve = this.getDataToRetrieve();
        if (dataToRetrieve.getFieldsToRetrieve().contains(TimelineReader.Field.CONFIGS)) {
            listBasedOnFields.addFilter(TimelineFilterUtils.createFilterForConfsOrMetricsToRetrieve((TimelineFilterList)dataToRetrieve.getConfsToRetrieve(), (ColumnFamily)SubApplicationColumnFamily.CONFIGS, (ColumnPrefix)SubApplicationColumnPrefix.CONFIG));
        }
        if (dataToRetrieve.getFieldsToRetrieve().contains(TimelineReader.Field.METRICS)) {
            listBasedOnFields.addFilter(TimelineFilterUtils.createFilterForConfsOrMetricsToRetrieve((TimelineFilterList)dataToRetrieve.getMetricsToRetrieve(), (ColumnFamily)SubApplicationColumnFamily.METRICS, (ColumnPrefix)SubApplicationColumnPrefix.METRIC));
        }
    }

    protected FilterList constructFilterListBasedOnFields() throws IOException {
        if (!this.needCreateFilterListBasedOnFields()) {
            return null;
        }
        FilterList listBasedOnFields = new FilterList(FilterList.Operator.MUST_PASS_ONE);
        FilterList infoColFamilyList = new FilterList(new Filter[0]);
        FamilyFilter infoColumnFamily = new FamilyFilter(CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)new BinaryComparator(SubApplicationColumnFamily.INFO.getBytes()));
        infoColFamilyList.addFilter((Filter)infoColumnFamily);
        if (this.fetchPartialColsFromInfoFamily()) {
            infoColFamilyList.addFilter((Filter)this.createFilterListForColsOfInfoFamily());
        } else {
            this.excludeFieldsFromInfoColFamily(infoColFamilyList);
        }
        listBasedOnFields.addFilter((Filter)infoColFamilyList);
        this.updateFilterForConfsAndMetricsToRetrieve(listBasedOnFields);
        return listBasedOnFields;
    }

    protected void validateParams() {
        Preconditions.checkNotNull((Object)this.getContext(), (Object)"context shouldn't be null");
        Preconditions.checkNotNull((Object)this.getDataToRetrieve(), (Object)"data to retrieve shouldn't be null");
        Preconditions.checkNotNull((Object)this.getContext().getClusterId(), (Object)"clusterId shouldn't be null");
        Preconditions.checkNotNull((Object)this.getContext().getDoAsUser(), (Object)"DoAsUser shouldn't be null");
        Preconditions.checkNotNull((Object)this.getContext().getEntityType(), (Object)"entityType shouldn't be null");
    }

    protected void augmentParams(Configuration hbaseConf, Connection conn) throws IOException {
        this.getDataToRetrieve().addFieldsBasedOnConfsAndMetricsToRetrieve();
        this.createFiltersIfNull();
    }

    private void setMetricsTimeRange(Query query) {
        HBaseTimelineStorageUtils.setMetricsTimeRange((Query)query, (byte[])SubApplicationColumnFamily.METRICS.getBytes(), (long)this.getDataToRetrieve().getMetricsTimeBegin(), (long)this.getDataToRetrieve().getMetricsTimeEnd());
    }

    protected ResultScanner getResults(Configuration hbaseConf, Connection conn, FilterList filterList) throws IOException {
        Scan scan = new Scan();
        TimelineReaderContext context = this.getContext();
        if (context.getDoAsUser() == null) {
            throw new BadRequestException("Invalid user!");
        }
        SubApplicationRowKeyPrefix subApplicationRowKeyPrefix = null;
        if (this.getFilters() == null || this.getFilters().getFromId() == null) {
            subApplicationRowKeyPrefix = new SubApplicationRowKeyPrefix(context.getDoAsUser(), context.getClusterId(), context.getEntityType(), null, null, null);
            scan.setRowPrefixFilter(subApplicationRowKeyPrefix.getRowKeyPrefix());
        } else {
            SubApplicationRowKey entityRowKey = null;
            try {
                entityRowKey = SubApplicationRowKey.parseRowKeyFromString((String)this.getFilters().getFromId());
            }
            catch (IllegalArgumentException e) {
                throw new BadRequestException("Invalid filter fromid is provided.");
            }
            if (!context.getClusterId().equals(entityRowKey.getClusterId())) {
                throw new BadRequestException("fromid doesn't belong to clusterId=" + context.getClusterId());
            }
            scan.setStartRow(entityRowKey.getRowKey());
            subApplicationRowKeyPrefix = new SubApplicationRowKeyPrefix(context.getDoAsUser(), context.getClusterId(), context.getEntityType(), null, null, null);
            scan.setStopRow(HBaseTimelineStorageUtils.calculateTheClosestNextRowKeyForPrefix((byte[])subApplicationRowKeyPrefix.getRowKeyPrefix()));
            filterList.addFilter((Filter)new PageFilter(this.getFilters().getLimit()));
        }
        this.setMetricsTimeRange((Query)scan);
        scan.setMaxVersions(this.getDataToRetrieve().getMetricsLimit().intValue());
        if (filterList != null && !filterList.getFilters().isEmpty()) {
            scan.setFilter((Filter)filterList);
        }
        return this.getTable().getResultScanner(hbaseConf, conn, scan);
    }

    protected Result getResult(Configuration hbaseConf, Connection conn, FilterList filterList) throws IOException {
        throw new UnsupportedOperationException("we don't support a single entity query");
    }

    protected TimelineEntity parseEntity(Result result) throws IOException {
        boolean checkEvents;
        boolean checkRelatesTo;
        boolean checkIsRelatedTo;
        if (result == null || result.isEmpty()) {
            return null;
        }
        TimelineEntity entity = new TimelineEntity();
        SubApplicationRowKey parseRowKey = SubApplicationRowKey.parseRowKey((byte[])result.getRow());
        entity.setType(parseRowKey.getEntityType());
        entity.setId(parseRowKey.getEntityId());
        entity.setIdPrefix(parseRowKey.getEntityIdPrefix().longValue());
        TimelineEntityFilters filters = this.getFilters();
        Long createdTime = (Long)SubApplicationColumn.CREATED_TIME.readResult(result);
        entity.setCreatedTime(createdTime);
        EnumSet fieldsToRetrieve = this.getDataToRetrieve().getFieldsToRetrieve();
        boolean bl = checkIsRelatedTo = filters.getIsRelatedTo() != null && filters.getIsRelatedTo().getFilterList().size() > 0;
        if (this.hasField(fieldsToRetrieve, TimelineReader.Field.IS_RELATED_TO) || checkIsRelatedTo) {
            this.readRelationship(entity, result, (ColumnPrefix)SubApplicationColumnPrefix.IS_RELATED_TO, true);
            if (checkIsRelatedTo && !TimelineStorageUtils.matchIsRelatedTo((TimelineEntity)entity, (TimelineFilterList)filters.getIsRelatedTo())) {
                return null;
            }
            if (!this.hasField(fieldsToRetrieve, TimelineReader.Field.IS_RELATED_TO)) {
                entity.getIsRelatedToEntities().clear();
            }
        }
        boolean bl2 = checkRelatesTo = !this.isSingleEntityRead() && filters.getRelatesTo() != null && filters.getRelatesTo().getFilterList().size() > 0;
        if (this.hasField(fieldsToRetrieve, TimelineReader.Field.RELATES_TO) || checkRelatesTo) {
            this.readRelationship(entity, result, (ColumnPrefix)SubApplicationColumnPrefix.RELATES_TO, false);
            if (checkRelatesTo && !TimelineStorageUtils.matchRelatesTo((TimelineEntity)entity, (TimelineFilterList)filters.getRelatesTo())) {
                return null;
            }
            if (!this.hasField(fieldsToRetrieve, TimelineReader.Field.RELATES_TO)) {
                entity.getRelatesToEntities().clear();
            }
        }
        if (this.hasField(fieldsToRetrieve, TimelineReader.Field.INFO)) {
            this.readKeyValuePairs(entity, result, (ColumnPrefix)SubApplicationColumnPrefix.INFO, false);
        }
        if (this.hasField(fieldsToRetrieve, TimelineReader.Field.CONFIGS)) {
            this.readKeyValuePairs(entity, result, (ColumnPrefix)SubApplicationColumnPrefix.CONFIG, true);
        }
        boolean bl3 = checkEvents = !this.isSingleEntityRead() && filters.getEventFilters() != null && filters.getEventFilters().getFilterList().size() > 0;
        if (this.hasField(fieldsToRetrieve, TimelineReader.Field.EVENTS) || checkEvents) {
            SubApplicationEntityReader.readEvents((TimelineEntity)entity, (Result)result, (ColumnPrefix)SubApplicationColumnPrefix.EVENT);
            if (checkEvents && !TimelineStorageUtils.matchEventFilters((TimelineEntity)entity, (TimelineFilterList)filters.getEventFilters())) {
                return null;
            }
            if (!this.hasField(fieldsToRetrieve, TimelineReader.Field.EVENTS)) {
                entity.getEvents().clear();
            }
        }
        if (this.hasField(fieldsToRetrieve, TimelineReader.Field.METRICS)) {
            this.readMetrics(entity, result, (ColumnPrefix)SubApplicationColumnPrefix.METRIC);
        }
        entity.getInfo().put("FROM_ID", parseRowKey.getRowKeyAsString());
        return entity;
    }
}

