/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage.reader;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineReaderContext;
import org.apache.hadoop.yarn.server.timelineservice.storage.apptoflow.AppToFlowColumnPrefix;
import org.apache.hadoop.yarn.server.timelineservice.storage.apptoflow.AppToFlowRowKey;
import org.apache.hadoop.yarn.server.timelineservice.storage.apptoflow.AppToFlowTable;
import org.apache.hadoop.yarn.server.timelineservice.storage.reader.AbstractTimelineStorageReader;
import org.apache.hadoop.yarn.webapp.NotFoundException;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class AbstractTimelineStorageReader {
    private final TimelineReaderContext context;
    private final AppToFlowTable appToFlowTable = new AppToFlowTable();

    public AbstractTimelineStorageReader(TimelineReaderContext ctxt) {
        this.context = ctxt;
    }

    protected TimelineReaderContext getContext() {
        return this.context;
    }

    protected FlowContext lookupFlowContext(AppToFlowRowKey appToFlowRowKey, String clusterId, Configuration hbaseConf, Connection conn) throws IOException {
        byte[] rowKey = appToFlowRowKey.getRowKey();
        Get get = new Get(rowKey);
        Result result = this.appToFlowTable.getResult(hbaseConf, conn, get);
        if (result != null && !result.isEmpty()) {
            Object flowName = AppToFlowColumnPrefix.FLOW_NAME.readResult(result, clusterId);
            Object flowRunId = AppToFlowColumnPrefix.FLOW_RUN_ID.readResult(result, clusterId);
            Object userId = AppToFlowColumnPrefix.USER_ID.readResult(result, clusterId);
            if (flowName == null || userId == null || flowRunId == null) {
                throw new NotFoundException("Unable to find the context flow name, and flow run id, and user id for clusterId=" + clusterId + ", appId=" + appToFlowRowKey.getAppId());
            }
            return new FlowContext((String)userId, (String)flowName, Long.valueOf(((Number)flowRunId).longValue()));
        }
        throw new NotFoundException("Unable to find the context flow name, and flow run id, and user id for clusterId=" + clusterId + ", appId=" + appToFlowRowKey.getAppId());
    }

    protected void augmentParams(Configuration hbaseConf, Connection conn) throws IOException {
        this.defaultAugmentParams(hbaseConf, conn);
    }

    protected final void defaultAugmentParams(Configuration hbaseConf, Connection conn) throws IOException {
        if (this.context.getFlowName() == null || this.context.getFlowRunId() == null || this.context.getUserId() == null) {
            AppToFlowRowKey appToFlowRowKey = new AppToFlowRowKey(this.context.getAppId());
            FlowContext flowContext = this.lookupFlowContext(appToFlowRowKey, this.context.getClusterId(), hbaseConf, conn);
            this.context.setFlowName(FlowContext.access$000((FlowContext)flowContext));
            this.context.setFlowRunId(FlowContext.access$100((FlowContext)flowContext).longValue());
            this.context.setUserId(FlowContext.access$200((FlowContext)flowContext));
        }
    }

    protected abstract void validateParams();
}

