/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage.flow;

import java.io.IOException;
import java.util.Map;
import java.util.NavigableMap;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ColumnFamily;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ColumnHelper;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ColumnPrefix;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.HBaseTimelineStorageUtils;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.KeyConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.Separator;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.TypedBufferedMutator;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ValueConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.AggregationOperation;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.Attribute;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.FlowActivityColumnFamily;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.FlowActivityTable;

public enum FlowActivityColumnPrefix implements ColumnPrefix<FlowActivityTable>
{
    RUN_ID((ColumnFamily)FlowActivityColumnFamily.INFO, "r", null);

    private final ColumnHelper<FlowActivityTable> column;
    private final ColumnFamily<FlowActivityTable> columnFamily;
    private final String columnPrefix;
    private final byte[] columnPrefixBytes;
    private final AggregationOperation aggOp;

    private FlowActivityColumnPrefix(ColumnFamily<FlowActivityTable> columnFamily, String columnPrefix, AggregationOperation aggOp) {
        this(string, n, columnFamily, columnPrefix, aggOp, false);
    }

    private FlowActivityColumnPrefix(ColumnFamily<FlowActivityTable> columnFamily, String columnPrefix, AggregationOperation aggOp, boolean compoundColQual) {
        this.column = new ColumnHelper(columnFamily);
        this.columnFamily = columnFamily;
        this.columnPrefix = columnPrefix;
        this.columnPrefixBytes = (byte[])(columnPrefix == null ? null : Bytes.toBytes((String)Separator.SPACE.encode(columnPrefix)));
        this.aggOp = aggOp;
    }

    public String getColumnPrefix() {
        return this.columnPrefix;
    }

    public byte[] getColumnPrefixBytes(byte[] qualifierPrefix) {
        return ColumnHelper.getColumnQualifier((byte[])this.columnPrefixBytes, (byte[])qualifierPrefix);
    }

    public byte[] getColumnPrefixBytes(String qualifierPrefix) {
        return ColumnHelper.getColumnQualifier((byte[])this.columnPrefixBytes, (String)qualifierPrefix);
    }

    public byte[] getColumnPrefixBytes() {
        return (byte[])this.columnPrefixBytes.clone();
    }

    public byte[] getColumnFamilyBytes() {
        return this.columnFamily.getBytes();
    }

    public ValueConverter getValueConverter() {
        return this.column.getValueConverter();
    }

    public AggregationOperation getAttribute() {
        return this.aggOp;
    }

    public void store(byte[] rowKey, TypedBufferedMutator<FlowActivityTable> tableMutator, byte[] qualifier, Long timestamp, Object inputValue, Attribute ... attributes) throws IOException {
        if (qualifier == null) {
            throw new IOException("Cannot store column with null qualifier in " + tableMutator.getName().getNameAsString());
        }
        byte[] columnQualifier = this.getColumnPrefixBytes(qualifier);
        Attribute[] combinedAttributes = HBaseTimelineStorageUtils.combineAttributes((Attribute[])attributes, (AggregationOperation)this.aggOp);
        this.column.store(rowKey, tableMutator, columnQualifier, timestamp, inputValue, combinedAttributes);
    }

    public Object readResult(Result result, String qualifier) throws IOException {
        byte[] columnQualifier = ColumnHelper.getColumnQualifier((byte[])this.columnPrefixBytes, (String)qualifier);
        return this.column.readResult(result, columnQualifier);
    }

    public <K> Map<K, Object> readResults(Result result, KeyConverter<K> keyConverter) throws IOException {
        return this.column.readResults(result, this.columnPrefixBytes, keyConverter);
    }

    public <K, V> NavigableMap<K, NavigableMap<Long, V>> readResultsWithTimestamps(Result result, KeyConverter<K> keyConverter) throws IOException {
        return this.column.readResultsWithTimestamps(result, this.columnPrefixBytes, keyConverter);
    }

    public void store(byte[] rowKey, TypedBufferedMutator<FlowActivityTable> tableMutator, String qualifier, Long timestamp, Object inputValue, Attribute ... attributes) throws IOException {
        if (qualifier == null) {
            throw new IOException("Cannot store column with null qualifier in " + tableMutator.getName().getNameAsString());
        }
        byte[] columnQualifier = this.getColumnPrefixBytes(qualifier);
        Attribute[] combinedAttributes = HBaseTimelineStorageUtils.combineAttributes((Attribute[])attributes, (AggregationOperation)this.aggOp);
        this.column.store(rowKey, tableMutator, columnQualifier, timestamp, inputValue, combinedAttributes);
    }
}

