/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage.common;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ColumnFamily;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.GenericConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.KeyConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.Separator;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.TimestampGenerator;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.TypedBufferedMutator;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ValueConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.AggregationCompactionDimension;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.Attribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnHelper<T> {
    private static final Logger LOG = LoggerFactory.getLogger(ColumnHelper.class);
    private final ColumnFamily<T> columnFamily;
    private final byte[] columnFamilyBytes;
    private final ValueConverter converter;
    private final boolean supplementTs;

    public ColumnHelper(ColumnFamily<T> columnFamily) {
        this(columnFamily, (ValueConverter)GenericConverter.getInstance());
    }

    public ColumnHelper(ColumnFamily<T> columnFamily, ValueConverter converter) {
        this(columnFamily, converter, false);
    }

    public ColumnHelper(ColumnFamily<T> columnFamily, ValueConverter converter, boolean needSupplementTs) {
        this.columnFamily = columnFamily;
        this.columnFamilyBytes = columnFamily.getBytes();
        this.converter = converter == null ? GenericConverter.getInstance() : converter;
        this.supplementTs = needSupplementTs;
    }

    public void store(byte[] rowKey, TypedBufferedMutator<?> tableMutator, byte[] columnQualifier, Long timestamp, Object inputValue, Attribute ... attributes) throws IOException {
        if (rowKey == null || columnQualifier == null || inputValue == null) {
            return;
        }
        Put p = new Put(rowKey);
        timestamp = this.getPutTimestamp(timestamp, attributes);
        p.addColumn(this.columnFamilyBytes, columnQualifier, timestamp.longValue(), this.converter.encodeValue(inputValue));
        if (attributes != null && attributes.length > 0) {
            for (Attribute attribute : attributes) {
                p.setAttribute(attribute.getName(), attribute.getValue());
            }
        }
        tableMutator.mutate((Mutation)p);
    }

    private long getPutTimestamp(Long timestamp, Attribute[] attributes) {
        if (timestamp == null) {
            timestamp = System.currentTimeMillis();
        }
        if (!this.supplementTs) {
            return timestamp;
        }
        String appId = this.getAppIdFromAttributes(attributes);
        long supplementedTS = TimestampGenerator.getSupplementedTimestamp((long)timestamp, (String)appId);
        return supplementedTS;
    }

    private String getAppIdFromAttributes(Attribute[] attributes) {
        if (attributes == null) {
            return null;
        }
        String appId = null;
        for (Attribute attribute : attributes) {
            if (!AggregationCompactionDimension.APPLICATION_ID.toString().equals(attribute.getName())) continue;
            appId = Bytes.toString((byte[])attribute.getValue());
        }
        return appId;
    }

    public ColumnFamily<T> getColumnFamily() {
        return this.columnFamily;
    }

    public Object readResult(Result result, byte[] columnQualifierBytes) throws IOException {
        if (result == null || columnQualifierBytes == null) {
            return null;
        }
        byte[] value = result.getValue(this.columnFamilyBytes, columnQualifierBytes);
        return this.converter.decodeValue(value);
    }

    public <K, V> NavigableMap<K, NavigableMap<Long, V>> readResultsWithTimestamps(Result result, byte[] columnPrefixBytes, KeyConverter<K> keyConverter) throws IOException {
        NavigableMap resultMap;
        NavigableMap columnCellMap;
        TreeMap results = new TreeMap();
        if (result != null && (columnCellMap = (NavigableMap)(resultMap = result.getMap()).get(this.columnFamilyBytes)) != null) {
            for (Map.Entry entry : columnCellMap.entrySet()) {
                Object converterColumnKey;
                block11: {
                    converterColumnKey = null;
                    if (columnPrefixBytes == null) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("null prefix was specified; returning all columns");
                        }
                        try {
                            converterColumnKey = keyConverter.decode((byte[])entry.getKey());
                            break block11;
                        }
                        catch (IllegalArgumentException iae) {
                            LOG.error("Illegal column found, skipping this column.", (Throwable)iae);
                            continue;
                        }
                    }
                    byte[][] columnNameParts = Separator.QUALIFIERS.split((byte[])entry.getKey(), 2);
                    byte[] actualColumnPrefixBytes = columnNameParts[0];
                    if (Bytes.equals((byte[])columnPrefixBytes, (byte[])actualColumnPrefixBytes) && columnNameParts.length == 2) {
                        try {
                            converterColumnKey = keyConverter.decode(columnNameParts[1]);
                        }
                        catch (IllegalArgumentException iae) {
                            LOG.error("Illegal column found, skipping this column.", (Throwable)iae);
                            continue;
                        }
                    }
                }
                if (converterColumnKey == null) continue;
                TreeMap<Long, Object> cellResults = new TreeMap<Long, Object>();
                NavigableMap cells = (NavigableMap)entry.getValue();
                if (cells != null) {
                    for (Map.Entry cell : cells.entrySet()) {
                        Object value = this.converter.decodeValue((byte[])cell.getValue());
                        long ts = this.supplementTs ? TimestampGenerator.getTruncatedTimestamp((long)((Long)cell.getKey())) : (Long)cell.getKey();
                        cellResults.put(ts, value);
                    }
                }
                results.put(converterColumnKey, cellResults);
            }
        }
        return results;
    }

    public <K> Map<K, Object> readResults(Result result, byte[] columnPrefixBytes, KeyConverter<K> keyConverter) throws IOException {
        HashMap<Object, Object> results = new HashMap<Object, Object>();
        if (result != null) {
            NavigableMap columns = result.getFamilyMap(this.columnFamilyBytes);
            for (Map.Entry entry : columns.entrySet()) {
                Object converterColumnKey;
                block8: {
                    byte[] actualColumnPrefixBytes;
                    byte[] columnKey = (byte[])entry.getKey();
                    if (columnKey == null || columnKey.length <= 0) continue;
                    converterColumnKey = null;
                    if (columnPrefixBytes == null) {
                        try {
                            converterColumnKey = keyConverter.decode(columnKey);
                            break block8;
                        }
                        catch (IllegalArgumentException iae) {
                            LOG.error("Illegal column found, skipping this column.", (Throwable)iae);
                            continue;
                        }
                    }
                    byte[][] columnNameParts = Separator.QUALIFIERS.split(columnKey, 2);
                    if (columnNameParts.length > 0 && Bytes.equals((byte[])columnPrefixBytes, (byte[])(actualColumnPrefixBytes = columnNameParts[0])) && columnNameParts.length == 2) {
                        try {
                            converterColumnKey = keyConverter.decode(columnNameParts[1]);
                        }
                        catch (IllegalArgumentException iae) {
                            LOG.error("Illegal column found, skipping this column.", (Throwable)iae);
                            continue;
                        }
                    }
                }
                if (converterColumnKey == null) continue;
                Object value = this.converter.decodeValue((byte[])entry.getValue());
                results.put(converterColumnKey, value);
            }
        }
        return results;
    }

    public static byte[] getColumnQualifier(byte[] columnPrefixBytes, String qualifier) {
        byte[] encodedQualifier = Separator.encode((String)qualifier, (Separator[])new Separator[]{Separator.SPACE, Separator.TAB});
        if (columnPrefixBytes == null) {
            return encodedQualifier;
        }
        byte[] columnQualifier = Separator.QUALIFIERS.join((byte[][])new byte[][]{columnPrefixBytes, encodedQualifier});
        return columnQualifier;
    }

    public static byte[] getColumnQualifier(byte[] columnPrefixBytes, long qualifier) {
        if (columnPrefixBytes == null) {
            return Bytes.toBytes((long)qualifier);
        }
        byte[] columnQualifier = Separator.QUALIFIERS.join((byte[][])new byte[][]{columnPrefixBytes, Bytes.toBytes((long)qualifier)});
        return columnQualifier;
    }

    public ValueConverter getValueConverter() {
        return this.converter;
    }

    public static byte[] getColumnQualifier(byte[] columnPrefixBytes, byte[] qualifier) {
        if (columnPrefixBytes == null) {
            return qualifier;
        }
        byte[] columnQualifier = Separator.QUALIFIERS.join((byte[][])new byte[][]{columnPrefixBytes, qualifier});
        return columnQualifier;
    }
}

