/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage.common;

import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.HBaseTimelineStorageUtils;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.KeyConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.LongConverter;

/*
 * Exception performing whole class analysis ignored.
 */
public final class AppIdKeyConverter
implements KeyConverter<String> {
    public byte[] encode(String appIdStr) {
        ApplicationId appId = ApplicationId.fromString((String)appIdStr);
        byte[] appIdBytes = new byte[AppIdKeyConverter.getKeySize()];
        byte[] clusterTs = Bytes.toBytes((long)LongConverter.invertLong((long)appId.getClusterTimestamp()));
        System.arraycopy(clusterTs, 0, appIdBytes, 0, 8);
        byte[] seqId = Bytes.toBytes((int)HBaseTimelineStorageUtils.invertInt((int)appId.getId()));
        System.arraycopy(seqId, 0, appIdBytes, 8, 4);
        return appIdBytes;
    }

    public String decode(byte[] appIdBytes) {
        if (appIdBytes.length != AppIdKeyConverter.getKeySize()) {
            throw new IllegalArgumentException("Invalid app id in byte format");
        }
        long clusterTs = LongConverter.invertLong((long)Bytes.toLong((byte[])appIdBytes, (int)0, (int)8));
        int seqId = HBaseTimelineStorageUtils.invertInt((int)Bytes.toInt((byte[])appIdBytes, (int)8, (int)4));
        return HBaseTimelineStorageUtils.convertApplicationIdToString((ApplicationId)ApplicationId.newInstance((long)clusterTs, (int)seqId));
    }

    public static int getKeySize() {
        return 12;
    }
}

