/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timeline;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.EnumSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileContextTestHelper;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.timeline.TimelineDomain;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntities;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntity;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.timeline.DomainLogInfo;
import org.apache.hadoop.yarn.server.timeline.EntityLogInfo;
import org.apache.hadoop.yarn.server.timeline.PluginStoreTestUtils;
import org.apache.hadoop.yarn.server.timeline.TimelineDataManager;
import org.apache.hadoop.yarn.server.timeline.TimelineReader;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.PrettyPrinter;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.util.MinimalPrettyPrinter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestLogInfo {
    private static final Path TEST_ROOT_DIR = new Path(System.getProperty("test.build.data", System.getProperty("java.io.tmpdir")), TestLogInfo.class.getSimpleName());
    private static final String TEST_ATTEMPT_DIR_NAME = "test_app";
    private static final String TEST_ENTITY_FILE_NAME = "test_entity";
    private static final String TEST_DOMAIN_FILE_NAME = "test_domain";
    private static final String TEST_BROKEN_FILE_NAME = "test_broken";
    private Configuration config = new YarnConfiguration();
    private MiniDFSCluster hdfsCluster;
    private FileSystem fs;
    private FileContext fc;
    private FileContextTestHelper fileContextTestHelper = new FileContextTestHelper("/tmp/TestLogInfo");
    private ObjectMapper objMapper;
    private JsonFactory jsonFactory = new JsonFactory();
    private JsonGenerator jsonGenerator;
    private FSDataOutputStream outStream = null;
    private FSDataOutputStream outStreamDomain = null;
    private TimelineDomain testDomain;
    private static final short FILE_LOG_DIR_PERMISSIONS = 504;

    @Before
    public void setup() throws Exception {
        this.config.set("hdfs.minidfs.basedir", TEST_ROOT_DIR.toString());
        HdfsConfiguration hdfsConfig = new HdfsConfiguration();
        this.hdfsCluster = new MiniDFSCluster.Builder((Configuration)hdfsConfig).numDataNodes(1).build();
        this.fs = this.hdfsCluster.getFileSystem();
        this.fc = FileContext.getFileContext((URI)this.hdfsCluster.getURI(0), (Configuration)this.config);
        Path testAppDirPath = this.getTestRootPath(TEST_ATTEMPT_DIR_NAME);
        this.fs.mkdirs(testAppDirPath, new FsPermission(504));
        this.objMapper = PluginStoreTestUtils.createObjectMapper();
        TimelineEntities testEntities = PluginStoreTestUtils.generateTestEntities();
        this.writeEntitiesLeaveOpen(testEntities, new Path(testAppDirPath, TEST_ENTITY_FILE_NAME));
        this.testDomain = new TimelineDomain();
        this.testDomain.setId("domain_1");
        this.testDomain.setReaders(UserGroupInformation.getLoginUser().getUserName());
        this.testDomain.setOwner(UserGroupInformation.getLoginUser().getUserName());
        this.testDomain.setDescription("description");
        this.writeDomainLeaveOpen(this.testDomain, new Path(testAppDirPath, TEST_DOMAIN_FILE_NAME));
        this.writeBrokenFile(new Path(testAppDirPath, TEST_BROKEN_FILE_NAME));
    }

    @After
    public void tearDown() throws Exception {
        this.jsonGenerator.close();
        this.outStream.close();
        this.outStreamDomain.close();
        this.hdfsCluster.shutdown();
    }

    @Test
    public void testMatchesGroupId() throws Exception {
        String testGroupId = "app1_group1";
        EntityLogInfo testLogInfo = new EntityLogInfo(TEST_ATTEMPT_DIR_NAME, "app1_group1", UserGroupInformation.getLoginUser().getUserName());
        Assert.assertTrue((boolean)testLogInfo.matchesGroupId(testGroupId));
        testLogInfo = new EntityLogInfo(TEST_ATTEMPT_DIR_NAME, "test_app1_group1", UserGroupInformation.getLoginUser().getUserName());
        Assert.assertTrue((boolean)testLogInfo.matchesGroupId(testGroupId));
        testLogInfo = new EntityLogInfo(TEST_ATTEMPT_DIR_NAME, "app2_group1", UserGroupInformation.getLoginUser().getUserName());
        Assert.assertFalse((boolean)testLogInfo.matchesGroupId(testGroupId));
        testLogInfo = new EntityLogInfo(TEST_ATTEMPT_DIR_NAME, "app1_group2", UserGroupInformation.getLoginUser().getUserName());
        Assert.assertFalse((boolean)testLogInfo.matchesGroupId(testGroupId));
        testLogInfo = new EntityLogInfo(TEST_ATTEMPT_DIR_NAME, "app1_group12", UserGroupInformation.getLoginUser().getUserName());
        Assert.assertFalse((boolean)testLogInfo.matchesGroupId(testGroupId));
        testLogInfo = new EntityLogInfo(TEST_ATTEMPT_DIR_NAME, "app1_group1_2", UserGroupInformation.getLoginUser().getUserName());
        Assert.assertTrue((boolean)testLogInfo.matchesGroupId(testGroupId));
        testLogInfo = new EntityLogInfo(TEST_ATTEMPT_DIR_NAME, "app1_group1.dat", UserGroupInformation.getLoginUser().getUserName());
        Assert.assertTrue((boolean)testLogInfo.matchesGroupId(testGroupId));
        testLogInfo = new EntityLogInfo(TEST_ATTEMPT_DIR_NAME, "app2", UserGroupInformation.getLoginUser().getUserName());
        Assert.assertFalse((boolean)testLogInfo.matchesGroupId(testGroupId));
    }

    @Test
    public void testParseEntity() throws Exception {
        TimelineDataManager tdm = PluginStoreTestUtils.getTdmWithMemStore((Configuration)this.config);
        EntityLogInfo testLogInfo = new EntityLogInfo(TEST_ATTEMPT_DIR_NAME, TEST_ENTITY_FILE_NAME, UserGroupInformation.getLoginUser().getUserName());
        testLogInfo.parseForStore(tdm, this.getTestRootPath(), true, this.jsonFactory, this.objMapper, this.fs);
        PluginStoreTestUtils.verifyTestEntities((TimelineDataManager)tdm);
        TimelineEntity entityNew = PluginStoreTestUtils.createEntity((String)"id_3", (String)"type_3", (Long)789L, null, null, null, null, (String)"domain_id_1");
        TimelineEntities entityList = new TimelineEntities();
        entityList.addEntity(entityNew);
        this.writeEntitiesLeaveOpen(entityList, new Path(this.getTestRootPath(TEST_ATTEMPT_DIR_NAME), TEST_ENTITY_FILE_NAME));
        testLogInfo.parseForStore(tdm, this.getTestRootPath(), true, this.jsonFactory, this.objMapper, this.fs);
        TimelineEntity entity3 = tdm.getEntity(entityNew.getEntityType(), entityNew.getEntityId(), EnumSet.allOf(TimelineReader.Field.class), UserGroupInformation.getLoginUser());
        Assert.assertNotNull((Object)entity3);
        Assert.assertEquals((String)"Failed to read out entity new", (Object)entityNew.getStartTime(), (Object)entity3.getStartTime());
        tdm.close();
    }

    @Test
    public void testParseBrokenEntity() throws Exception {
        TimelineDataManager tdm = PluginStoreTestUtils.getTdmWithMemStore((Configuration)this.config);
        EntityLogInfo testLogInfo = new EntityLogInfo(TEST_ATTEMPT_DIR_NAME, TEST_BROKEN_FILE_NAME, UserGroupInformation.getLoginUser().getUserName());
        DomainLogInfo domainLogInfo = new DomainLogInfo(TEST_ATTEMPT_DIR_NAME, TEST_BROKEN_FILE_NAME, UserGroupInformation.getLoginUser().getUserName());
        testLogInfo.parseForStore(tdm, this.getTestRootPath(), true, this.jsonFactory, this.objMapper, this.fs);
        domainLogInfo.parseForStore(tdm, this.getTestRootPath(), true, this.jsonFactory, this.objMapper, this.fs);
        tdm.close();
    }

    @Test
    public void testParseDomain() throws Exception {
        TimelineDataManager tdm = PluginStoreTestUtils.getTdmWithMemStore((Configuration)this.config);
        DomainLogInfo domainLogInfo = new DomainLogInfo(TEST_ATTEMPT_DIR_NAME, TEST_DOMAIN_FILE_NAME, UserGroupInformation.getLoginUser().getUserName());
        domainLogInfo.parseForStore(tdm, this.getTestRootPath(), true, this.jsonFactory, this.objMapper, this.fs);
        TimelineDomain resultDomain = tdm.getDomain("domain_1", UserGroupInformation.getLoginUser());
        Assert.assertNotNull((Object)resultDomain);
        Assert.assertEquals((Object)this.testDomain.getReaders(), (Object)resultDomain.getReaders());
        Assert.assertEquals((Object)this.testDomain.getOwner(), (Object)resultDomain.getOwner());
        Assert.assertEquals((Object)this.testDomain.getDescription(), (Object)resultDomain.getDescription());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeBrokenFile(Path logPath) throws IOException {
        try (FSDataOutputStream out = null;){
            String broken = "{ broken { [[]} broken";
            out = PluginStoreTestUtils.createLogFile((Path)logPath, (FileSystem)this.fs);
            out.write(broken.getBytes(Charset.forName("UTF-8")));
            out.close();
            out = null;
        }
    }

    private void writeEntitiesLeaveOpen(TimelineEntities entities, Path logPath) throws IOException {
        if (this.outStream == null) {
            this.outStream = PluginStoreTestUtils.createLogFile((Path)logPath, (FileSystem)this.fs);
            this.jsonGenerator = new JsonFactory().createJsonGenerator((OutputStream)this.outStream);
            this.jsonGenerator.setPrettyPrinter((PrettyPrinter)new MinimalPrettyPrinter("\n"));
        }
        for (TimelineEntity entity : entities.getEntities()) {
            this.objMapper.writeValue(this.jsonGenerator, (Object)entity);
        }
        this.outStream.hflush();
    }

    private void writeDomainLeaveOpen(TimelineDomain domain, Path logPath) throws IOException {
        if (this.outStreamDomain == null) {
            this.outStreamDomain = PluginStoreTestUtils.createLogFile((Path)logPath, (FileSystem)this.fs);
        }
        JsonGenerator jsonGeneratorLocal = new JsonFactory().createJsonGenerator((OutputStream)this.outStreamDomain);
        jsonGeneratorLocal.setPrettyPrinter((PrettyPrinter)new MinimalPrettyPrinter("\n"));
        this.objMapper.writeValue(jsonGeneratorLocal, (Object)domain);
        this.outStreamDomain.hflush();
    }

    private Path getTestRootPath() {
        return this.fileContextTestHelper.getTestRootPath(this.fc);
    }

    private Path getTestRootPath(String pathString) {
        return this.fileContextTestHelper.getTestRootPath(this.fc, pathString);
    }
}

