/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timeline;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.yarn.server.timeline.KeyValueBasedTimelineStore;
import org.apache.hadoop.yarn.server.timeline.LevelDBCacheTimelineStore;
import org.apache.hadoop.yarn.server.timeline.MemoryTimelineStore;
import org.apache.hadoop.yarn.server.timeline.util.LeveldbUtils;
import org.fusesource.leveldbjni.JniDBFactory;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.Options;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class LevelDBCacheTimelineStore
extends KeyValueBasedTimelineStore {
    private static final Logger LOG = LoggerFactory.getLogger(LevelDBCacheTimelineStore.class);
    private static final String CACHED_LDB_FILE_PREFIX = "-timeline-cache.ldb";
    private String dbId;
    private DB entityDb;
    private Configuration configuration;

    public LevelDBCacheTimelineStore(String id, String name) {
        super(name);
        this.dbId = id;
        this.entityInsertTimes = new MemoryTimelineStore.HashMapStoreAdapter();
        this.domainById = new MemoryTimelineStore.HashMapStoreAdapter();
        this.domainsByOwner = new MemoryTimelineStore.HashMapStoreAdapter();
    }

    public LevelDBCacheTimelineStore(String id) {
        this(id, LevelDBCacheTimelineStore.class.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void serviceInit(Configuration conf) throws Exception {
        this.configuration = conf;
        Options options = new Options();
        options.createIfMissing(true);
        options.cacheSize(conf.getLong("yarn.timeline-service.entity-group-fs-store.leveldb-cache-read-cache-size", 0xA00000L));
        JniDBFactory factory = new JniDBFactory();
        Path dbPath = new Path(conf.get("yarn.timeline-service.leveldb-timeline-store.path"), this.dbId + CACHED_LDB_FILE_PREFIX);
        LocalFileSystem localFS = null;
        try {
            localFS = FileSystem.getLocal((Configuration)conf);
            if (!localFS.exists(dbPath)) {
                if (!localFS.mkdirs(dbPath)) {
                    throw new IOException("Couldn't create directory for leveldb timeline store " + dbPath);
                }
                localFS.setPermission(dbPath, LeveldbUtils.LEVELDB_DIR_UMASK);
            }
        }
        catch (Throwable throwable) {
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{localFS});
            throw throwable;
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{localFS});
        LOG.info("Using leveldb path " + dbPath);
        this.entityDb = factory.open(new File(dbPath.toString()), options);
        this.entities = new LevelDBMapAdapter(this.entityDb);
        super.serviceInit(conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void serviceStop() throws Exception {
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{this.entityDb});
        Path dbPath = new Path(this.configuration.get("yarn.timeline-service.leveldb-timeline-store.path"), this.dbId + CACHED_LDB_FILE_PREFIX);
        LocalFileSystem localFS = null;
        try {
            localFS = FileSystem.getLocal((Configuration)this.configuration);
            if (!localFS.delete(dbPath, true)) {
                throw new IOException("Couldn't delete data file for leveldb timeline store " + dbPath);
            }
        }
        catch (Throwable throwable) {
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{localFS});
            throw throwable;
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{localFS});
        super.serviceStop();
    }

    static /* synthetic */ Logger access$000() {
        return LOG;
    }
}

