/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.sharedcachemanager;

import com.google.common.annotations.VisibleForTesting;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.source.JvmMetrics;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.ShutdownHookManager;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.YarnUncaughtExceptionHandler;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.sharedcachemanager.CleanerService;
import org.apache.hadoop.yarn.server.sharedcachemanager.ClientProtocolService;
import org.apache.hadoop.yarn.server.sharedcachemanager.SCMAdminProtocolService;
import org.apache.hadoop.yarn.server.sharedcachemanager.SharedCacheUploaderService;
import org.apache.hadoop.yarn.server.sharedcachemanager.store.SCMStore;
import org.apache.hadoop.yarn.server.sharedcachemanager.webapp.SCMWebServer;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class SharedCacheManager
extends CompositeService {
    public static final int SHUTDOWN_HOOK_PRIORITY = 30;
    private static final Log LOG = LogFactory.getLog(SharedCacheManager.class);
    private SCMStore store;

    public SharedCacheManager() {
        super("SharedCacheManager");
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.store = SharedCacheManager.createSCMStoreService(conf);
        this.addService((Service)this.store);
        CleanerService cs = this.createCleanerService(this.store);
        this.addService((Service)cs);
        SharedCacheUploaderService nms = this.createNMCacheUploaderSCMProtocolService(this.store);
        this.addService((Service)nms);
        ClientProtocolService cps = this.createClientProtocolService(this.store);
        this.addService((Service)cps);
        SCMAdminProtocolService saps = this.createSCMAdminProtocolService(cs);
        this.addService((Service)saps);
        SCMWebServer webUI = this.createSCMWebServer(this);
        this.addService((Service)webUI);
        DefaultMetricsSystem.initialize((String)"SharedCacheManager");
        JvmMetrics.initSingleton((String)"SharedCacheManager", null);
        super.serviceInit(conf);
    }

    private static SCMStore createSCMStoreService(Configuration conf) {
        Class<?> defaultStoreClass;
        try {
            defaultStoreClass = Class.forName("org.apache.hadoop.yarn.server.sharedcachemanager.store.InMemorySCMStore");
        }
        catch (Exception e) {
            throw new YarnRuntimeException("Invalid default scm store classorg.apache.hadoop.yarn.server.sharedcachemanager.store.InMemorySCMStore", (Throwable)e);
        }
        SCMStore store = (SCMStore)((Object)ReflectionUtils.newInstance((Class)conf.getClass("yarn.sharedcache.store.class", defaultStoreClass, SCMStore.class), (Configuration)conf));
        return store;
    }

    private CleanerService createCleanerService(SCMStore store) {
        return new CleanerService(store);
    }

    private SharedCacheUploaderService createNMCacheUploaderSCMProtocolService(SCMStore store) {
        return new SharedCacheUploaderService(store);
    }

    private ClientProtocolService createClientProtocolService(SCMStore store) {
        return new ClientProtocolService(store);
    }

    private SCMAdminProtocolService createSCMAdminProtocolService(CleanerService cleanerService) {
        return new SCMAdminProtocolService(cleanerService);
    }

    private SCMWebServer createSCMWebServer(SharedCacheManager scm) {
        return new SCMWebServer(scm);
    }

    protected void serviceStop() throws Exception {
        DefaultMetricsSystem.shutdown();
        super.serviceStop();
    }

    @VisibleForTesting
    SCMStore getSCMStore() {
        return this.store;
    }

    public static void main(String[] args) {
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new YarnUncaughtExceptionHandler());
        StringUtils.startupShutdownMessage(SharedCacheManager.class, (String[])args, (Log)LOG);
        try {
            YarnConfiguration conf = new YarnConfiguration();
            SharedCacheManager sharedCacheManager = new SharedCacheManager();
            ShutdownHookManager.get().addShutdownHook((Runnable)new CompositeService.CompositeServiceShutdownHook((CompositeService)sharedCacheManager), 30);
            sharedCacheManager.init((Configuration)conf);
            sharedCacheManager.start();
        }
        catch (Throwable t) {
            LOG.fatal((Object)"Error starting SharedCacheManager", t);
            System.exit(-1);
        }
    }
}

