/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.sharedcachemanager.store;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.server.sharedcachemanager.AppChecker;
import org.apache.hadoop.yarn.server.sharedcachemanager.DummyAppChecker;
import org.apache.hadoop.yarn.server.sharedcachemanager.store.InMemorySCMStore;
import org.apache.hadoop.yarn.server.sharedcachemanager.store.SCMStore;
import org.apache.hadoop.yarn.server.sharedcachemanager.store.SCMStoreBaseTest;
import org.apache.hadoop.yarn.server.sharedcachemanager.store.SharedCacheResourceReference;
import org.apache.hadoop.yarn.server.sharedcachemanager.store.TestInMemorySCMStore;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class TestInMemorySCMStore
extends SCMStoreBaseTest {
    private InMemorySCMStore store;
    private AppChecker checker;

    Class<? extends SCMStore> getStoreClass() {
        return InMemorySCMStore.class;
    }

    @Before
    public void setup() {
        this.checker = (AppChecker)Mockito.spy((Object)new DummyAppChecker());
        this.store = (InMemorySCMStore)Mockito.spy((Object)new InMemorySCMStore(this.checker));
    }

    @After
    public void cleanup() {
        if (this.store != null) {
            this.store.stop();
        }
    }

    private void startEmptyStore() throws Exception {
        ((AppChecker)Mockito.doReturn(new ArrayList()).when((Object)this.checker)).getActiveApplications();
        ((InMemorySCMStore)Mockito.doReturn(new HashMap()).when((Object)this.store)).getInitialCachedResources((FileSystem)Matchers.isA(FileSystem.class), (Configuration)Matchers.isA(Configuration.class));
        this.store.init(new Configuration());
        this.store.start();
    }

    private Map<String, String> startStoreWithResources() throws Exception {
        HashMap<String, String> initialCachedResources = new HashMap<String, String>();
        int count = 10;
        for (int i = 0; i < count; ++i) {
            String key = String.valueOf(i);
            String fileName = key + ".jar";
            initialCachedResources.put(key, fileName);
        }
        ((AppChecker)Mockito.doReturn(new ArrayList()).when((Object)this.checker)).getActiveApplications();
        ((InMemorySCMStore)Mockito.doReturn(initialCachedResources).when((Object)this.store)).getInitialCachedResources((FileSystem)Matchers.isA(FileSystem.class), (Configuration)Matchers.isA(Configuration.class));
        this.store.init(new Configuration());
        this.store.start();
        return initialCachedResources;
    }

    private void startStoreWithApps() throws Exception {
        ArrayList<ApplicationId> list = new ArrayList<ApplicationId>();
        int count = 5;
        for (int i = 0; i < count; ++i) {
            list.add(this.createAppId(i, (long)i));
        }
        ((AppChecker)Mockito.doReturn(list).when((Object)this.checker)).getActiveApplications();
        ((InMemorySCMStore)Mockito.doReturn(new HashMap()).when((Object)this.store)).getInitialCachedResources((FileSystem)Matchers.isA(FileSystem.class), (Configuration)Matchers.isA(Configuration.class));
        this.store.init(new Configuration());
        this.store.start();
    }

    @Test
    public void testAddResourceConcurrency() throws Exception {
        this.startEmptyStore();
        String key = "key1";
        int count = 5;
        ExecutorService exec = Executors.newFixedThreadPool(count);
        ArrayList futures = new ArrayList(count);
        CountDownLatch start = new CountDownLatch(1);
        for (int i = 0; i < count; ++i) {
            String fileName = "foo-" + i + ".jar";
            1 var8_9 = new /* Unavailable Anonymous Inner Class!! */;
            futures.add(exec.submit(var8_9));
        }
        start.countDown();
        HashSet results = new HashSet();
        for (Future future : futures) {
            results.add(future.get());
        }
        Assert.assertSame((Object)1, (Object)results.size());
        exec.shutdown();
    }

    @Test
    public void testAddResourceRefNonExistentResource() throws Exception {
        this.startEmptyStore();
        String key = "key1";
        ApplicationId id = this.createAppId(1, 1L);
        Assert.assertNull((Object)this.store.addResourceReference(key, new SharedCacheResourceReference(id, "user")));
    }

    @Test
    public void testRemoveResourceEmptyRefs() throws Exception {
        this.startEmptyStore();
        String key = "key1";
        String fileName = "foo.jar";
        this.store.addResource(key, fileName);
        Assert.assertTrue((boolean)this.store.removeResource(key));
    }

    @Test
    public void testAddResourceRefRemoveResource() throws Exception {
        this.startEmptyStore();
        String key = "key1";
        ApplicationId id = this.createAppId(1, 1L);
        String user = "user";
        this.store.addResource(key, "foo.jar");
        this.store.addResourceReference(key, new SharedCacheResourceReference(id, user));
        Assert.assertTrue((!this.store.removeResource(key) ? 1 : 0) != 0);
        Collection refs = this.store.getResourceReferences(key);
        Assert.assertTrue((refs != null ? 1 : 0) != 0);
        Assert.assertEquals(Collections.singleton(new SharedCacheResourceReference(id, user)), (Object)refs);
    }

    @Test
    public void testAddResourceRefConcurrency() throws Exception {
        this.startEmptyStore();
        String key = "key1";
        String user = "user";
        String fileName = "foo.jar";
        this.store.addResource("key1", fileName);
        int count = 5;
        ExecutorService exec = Executors.newFixedThreadPool(count);
        ArrayList futures = new ArrayList(count);
        CountDownLatch start = new CountDownLatch(1);
        for (int i = 0; i < count; ++i) {
            ApplicationId id = this.createAppId(i, (long)i);
            2 var10_11 = new /* Unavailable Anonymous Inner Class!! */;
            futures.add(exec.submit(var10_11));
        }
        start.countDown();
        HashSet results = new HashSet();
        for (Future future : futures) {
            results.add(future.get());
        }
        Assert.assertSame((Object)1, (Object)results.size());
        Assert.assertEquals(Collections.singleton(fileName), results);
        Collection refs = this.store.getResourceReferences("key1");
        Assert.assertSame((Object)count, (Object)refs.size());
        exec.shutdown();
    }

    @Test
    public void testAddResourceRefAddResourceConcurrency() throws Exception {
        this.startEmptyStore();
        String key = "key1";
        String fileName = "foo.jar";
        String user = "user";
        ApplicationId id = this.createAppId(1, 1L);
        ExecutorService exec = Executors.newFixedThreadPool(2);
        CountDownLatch start = new CountDownLatch(1);
        3 addKeyTask = new /* Unavailable Anonymous Inner Class!! */;
        4 addAppIdTask = new /* Unavailable Anonymous Inner Class!! */;
        Future addAppIdFuture = exec.submit(addAppIdTask);
        Future addKeyFuture = exec.submit(addKeyTask);
        start.countDown();
        String addKeyResult = (String)addKeyFuture.get();
        String addAppIdResult = (String)addAppIdFuture.get();
        Assert.assertEquals((Object)"foo.jar", (Object)addKeyResult);
        System.out.println("addAppId() result: " + addAppIdResult);
        Assert.assertTrue((addAppIdResult == null || addAppIdResult.equals("foo.jar") ? 1 : 0) != 0);
        exec.shutdown();
    }

    @Test
    public void testRemoveRef() throws Exception {
        this.startEmptyStore();
        String key = "key1";
        String fileName = "foo.jar";
        String user = "user";
        this.store.addResource(key, fileName);
        ApplicationId id = this.createAppId(1, 1L);
        SharedCacheResourceReference myRef = new SharedCacheResourceReference(id, user);
        String result = this.store.addResourceReference(key, myRef);
        Assert.assertEquals((Object)fileName, (Object)result);
        Collection refs = this.store.getResourceReferences(key);
        Assert.assertSame((Object)1, (Object)refs.size());
        Assert.assertEquals(Collections.singleton(myRef), (Object)refs);
        this.store.removeResourceReferences(key, Collections.singleton(myRef), true);
        Collection newRefs = this.store.getResourceReferences(key);
        Assert.assertTrue((newRefs == null || newRefs.isEmpty() ? 1 : 0) != 0);
    }

    @Test
    public void testBootstrapping() throws Exception {
        Map initialCachedResources = this.startStoreWithResources();
        int count = initialCachedResources.size();
        ApplicationId id = this.createAppId(1, 1L);
        for (int i = 0; i < count; ++i) {
            String key = String.valueOf(i);
            String fileName = key + ".jar";
            String result = this.store.addResourceReference(key, new SharedCacheResourceReference(id, "user"));
            Assert.assertEquals((Object)fileName, (Object)result);
            Assert.assertTrue((boolean)initialCachedResources.isEmpty());
        }
    }

    @Test
    public void testEvictableWithInitialApps() throws Exception {
        this.startStoreWithApps();
        Assert.assertFalse((boolean)this.store.isResourceEvictable("key", (FileStatus)Mockito.mock(FileStatus.class)));
    }

    private ApplicationId createAppId(int id, long timestamp) {
        return ApplicationId.newInstance((long)timestamp, (int)id);
    }

    static /* synthetic */ InMemorySCMStore access$000(TestInMemorySCMStore x0) {
        return x0.store;
    }
}

