/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.sharedcachemanager.metrics;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;

@InterfaceAudience.Private
@InterfaceStability.Unstable
@Metrics(about="Client SCM metrics", context="yarn")
public class ClientSCMMetrics {
    private static final Log LOG = LogFactory.getLog(ClientSCMMetrics.class);
    final MetricsRegistry registry = new MetricsRegistry("clientRequests");
    private static final ClientSCMMetrics INSTANCE = ClientSCMMetrics.create();
    @Metric(value={"Number of cache hits"})
    MutableCounterLong cacheHits;
    @Metric(value={"Number of cache misses"})
    MutableCounterLong cacheMisses;
    @Metric(value={"Number of cache releases"})
    MutableCounterLong cacheReleases;

    private ClientSCMMetrics() {
        LOG.debug((Object)("Initialized " + this.registry));
    }

    public static ClientSCMMetrics getInstance() {
        return INSTANCE;
    }

    static ClientSCMMetrics create() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        ClientSCMMetrics metrics = new ClientSCMMetrics();
        ms.register("clientRequests", null, (Object)metrics);
        return metrics;
    }

    public void incCacheHitCount() {
        this.cacheHits.incr();
    }

    public void incCacheMissCount() {
        this.cacheMisses.incr();
    }

    public void incCacheRelease() {
        this.cacheReleases.incr();
    }

    public long getCacheHits() {
        return this.cacheHits.value();
    }

    public long getCacheMisses() {
        return this.cacheMisses.value();
    }

    public long getCacheReleases() {
        return this.cacheReleases.value();
    }
}

