/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.sharedcachemanager;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.ipc.RPCUtil;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.security.YarnAuthorizationProvider;
import org.apache.hadoop.yarn.server.api.SCMAdminProtocol;
import org.apache.hadoop.yarn.server.api.protocolrecords.RunSharedCacheCleanerTaskRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RunSharedCacheCleanerTaskResponse;
import org.apache.hadoop.yarn.server.sharedcachemanager.CleanerService;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class SCMAdminProtocolService
extends AbstractService
implements SCMAdminProtocol {
    private static final Log LOG = LogFactory.getLog(SCMAdminProtocolService.class);
    private final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private Server server;
    InetSocketAddress clientBindAddress;
    private final CleanerService cleanerService;
    private YarnAuthorizationProvider authorizer;

    public SCMAdminProtocolService(CleanerService cleanerService) {
        super(SCMAdminProtocolService.class.getName());
        this.cleanerService = cleanerService;
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.clientBindAddress = this.getBindAddress(conf);
        this.authorizer = YarnAuthorizationProvider.getInstance((Configuration)conf);
        super.serviceInit(conf);
    }

    InetSocketAddress getBindAddress(Configuration conf) {
        return conf.getSocketAddr("yarn.sharedcache.admin.address", "0.0.0.0:8047", 8047);
    }

    protected void serviceStart() throws Exception {
        Configuration conf = this.getConfig();
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        this.server = rpc.getServer(SCMAdminProtocol.class, (Object)this, this.clientBindAddress, conf, null, conf.getInt("yarn.sharedcache.admin.thread-count", 1));
        this.server.start();
        this.clientBindAddress = conf.updateConnectAddr("yarn.sharedcache.admin.address", this.server.getListenerAddress());
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
        super.serviceStop();
    }

    private void checkAcls(String method) throws YarnException {
        UserGroupInformation user;
        try {
            user = UserGroupInformation.getCurrentUser();
        }
        catch (IOException ioe) {
            LOG.warn((Object)"Couldn't get current user", (Throwable)ioe);
            throw RPCUtil.getRemoteException((Throwable)ioe);
        }
        if (!this.authorizer.isAdmin(user)) {
            LOG.warn((Object)("User " + user.getShortUserName() + " doesn't have permission" + " to call '" + method + "'"));
            throw RPCUtil.getRemoteException((Throwable)new AccessControlException("User " + user.getShortUserName() + " doesn't have permission" + " to call '" + method + "'"));
        }
        LOG.info((Object)("SCM Admin: " + method + " invoked by user " + user.getShortUserName()));
    }

    public RunSharedCacheCleanerTaskResponse runCleanerTask(RunSharedCacheCleanerTaskRequest request) throws YarnException {
        this.checkAcls("runCleanerTask");
        RunSharedCacheCleanerTaskResponse response = (RunSharedCacheCleanerTaskResponse)this.recordFactory.newRecordInstance(RunSharedCacheCleanerTaskResponse.class);
        this.cleanerService.runCleanerTask();
        response.setAccepted(true);
        return response;
    }
}

